/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

public final class FastLongBigArray {
    private static final int DEFAULT_NUM_ROWS = 100;
    private static final int DEFAULT_NUM_COLUMNS = 1000;
    private int numRows;
    private final int numColumns;
    private long[][] data;
    private long size = 0L;
    private long lastIndex = -1L;

    public FastLongBigArray() {
        this(100, 1000);
    }

    public FastLongBigArray(int initialRows, int columns) {
        if (initialRows < 1 || columns < 1) {
            throw new IllegalArgumentException();
        }
        this.numRows = initialRows;
        this.numColumns = columns;
        this.data = new long[this.numRows][];
        this.data[0] = new long[this.numColumns];
        for (int i = 0; i < this.numColumns; ++i) {
            this.data[0][i] = -1L;
        }
    }

    public long get(long index) {
        if (index < 0L) {
            throw new IllegalArgumentException();
        }
        if (index < (long)this.numColumns) {
            return this.data[0][(int)index];
        }
        int rowNumber = (int)index / this.numColumns;
        if (rowNumber >= this.numRows) {
            return -1L;
        }
        if (this.data[rowNumber] == null) {
            return -1L;
        }
        int offset = (int)index % this.numColumns;
        return this.data[rowNumber][offset];
    }

    public long put(long index, long value) {
        if (index < 0L || value < 0L) {
            throw new IllegalArgumentException();
        }
        if (index < (long)this.numColumns) {
            long oldValue = this.data[0][(int)index];
            this.data[0][(int)index] = value;
            if (oldValue == -1L) {
                ++this.size;
            }
            if (index > this.lastIndex) {
                this.lastIndex = index;
            }
            return oldValue;
        }
        int rowNumber = (int)index / this.numColumns;
        if (rowNumber >= this.numRows) {
            this.growArray(rowNumber + 1);
        }
        if (this.data[rowNumber] == null) {
            this.data[rowNumber] = new long[this.numColumns];
            for (int i = 0; i < this.numColumns; ++i) {
                this.data[rowNumber][i] = -1L;
            }
        }
        int offset = (int)index % this.numColumns;
        long oldValue = this.data[rowNumber][offset];
        this.data[rowNumber][offset] = value;
        if (oldValue == -1L) {
            ++this.size;
        }
        if (index > this.lastIndex) {
            this.lastIndex = index;
        }
        return oldValue;
    }

    private void growArray(int minRows) {
        int newSize;
        for (newSize = this.numRows; newSize < minRows; newSize *= 2) {
        }
        long[][] newData = new long[newSize][];
        System.arraycopy(this.data, 0, newData, 0, this.numRows);
        this.data = newData;
        this.numRows = newSize;
    }

    public long lastIndex() {
        return this.lastIndex;
    }

    public long size() {
        return this.size;
    }
}

