/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class JavaObjectMemorySize {
    public static final int JAVA_OBJECT_HEADER_SIZE_32_BIT = 12;
    public static final int JAVA_OBJECT_PTR_SIZE_32_BIT = 4;
    public static final int JAVA_OBJECT_HEADER_SIZE_64_BIT = 20;
    public static final int JAVA_OBJECT_PTR_SIZE_64_BIT = 8;
    public static final int JAVA_OBJECT_BOUNDARY = 8;
    private static final long THIRTY_TWO_GIG = 0x800000000L;
    private static final boolean USING_FULL_64BIT_REFS = Runtime.getRuntime().maxMemory() > 0x800000000L;
    public static final int BOOLEAN_SIZE = 1;
    public static final int BYTE_SIZE = 1;
    public static final int CHAR_SIZE = 2;
    public static final int DOUBLE_SIZE = 8;
    public static final int FLOAT_SIZE = 4;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int SHORT_SIZE = 2;
    public static final int SIZE_ADJUSTMENT = 8;

    public static long getJavaObjectSize(long numBytesInNativeTypeFields, long numPointers) {
        long baseSize = (long)JavaObjectMemorySize.getJavaObjectHeaderSize() + numPointers * (long)JavaObjectMemorySize.getJavaObjectPtrSize() + numBytesInNativeTypeFields;
        return JavaObjectMemorySize.roundToJavaObjectBoundary(baseSize);
    }

    public static boolean isUsingFull64BitRefs() {
        return USING_FULL_64BIT_REFS;
    }

    private static int getJavaObjectHeaderSize() {
        if (USING_FULL_64BIT_REFS) {
            return 20;
        }
        return 12;
    }

    private static int getJavaObjectPtrSize() {
        if (USING_FULL_64BIT_REFS) {
            return 8;
        }
        return 4;
    }

    private static long roundToJavaObjectBoundary(long objectSize) {
        int extraBytesNeeded = 0;
        int bytesPastBoundary = (int)(objectSize % 8L);
        if (bytesPastBoundary > 0) {
            extraBytesNeeded = 8 - bytesPastBoundary;
        }
        return objectSize + (long)extraBytesNeeded;
    }

    private static long getJavaObjectShallowSize(Class<?> objectClass) {
        int primitiveFieldSize = 0;
        int referenceFieldCount = 0;
        while (objectClass != null) {
            Field[] fields;
            for (Field field : fields = objectClass.getDeclaredFields()) {
                int fieldModifiers = field.getModifiers();
                if (Modifier.isStatic(fieldModifiers)) continue;
                Class<?> fieldClass = field.getType();
                if (Boolean.TYPE.equals(fieldClass)) {
                    ++primitiveFieldSize;
                    continue;
                }
                if (Byte.TYPE.equals(fieldClass)) {
                    ++primitiveFieldSize;
                    continue;
                }
                if (Character.TYPE.equals(fieldClass)) {
                    primitiveFieldSize += 2;
                    continue;
                }
                if (Short.TYPE.equals(fieldClass)) {
                    primitiveFieldSize += 2;
                    continue;
                }
                if (Integer.TYPE.equals(fieldClass)) {
                    primitiveFieldSize += 4;
                    continue;
                }
                if (Float.TYPE.equals(fieldClass)) {
                    primitiveFieldSize += 4;
                    continue;
                }
                if (Long.TYPE.equals(fieldClass)) {
                    primitiveFieldSize += 8;
                    continue;
                }
                if (Double.TYPE.equals(fieldClass)) {
                    primitiveFieldSize += 8;
                    continue;
                }
                ++referenceFieldCount;
            }
            objectClass = objectClass.getSuperclass();
        }
        return JavaObjectMemorySize.getJavaObjectSize(primitiveFieldSize, referenceFieldCount);
    }

    public static long getEstimatedJavaObjectShallowSize(Class<?> objectClass) {
        return JavaObjectMemorySize.getJavaObjectShallowSize(objectClass) + 8L;
    }

    public static long getEstimatedJavaPrimitiveArraySize(int primitiveSize, long arrayLength) {
        return JavaObjectMemorySize.getJavaObjectSize((long)primitiveSize * arrayLength, 0L) + 8L;
    }

    public static long getEstimatedJavaObjectArraySize(long arrayLength) {
        return JavaObjectMemorySize.getJavaObjectSize(0L, arrayLength) + 8L;
    }
}

