/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqebifw.bibushandler.datasource.JCAMImpersonator;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class KerberosSSOLoginHelper {
    public static final String JAAS_CONFIGURATION_ENTRY = "com.cognos.biserver.security.xqe";

    public static void main(String[] args) {
        if (System.getProperty("java.vendor").toUpperCase().contains("IBM")) {
            System.setProperty("com.ibm.security.krb5.Krb5Debug", "all");
            System.setProperty("com.ibm.security.jgss.debug", "all");
        } else {
            System.setProperty("sun.security.krb5.debug", "true");
            System.setProperty("sun.security.jgss.debug", "true");
        }
        try {
            LoginContext lc;
            block11: {
                lc = null;
                try {
                    lc = new LoginContext(JAAS_CONFIGURATION_ENTRY);
                }
                catch (LoginException e) {
                    try {
                        XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SecBridge", LogLevel.TRACE).log("Got exception " + e.getMessage() + ", will create default configuration.");
                    }
                    catch (Exception exc) {
                        if (!exc.toString().contains("ClassNotFoundException")) break block11;
                        System.exit(1);
                    }
                }
            }
            if (lc == null) {
                lc = new LoginContext(JAAS_CONFIGURATION_ENTRY, null, null, new JCAMImpersonator.LocalSSOConfiguration());
                System.out.println("Creating login context using Cognos configuration entry.");
            } else {
                System.out.println("Creating login context using login configuration file.");
            }
            lc.login();
            System.out.println("Helper login succeeded.");
        }
        catch (Exception ex) {
            System.out.println("Helper login failed." + ex.getMessage());
            if (ex.toString().contains("ClassNotFoundException")) {
                System.exit(1);
            }
            System.exit(0);
        }
        System.exit(0);
    }
}

