/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.INullPlacement;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.apache.Named;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OrderedMap<V>
implements IOrderedMap<V> {
    private final boolean caseSensitive;
    private boolean containsItems = false;
    private boolean isFixed = false;
    private static final String ERROR_ATTEMPT_TO_ADD_OBJECT_TO_FIXED_ORDERED_MAP = "Attempt to add object to fixed OrderedMap";
    private TreeMap<String, V> map;
    private HashMap<String, List<V>> mapDuplicates;
    private ArrayList<V> list;
    private V[] fixedObjects;
    private V[] orderedObjects;
    private Comparator<V> comparator;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock rLock = this.rwLock.readLock();
    private final Lock wLock = this.rwLock.writeLock();
    private NullOrder nullOrder;
    private int nullCount = 0;

    @Override
    public ArrayList<V> getList() {
        return this.list;
    }

    @Override
    public void fixate() {
        this.wLock.lock();
        try {
            if (this.containsItems && !this.isFixed) {
                this.comparator = new FixedObjectComparator(this.caseSensitive);
                this.fixedObjects = this.list.toArray();
                this.orderedObjects = (Object[])this.fixedObjects.clone();
                Arrays.sort(this.fixedObjects, this.comparator);
                this.map = null;
                this.mapDuplicates = null;
                this.list = null;
                this.isFixed = true;
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    @Override
    public ListIterator<V> listIterator() {
        if (this.containsItems) {
            if (this.list != null) {
                return this.list.listIterator();
            }
            return new FixedArrayIterator(this.fixedObjects);
        }
        return new ArrayList().listIterator();
    }

    @Override
    public ListIterator<V> listIterator(int arg0) {
        if (this.containsItems) {
            if (this.list != null) {
                return this.list.listIterator(arg0);
            }
            return new FixedArrayIterator(this.fixedObjects, arg0);
        }
        return new ArrayList().listIterator(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(V arg0) {
        this.rLock.lock();
        try {
            if (this.containsItems) {
                if (this.list != null) {
                    int n = this.list.lastIndexOf(arg0);
                    return n;
                }
                for (int i = this.fixedObjects.length - 1; i >= 0; --i) {
                    if (this.fixedObjects[i] != arg0) continue;
                    int n = i;
                    return n;
                }
                int n = -1;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> subList(int arg0, int arg1) {
        this.rLock.lock();
        try {
            if (this.containsItems) {
                if (this.list != null) {
                    List<V> list = this.list.subList(arg0, arg1);
                    return list;
                }
                ArrayList<V> result = new ArrayList<V>();
                for (int i = arg0; i < arg0 + arg1 && i < this.fixedObjects.length; ++i) {
                    result.add(this.fixedObjects[i]);
                }
                ArrayList<V> arrayList = result;
                return arrayList;
            }
            List list = new ArrayList().subList(arg0, arg1);
            return list;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(int arg) {
        this.wLock.lock();
        try {
            V result = null;
            if (this.containsItems) {
                if (this.list != null) {
                    result = this.list.remove(arg);
                    if (result != null) {
                        String key = this.getObjectKey(result);
                        this.map.remove(key);
                        this.mapDuplicates.remove(key);
                    }
                } else {
                    throw new RuntimeException(ERROR_ATTEMPT_TO_ADD_OBJECT_TO_FIXED_ORDERED_MAP);
                }
            }
            V v = result;
            return v;
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(V arg) {
        this.wLock.lock();
        try {
            boolean result = false;
            if (this.containsItems && (result = this.list.remove(arg))) {
                String key = this.getObjectKey(arg);
                this.map.remove(key);
                this.mapDuplicates.remove(key);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<V> collection) {
        this.wLock.lock();
        try {
            if (this.containsItems) {
                if (this.list != null) {
                    this.list.retainAll(collection);
                    this.map.clear();
                    this.mapDuplicates.clear();
                    for (V addMe : collection) {
                        V duplicate;
                        String key = this.getObjectKey(addMe);
                        if (key == null || (duplicate = this.map.put(key, addMe)) == null) continue;
                        this.addToDuplicateMap(key, duplicate);
                    }
                } else {
                    throw new RuntimeException(ERROR_ATTEMPT_TO_ADD_OBJECT_TO_FIXED_ORDERED_MAP);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.wLock.unlock();
        }
    }

    public OrderedMap() {
        this(true, NullOrder.DEFAULT);
    }

    public OrderedMap(boolean isCaseSensitive) {
        this(isCaseSensitive, NullOrder.DEFAULT);
    }

    public OrderedMap(boolean isCaseSensitive, NullOrder nOrder) {
        this.caseSensitive = isCaseSensitive;
        this.nullOrder = nOrder;
        this.nullCount = 0;
        this.map = null;
        this.mapDuplicates = null;
        this.list = null;
    }

    public String toString() {
        if (this.containsItems) {
            return this.map.toString();
        }
        return "OrderedMap Empty";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, V arg) {
        this.wLock.lock();
        try {
            V duplicate;
            this.initializeContainers();
            this.list.add(index, arg);
            String key = this.getObjectKey(arg);
            if (key != null && (duplicate = this.map.put(key, arg)) != null) {
                this.addToDuplicateMap(key, duplicate);
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V set(int index, V arg) {
        this.wLock.lock();
        try {
            this.initializeContainers();
            V currentAtIndex = this.get(index);
            this.list.set(index, arg);
            this.map.remove(currentAtIndex);
            this.mapDuplicates.remove(currentAtIndex);
            String key = this.getObjectKey(arg);
            if (key != null) {
                this.map.put(key, arg);
            }
            V v = currentAtIndex;
            return v;
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(V arg) {
        this.wLock.lock();
        try {
            V duplicate;
            this.initializeContainers();
            this.list.add(arg);
            String key = this.getObjectKey(arg);
            if (key != null && (duplicate = this.map.put(key, arg)) != null) {
                this.addToDuplicateMap(key, duplicate);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.wLock.unlock();
        }
    }

    private void initializeContainers() {
        if (this.isFixed) {
            throw new RuntimeException(ERROR_ATTEMPT_TO_ADD_OBJECT_TO_FIXED_ORDERED_MAP);
        }
        if (!this.containsItems) {
            this.containsItems = true;
            this.map = new TreeMap(new OrderedMapComparator(this.caseSensitive));
            this.mapDuplicates = new HashMap();
            this.list = new ArrayList();
        }
    }

    @Override
    public String getObjectKey(V arg) {
        String key = null;
        if (arg instanceof Named) {
            key = ((Named)arg).getName();
        } else if (arg != null) {
            key = arg.toString();
        }
        if (!this.caseSensitive) {
            key = key.toUpperCase();
        }
        return key;
    }

    @Override
    public void clear() {
        this.wLock.lock();
        try {
            if (this.containsItems) {
                if (this.map == null) {
                    this.map = new TreeMap(new OrderedMapComparator());
                    this.mapDuplicates = new HashMap();
                    this.list = new ArrayList();
                    this.comparator = null;
                    this.fixedObjects = null;
                    this.orderedObjects = null;
                } else {
                    this.map.clear();
                    this.mapDuplicates.clear();
                    this.list.clear();
                }
                this.nullCount = 0;
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    @Override
    public Iterator<V> iterator() {
        if (this.containsItems) {
            if (this.list != null) {
                return this.list.iterator();
            }
            return new FixedArrayIterator(this.fixedObjects);
        }
        return new ArrayList().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(String key) {
        this.rLock.lock();
        try {
            if (this.containsItems) {
                String keyToUse = key;
                if (!this.caseSensitive) {
                    keyToUse = key.toUpperCase();
                }
                if (this.map != null) {
                    V v = this.map.get(keyToUse);
                    return v;
                }
                int idx = Arrays.binarySearch(this.fixedObjects, keyToUse, this.comparator);
                if (idx >= 0) {
                    V v = this.fixedObjects[idx];
                    return v;
                }
                V v = null;
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public V get(int index) {
        this.rLock.lock();
        try {
            if (this.containsItems) {
                if (this.list != null) {
                    V v = this.list.get(index);
                    return v;
                }
                V v = this.orderedObjects[index];
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public Set<String> keySet() {
        if (this.containsItems) {
            if (this.map != null) {
                return this.map.keySet();
            }
            HashSet<String> result = new HashSet<String>();
            for (int i = 0; i < this.fixedObjects.length; ++i) {
                V o = this.fixedObjects[i];
                if (o instanceof Named) {
                    result.add(((Named)o).getName());
                    continue;
                }
                result.add(o.toString());
            }
            return result;
        }
        return new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(V o) {
        this.rLock.lock();
        try {
            if (this.containsItems) {
                if (this.list != null) {
                    int n = this.list.indexOf(o);
                    return n;
                }
                int idx = Arrays.binarySearch(this.fixedObjects, o, this.comparator);
                if (idx >= 0) {
                    int n = idx;
                    return n;
                }
                int n = -1;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String key) {
        this.rLock.lock();
        try {
            if (this.containsItems) {
                String keyToUse = key;
                if (!this.caseSensitive) {
                    keyToUse = key.toUpperCase();
                }
                if (this.map != null) {
                    boolean bl = this.map.containsKey(keyToUse);
                    return bl;
                }
                int idx = Arrays.binarySearch(this.fixedObjects, keyToUse, this.comparator);
                boolean bl = idx >= 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rLock.unlock();
        }
    }

    private void addEntry(String key, V value) {
        this.initializeContainers();
        if (this.map != null) {
            String keyToUse = key;
            if (!this.caseSensitive) {
                keyToUse = key.toUpperCase();
            }
            if (!this.map.containsKey(keyToUse)) {
                this.map.put(keyToUse, value);
            } else {
                this.addToDuplicateMap(keyToUse, value);
            }
            switch (this.nullOrder) {
                case FIRST: {
                    if (value instanceof INullPlacement && ((INullPlacement)value).isNullPlacement()) {
                        this.list.add(this.nullCount++, value);
                        break;
                    }
                    this.list.add(value);
                    break;
                }
                case LAST: {
                    if (value instanceof INullPlacement && ((INullPlacement)value).isNullPlacement()) {
                        this.list.add(value);
                        ++this.nullCount;
                        break;
                    }
                    this.list.add(this.list.size() - this.nullCount, value);
                    break;
                }
                default: {
                    this.list.add(value);
                    break;
                }
            }
        } else {
            XQEDebugLog.err.println(ERROR_ATTEMPT_TO_ADD_OBJECT_TO_FIXED_ORDERED_MAP);
        }
    }

    @Override
    public void put(Named value) {
        this.wLock.lock();
        try {
            this.addEntry(value.getName(), value);
        }
        finally {
            this.wLock.unlock();
        }
    }

    @Override
    public void put(String key, V value) {
        this.wLock.lock();
        try {
            this.addEntry(key, value);
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(IOrderedMap<V> arg) {
        this.wLock.lock();
        try {
            Set<String> keyset = arg.keySet();
            for (String key : keyset) {
                this.addEntry(key, arg.get(key));
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Collection<V> collection) {
        this.wLock.lock();
        try {
            for (V elt : collection) {
                this.put((Named)elt);
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    @Override
    public int size() {
        this.rLock.lock();
        try {
            if (this.containsItems) {
                if (this.list != null) {
                    int n = this.list.size();
                    return n;
                }
                int n = this.fixedObjects.length;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public V[] toArray() {
        this.rLock.lock();
        try {
            if (this.containsItems) {
                if (this.list != null) {
                    Object[] objectArray = this.list.toArray();
                    return objectArray;
                }
                V[] VArray = this.orderedObjects;
                return VArray;
            }
            Object[] objectArray = new String[0];
            return objectArray;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public Object[] toArray(Object[] o) {
        this.rLock.lock();
        try {
            if (this.containsItems) {
                if (this.list != null) {
                    Object[] objectArray = this.list.toArray(o);
                    return objectArray;
                }
                if (o.length < this.orderedObjects.length) {
                    o = (Object[])Array.newInstance(o.getClass().getComponentType(), this.orderedObjects.length);
                }
                System.arraycopy(this.orderedObjects, 0, o, 0, this.orderedObjects.length);
                if (o.length > this.orderedObjects.length) {
                    o[this.orderedObjects.length] = null;
                }
                Object[] objectArray = o;
                return objectArray;
            }
            Object[] objectArray = (Object[])Array.newInstance(o.getClass().getComponentType(), 0);
            return objectArray;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<V> toArrayList() {
        this.rLock.lock();
        try {
            if (this.containsItems) {
                if (this.list != null) {
                    ArrayList arrayList = (ArrayList)this.list.clone();
                    return arrayList;
                }
                ArrayList<V> result = new ArrayList<V>();
                for (int i = 0; i < this.fixedObjects.length; ++i) {
                    V orderedObject = this.fixedObjects[i];
                    result.add(orderedObject);
                }
                ArrayList<V> arrayList = result;
                return arrayList;
            }
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object copy() {
        OrderedMap<V> theClone = new OrderedMap<V>();
        this.rLock.lock();
        try {
            for (String key : this.keySet()) {
                theClone.put(key, this.get(key));
            }
            OrderedMap<V> orderedMap = theClone;
            return orderedMap;
        }
        finally {
            this.rLock.unlock();
        }
    }

    private void addToDuplicateMap(String key, V v) {
        List<V> duplicates = this.mapDuplicates.get(key);
        if (duplicates == null) {
            duplicates = new ArrayList<V>();
            this.mapDuplicates.put(key, duplicates);
        }
        duplicates.add(v);
    }

    @Override
    public List<V> getDuplicates(String key) {
        List<V> result = this.mapDuplicates.get(key);
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void lock() {
        this.rLock.lock();
    }

    @Override
    public void unlock() {
        this.rLock.unlock();
    }

    @Override
    public void sort(Comparator<V> comp) {
        block4: {
            this.wLock.lock();
            try {
                if (!this.containsItems) break block4;
                if (this.list != null) {
                    Collections.sort(this.list, comp);
                    break block4;
                }
                throw new RuntimeException(ERROR_ATTEMPT_TO_ADD_OBJECT_TO_FIXED_ORDERED_MAP);
            }
            finally {
                this.wLock.unlock();
            }
        }
    }

    public class FixedArrayIterator
    implements ListIterator<V> {
        int index;
        V[] items;

        public FixedArrayIterator(V[] someItems) {
            this.items = someItems;
            this.index = 0;
        }

        public FixedArrayIterator(V[] someItems, int startIndex) {
            this.items = someItems;
            this.index = startIndex;
        }

        @Override
        public void add(V o) {
            throw new RuntimeException(OrderedMap.ERROR_ATTEMPT_TO_ADD_OBJECT_TO_FIXED_ORDERED_MAP);
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0 && this.index < this.items.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.index - 1 >= 0 && this.index - 1 < this.items.length;
        }

        @Override
        public V next() {
            Object result = null;
            if (this.index >= 0 && this.index < this.items.length) {
                result = this.items[this.index];
                ++this.index;
            }
            return result;
        }

        @Override
        public int nextIndex() {
            return this.index + 1;
        }

        @Override
        public V previous() {
            Object result = null;
            if (this.index > 0) {
                --this.index;
                if (this.index < this.items.length) {
                    result = this.items[this.index];
                }
            }
            return result;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new RuntimeException(OrderedMap.ERROR_ATTEMPT_TO_ADD_OBJECT_TO_FIXED_ORDERED_MAP);
        }

        @Override
        public void set(V o) {
            throw new RuntimeException(OrderedMap.ERROR_ATTEMPT_TO_ADD_OBJECT_TO_FIXED_ORDERED_MAP);
        }
    }

    class OrderedMapComparator
    implements Comparator<String> {
        boolean caseSensitive = true;

        private OrderedMapComparator() {
        }

        OrderedMapComparator(boolean caseSensitivity) {
            this.caseSensitive = caseSensitivity;
        }

        @Override
        public int compare(String elt1, String elt2) {
            if (this.caseSensitive) {
                return elt1.compareTo(elt2);
            }
            return elt1.compareToIgnoreCase(elt2);
        }
    }

    class FixedObjectComparator
    implements Comparator<V> {
        final boolean caseSensitive;

        FixedObjectComparator() {
            this.caseSensitive = true;
        }

        FixedObjectComparator(boolean isCaseSensitive) {
            this.caseSensitive = isCaseSensitive;
        }

        @Override
        public int compare(V o1, V o2) {
            String elt1 = o1 instanceof Named ? ((Named)o1).getName() : o1.toString();
            String elt2 = o2 instanceof Named ? ((Named)o2).getName() : o2.toString();
            if (this.caseSensitive) {
                return elt1.compareTo(elt2);
            }
            return elt1.compareToIgnoreCase(elt2);
        }
    }

    public static enum NullOrder {
        FIRST,
        LAST,
        DEFAULT;

    }
}

