/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.IParameterMaps;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class ParameterMapDyn
implements IParameterMaps {
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int MINUTES_PER_HOUR = 60;
    String mapName = "_env";
    int priority;
    Map<String, EPARAMETERMAPDYN> parameterMapDyn = new HashMap<String, EPARAMETERMAPDYN>();

    public ParameterMapDyn(int mapPriority) {
        this.priority = mapPriority;
        this.parameterMapDyn.put("current_timestamp", EPARAMETERMAPDYN.CURRENT_TIMESTAMP);
        this.parameterMapDyn.put("machine", EPARAMETERMAPDYN.MACHINE);
        this.parameterMapDyn.put("_as_of_date", EPARAMETERMAPDYN.AS_OF_DATE);
    }

    @Override
    public String get(String map, String key) throws XQERuntimeException {
        EPARAMETERMAPDYN id;
        if (map.equals("_env") && (id = this.parameterMapDyn.get(key)) != null) {
            return this.getCurrentValue(id);
        }
        return null;
    }

    @Override
    public String get(String key) throws XQERuntimeException {
        return this.get("_env", key);
    }

    @Override
    public Map<String, String> getAllEntries(String nameOfMap) {
        HashMap<String, String> allEntries = new HashMap<String, String>();
        for (Map.Entry<String, EPARAMETERMAPDYN> entrySet : this.parameterMapDyn.entrySet()) {
            allEntries.put(entrySet.getKey(), this.getCurrentValue(entrySet.getValue()));
        }
        return allEntries;
    }

    @Override
    public ArrayList<String> getArray(String map, String key) throws XQERuntimeException {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.get(map, key));
        return values;
    }

    @Override
    public ArrayList<String> getArray(String key) throws XQERuntimeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, ArrayList<String>> getArrayAllEntries(String nameOfMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDefault(String nameOfMap) {
        return null;
    }

    @Override
    public void setDefault(String nameOfMap, String value) {
    }

    @Override
    public String[] getMapNames() {
        String[] temp = new String[]{this.mapName};
        return temp;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newPriority) {
        throw new UnsupportedOperationException();
    }

    private String getCurrentValue(EPARAMETERMAPDYN valueId) {
        String result = null;
        String sign = null;
        switch (valueId) {
            case CURRENT_TIMESTAMP: {
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                TimeZone timeZone = cal.getTimeZone();
                int tzOffset = timeZone.getRawOffset();
                long currentTimeinMillis = cal.getTimeInMillis();
                XQEConfiguration config = XQEConfigurationManager.getInstance().getOrCreateXQEConfiguration();
                boolean considerDST = config.getBooleanProperty("general.includeDstInTimeZoneOffset[@enabled]", true);
                if (timeZone.inDaylightTime(cal.getTime())) {
                    if (considerDST) {
                        tzOffset += timeZone.getDSTSavings();
                    } else {
                        cal.setTimeInMillis(currentTimeinMillis - (long)timeZone.getDSTSavings());
                    }
                }
                if (tzOffset < 0) {
                    sign = "-";
                    tzOffset = -tzOffset;
                } else {
                    sign = "+";
                }
                int tzSeconds = tzOffset / 1000;
                int tzHour = tzSeconds / 3600;
                int tzMinute = tzSeconds % 3600 / 60;
                result = String.format("%s%s%02d:%02d", dateFormat.format(cal.getTime()), sign, tzHour, tzMinute);
                break;
            }
            case MACHINE: {
                try {
                    result = InetAddress.getLocalHost().getHostName();
                    break;
                }
                catch (UnknownHostException e) {
                    return "Unknown Host";
                }
            }
            case AS_OF_DATE: {
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                result = dateFormat.format(cal.getTime());
                break;
            }
        }
        return result;
    }

    @Override
    public boolean isModelMap() {
        return false;
    }

    @Override
    public boolean isQueryItemMap() {
        return false;
    }

    @Override
    public boolean getHiddenProperty(String name) {
        return false;
    }

    public static enum EPARAMETERMAPDYN {
        CURRENT_TIMESTAMP(1),
        MACHINE(2),
        AS_OF_DATE(3);

        private int key;

        private EPARAMETERMAPDYN(int c) {
            this.key = c;
        }

        public int getKey() {
            return this.key;
        }
    }
}

