/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.exception.XQERuntimeException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Pipe<T> {
    private static final int QUEUE_SIZE = 20;
    private static final int BLOCK_SIZE = 500;
    private final List<T> eosMarker = new ArrayList<T>();
    private final ArrayBlockingQueue<List<T>> queue;
    private List<T> pendingItems;
    private volatile XQERuntimeException error = null;
    private int numEnques = 0;
    private int numEnquesWhenFull = 0;
    private long numElementsAdded = 0L;
    private final int blockSize;
    private final int queueSize;

    public Pipe() {
        this(500, 20);
    }

    public Pipe(int theBlockSize, int theQueueSize) {
        if (theBlockSize <= 0 || theQueueSize <= 0) {
            throw new IllegalArgumentException("Both the queue and block sizes need to be greater than zero.");
        }
        this.blockSize = theBlockSize;
        this.queueSize = theQueueSize;
        this.queue = new ArrayBlockingQueue(this.queueSize);
        this.pendingItems = new ArrayList<T>(this.blockSize);
    }

    public void add(T item) throws InterruptedException {
        if (this.error != null) {
            throw this.error;
        }
        this.pendingItems.add(item);
        ++this.numElementsAdded;
        if (this.pendingItems.size() >= this.blockSize) {
            this.putOnQueue(this.pendingItems);
            this.pendingItems = new ArrayList<T>(this.blockSize);
        }
    }

    public void producerFinished() throws InterruptedException {
        if (this.error == null) {
            if (this.pendingItems.size() > 0) {
                this.putOnQueue(this.pendingItems);
                this.pendingItems = null;
            }
            this.putOnQueue(this.eosMarker);
        }
    }

    public synchronized void setError(XQERuntimeException anError) {
        if (this.error == null) {
            this.error = anError;
        }
    }

    private void putOnQueue(List<T> items) throws InterruptedException {
        ++this.numEnques;
        if (this.queue.remainingCapacity() == 0) {
            ++this.numEnquesWhenFull;
        }
        while (!this.queue.offer(items, 1L, TimeUnit.SECONDS)) {
            if (this.error == null) continue;
            throw this.error;
        }
    }

    public Iterator<T> iterator() {
        return new PipeIterator();
    }

    public int getNumEnques() {
        return this.numEnques;
    }

    public int getNumEnquesWhenFull() {
        return this.numEnquesWhenFull;
    }

    public long getNumTotalElementsAdded() {
        return this.numElementsAdded;
    }

    private class PipeIterator
    implements Iterator<T> {
        private List<T> block = null;
        private int pos = 0;

        private PipeIterator() {
        }

        @Override
        public boolean hasNext() {
            if (Pipe.this.error != null) {
                throw Pipe.this.error;
            }
            if (this.block == null) {
                try {
                    this.block = this.nextBlock();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.pos = 0;
                if (this.block == null) {
                    return false;
                }
            }
            return true;
        }

        private List<T> nextBlock() throws InterruptedException {
            List nextBlock = null;
            while (nextBlock == null) {
                nextBlock = (List)Pipe.this.queue.poll(1L, TimeUnit.SECONDS);
                if (Pipe.this.error == null) continue;
                throw Pipe.this.error;
            }
            if (nextBlock == Pipe.this.eosMarker) {
                boolean added = Pipe.this.queue.offer(nextBlock);
                if (!added) {
                    throw new IllegalStateException("Could not enqueue the EOS marker back onto the pipe.");
                }
                nextBlock = null;
            }
            return nextBlock;
        }

        @Override
        public T next() {
            Object returnElement = null;
            if (this.hasNext()) {
                returnElement = this.block.get(this.pos);
                ++this.pos;
                if (this.pos == this.block.size()) {
                    this.block = null;
                }
            } else {
                throw new NoSuchElementException();
            }
            return returnElement;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

