/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class UniqueNameParser {
    private static final int LENGTHDOTSEPS = 3;
    private static final String RIGHT_SQUARE_BRACKET = "]";
    private static final String LEFT_SQUARE_BRACKET = "[";
    public static final String ESCAPED_RIGHT_SQUARE_BRACKET = "]]";
    private static final String RIGHT_DOT_AND_LEFT_SQUARE_BRACKET = "].&[";
    private static final String RIGHT_DOT_LEFT_SQUARE_BRACKET = "].[";

    public static String parseLastIdentifier(String uniqueName) throws UniqueNameParserException {
        int beginIndex = uniqueName.lastIndexOf(RIGHT_DOT_AND_LEFT_SQUARE_BRACKET);
        int lengthSeparator = 4;
        if (beginIndex < 0) {
            beginIndex = uniqueName.lastIndexOf(RIGHT_DOT_LEFT_SQUARE_BRACKET);
            lengthSeparator = 3;
        }
        beginIndex = beginIndex < 0 ? ((beginIndex = uniqueName.lastIndexOf(LEFT_SQUARE_BRACKET)) >= 0 ? ++beginIndex : 0) : (beginIndex += lengthSeparator);
        int endIndex = uniqueName.length();
        if (uniqueName.endsWith(RIGHT_SQUARE_BRACKET)) {
            --endIndex;
        }
        return uniqueName.substring(beginIndex, endIndex);
    }

    public static String parseLastIdentifierWithEscapedRightSquareBracket(String uniqueName) {
        String uniqueNameTobeParsed = uniqueName;
        int beginIndex = uniqueNameTobeParsed.lastIndexOf(RIGHT_DOT_AND_LEFT_SQUARE_BRACKET);
        int lengthSeparator = 4;
        if (beginIndex < 0) {
            beginIndex = uniqueNameTobeParsed.lastIndexOf(RIGHT_DOT_LEFT_SQUARE_BRACKET);
            lengthSeparator = 3;
        }
        if (beginIndex < 0) {
            int occurenct = StringUtils.countMatches((String)uniqueNameTobeParsed, (String)ESCAPED_RIGHT_SQUARE_BRACKET);
            String substr = uniqueNameTobeParsed;
            for (int i = 0; i < occurenct; ++i) {
                int index = substr.lastIndexOf(LEFT_SQUARE_BRACKET, substr.lastIndexOf(LEFT_SQUARE_BRACKET) - 1) + 1;
                substr = substr.substring(0, index);
            }
            beginIndex = substr.lastIndexOf(LEFT_SQUARE_BRACKET);
            beginIndex = beginIndex >= 0 ? ++beginIndex : 0;
        } else {
            beginIndex += lengthSeparator;
        }
        uniqueNameTobeParsed = uniqueNameTobeParsed.replaceAll(ESCAPED_RIGHT_SQUARE_BRACKET, RIGHT_SQUARE_BRACKET);
        int endIndex = uniqueNameTobeParsed.length();
        if (uniqueNameTobeParsed.endsWith(RIGHT_SQUARE_BRACKET)) {
            --endIndex;
        }
        return uniqueNameTobeParsed.substring(beginIndex, endIndex);
    }

    public static String[] parse(String aUniqueName) throws UniqueNameParserException {
        return UniqueNameParser.parse(aUniqueName, -1);
    }

    public static String parserFirstIdentifier(String aUniqueName) throws UniqueNameParserException {
        String[] result = UniqueNameParser.parse(aUniqueName, 1);
        if (result != null && result.length > 0) {
            return result[0];
        }
        return null;
    }

    public static String[] parse(String aUniqueName, int count) throws UniqueNameParserException {
        return UniqueNameParser.parse(aUniqueName, count, true);
    }

    public static String[] parseNoThrow(String aUniqueName) {
        try {
            return UniqueNameParser.parse(aUniqueName, -1, false);
        }
        catch (UniqueNameParserException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] parse(String aUniqueName, int count, boolean throwException) throws UniqueNameParserException {
        char ch;
        int pointer = 0;
        String uniqueName = aUniqueName.trim();
        if ((ch = UniqueNameParser.nextChar(pointer++, uniqueName)) == '\u0000') {
            return UniqueNameParser.handleError(XQEMessageKeys.UNP_UNIQUE_NAME_EMPTY, uniqueName, throwException);
        }
        String alias = null;
        if (ch != '[') {
            if (MetadataUtil.isIdForPackage(uniqueName)) {
                int end = uniqueName.indexOf(91);
                alias = uniqueName.substring(0, end - 1);
                uniqueName = uniqueName.substring(end);
                pointer = 0;
                ch = UniqueNameParser.nextChar(pointer++, uniqueName);
            }
            if (ch != '[') {
                return UniqueNameParser.handleError(XQEMessageKeys.UNP_UNEXPECTED_CHAR, ch, throwException);
            }
        }
        StringBuilder str = null;
        ArrayList<String> names = new ArrayList<String>();
        if (alias != null) {
            names.add(alias);
        }
        int counter = 0;
        while (ch != '\u0000' && (count == -1 || counter < count)) {
            if (str == null) {
                if (ch == '[') {
                    str = new StringBuilder("");
                } else if (ch == '&') {
                    ++counter;
                    --counter;
                } else {
                    if (ch != '.') return UniqueNameParser.handleError(XQEMessageKeys.UNP_UNEXPECTED_CHAR, ch, throwException);
                    names.add("");
                    ++counter;
                    str = null;
                }
            } else if (ch == ']') {
                ch = UniqueNameParser.nextChar(pointer, uniqueName);
                if (ch == '\u0000') {
                    names.add(str.toString());
                    ++counter;
                    str = null;
                } else {
                    ++pointer;
                    if (ch == ']') {
                        str.append(ch);
                    } else {
                        if (ch != '.') return UniqueNameParser.handleError(XQEMessageKeys.UNP_UNEXPECTED_CHAR, ch, throwException);
                        names.add(str.toString());
                        ++counter;
                        str = null;
                    }
                }
            } else {
                str.append(ch);
            }
            if ((ch = UniqueNameParser.nextChar(pointer, uniqueName)) == '\u0000') continue;
            ++pointer;
        }
        if (str == null) return names.toArray(new String[names.size()]);
        return UniqueNameParser.handleError(XQEMessageKeys.UNP_UNEXPECTED_ID_END, uniqueName, throwException);
    }

    private static char nextChar(int pointer, String uniqueName) {
        if (pointer == uniqueName.length()) {
            return '\u0000';
        }
        return uniqueName.charAt(pointer);
    }

    private static String[] handleError(IMessageKey.Param1 msg, String uniqueName, boolean throwException) throws UniqueNameParserException {
        if (throwException) {
            throw new UniqueNameParserException(msg, uniqueName);
        }
        return null;
    }

    private static String[] handleError(IMessageKey.Param1 msg, char ch, boolean throwException) throws UniqueNameParserException {
        if (throwException) {
            return UniqueNameParser.handleError(msg, Character.toString(ch), throwException);
        }
        return null;
    }

    public static String undoEscapedSquareBracket(String identifier) {
        String newIndentifier = identifier.replaceAll(ESCAPED_RIGHT_SQUARE_BRACKET, RIGHT_SQUARE_BRACKET);
        return newIndentifier;
    }

    public static String escapeSquareBrackets(String identifier) {
        if (identifier.contains(RIGHT_SQUARE_BRACKET)) {
            return identifier.replaceAll(RIGHT_SQUARE_BRACKET, ESCAPED_RIGHT_SQUARE_BRACKET);
        }
        return identifier;
    }
}

