/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.ast.IXQEProperty;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5JoinOperand;
import com.cognos.xqe.ast.v5.query.V5JoinOperation;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5QueryOperation;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.query.V5SummaryFilterLevel;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5GroupFooter;
import com.cognos.xqe.ast.v5.result.V5GroupHeader;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class V5SpecificationGeneration {
    public static final String QUERIES = "queries";
    public static final String EXPRESSION = "expression";
    public static final String FILTEREXPRESSION = "filterExpression";
    public static final String DETAILFILTERS = "detailFilters";
    public static final String SUMMARYFILTERS = "summaryFilters";
    public static final String SUMMARYFILTERLEVELS = "summaryFilterLevels";
    public static final String QUERYRESULTDEFINITIONS = "queryResultDefinitions";
    public static final String EDGEGROUPS = "edgeGroups";
    public static final String EDGES = "edges";
    public static final String VALUESETS = "valueSets";
    public static final String GROUPSORT = "groupSort";
    public static final String QUERYREFS = "queryRefs";
    public static final String JOINOPERANDS = "joinOperands";
    public static final String JOINFILTER = "joinFilter";
    public static final String VALUE = "value";
    private int queryCounter = 0;
    private int detailFilterCounter = 0;
    private int summaryFilterCounter = 0;
    private int qrdCounter = 0;
    private int edgeCounter = 0;
    private int edgeGroupCounter = 0;
    private int valueSetCounter = 0;
    private int sortItemCounter = 0;
    private int joinOperandCounter = 0;
    private int queryRefCounter = 0;
    protected XMLWriter writer;
    StringWriter stringWriter = new StringWriter();
    private static final HashMap<String, String> V5TYPENAME_TO_V5NAME_MAP = new HashMap();

    public V5SpecificationGeneration() {
        this.writer = new XMLWriter();
        this.writer.addStream(this.stringWriter);
    }

    public int getQueryCounter() {
        return this.queryCounter;
    }

    public void incrementQueryCounter() {
        ++this.queryCounter;
    }

    public int getDetailFilterCounter() {
        return this.detailFilterCounter;
    }

    public void incrementDetailFilterCounter() {
        ++this.detailFilterCounter;
    }

    public int getSummaryFilterCounter() {
        return this.summaryFilterCounter;
    }

    public void incrementSummaryFilterCounter() {
        ++this.summaryFilterCounter;
    }

    public int getQRDCounter() {
        return this.qrdCounter;
    }

    public void incrementQRDCounter() {
        ++this.qrdCounter;
    }

    public int getEdgeCounter() {
        return this.edgeCounter;
    }

    public void incrementEdgeCounter() {
        ++this.edgeCounter;
    }

    public int getEdgeGroupCounter() {
        return this.edgeGroupCounter;
    }

    public void incrementEdgeGroupCounter() {
        ++this.edgeGroupCounter;
    }

    public int getValueSetCounter() {
        return this.valueSetCounter;
    }

    public void incrementValueSetCounter() {
        ++this.valueSetCounter;
    }

    public int getSortItemCounter() {
        return this.sortItemCounter;
    }

    public void incrementSortItemCounter() {
        ++this.sortItemCounter;
    }

    public int getJoinOperandCounter() {
        return this.joinOperandCounter;
    }

    public void incrementJoinOperandCounter() {
        ++this.joinOperandCounter;
    }

    public int getQueryRefCounter() {
        return this.queryRefCounter;
    }

    public void incrementQueryRefCounter() {
        ++this.queryRefCounter;
    }

    public String dumpToString() {
        return this.stringWriter.toString();
    }

    public void dumpProperties(V5QueryNode node) {
        Object governorObj;
        IXQEQueryNode queryNode;
        String queryRef;
        Iterator<String> keys = node.getProperties().keySet().iterator();
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("aggregateExpression");
        attributes.add("aggregate");
        attributes.add("rollupAggregate");
        attributes.add("autoSummary");
        attributes.add("expressionLocale");
        attributes.add("name");
        attributes.add("refDataItem");
        attributes.add("refQuery");
        attributes.add("rollupExpression");
        attributes.add("sort");
        attributes.add("sortOrder");
        attributes.add("postAutoAggregation");
        attributes.add("identifier");
        attributes.add("topNRows");
        attributes.add("cardinality");
        attributes.add("queryRef");
        attributes.add("duplicates");
        attributes.add("setOperation");
        attributes.add("metadataContextName");
        attributes.add("v5Version");
        while (keys.hasNext()) {
            String key = keys.next();
            if (key.equals("queryRef") && node.getType() != 101021 || !attributes.contains(key)) continue;
            Object value = node.getPropertyValue(key);
            if (value != null && value instanceof String[]) {
                List<String> arrayValues = Arrays.asList((String[])value);
                this.writer.attribute(key, arrayValues.toString());
                continue;
            }
            if (value == null || value instanceof IXQEProperty) continue;
            this.writer.attribute(key, value.toString());
        }
        Object modelPathObj = node.getPropertyValue("modelPath");
        if (modelPathObj != null && modelPathObj instanceof String) {
            String modelPath = (String)modelPathObj;
            this.writer.beginElement("modelPath", -1);
            this.writer.data(modelPath);
            this.writer.endElement();
        }
        if (node instanceof V5Source && (queryRef = ((V5Source)node).getQueryRef()) != null) {
            this.writer.beginElement("queryRef", -1);
            this.writer.attribute("refQuery", queryRef.toString());
            this.writer.endElement();
        }
        if (node instanceof V5Query) {
            Object allJoinsObj;
            Boolean relSubquery;
            this.writer.beginElement("queryHints", -1);
            Object governorObj2 = node.getPropertyValue("governors");
            if (governorObj2 != null && governorObj2 instanceof Governors) {
                Governors governors = (Governors)governorObj2;
                Governors defaultGovernor = new Governors();
                for (V5Query.QueryHint queryHint : V5Query.QueryHint.values()) {
                    String hintName = queryHint.getPropertyName();
                    Object incomingValue = governors.getValue(hintName);
                    if (incomingValue == null || incomingValue.equals(defaultGovernor.getValue(hintName))) continue;
                    this.writer.beginElement(hintName, -1);
                    this.writer.attribute(VALUE, incomingValue.toString());
                    this.writer.endElement();
                }
            }
            if ((relSubquery = node.getBooleanPropertyValue("relationalSubquery")) != null && Boolean.TRUE == relSubquery) {
                this.writer.beginElement("relationalSubquery", -1);
                this.writer.attribute(VALUE, relSubquery.toString());
                this.writer.endElement();
            }
            if ((allJoinsObj = node.getPropertyValue("allJoins")) != null && allJoinsObj instanceof List) {
                this.writer.beginElement("allJoins", -1);
                List allJoinsList = (List)allJoinsObj;
                for (Object join : allJoinsList) {
                    this.writer.beginElement("join", -1);
                    this.writer.data(join.toString());
                    this.writer.endElement();
                }
                this.writer.endElement();
            }
            this.writer.endElement();
        }
        if (node instanceof V5QuerySet && (queryNode = node.getFirstChildByType(101006)) != null && (governorObj = queryNode.getPropertyValue("governors")) != null && governorObj instanceof Governors) {
            Governors governors = (Governors)governorObj;
            Governors defaultGovernor = new Governors();
            this.writer.beginElement("requestHints", -1);
            for (V5QuerySet.RequestHint requestHint : V5QuerySet.RequestHint.values()) {
                String hintName = requestHint.getPropertyName();
                Object incomingValue = governors.getValue(hintName);
                if (incomingValue == null || incomingValue.equals(defaultGovernor.getValue(hintName))) continue;
                this.writer.beginElement(hintName, -1);
                this.writer.attribute(VALUE, incomingValue.toString());
                this.writer.endElement();
            }
            this.writer.endElement();
        }
    }

    private void visitChildren(IXQEQueryNode parent) {
        block22: for (IXQEQueryNode child : parent.getChildren()) {
            switch (child.getType()) {
                case 101002: {
                    this.visit((V5QuerySet)child);
                    continue block22;
                }
                case 101006: {
                    this.visit((V5Query)child);
                    continue block22;
                }
                case 101009: {
                    this.visit((V5Selection)child);
                    continue block22;
                }
                case 101003: {
                    this.visit((V5DataItem)child);
                    continue block22;
                }
                case 101008: {
                    int numberDetailFilters = parent.getNumberChildrenOfType(101008);
                    if (this.getDetailFilterCounter() == 0) {
                        this.writer.beginElement(DETAILFILTERS, -1);
                    }
                    this.visitFilter((V5QueryNode)child, "detailFilter");
                    this.incrementDetailFilterCounter();
                    if (this.getDetailFilterCounter() != numberDetailFilters) continue block22;
                    this.writer.endElement();
                    continue block22;
                }
                case 101011: {
                    int numberSummaryFilters = parent.getNumberChildrenOfType(101011);
                    if (this.getSummaryFilterCounter() == 0) {
                        this.writer.beginElement(SUMMARYFILTERS, -1);
                    }
                    this.visitFilter((V5QueryNode)child, "summaryFilter");
                    this.incrementSummaryFilterCounter();
                    if (this.getSummaryFilterCounter() != numberSummaryFilters) continue block22;
                    this.writer.endElement();
                    continue block22;
                }
                case 101007: {
                    this.visit((V5Source)child);
                    continue block22;
                }
                case 101055: {
                    this.visit((V5QueryResultDefinition)child);
                    continue block22;
                }
                case 401005: {
                    this.visitChildren(child);
                    continue block22;
                }
                case 101049: {
                    int numberEdges = parent.getNumberChildrenOfType(101049);
                    if (this.getEdgeCounter() == 0) {
                        this.writer.beginElement(EDGES, -1);
                    }
                    this.visit((V5Edge)child);
                    this.incrementEdgeCounter();
                    if (this.getEdgeCounter() != numberEdges) continue block22;
                    this.writer.endElement();
                    continue block22;
                }
                case 101050: {
                    int numberEdgeGroups = parent.getNumberChildrenOfType(101050);
                    if (this.getEdgeGroupCounter() == 0) {
                        this.writer.beginElement(EDGEGROUPS, -1);
                    }
                    this.visit((V5EdgeGroup)child);
                    this.incrementEdgeGroupCounter();
                    if (this.getEdgeGroupCounter() != numberEdgeGroups) continue block22;
                    this.writer.endElement();
                    continue block22;
                }
                case 101057: {
                    int numberValueSets = parent.getNumberChildrenOfType(101057);
                    if (this.getValueSetCounter() == 0) {
                        this.writer.beginElement(VALUESETS, -1);
                    }
                    this.visit((V5ValueSet)child);
                    this.incrementValueSetCounter();
                    if (this.getValueSetCounter() != numberValueSets) continue block22;
                    this.writer.endElement();
                    continue block22;
                }
                case 101051: {
                    this.visit((V5GroupBody)child);
                    continue block22;
                }
                case 101053: {
                    this.visit((V5GroupHeader)child);
                    continue block22;
                }
                case 101052: {
                    this.visit((V5GroupFooter)child);
                    continue block22;
                }
                case 101015: {
                    this.visit((V5DataItemRef)child);
                    continue block22;
                }
                case 101056: {
                    int numberSortItems = parent.getNumberChildrenOfType(101056);
                    if (this.getSortItemCounter() == 0) {
                        this.writer.beginElement(GROUPSORT, -1);
                    }
                    this.visit((V5SortItem)child);
                    this.incrementSortItemCounter();
                    if (this.getSortItemCounter() != numberSortItems) continue block22;
                    this.writer.endElement();
                    continue block22;
                }
                case 101019: {
                    this.visit((V5JoinOperation)child);
                    continue block22;
                }
                case 101023: {
                    int numberQueryRefs = parent.getNumberChildrenOfType(101023);
                    if (this.getQueryRefCounter() == 0) {
                        this.writer.beginElement(QUERYREFS, -1);
                    }
                    this.visitGeneral((V5QueryNode)child);
                    this.incrementQueryRefCounter();
                    if (this.getQueryRefCounter() != numberQueryRefs) continue block22;
                    this.writer.endElement();
                    continue block22;
                }
                case 101018: 
                case 101020: 
                case 101022: {
                    this.visitGeneral((V5QueryNode)child);
                    continue block22;
                }
                default: {
                    if (!(child instanceof V5QueryNode)) continue block22;
                    this.writer.xml("<!-- V5SpecGen following node not supported, dumping internal form-->");
                    this.writer.writeXML(child.dumpToString(false));
                }
            }
        }
    }

    public void visit(V5QuerySet querySet) {
        this.writer.beginElement("Execute", -1);
        this.visitGeneral(querySet);
        this.writer.endElement();
    }

    public void visit(V5Query query) {
        this.detailFilterCounter = 0;
        this.summaryFilterCounter = 0;
        IXQEQueryNode parent = query.getParent();
        int numberQueries = parent.getNumberChildrenOfType(101006);
        if (this.getQueryCounter() == 0) {
            this.writer.beginElement(QUERIES, -1);
        }
        this.visitGeneral(query);
        this.incrementQueryCounter();
        if (this.getQueryCounter() == numberQueries) {
            this.writer.endElement();
        }
    }

    public void visit(V5Selection selection) {
        this.visitGeneral(selection);
    }

    public void visit(V5Source source) {
        this.visitGeneral(source);
    }

    public void visit(V5GroupBody groupBody) {
        this.visitGeneral(groupBody);
    }

    public void visit(V5GroupHeader groupHeader) {
        this.visitGeneral(groupHeader);
    }

    public void visit(V5GroupFooter groupFooter) {
        this.visitGeneral(groupFooter);
    }

    public void visit(V5DataItemRef dataItemRef) {
        this.visitGeneral(dataItemRef);
    }

    public void visit(V5SortItem sortItem) {
        this.visitGeneral(sortItem);
    }

    public void visit(V5DataItem dataItem) {
        this.writer.beginElement(V5TYPENAME_TO_V5NAME_MAP.get(dataItem.getNodeTypeName()), -1);
        this.dumpProperties(dataItem);
        for (IXQEQueryNode child : dataItem.getChildren()) {
            this.visitExpression(child, EXPRESSION);
        }
        this.writer.endElement();
    }

    public void visit(V5QueryResultDefinition qrd) {
        IXQEQueryNode parent = qrd.getParent();
        int numberQRDs = parent.getNumberChildrenOfType(101055);
        if (this.getQRDCounter() == 0) {
            this.writer.beginElement(QUERYRESULTDEFINITIONS, -1);
        }
        this.visitGeneral(qrd);
        this.incrementQRDCounter();
        if (this.getQRDCounter() == numberQRDs) {
            this.writer.endElement();
        }
    }

    public void visit(V5Edge edge) {
        this.visitGeneral(edge);
    }

    public void visit(V5EdgeGroup edgeGroup) {
        this.visitGeneral(edgeGroup);
    }

    public void visit(V5ValueSet valueSet) {
        this.visitGeneral(valueSet);
    }

    public void visitFilter(V5QueryNode filter, String v5Name) {
        this.writer.beginElement(v5Name, -1);
        this.dumpProperties(filter);
        for (IXQEQueryNode child : filter.getChildren()) {
            if (child instanceof V5SummaryFilterLevel) break;
            this.visitExpression(child, FILTEREXPRESSION);
        }
        int numLevels = filter.getNumberChildrenOfType(101012);
        if (numLevels > 0) {
            int countSummaryFilterLevels = 0;
            for (IXQEQueryNode level : filter.getChildrenOfType(101012)) {
                if (countSummaryFilterLevels == 0) {
                    this.writer.beginElement(SUMMARYFILTERLEVELS, -1);
                }
                this.visitGeneral((V5QueryNode)level);
                if (++countSummaryFilterLevels != numLevels) continue;
                this.writer.endElement();
            }
        }
        this.writer.endElement();
    }

    public void visitExpression(IXQEQueryNode expression, String elementName) {
        this.writer.beginElement(elementName, -1);
        if (expression instanceof V5Expression) {
            this.dumpProperties((V5QueryNode)expression);
        }
        StringBuilder stringBuilder = new StringBuilder();
        expression.writeFormattedText(stringBuilder);
        this.writer.data(stringBuilder.toString());
        this.writer.endElement();
    }

    public void visitGeneral(V5QueryNode node) {
        this.writer.beginElement(V5TYPENAME_TO_V5NAME_MAP.get(node.getNodeTypeName()), -1);
        this.dumpProperties(node);
        this.visitChildren(node);
        this.writer.endElement();
    }

    public void visit(V5QueryOperation node) {
        this.visitGeneral(node);
        this.writer.endElement();
    }

    public void visit(V5JoinOperation node) {
        this.writer.beginElement(V5TYPENAME_TO_V5NAME_MAP.get(node.getNodeTypeName()), -1);
        this.dumpProperties(node);
        for (IXQEQueryNode aChild : node.getChildren()) {
            if (aChild.getType() == 101013) {
                this.writer.beginElement(JOINFILTER, -1);
                this.visitExpression(aChild, FILTEREXPRESSION);
                this.writer.endElement();
                continue;
            }
            if (aChild.getType() == 101021) {
                int numberJoinOperand = node.getNumberChildrenOfType(101021);
                if (this.getJoinOperandCounter() == 0) {
                    this.writer.beginElement(JOINOPERANDS, -1);
                }
                this.visit((V5JoinOperand)aChild);
                this.incrementJoinOperandCounter();
                if (this.getJoinOperandCounter() != numberJoinOperand) continue;
                this.writer.endElement();
                this.joinOperandCounter = 0;
                continue;
            }
            this.writer.xml("<!-- V5SpecGen following node not supported as children of V5JoinOperation, dumping internal form-->");
            this.writer.writeXML(aChild.dumpToString(false));
        }
        this.writer.endElement();
    }

    public void visit(V5JoinOperand node) {
        this.writer.beginElement(V5TYPENAME_TO_V5NAME_MAP.get(node.getNodeTypeName()), -1);
        this.dumpProperties(node);
        this.visitChildren(node);
        this.writer.endElement();
    }

    static {
        V5TYPENAME_TO_V5NAME_MAP.put("V5QuerySet", "querySet");
        V5TYPENAME_TO_V5NAME_MAP.put("V5Query", "query");
        V5TYPENAME_TO_V5NAME_MAP.put("V5Selection", "selection");
        V5TYPENAME_TO_V5NAME_MAP.put("V5Source", "source");
        V5TYPENAME_TO_V5NAME_MAP.put("V5DataItem", "dataItem");
        V5TYPENAME_TO_V5NAME_MAP.put("V5SummaryFilterLevel", "summaryFilterLevel");
        V5TYPENAME_TO_V5NAME_MAP.put("V5QueryResultDefinition", "queryResultDefinition");
        V5TYPENAME_TO_V5NAME_MAP.put("V5Edge", "edge");
        V5TYPENAME_TO_V5NAME_MAP.put("V5EdgeGroup", "edgeGroup");
        V5TYPENAME_TO_V5NAME_MAP.put("V5ValueSet", "valueSet");
        V5TYPENAME_TO_V5NAME_MAP.put("V5GroupBody", "groupBody");
        V5TYPENAME_TO_V5NAME_MAP.put("V5GroupFooter", "groupFooter");
        V5TYPENAME_TO_V5NAME_MAP.put("V5GroupHeader", "groupHeader");
        V5TYPENAME_TO_V5NAME_MAP.put("V5DataItemRef", "dataItemRef");
        V5TYPENAME_TO_V5NAME_MAP.put("V5SortItem", "sortItem");
        V5TYPENAME_TO_V5NAME_MAP.put("V5JoinOperation", "joinOperation");
        V5TYPENAME_TO_V5NAME_MAP.put("V5JoinOperand", "joinOperand");
        V5TYPENAME_TO_V5NAME_MAP.put("V5QueryOperation", "queryOperation");
        V5TYPENAME_TO_V5NAME_MAP.put("V5QueryRef", "queryRef");
        V5TYPENAME_TO_V5NAME_MAP.put("V5ProjectionList", "projectionList");
        V5TYPENAME_TO_V5NAME_MAP.put("V5QueryItem", "queryItem");
    }
}

