/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class Gate {
    private final AtomicBoolean mOpen = new AtomicBoolean(false);
    private final Lock mSync = new ReentrantLock();
    private final Condition mOpenCond = this.mSync.newCondition();
    private final Runnable mOpenCallback;

    public Gate() {
        this(null);
    }

    public Gate(Runnable openCallback) {
        this.mOpenCallback = openCallback;
    }

    public void await() throws InterruptedException {
        if (this.mOpen.get()) {
            return;
        }
        this.mSync.lock();
        try {
            while (!this.mOpen.get()) {
                this.mOpenCond.await();
            }
        }
        finally {
            this.mSync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.mOpen.get()) {
            return true;
        }
        this.mSync.lock();
        try {
            while (!this.mOpen.get()) {
                if (this.mOpenCond.await(timeout, unit)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.mSync.unlock();
        }
        return true;
    }

    public void awaitUninterruptibly() {
        if (this.mOpen.get()) {
            return;
        }
        this.mSync.lock();
        try {
            while (!this.mOpen.get()) {
                this.mOpenCond.awaitUninterruptibly();
            }
        }
        finally {
            this.mSync.unlock();
        }
    }

    public boolean isOpen() {
        return this.mOpen.get();
    }

    public void open() {
        if (this.mOpen.compareAndSet(false, true)) {
            if (null != this.mOpenCallback) {
                this.mOpenCallback.run();
            }
            this.mSync.lock();
            try {
                this.mOpenCond.signalAll();
            }
            finally {
                this.mSync.unlock();
            }
        }
    }

    public void close() {
        this.mOpen.set(false);
    }
}

