/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class UnboundedThreadPool {
    private static ExecutorService threadPoolService = Executors.newCachedThreadPool(new UnboundedThreadPoolFactory());
    public static final String THREAD_NAME_PREFIX = "UnboundedThreadPool: ";

    public static ExecutorService getThreadPool() {
        return threadPoolService;
    }

    private static class UnboundedThreadPoolFactory
    implements ThreadFactory {
        private UnboundedThreadPoolFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            ThreadFactory defaultFactory = Executors.defaultThreadFactory();
            Thread thd = defaultFactory.newThread(r);
            thd.setName(UnboundedThreadPool.THREAD_NAME_PREFIX + thd.getName());
            return thd;
        }
    }
}

