/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.datasets;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.ibm.json.java.JSON;
import com.ibm.json.java.OrderedJSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import org.apache.commons.io.IOUtils;

public class MetadataInfo {
    public static final String STORE_ID_KEY = "storeID";
    public static final String UPLOADED_FILE_NAME_KEY = "uploadedFileName";
    public static final String UPLOADED_FILE_TIMESTAMP_KEY = "uploadedFileTimestamp";
    public static final String CA_ABSOLUTE_PATH_KEY = "caPQAbsolutePath";
    public static final String FLINT_ABSOLUTE_PATH_KEY = "flintPQAbsolutePath";
    private String storeID;
    private String uploadedFileName;
    private LocalDateTime uploadedFileTimestamp;
    private String caPQAbsolutePath;
    private String flintPQAbsolutePath;
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "DatasetManager", LogLevel.WARN);

    public MetadataInfo(String theStoreId, String theUploadedFileName, LocalDateTime theUploadedFileTimestamp) {
        this.setStoreID(theStoreId);
        this.uploadedFileName = theUploadedFileName;
        this.uploadedFileTimestamp = theUploadedFileTimestamp;
    }

    public String getStoreID() {
        return this.storeID;
    }

    public void setStoreID(String providedStoreID) {
        this.storeID = providedStoreID;
    }

    public String getUploadedFileName() {
        return this.uploadedFileName;
    }

    public void setUploadedFileName(String providedUploadedFileName) {
        this.uploadedFileName = providedUploadedFileName;
    }

    public LocalDateTime getUploadedFileTimestamp() {
        return this.uploadedFileTimestamp;
    }

    public void setUploadedFileTimestamp(LocalDateTime providedUploadedFileTimestamp) {
        this.uploadedFileTimestamp = providedUploadedFileTimestamp;
    }

    public String getCAPQAbsolutePath() {
        return this.caPQAbsolutePath;
    }

    public void setCAPQAbsolutePath(String providedCAPQAbsolutePath) {
        this.caPQAbsolutePath = providedCAPQAbsolutePath;
    }

    public String getFlintPQAbsolutePath() {
        return this.flintPQAbsolutePath;
    }

    public void setFlintPQAbsolutePath(String providedFlintPQAbsolutePath) {
        this.flintPQAbsolutePath = providedFlintPQAbsolutePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataInfo fromJSON(InputStream in) {
        MetadataInfo result = null;
        if (in == null) {
            return result;
        }
        try {
            OrderedJSONObject metaInfo = (OrderedJSONObject)JSON.parse((InputStream)in, (boolean)true);
            String storeId = (String)metaInfo.get((Object)STORE_ID_KEY);
            String uploadedFileName = (String)metaInfo.get((Object)UPLOADED_FILE_NAME_KEY);
            LocalDateTime uploadedFileTimestamp = LocalDateTime.parse((String)metaInfo.get((Object)UPLOADED_FILE_TIMESTAMP_KEY));
            String caPQPath = (String)metaInfo.get((Object)CA_ABSOLUTE_PATH_KEY);
            String flintPQPath = (String)metaInfo.get((Object)FLINT_ABSOLUTE_PATH_KEY);
            if (storeId == null || storeId.isEmpty()) {
                throw new IllegalArgumentException("The storeID is null or empty.");
            }
            if (uploadedFileName == null || uploadedFileName.isEmpty()) {
                throw new IllegalArgumentException("The uploadedFileName is null or empty.");
            }
            if (caPQPath == null || caPQPath.isEmpty()) {
                throw new IllegalArgumentException("The caPQAbsolutePath is null or empty.");
            }
            if (flintPQPath == null || flintPQPath.isEmpty()) {
                throw new IllegalArgumentException("The flintPQAbsolutePath is null or empty.");
            }
            result = new MetadataInfo(storeId, uploadedFileName, uploadedFileTimestamp);
            result.setCAPQAbsolutePath(caPQPath);
            result.setFlintPQAbsolutePath(flintPQPath);
        }
        catch (DateTimeParseException dtpe) {
            if (LOGGER.isOn(LogLevel.WARN)) {
                LOGGER.log("Corrupted value for key 'uploadedFileTimestamp' detected.", (Throwable)dtpe);
            }
            result = null;
        }
        catch (IllegalArgumentException iae) {
            if (LOGGER.isOn(LogLevel.WARN)) {
                LOGGER.log(iae);
            }
            result = null;
        }
        catch (NullPointerException ne) {
            if (LOGGER.isOn(LogLevel.WARN)) {
                LOGGER.log("The input stream provided is null", (Throwable)ne);
            }
            result = null;
        }
        catch (IOException ioe) {
            if (LOGGER.isOn(LogLevel.WARN)) {
                LOGGER.log("Cannot read the provided metadataInfo.json input stream.", (Throwable)ioe);
            }
            result = null;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return result;
    }

    public String toJSONString() {
        OrderedJSONObject obj = new OrderedJSONObject();
        obj.put((Object)STORE_ID_KEY, (Object)this.storeID);
        obj.put((Object)UPLOADED_FILE_NAME_KEY, (Object)this.uploadedFileName);
        obj.put((Object)UPLOADED_FILE_TIMESTAMP_KEY, (Object)this.uploadedFileTimestamp.toString());
        obj.put((Object)CA_ABSOLUTE_PATH_KEY, (Object)this.caPQAbsolutePath);
        obj.put((Object)FLINT_ABSOLUTE_PATH_KEY, (Object)this.flintPQAbsolutePath);
        return obj.toString();
    }
}

