/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.eviction;

import com.cognos.xqe.util.eviction.AbstractMapEvictionQueue;
import com.cognos.xqe.util.eviction.IMapEvictionQueue;
import java.util.HashSet;
import java.util.Set;

public final class SimpleDLinkMapLRUEvictionQueue<K, V>
extends AbstractMapEvictionQueue<K, V> {
    private final DLinkEntry<K, V> mHeadSentinel = new DLinkEntry<Object, Object>(this, null, null);
    private final DLinkEntry<K, V> mTailSentinel = new DLinkEntry<Object, Object>(this, null, null);
    int mEvictionQueueSize;

    public SimpleDLinkMapLRUEvictionQueue(int retainSize, IMapEvictionQueue.IEvictionTarget<K, V> evictionTarget) {
        super(retainSize, evictionTarget);
        this.initAsEmpty();
    }

    private void initAsEmpty() {
        this.mHeadSentinel.mNext = this.mTailSentinel;
        this.mTailSentinel.mPrevious = this.mHeadSentinel;
        this.mEvictionQueueSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnAdd(DLinkEntry<K, V> entry) {
        DLinkEntry entryToEvict = null;
        SimpleDLinkMapLRUEvictionQueue simpleDLinkMapLRUEvictionQueue = this;
        synchronized (simpleDLinkMapLRUEvictionQueue) {
            entry.insertBefore(this.mTailSentinel);
            ++this.mEvictionQueueSize;
            if (this.mEvictionQueueSize > this.mRetainSize) {
                entryToEvict = this.mHeadSentinel.mNext;
            }
        }
        while (null != entryToEvict) {
            SimpleDLinkMapLRUEvictionQueue simpleDLinkMapLRUEvictionQueue2;
            IMapEvictionQueue.IEntry evictedEntry = this.mEvictionTarget.evictEntry(entryToEvict);
            if (evictedEntry != entryToEvict) {
                simpleDLinkMapLRUEvictionQueue2 = this;
                synchronized (simpleDLinkMapLRUEvictionQueue2) {
                    if (entryToEvict.remove(true)) {
                        --this.mEvictionQueueSize;
                    }
                    entryToEvict = this.mEvictionQueueSize > this.mRetainSize ? this.mHeadSentinel.mNext : null;
                    continue;
                }
            }
            simpleDLinkMapLRUEvictionQueue2 = this;
            synchronized (simpleDLinkMapLRUEvictionQueue2) {
                entryToEvict = this.mEvictionQueueSize > this.mRetainSize ? this.mHeadSentinel.mNext : null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnRecentUse(DLinkEntry<K, V> entry) {
        SimpleDLinkMapLRUEvictionQueue simpleDLinkMapLRUEvictionQueue = this;
        synchronized (simpleDLinkMapLRUEvictionQueue) {
            if (this.mTailSentinel != entry.mNext && entry.remove(false)) {
                entry.insertBefore(this.mTailSentinel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnRemove(DLinkEntry<K, V> entry) {
        SimpleDLinkMapLRUEvictionQueue simpleDLinkMapLRUEvictionQueue = this;
        synchronized (simpleDLinkMapLRUEvictionQueue) {
            if (entry.remove(true)) {
                --this.mEvictionQueueSize;
            }
        }
    }

    @Override
    public IMapEvictionQueue.IEntry<K, V> newEntry(K key, V value) {
        return new DLinkEntry<K, V>(this, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<K> keySet() {
        HashSet result = new HashSet();
        SimpleDLinkMapLRUEvictionQueue simpleDLinkMapLRUEvictionQueue = this;
        synchronized (simpleDLinkMapLRUEvictionQueue) {
            DLinkEntry current = this.mHeadSentinel.mNext;
            while (current != this.mTailSentinel) {
                result.add(current.getKey());
                current = current.mNext;
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.mEvictionQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        SimpleDLinkMapLRUEvictionQueue simpleDLinkMapLRUEvictionQueue = this;
        synchronized (simpleDLinkMapLRUEvictionQueue) {
            this.initAsEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        SimpleDLinkMapLRUEvictionQueue simpleDLinkMapLRUEvictionQueue = this;
        synchronized (simpleDLinkMapLRUEvictionQueue) {
            int nbEntries;
            int mapSize = this.mEvictionTarget.size();
            sb.append("{map size = ").append(mapSize);
            int queueSize = this.size();
            if (queueSize != mapSize) {
                sb.append(" queueSize mismatch = ").append(queueSize);
            }
            if ((nbEntries = this.keySet().size()) != mapSize) {
                sb.append(" nbEntries mismatch = ").append(nbEntries);
            }
            DLinkEntry current = this.mHeadSentinel.mNext;
            while (current != this.mTailSentinel) {
                sb.append(current.toString());
                current = current.mNext;
            }
            sb.append('}');
        }
        return sb.toString();
    }

    private static final class DLinkEntry<K, V>
    extends AbstractMapEvictionQueue.Entry<K, V> {
        final SimpleDLinkMapLRUEvictionQueue<K, V> mLRUEvictionQueue;
        DLinkEntry<K, V> mPrevious;
        DLinkEntry<K, V> mNext;

        DLinkEntry(SimpleDLinkMapLRUEvictionQueue<K, V> lruEvictionQueue, K key, V value) {
            super(key, value);
            this.mLRUEvictionQueue = lruEvictionQueue;
            this.mPrevious = null;
            this.mNext = null;
        }

        @Override
        public void updateOnAdd() {
            ((SimpleDLinkMapLRUEvictionQueue)this.mLRUEvictionQueue).updateOnAdd(this);
        }

        @Override
        public void updateOnRecentUse() {
            ((SimpleDLinkMapLRUEvictionQueue)this.mLRUEvictionQueue).updateOnRecentUse(this);
        }

        @Override
        public void updateOnRemove() {
            ((SimpleDLinkMapLRUEvictionQueue)this.mLRUEvictionQueue).updateOnRemove(this);
        }

        private void markAsRemoved() {
            this.mPrevious = null;
        }

        boolean markedAsRemoved() {
            return null == this.mPrevious;
        }

        boolean remove(boolean removeEvenIfLast) {
            boolean result;
            if (this == ((SimpleDLinkMapLRUEvictionQueue)this.mLRUEvictionQueue).mTailSentinel.mPrevious && !removeEvenIfLast) {
                result = false;
            } else if (!this.markedAsRemoved()) {
                this.mPrevious.mNext = this.mNext;
                this.mNext.mPrevious = this.mPrevious;
                this.markAsRemoved();
                result = true;
            } else {
                result = false;
            }
            return result;
        }

        void insertBefore(DLinkEntry<K, V> nextDLinkEntry) {
            DLinkEntry<K, V> previousDLinkEntry = nextDLinkEntry.mPrevious;
            previousDLinkEntry.mNext = this;
            this.mPrevious = previousDLinkEntry;
            nextDLinkEntry.mPrevious = this;
            this.mNext = nextDLinkEntry;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[').append(this.getKey()).append(':').append(this.getValue()).append(']');
            return sb.toString();
        }
    }
}

