/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.fds;

import com.cognos.xqe.ast.v5Exp_new2.parser.ASTFunction;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import com.cognos.xqe.util.fds.FunctionDefinition;
import com.cognos.xqe.util.fds.IFunctionDLL;
import com.cognos.xqe.util.fds.IFunctionNode;
import com.cognos.xqe.util.fds.IFunctionParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public interface IFunctionDefinition {
    public void addContextFilter(String var1);

    public void addContextFiltersForCQE();

    public void addModelDatasourceInterfaceIDFilter(String var1);

    public void addModelDatasourceQueryTypeFilter(String var1);

    public void addTypeFilter(String var1);

    public void addVendorFunctionSetFilter(String var1);

    public IFunctionNode findById(String var1);

    public IFunctionNode findByName(String var1);

    public ArrayList<IFunctionNode> findFuncListByName(String var1);

    public MatchedFunction findFuncListByNameAndParameterTypes(ASTFunction var1, String var2, List<FDSDataTypeEnum> var3, boolean var4);

    public ArrayList<IFunctionDLL> getDLLs();

    public Locale getEffectiveLocale();

    public TreeSet<String> getSupportedLocaleNames();

    public void getSupportedVendorFunctionSets(ArrayList<String> var1, ArrayList<String> var2);

    public String getVendorFunctionSetName(String var1);

    public ArrayList<String> getSupportedModelDatasourceInterfaceIDs();

    public IFunctionNode getRoot();

    public void addAppGroup(String var1, IFunctionNode var2);

    public void overrideModelQoSLevel(String var1, IFunctionNode.FDSQoSLevelEnum var2, String var3);

    public void overridePackageQoSLevel(String var1, IFunctionNode.FDSQoSLevelEnum var2, String var3);

    public void showHidden();

    public void showOnlyDimensional();

    public static final class MatchedFunction {
        private IFunctionNode functionNode = null;
        private MatchTypeEnum matchType = null;
        private List<ParameterMismatch> parameterMismatches = null;
        private int parameterCount;

        MatchedFunction() {
        }

        public void addExactMatch(IFunctionNode theFunctionNode) {
            if (this.getMatchType() != MatchTypeEnum.EXACT) {
                this.setMatchType(MatchTypeEnum.EXACT);
                this.setFunctionNode(theFunctionNode);
            }
        }

        public void addNameCountMatch(IFunctionNode theFunctionNode, List<ParameterMismatch> theParameterMismatches) {
            if (this.getMatchType() != MatchTypeEnum.NAME_COUNT && this.getMatchType() != MatchTypeEnum.EXACT) {
                this.setMatchType(MatchTypeEnum.NAME_COUNT);
                this.setFunctionNode(theFunctionNode);
                this.setParameterMismatches(theParameterMismatches);
            }
        }

        public void addNameMatch(IFunctionNode theFunctionNode, int theParameterCount) {
            if (this.getMatchType() == null) {
                this.setMatchType(MatchTypeEnum.NAME);
                this.setFunctionNode(theFunctionNode);
                this.setParameterCount(theParameterCount);
            }
        }

        private void setFunctionNode(IFunctionNode theFunctionNode) {
            this.functionNode = theFunctionNode;
        }

        public IFunctionNode getFunctionNode() {
            return this.functionNode;
        }

        private void setMatchType(MatchTypeEnum theMatchType) {
            this.matchType = theMatchType;
        }

        public MatchTypeEnum getMatchType() {
            return this.matchType;
        }

        public boolean hasMatch() {
            return this.getMatchType() != null;
        }

        private void setParameterMismatches(List<ParameterMismatch> theParameterMismatches) {
            this.parameterMismatches = theParameterMismatches;
        }

        public List<ParameterMismatch> getParameterMismatches() {
            return this.parameterMismatches;
        }

        private void setParameterCount(int theParameterCount) {
            this.parameterCount = theParameterCount;
        }

        public int getParameterCount() {
            return this.parameterCount;
        }
    }

    public static final class ParameterMismatch {
        private int position;
        private IFunctionParameter expectedParameter;
        private boolean olapParameter;

        ParameterMismatch(int thePosition, IFunctionParameter theExpectedParameter, boolean isOLAPParameter) {
            this.position = thePosition;
            this.expectedParameter = theExpectedParameter;
            this.olapParameter = isOLAPParameter;
        }

        public int getPosition() {
            return this.position;
        }

        public IFunctionParameter getExpectedParameter() {
            return this.expectedParameter;
        }

        public boolean isOLAPParameter() {
            return this.olapParameter;
        }
    }

    public static enum MatchTypeEnum {
        EXACT,
        NAME,
        NAME_COUNT;

    }

    public static class Util {
        public static FDSDataTypeEnum getFunctionReturnType(String fname) {
            return FunctionDefinition.getFunctionReturnType(fname);
        }

        public static String getFunctionFormatType(String fname) {
            return FunctionDefinition.getFunctionFormatType(fname);
        }

        public static String getFunctionFormatTypeBasedOnVendorID(String fname, MetadataConnection mdc) {
            return FunctionDefinition.getFunctionFormatTypeBasedOnVendorID(fname, mdc);
        }

        public static String getFormatForSpec(String formatSpec) {
            return FunctionDefinition.getFormatForSpec(formatSpec);
        }

        static IFunctionNode.FDSQoSLevelEnum consolidateQosLevels(IFunctionNode.FDSQoSLevelEnum existingQosLevel, IFunctionNode.FDSQoSLevelEnum newQosLevel) {
            if (existingQosLevel.compareTo(IFunctionNode.FDSQoSLevelEnum.UNSPECIFIED) <= 0) {
                return newQosLevel;
            }
            IFunctionNode.FDSQoSLevelEnum resultVal = IFunctionNode.FDSQoSLevelEnum.UNAVAILABLE;
            block0 : switch (existingQosLevel) {
                case UNAVAILABLE: {
                    switch (newQosLevel) {
                        case UNAVAILABLE: {
                            resultVal = IFunctionNode.FDSQoSLevelEnum.UNAVAILABLE;
                            break block0;
                        }
                        case RESTRICTED: 
                        case LIMITED: 
                        case OK: {
                            resultVal = IFunctionNode.FDSQoSLevelEnum.RESTRICTED;
                            break block0;
                        }
                    }
                    break;
                }
                case RESTRICTED: {
                    resultVal = IFunctionNode.FDSQoSLevelEnum.RESTRICTED;
                    break;
                }
                case LIMITED: {
                    switch (newQosLevel) {
                        case UNAVAILABLE: 
                        case RESTRICTED: {
                            resultVal = IFunctionNode.FDSQoSLevelEnum.RESTRICTED;
                            break block0;
                        }
                        case LIMITED: 
                        case OK: {
                            resultVal = IFunctionNode.FDSQoSLevelEnum.LIMITED;
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    switch (newQosLevel) {
                        case UNAVAILABLE: 
                        case RESTRICTED: {
                            resultVal = IFunctionNode.FDSQoSLevelEnum.RESTRICTED;
                            break block0;
                        }
                        case LIMITED: {
                            resultVal = IFunctionNode.FDSQoSLevelEnum.LIMITED;
                            break block0;
                        }
                        case OK: {
                            resultVal = IFunctionNode.FDSQoSLevelEnum.OK;
                            break block0;
                        }
                    }
                }
            }
            return resultVal;
        }

        Set<String> getInterfaceIDs(InterfaceIDType idType) {
            return FunctionDefinition.getInterfaceIDs(idType);
        }

        static boolean isInterfaceIDSupported(InterfaceIDType interfaceIDType, String interfaceID) {
            return FunctionDefinition.isInterfaceIDSupported(interfaceIDType, interfaceID);
        }
    }

    public static final class Factory {
        public static IFunctionDefinition create(Locale desiredLocale) {
            FunctionDefinition fd = new FunctionDefinition(desiredLocale);
            return fd;
        }

        public static IFunctionDefinition createFDAllLocales() {
            FunctionDefinition fd = new FunctionDefinition();
            return fd;
        }
    }

    public static enum InterfaceIDType {
        eRelationalInterfaceIDs,
        eMultidimensionalInterfaceIDs,
        eAll;

    }
}

