/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.fds;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.iterators.EmptyIterator;

public class MultiTreeMap<K, V>
extends TreeMap<K, Collection<V>> {
    private static final long serialVersionUID = -1970243827504183174L;
    private Collection<V> valuesCollection = null;

    public Iterator<V> iterator(K key) {
        Collection theValues = (Collection)this.get(key);
        if (theValues == null) {
            return EmptyIterator.INSTANCE;
        }
        return theValues.iterator();
    }

    @Override
    public Collection<V> put(K key, Collection<V> value) {
        return super.put(key, value);
    }

    public Collection<V> putValue(K key, V value) {
        boolean results;
        Collection<V> theValues = (Collection<V>)this.get(key);
        if (theValues == null) {
            theValues = this.createNewCollection(null);
            super.put(key, theValues);
        }
        if (results = theValues.add(value)) {
            return theValues;
        }
        return null;
    }

    protected Collection<V> createNewCollection(Collection<V> newCollection) {
        if (newCollection == null) {
            return new ArrayList();
        }
        return new ArrayList<V>(newCollection);
    }

    public boolean putAll(K key, Collection<V> valueSet) {
        if (valueSet == null || valueSet.size() == 0) {
            return false;
        }
        Collection<V> theValues = (Collection<V>)this.get(key);
        if (theValues == null) {
            theValues = this.createNewCollection(valueSet);
            if (theValues.size() == 0) {
                return false;
            }
            super.put(key, theValues);
            return true;
        }
        return theValues.addAll(valueSet);
    }

    @Override
    public void clear() {
        Set pairs = super.entrySet();
        for (Map.Entry thePair : pairs) {
            Collection theValues = (Collection)thePair.getValue();
            theValues.clear();
        }
        super.clear();
    }

    public Collection<V> getAllValues() {
        Collection<V> theValues = this.valuesCollection;
        if (theValues != null) {
            return theValues;
        }
        this.valuesCollection = new MapValues();
        return this.valuesCollection;
    }

    private final class ValueIterator<E>
    implements Iterator<V> {
        private Iterator<Collection<V>> valueColIterator;
        private Iterator<V> tempValColIterator;

        private ValueIterator() {
            this.valueColIterator = MultiTreeMap.super.values().iterator();
        }

        private boolean getNextIterator() {
            while (this.tempValColIterator == null || !this.tempValColIterator.hasNext()) {
                if (!this.valueColIterator.hasNext()) {
                    return false;
                }
                this.tempValColIterator = this.valueColIterator.next().iterator();
            }
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.getNextIterator();
        }

        @Override
        public V next() {
            if (!this.getNextIterator()) {
                throw new NoSuchElementException();
            }
            return this.tempValColIterator.next();
        }

        @Override
        public void remove() {
            if (this.tempValColIterator == null) {
                throw new IllegalStateException();
            }
            this.tempValColIterator.remove();
        }
    }

    private class MapValues<E>
    extends AbstractCollection<V> {
        private MapValues() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            int numberValues = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                it.next();
                ++numberValues;
            }
            return numberValues;
        }

        @Override
        public void clear() {
            MultiTreeMap.this.clear();
        }
    }
}

