/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.io;

import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.runtree.XDataContext;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class BufferedDataInputStream
extends DataInputStream {
    private static final int PAGE_SIZE = 0x100000;
    private static final String READ_MODE = "r";

    public BufferedDataInputStream(File file) throws IOException {
        super(new NIOInputStream(file, 0));
    }

    public BufferedDataInputStream(File file, int iterators) throws IOException {
        super(new NIOInputStream(file, iterators));
    }

    public boolean readValue(XDataContext context, IEncodable value) throws IOException {
        try {
            value.decode(context, this);
        }
        catch (EOFException e) {
            return false;
        }
        catch (IOException e) {
            throw e;
        }
        return true;
    }

    public void seek(long pos) throws IOException {
        this.reset();
        this.skip(pos);
    }

    public long getPosition() throws IOException {
        return ((NIOInputStream)this.in).channelPosition();
    }

    static class NIOInputStream
    extends InputStream {
        private static final int SMALEST_PAGE_SIZE = 4;
        private static final int BLOCK_SIZE = 1024;
        private static final int MASK = 255;
        private FileChannel channel;
        private ByteBuffer buffer;
        private boolean valid;
        private RandomAccessFile ra;

        NIOInputStream(File file, int iterators) throws IOException {
            this.ra = new RandomAccessFile(file, BufferedDataInputStream.READ_MODE);
            this.channel = this.ra.getChannel();
            this.buffer = ByteBuffer.allocate(this.culcBufferSize(iterators));
            this.valid = false;
        }

        private int culcBufferSize(int iterators) {
            int bufferSize = 0x100000;
            if (iterators > 0) {
                bufferSize = 1024 / (iterators + 1);
                bufferSize = bufferSize < 4 ? 4096 : bufferSize * 1024;
            }
            return bufferSize;
        }

        @Override
        public int read() throws IOException {
            int x = 0;
            this.validate();
            if (!this.buffer.hasRemaining()) {
                this.buffer.clear();
                this.channel.read(this.buffer);
                this.buffer.flip();
            }
            try {
                x = 0xFF & this.buffer.get();
                return x;
            }
            catch (BufferUnderflowException e) {
                return -1;
            }
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
            this.ra.close();
        }

        @Override
        public void reset() throws IOException {
            this.channel.position(0L);
            this.valid = false;
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.valid) {
                int nb = this.buffer.remaining();
                if ((long)nb > n) {
                    int pos = this.buffer.position();
                    this.buffer.position(pos += (int)n);
                } else {
                    long position = this.channel.position() + (n - (long)nb);
                    this.channel.position(position);
                    this.buffer.clear();
                    this.channel.read(this.buffer);
                    this.buffer.flip();
                }
            } else {
                long position = this.channel.position() + n;
                this.channel.position(position);
            }
            return n;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        private void validate() throws IOException {
            if (!this.valid) {
                this.buffer.clear();
                this.channel.read(this.buffer);
                this.buffer.flip();
                this.valid = true;
            }
        }

        public long channelPosition() throws IOException {
            return this.channel.position();
        }
    }
}

