/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.io;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class BufferedDataOutputStream
extends DataOutputStream {
    private static final int PAGE_SIZE = 0x100000;
    private static final String READ_WRITE_MODE = "rw";
    private static XQELogger infoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CacheManager", LogLevel.INFO);

    public BufferedDataOutputStream(File file) throws FileNotFoundException {
        this(file, 1);
    }

    public BufferedDataOutputStream(File file, int nPages) throws FileNotFoundException {
        super(new NIOOutputStream(file, nPages));
    }

    public BufferedDataOutputStream(File file, int nPages, int requestId) throws FileNotFoundException {
        super(new NIOOutputStream(file, nPages, requestId));
    }

    public void writeValue(XDataContext context, IEncodable value) {
        try {
            value.encode(context, this);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    public long getPosition() {
        return ((NIOOutputStream)this.out).getBytesWritten();
    }

    private static class NIOOutputStream
    extends OutputStream {
        private FileChannel channel;
        private ByteBuffer buffer;
        private long counter;
        private int nPages;
        private int maxPages;
        private int requestId = -1;
        private String fileName;

        NIOOutputStream(File file, int iMaxPages) throws FileNotFoundException {
            RandomAccessFile ra = new RandomAccessFile(file, BufferedDataOutputStream.READ_WRITE_MODE);
            this.channel = ra.getChannel();
            this.buffer = ByteBuffer.allocate(0x100000);
            this.counter = 0L;
            this.nPages = 1;
            this.maxPages = iMaxPages;
        }

        NIOOutputStream(File file, int iMaxPages, int id) throws FileNotFoundException {
            this(file, iMaxPages);
            this.requestId = id;
            this.fileName = file.getName();
        }

        @Override
        public void write(int b) throws IOException {
            if (!this.buffer.hasRemaining()) {
                if (this.nPages < this.maxPages) {
                    ++this.nPages;
                    this.buffer.rewind();
                    ByteBuffer tmpBuffer = ByteBuffer.allocate(this.nPages * 0x100000);
                    tmpBuffer.put(this.buffer);
                    this.buffer = tmpBuffer;
                } else {
                    if (this.requestId != -1) {
                        infoLogger.log(String.format("Exceeded maximum memory usage for cached result set [id=%1$d, maxMemory=%2$d] - spilling to disk [file=%3$s].", this.requestId, this.maxPages, this.fileName));
                        this.requestId = -1;
                    }
                    this.buffer.flip();
                    this.channel.write(this.buffer);
                    if (this.nPages > 1) {
                        this.buffer = ByteBuffer.allocate(0x100000);
                        this.nPages = 1;
                    } else {
                        this.buffer.clear();
                    }
                }
            }
            this.buffer.put((byte)b);
            ++this.counter;
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.channel.close();
        }

        @Override
        public void flush() throws IOException {
            if (this.buffer.position() > 0) {
                this.buffer.flip();
                this.channel.write(this.buffer);
                this.buffer.clear();
            }
        }

        public long getBytesWritten() {
            return this.counter;
        }
    }
}

