/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class MultiOutputStream
extends OutputStream {
    private static final String ERRMSG_STREAM_WAS_NULL = "stream was null";
    private final List<OutputStream> sinks = new ArrayList<OutputStream>();

    public MultiOutputStream() {
    }

    public void addStream(OutputStream stream) {
        if (null == stream) {
            throw new NullPointerException(ERRMSG_STREAM_WAS_NULL);
        }
        this.sinks.add(stream);
    }

    public boolean removeStream(OutputStream stream) {
        if (null == stream) {
            throw new NullPointerException(ERRMSG_STREAM_WAS_NULL);
        }
        return this.sinks.remove(stream);
    }

    public void clearStreams() {
        this.sinks.clear();
    }

    public MultiOutputStream(Collection<? extends OutputStream> theSinks) {
        for (OutputStream outputStream : theSinks) {
            if (null != outputStream) continue;
            throw new NullPointerException("theSinks contained at least one null OutputStream.");
        }
        this.sinks.addAll(theSinks);
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream stream : this.sinks) {
            stream.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        for (OutputStream stream : this.sinks) {
            stream.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (OutputStream stream : this.sinks) {
            stream.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream stream : this.sinks) {
            stream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (OutputStream stream : this.sinks) {
            stream.close();
        }
    }
}

