/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.memory;

import com.cognos.xqe.util.memory.MemorySizes;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;

public class MemoryCounter {
    private static final MemorySizes SIZES = new MemorySizes();
    private final Map<Object, Object> visited = new IdentityHashMap<Object, Object>();
    private final Stack<Object> stack = new Stack();
    private static Class unsafe;
    private static final long EIGHT = 8L;

    public synchronized long estimate(Object obj, boolean includeStatic) {
        long result = this.estimateObject(obj, includeStatic);
        while (!this.stack.isEmpty()) {
            result += this.estimateObject(this.stack.pop(), includeStatic);
        }
        this.visited.clear();
        return result;
    }

    private boolean skipObject(Object obj) {
        if (obj instanceof String && obj == ((String)obj).intern()) {
            return true;
        }
        return obj == null || this.visited.containsKey(obj);
    }

    private long estimateObject(Object obj, boolean includeStatic) {
        Class<?> clazz;
        long result = 0L;
        if (obj == null) {
            return 0L;
        }
        if (this.skipObject(obj)) {
            return 0L;
        }
        this.visited.put(obj, null);
        if (clazz.isArray()) {
            return this.estimateArray(obj, includeStatic);
        }
        for (clazz = obj.getClass(); clazz != null && this.isSafe(clazz); clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Object toBeDone;
                if (!includeStatic && Modifier.isStatic(fields[i].getModifiers())) continue;
                if (fields[i].getType().isPrimitive()) {
                    result += (long)SIZES.getPrimitiveFieldSize(fields[i].getType());
                    continue;
                }
                result += (long)SIZES.getPointerSize();
                fields[i].setAccessible(true);
                try {
                    toBeDone = fields[i].get(obj);
                }
                catch (IllegalArgumentException e) {
                    toBeDone = null;
                }
                catch (IllegalAccessException e) {
                    toBeDone = null;
                }
                if (toBeDone == null || !this.isSafe(toBeDone.getClass())) continue;
                this.stack.add(toBeDone);
            }
        }
        return this.roundUpToNearestEightBytes(result += (long)SIZES.getClassSize());
    }

    private long roundUpToNearestEightBytes(long result) {
        long rem = result % 8L;
        if (rem != 0L) {
            result += 8L - rem;
        }
        return result;
    }

    private long estimateArray(Object obj, boolean includeStatic) {
        long result = SIZES.getArrayOverheadSize();
        int length = Array.getLength(obj);
        if (length != 0) {
            Class<?> arrayElementClazz = obj.getClass().getComponentType();
            if (arrayElementClazz.isPrimitive()) {
                result += (long)(length * SIZES.getPrimitiveArrayElementSize(arrayElementClazz));
            } else {
                for (int i = 0; i < length; ++i) {
                    result += (long)SIZES.getPointerSize() + this.estimateObject(Array.get(obj, i), includeStatic);
                }
            }
        }
        return result;
    }

    private boolean isSafe(Class clazz) {
        return clazz != unsafe;
    }

    static {
        try {
            unsafe = Class.forName("sun.reflect.UnsafeStaticFieldAccessorImpl");
        }
        catch (ClassNotFoundException e) {
            unsafe = null;
        }
    }
}

