/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.monitor;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.RequestMetrics;
import com.cognos.xqe.query.engine.SessionContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.monitor.CancelRequestSelectionMethod;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceMonitorRegistry
implements Observer {
    private static final double SAME_METRIC_PERCENT_THRESHOLD = 0.9;
    private static final XQELogger LOGGER = ROLAPLog.getLogger("Resources.Monitor");
    private static final RunningTimeComparator RUNNINGTIMECOMPARATOR = new RunningTimeComparator();
    private static final BiggestSetComparator BIGGESTSETCOMPARATOR = new BiggestSetComparator();
    private static final CubeletsValueCountComparator CUBELETSVALUECOUNTCOMPARATOR = new CubeletsValueCountComparator();
    private final Set<SessionContext> sessions = Collections.newSetFromMap(new ConcurrentHashMap());

    public void register(SessionContext sessionContext) {
        RequestEnvironment reqEnv = sessionContext.getRequestEnvironment();
        if (reqEnv != null && reqEnv.isInternal() && !reqEnv.getMonitorResources()) {
            LOGGER.log(LogLevel.TRACE, "Internal request is not being registered with the resource monitor. Session ID: " + sessionContext.getIDSString());
            return;
        }
        LOGGER.log(LogLevel.TRACE, "Registering session " + sessionContext.getIDSString());
        sessionContext.addObserver(this);
        this.sessions.add(sessionContext);
    }

    @Override
    public void update(Observable o, Object arg) {
        SessionContext sessionContext = (SessionContext)o;
        LOGGER.log(LogLevel.TRACE, "Unregistering session " + sessionContext.getIDSString());
        this.sessions.remove(sessionContext);
    }

    public int size() {
        return this.sessions.size();
    }

    public List<SessionContext> getSessionsToCancelRequest(CancelRequestSelectionMethod cancelMethod) {
        if (this.sessions.isEmpty()) {
            LOGGER.log(LogLevel.TRACE, "No sessions have been registered with the resource monitor");
        }
        List<SessionInfo> sessionInfoList = SessionInfo.createSessionInfoList(this.sessions);
        ArrayList<SessionInfo> externalSessions = new ArrayList<SessionInfo>();
        ArrayList<SessionInfo> internalSessions = new ArrayList<SessionInfo>();
        for (SessionInfo sessionInfo : sessionInfoList) {
            boolean isInternalRequest = sessionInfo.session.getRequestEnvironment().isInternal();
            if (isInternalRequest) {
                internalSessions.add(sessionInfo);
                continue;
            }
            externalSessions.add(sessionInfo);
        }
        sessionInfoList = ResourceMonitorRegistry.sortSessions(externalSessions, cancelMethod);
        sessionInfoList.addAll(ResourceMonitorRegistry.sortSessions(internalSessions, cancelMethod));
        List<SessionContext> sessionList = SessionInfo.createSessionContextList(sessionInfoList);
        return sessionList;
    }

    private static List<SessionInfo> sortSessions(List<SessionInfo> sessionList, CancelRequestSelectionMethod cancelMethod) {
        switch (cancelMethod) {
            case ALL: {
                return sessionList;
            }
            case LONGEST_RUNNING: {
                Collections.sort(sessionList, RUNNINGTIMECOMPARATOR);
                return sessionList;
            }
            case BIGGEST_SET_SIZE: {
                Collections.sort(sessionList, BIGGESTSETCOMPARATOR);
                return sessionList;
            }
            case CUBELETS_VALUE_COUNT: {
                Collections.sort(sessionList, CUBELETSVALUECOUNTCOMPARATOR);
                return sessionList;
            }
            case MULTIPLE_METRICS: {
                CancelRequestSelectionMethod[] metricsToSortBy = new CancelRequestSelectionMethod[]{CancelRequestSelectionMethod.BIGGEST_SET_SIZE, CancelRequestSelectionMethod.CUBELETS_VALUE_COUNT, CancelRequestSelectionMethod.LONGEST_RUNNING};
                return ResourceMonitorRegistry.sortSessionsByMultipleMetrics(sessionList, metricsToSortBy, 0);
            }
        }
        return new ArrayList<SessionInfo>();
    }

    private static List<SessionInfo> sortSessionsByMultipleMetrics(List<SessionInfo> sessionList, CancelRequestSelectionMethod[] metricsToSortBy, int metricIdx) {
        if (metricIdx >= metricsToSortBy.length) {
            return sessionList;
        }
        if (metricIdx == 0) {
            sessionList = ResourceMonitorRegistry.sortSessions(sessionList, metricsToSortBy[0]);
            return ResourceMonitorRegistry.sortSessionsByMultipleMetrics(sessionList, metricsToSortBy, metricIdx + 1);
        }
        List<List<SessionInfo>> sessionGroups = ResourceMonitorRegistry.groupSessions(sessionList, metricsToSortBy[metricIdx - 1]);
        ArrayList<SessionInfo> outSessionList = new ArrayList<SessionInfo>();
        for (List<SessionInfo> sessionGroup : sessionGroups) {
            List<SessionInfo> sessionGroupSorted = ResourceMonitorRegistry.sortSessions(sessionGroup, metricsToSortBy[metricIdx]);
            outSessionList.addAll(ResourceMonitorRegistry.sortSessionsByMultipleMetrics(sessionGroupSorted, metricsToSortBy, metricIdx + 1));
        }
        return outSessionList;
    }

    private static List<List<SessionInfo>> groupSessions(List<SessionInfo> sessionList, CancelRequestSelectionMethod cancelMethod) {
        ArrayList<List<SessionInfo>> sessionGroups = new ArrayList<List<SessionInfo>>();
        List<SessionInfo> sessionGroup = new ArrayList();
        sessionGroups.add(sessionGroup);
        long groupLongestRequestTime = 0L;
        BigInteger groupBiggestReqSet = BigInteger.ZERO;
        long groupBiggestCubeletValueCount = 0L;
        block6: for (int i = 0; i < sessionList.size(); ++i) {
            SessionInfo session = sessionList.get(i);
            switch (cancelMethod) {
                case ALL: {
                    sessionGroup = (List)sessionGroups.get(sessionGroups.size() - 1);
                    sessionGroup.addAll(sessionList);
                    return sessionGroups;
                }
                case LONGEST_RUNNING: {
                    long reqTime;
                    if (groupLongestRequestTime == 0L) {
                        groupLongestRequestTime = session.getRequestMetrics().getRequestTimer().getElapsedTimeInMilliseconds();
                    }
                    if ((double)groupLongestRequestTime * 0.9 <= (double)(reqTime = session.getRequestMetrics().getRequestTimer().getElapsedTimeInMilliseconds())) {
                        sessionGroup = (List)sessionGroups.get(sessionGroups.size() - 1);
                        sessionGroup.add(session);
                        continue block6;
                    }
                    groupLongestRequestTime = reqTime;
                    sessionGroup = new ArrayList();
                    sessionGroup.add(session);
                    sessionGroups.add(sessionGroup);
                    continue block6;
                }
                case BIGGEST_SET_SIZE: {
                    if (groupBiggestReqSet == BigInteger.ZERO) {
                        groupBiggestReqSet = session.getRequestMetrics().getBiggestSetSize();
                    }
                    BigInteger reqBiggestSet = session.getRequestMetrics().getBiggestSetSize();
                    if (groupBiggestReqSet.doubleValue() * 0.9 <= reqBiggestSet.doubleValue()) {
                        sessionGroup = (List)sessionGroups.get(sessionGroups.size() - 1);
                        sessionGroup.add(session);
                        continue block6;
                    }
                    groupBiggestReqSet = reqBiggestSet;
                    sessionGroup = new ArrayList();
                    sessionGroup.add(session);
                    sessionGroups.add(sessionGroup);
                    continue block6;
                }
                case CUBELETS_VALUE_COUNT: {
                    long reqCubeletValueCount;
                    if (groupBiggestCubeletValueCount == 0L) {
                        groupBiggestCubeletValueCount = session.getRequestMetrics().getCubeletsValueCount();
                    }
                    if ((double)groupBiggestCubeletValueCount * 0.9 <= (double)(reqCubeletValueCount = session.getRequestMetrics().getCubeletsValueCount())) {
                        sessionGroup = (List)sessionGroups.get(sessionGroups.size() - 1);
                        sessionGroup.add(session);
                        continue block6;
                    }
                    groupBiggestCubeletValueCount = reqCubeletValueCount;
                    sessionGroup = new ArrayList();
                    sessionGroup.add(session);
                    sessionGroups.add(sessionGroup);
                    continue block6;
                }
                default: {
                    return new ArrayList<List<SessionInfo>>();
                }
            }
        }
        return sessionGroups;
    }

    private static final class SessionInfo {
        private final SessionContext session;
        private final RequestMetrics requestMetrics;

        private SessionInfo(SessionContext sessionContext, RequestMetrics reqMetrics) {
            this.session = sessionContext;
            this.requestMetrics = reqMetrics;
        }

        public RequestMetrics getRequestMetrics() {
            return this.requestMetrics;
        }

        public static List<SessionInfo> createSessionInfoList(Set<SessionContext> sessionContextList) {
            ArrayList<SessionInfo> sessionInfoList = new ArrayList<SessionInfo>();
            for (SessionContext sessionContext : sessionContextList) {
                RequestEnvironment reqEnv = sessionContext.getRequestEnvironment();
                if (reqEnv == null) continue;
                sessionInfoList.add(new SessionInfo(sessionContext, reqEnv.getRequestMetrics()));
            }
            return sessionInfoList;
        }

        public static List<SessionContext> createSessionContextList(List<SessionInfo> sessionInfoList) {
            ArrayList<SessionContext> sessionContextList = new ArrayList<SessionContext>();
            for (SessionInfo sessionInfo : sessionInfoList) {
                sessionContextList.add(sessionInfo.session);
            }
            return sessionContextList;
        }
    }

    private static class CubeletsValueCountComparator
    implements Comparator<SessionInfo> {
        private CubeletsValueCountComparator() {
        }

        @Override
        public int compare(SessionInfo session0, SessionInfo session1) {
            long cubeletsValueCount1;
            long cubeletsValueCount0 = session0.getRequestMetrics().getCubeletsValueCount();
            if (cubeletsValueCount0 == (cubeletsValueCount1 = session1.getRequestMetrics().getCubeletsValueCount())) {
                return 0;
            }
            if (cubeletsValueCount0 > cubeletsValueCount1) {
                return -1;
            }
            return 1;
        }
    }

    private static class BiggestSetComparator
    implements Comparator<SessionInfo> {
        private BiggestSetComparator() {
        }

        @Override
        public int compare(SessionInfo session0, SessionInfo session1) {
            BigInteger biggestSetSize0 = BigInteger.ZERO;
            BigInteger reqSetSize = session0.getRequestMetrics().getBiggestSetSize();
            if (reqSetSize != null) {
                biggestSetSize0 = reqSetSize;
            }
            BigInteger biggestSetSize1 = BigInteger.ZERO;
            reqSetSize = session1.getRequestMetrics().getBiggestSetSize();
            if (reqSetSize != null) {
                biggestSetSize1 = reqSetSize;
            }
            return biggestSetSize0.compareTo(biggestSetSize1) * -1;
        }
    }

    private static class RunningTimeComparator
    implements Comparator<SessionInfo> {
        private RunningTimeComparator() {
        }

        @Override
        public int compare(SessionInfo session0, SessionInfo session1) {
            long duration0 = 0L;
            HighPrecisionStopWatch timer0 = session0.getRequestMetrics().getRequestTimer();
            if (timer0 != null) {
                duration0 = timer0.getElapsedTimeInMilliseconds();
            }
            long duration1 = 0L;
            HighPrecisionStopWatch timer1 = session1.getRequestMetrics().getRequestTimer();
            if (timer1 != null) {
                duration1 = timer1.getElapsedTimeInMilliseconds();
            }
            if (duration0 == duration1) {
                return 0;
            }
            if (duration0 > duration1) {
                return -1;
            }
            return 1;
        }
    }
}

