/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.pool;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class DirectByteBufferPool {
    private final ByteOrder mByteOrder;
    private final int mAllocationSize;
    private ConcurrentLinkedQueue<ByteBuffer> mFreeBuffers = new ConcurrentLinkedQueue();

    public DirectByteBufferPool(ByteOrder order, int allocationSize) {
        this.mByteOrder = order;
        this.mAllocationSize = allocationSize;
    }

    public ByteOrder getByteOrder() {
        return this.mByteOrder;
    }

    public int getAllocationSize() {
        return this.mAllocationSize;
    }

    public ByteBuffer borrowBuffer() {
        ByteBuffer buffer = this.mFreeBuffers.poll();
        if (null == buffer) {
            buffer = ByteBuffer.allocateDirect(this.mAllocationSize);
        }
        buffer.order(this.mByteOrder);
        buffer.clear();
        return buffer;
    }

    public void returnBuffer(ByteBuffer buffer) {
        this.mFreeBuffers.add(buffer);
    }
}

