/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.pool;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.SoftReferenceObjectPool;

public final class XQEHttpClientPool {
    private static final String STATUS_MSG_FRAGMENT = ", # of idle: ";
    private static final String NEW_LINE = "\n";
    private static XQEHttpClientPool instance = new XQEHttpClientPool();
    private ObjectPool httpClientPool = new SoftReferenceObjectPool((PoolableObjectFactory)new HttpClientPoolableFactory());

    private XQEHttpClientPool() {
    }

    public static XQEHttpClientPool getInstance() {
        return instance;
    }

    public HttpClient borrowHttpClient() throws Exception {
        return (HttpClient)this.httpClientPool.borrowObject();
    }

    public void returnHttpClient(HttpClient aClient) throws Exception {
        this.httpClientPool.returnObject((Object)aClient);
    }

    public void clear() throws Exception {
        this.httpClientPool.clear();
    }

    public void showStatus(Writer aWriter) throws IOException {
        aWriter.write(NEW_LINE);
        aWriter.write("HttpClient pool ->\t# in use: ");
        aWriter.write(String.valueOf(this.httpClientPool.getNumActive()));
        aWriter.write(STATUS_MSG_FRAGMENT);
        aWriter.write(String.valueOf(this.httpClientPool.getNumIdle()));
        aWriter.write(NEW_LINE);
        aWriter.flush();
    }

    private static class HttpClientPoolableFactory
    implements PoolableObjectFactory {
        private HttpClientPoolableFactory() {
        }

        public void activateObject(Object arg0) throws Exception {
        }

        public void destroyObject(Object arg0) throws Exception {
        }

        public Object makeObject() throws Exception {
            return new HttpClient();
        }

        public void passivateObject(Object arg0) throws Exception {
            HttpClient aClient = (HttpClient)arg0;
            aClient.setState(new HttpState());
        }

        public boolean validateObject(Object arg0) {
            return true;
        }
    }
}

