/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.pool;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.SoftReferenceObjectPool;
import org.dom4j.io.SAXReader;

public final class XQESAXReaderPool {
    private static final String STATUS_MSG_FRAGMENT = ", # of idle: ";
    private static final String NEW_LINE = "\n";
    private static XQESAXReaderPool instance = new XQESAXReaderPool();
    private ObjectPool saxReaderPool = new SoftReferenceObjectPool((PoolableObjectFactory)new SAXReaderPoolableFactory());

    private XQESAXReaderPool() {
    }

    public static XQESAXReaderPool getInstance() {
        return instance;
    }

    public SAXReader borrowReader() throws Exception {
        return (SAXReader)this.saxReaderPool.borrowObject();
    }

    public void returnReader(SAXReader aReader) throws Exception {
        this.saxReaderPool.returnObject((Object)aReader);
    }

    public void invalidateReader(SAXReader aReader) throws Exception {
        this.saxReaderPool.invalidateObject((Object)aReader);
    }

    public void clear() throws Exception {
        this.saxReaderPool.clear();
    }

    public void showStatus(Writer aWriter) throws IOException {
        aWriter.write(NEW_LINE);
        aWriter.write("SAXReader pool ->\t# in use: ");
        aWriter.write(String.valueOf(this.saxReaderPool.getNumActive()));
        aWriter.write(STATUS_MSG_FRAGMENT);
        aWriter.write(String.valueOf(this.saxReaderPool.getNumIdle()));
        aWriter.write(NEW_LINE);
        aWriter.flush();
    }

    private static class SAXReaderPoolableFactory
    implements PoolableObjectFactory {
        private SAXReaderPoolableFactory() {
        }

        public void activateObject(Object arg0) throws Exception {
        }

        public void destroyObject(Object arg0) throws Exception {
        }

        public Object makeObject() throws Exception {
            return new SAXReader();
        }

        public void passivateObject(Object arg0) throws Exception {
        }

        public boolean validateObject(Object arg0) {
            return true;
        }
    }
}

