/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.pool;

import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.SoftReferenceObjectPool;

public final class XQEXMLInputFactoryPool {
    private static final String STATUS_MSG_FRAGMENT = ", # of idle: ";
    private static final String NEW_LINE = "\n";
    private static XQEXMLInputFactoryPool instance = new XQEXMLInputFactoryPool();
    private ObjectPool xmlInputFactoryPool = new SoftReferenceObjectPool((PoolableObjectFactory)new XMLInputFactoryPoolableFactory());

    private XQEXMLInputFactoryPool() {
    }

    public static XQEXMLInputFactoryPool getInstance() {
        return instance;
    }

    public XMLInputFactory borrowXMLInputFactory() throws Exception {
        return (XMLInputFactory)this.xmlInputFactoryPool.borrowObject();
    }

    public void returnXMLInputFactory(XMLInputFactory aFactory) throws Exception {
        this.xmlInputFactoryPool.returnObject((Object)aFactory);
    }

    public void clear() throws Exception {
        this.xmlInputFactoryPool.clear();
    }

    public void showStatus(Writer aWriter) throws IOException {
        aWriter.write(NEW_LINE);
        aWriter.write("XMLInputFactory pool ->\t# in use: ");
        aWriter.write(String.valueOf(this.xmlInputFactoryPool.getNumActive()));
        aWriter.write(STATUS_MSG_FRAGMENT);
        aWriter.write(String.valueOf(this.xmlInputFactoryPool.getNumIdle()));
        aWriter.write(NEW_LINE);
        aWriter.flush();
    }

    private static class XMLInputFactoryPoolableFactory
    implements PoolableObjectFactory {
        private XMLInputFactoryPoolableFactory() {
        }

        public void activateObject(Object arg0) throws Exception {
        }

        public void destroyObject(Object arg0) throws Exception {
        }

        public Object makeObject() throws Exception {
            return StaxUtil.createXMLInputFactory();
        }

        public void passivateObject(Object arg0) throws Exception {
            XMLInputFactory theFactory = (XMLInputFactory)arg0;
            StaxUtil.configureInputFactory(theFactory, false, true, false);
        }

        public boolean validateObject(Object arg0) {
            return true;
        }
    }
}

