/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.primitive;

import com.cognos.xqe.util.JavaObjectMemorySize;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqe.util.primitive.ByteArrayList;
import com.cognos.xqe.util.primitive.IntArrayComparator;
import com.cognos.xqe.util.primitive.ShortArrayList;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;

public class CompactIntArrayList
extends AbstractList<int[]>
implements RandomAccess {
    private static final int NUM_ITEMS_ON_TO_STRING = 30;
    private static final int NUM_EXTRA_ITEMS = 1000;
    private final ArrayListInt[] intValues;
    private final ShortArrayList[] shortValues;
    private final ByteArrayList[] byteValues;
    private int[] fixedValues;
    private int arrayAllocationSize;

    public CompactIntArrayList(int arrayWidth) {
        this(arrayWidth, 0);
    }

    public CompactIntArrayList(int arrayWidth, int initialSize) {
        this.intValues = new ArrayListInt[arrayWidth];
        this.shortValues = new ShortArrayList[arrayWidth];
        this.byteValues = new ByteArrayList[arrayWidth];
        this.fixedValues = null;
        this.arrayAllocationSize = initialSize;
    }

    public CompactIntArrayList(int arrayWidth, List<int[]> initialList) {
        this(arrayWidth, initialList.size());
        this.addAll(initialList);
    }

    @Override
    public int[] get(int index) {
        return this.get(index, null);
    }

    public int[] get(int index, int[] outputArray) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range for list size " + this.size());
        }
        if (outputArray == null || outputArray.length < this.intValues.length) {
            outputArray = new int[this.intValues.length];
        }
        for (int i = 0; i < this.intValues.length; ++i) {
            outputArray[i] = this.byteValues[i] != null ? (int)this.byteValues[i].get(index) : (this.shortValues[i] != null ? (int)this.shortValues[i].get(index) : (this.intValues[i] != null ? this.intValues[i].get(index) : this.fixedValues[i]));
        }
        return outputArray;
    }

    @Override
    public int size() {
        int numItems = 0;
        for (int i = 0; i < this.intValues.length; ++i) {
            if (this.intValues[i] != null) {
                numItems = this.intValues[i].size();
                break;
            }
            if (this.shortValues[i] != null) {
                numItems = this.shortValues[i].size();
                break;
            }
            if (this.byteValues[i] == null) continue;
            numItems = this.byteValues[i].size();
            break;
        }
        if (numItems == 0 && this.fixedValues != null) {
            numItems = 1;
        }
        return numItems;
    }

    @Override
    public boolean add(int[] newArray) {
        int numExistingItems = this.size();
        if (numExistingItems == 0) {
            this.fixedValues = new int[this.intValues.length];
            System.arraycopy(newArray, 0, this.fixedValues, 0, this.fixedValues.length);
            return true;
        }
        this.inflateNeededArrays(newArray);
        for (int i = 0; i < this.intValues.length; ++i) {
            if (this.intValues[i] != null) {
                this.intValues[i].add(newArray[i]);
                continue;
            }
            if (this.shortValues[i] != null) {
                this.shortValues[i].add((short)newArray[i]);
                continue;
            }
            if (this.byteValues[i] == null) continue;
            this.byteValues[i].add((byte)newArray[i]);
        }
        return true;
    }

    @Override
    public int[] set(int index, int[] newArray) {
        int[] oldValue = new int[this.intValues.length];
        this.inflateNeededArrays(newArray);
        for (int i = 0; i < this.intValues.length; ++i) {
            oldValue[i] = this.intValues[i] != null ? this.intValues[i].set(index, newArray[i]) : (this.shortValues[i] != null ? (int)this.shortValues[i].set(index, (short)newArray[i]) : (this.byteValues[i] != null ? (int)this.byteValues[i].set(index, (byte)newArray[i]) : this.fixedValues[i]));
        }
        return oldValue;
    }

    public void trim() {
        for (int i = 0; i < this.intValues.length; ++i) {
            if (this.intValues[i] != null) {
                this.intValues[i].trimToSize();
            }
            if (this.shortValues[i] != null) {
                this.shortValues[i].trim();
            }
            if (this.byteValues[i] == null) continue;
            this.byteValues[i].trim();
        }
    }

    @Override
    public String toString() {
        int numItems = this.size();
        StringBuilder sb = new StringBuilder(String.format("[size=%,d ", numItems));
        for (int i = 0; i < numItems && i < 30; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(Arrays.toString(this.get(i)));
        }
        if (numItems > 30) {
            sb.append(String.format("...%,d more]", numItems - 30));
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public long estimateMemoryUsage() {
        int numIntArrays = 0;
        int numShortArrays = 0;
        int numByteArrays = 0;
        for (int i = 0; i < this.intValues.length; ++i) {
            if (this.intValues[i] != null) {
                ++numIntArrays;
                continue;
            }
            if (this.shortValues[i] != null) {
                ++numShortArrays;
                continue;
            }
            if (this.byteValues[i] == null) continue;
            ++numByteArrays;
        }
        return CompactIntArrayList.estimateMemoryUsage(this.size(), numIntArrays, numShortArrays, numByteArrays);
    }

    public int getArrayWidth() {
        return this.intValues.length;
    }

    public int[] getMemoryUsageStats() {
        int[] bytesPerArrayPosition = new int[this.intValues.length];
        for (int i = 0; i < this.intValues.length; ++i) {
            bytesPerArrayPosition[i] = this.intValues[i] != null ? 4 : (this.shortValues[i] != null ? 2 : (this.byteValues[i] != null ? 1 : 0));
        }
        return bytesPerArrayPosition;
    }

    public void swap(int index1, int index2) {
        for (int i = 0; i < this.intValues.length; ++i) {
            short s;
            short s2;
            if (this.byteValues[i] != null) {
                s2 = this.byteValues[i].get(index1);
                s = this.byteValues[i].set(index2, (byte)s2);
                this.byteValues[i].set(index1, (byte)s);
                continue;
            }
            if (this.shortValues[i] != null) {
                s2 = this.shortValues[i].get(index1);
                s = this.shortValues[i].set(index2, s2);
                this.shortValues[i].set(index1, s);
                continue;
            }
            if (this.intValues[i] == null) continue;
            s2 = this.intValues[i].get(index1);
            s = this.intValues[i].set(index2, s2);
            this.intValues[i].set(index1, s);
        }
    }

    public int compare(int index1, int index2) {
        return IntArrayComparator.getInstance().compare(this.intValues, this.shortValues, this.byteValues, index1, index2);
    }

    public int compare(int index, int[] theValue) {
        return IntArrayComparator.getInstance().compare(this.intValues, this.shortValues, this.byteValues, this.fixedValues, index, theValue);
    }

    protected static long estimateMemoryUsage(long size, int numIntArrays, int numShortArrays, int numByteArrays) {
        int arrayWidth = numIntArrays + numShortArrays + numByteArrays;
        long fixedOverhead = JavaObjectMemorySize.getEstimatedJavaObjectArraySize(arrayWidth) * 2L * 2L;
        return size * (long)numIntArrays * 4L + size * (long)numShortArrays * 2L + size * (long)numByteArrays + fixedOverhead;
    }

    public static long estimateMemoryUsage(int numEntries, int[] largestPossibleValues) {
        int numIntArrays = 0;
        int numShortArrays = 0;
        int numByteArrays = 0;
        for (int largestPossibleValue : largestPossibleValues) {
            if (largestPossibleValue <= 127 && largestPossibleValue >= -128) {
                ++numByteArrays;
                continue;
            }
            if (largestPossibleValue <= Short.MAX_VALUE && largestPossibleValue >= Short.MIN_VALUE) {
                ++numShortArrays;
                continue;
            }
            ++numIntArrays;
        }
        return CompactIntArrayList.estimateMemoryUsage(numEntries, numIntArrays, numShortArrays, numByteArrays);
    }

    protected int[][] getIntArrayValues() {
        int[][] newValues = new int[this.intValues.length][];
        for (int i = 0; i < this.intValues.length; ++i) {
            if (this.intValues[i] == null) continue;
            newValues[i] = this.intValues[i].toArray();
        }
        return newValues;
    }

    protected short[][] getShortArrayValues() {
        short[][] newValues = new short[this.intValues.length][];
        for (int i = 0; i < this.intValues.length; ++i) {
            if (this.shortValues[i] == null) continue;
            newValues[i] = this.shortValues[i].toArray();
        }
        return newValues;
    }

    protected byte[][] getByteArrayValues() {
        byte[][] newValues = new byte[this.intValues.length][];
        for (int i = 0; i < this.byteValues.length; ++i) {
            if (this.byteValues[i] == null) continue;
            newValues[i] = this.byteValues[i].toArray();
        }
        return newValues;
    }

    protected int[] getFixedValues() {
        if (this.fixedValues == null) {
            return null;
        }
        int[] newValues = new int[this.fixedValues.length];
        System.arraycopy(this.fixedValues, 0, newValues, 0, this.fixedValues.length);
        return newValues;
    }

    private int getNewArraySize(int numExistingItems) {
        if (this.arrayAllocationSize > numExistingItems) {
            return this.arrayAllocationSize;
        }
        return numExistingItems + 1000;
    }

    private void inflateNeededArrays(int[] newValue) {
        boolean allFixedValues = true;
        for (int i = 0; i < this.intValues.length; ++i) {
            if (this.intValues[i] == null) {
                if (this.shortValues[i] != null) {
                    allFixedValues = false;
                    if (newValue[i] <= Short.MAX_VALUE && newValue[i] >= Short.MIN_VALUE) continue;
                    this.inflateToIntArray(i);
                    continue;
                }
                if (this.byteValues[i] != null) {
                    allFixedValues = false;
                    if (newValue[i] > Short.MAX_VALUE || newValue[i] < Short.MIN_VALUE) {
                        this.inflateToIntArray(i);
                        continue;
                    }
                    if (newValue[i] <= 127 && newValue[i] >= -128) continue;
                    this.inflateToShortArray(i);
                    continue;
                }
                if (newValue[i] == this.fixedValues[i] && (!allFixedValues || i != this.intValues.length - 1)) continue;
                if (newValue[i] <= 127 && newValue[i] >= -128 && this.fixedValues[i] <= 127 && this.fixedValues[i] >= -128) {
                    allFixedValues = false;
                    this.inflateToByteArray(i);
                    continue;
                }
                if (newValue[i] <= Short.MAX_VALUE && newValue[i] >= Short.MIN_VALUE && this.fixedValues[i] <= Short.MAX_VALUE && this.fixedValues[i] >= Short.MIN_VALUE) {
                    allFixedValues = false;
                    this.inflateToShortArray(i);
                    continue;
                }
                allFixedValues = false;
                this.inflateToIntArray(i);
                continue;
            }
            allFixedValues = false;
        }
    }

    private void inflateToIntArray(int index) {
        if (this.intValues[index] != null) {
            throw new IllegalStateException("Asked to inflate to an int array, but an int array is already allocated.");
        }
        int numValues = this.size();
        this.intValues[index] = new ArrayListInt(this.getNewArraySize(numValues));
        int value = this.fixedValues[index];
        for (int i = 0; i < numValues; ++i) {
            if (this.shortValues[index] != null) {
                value = this.shortValues[index].get(i);
            } else if (this.byteValues[index] != null) {
                value = this.byteValues[index].get(i);
            }
            this.intValues[index].add(value);
        }
        this.shortValues[index] = null;
        this.byteValues[index] = null;
        this.fixedValues[index] = -1;
    }

    private void inflateToShortArray(int index) {
        if (this.shortValues[index] != null || this.intValues[index] != null) {
            throw new IllegalStateException("Asked to inflate to an short array, but an short array is already allocated.");
        }
        int numValues = this.size();
        this.shortValues[index] = new ShortArrayList(this.getNewArraySize(numValues));
        short value = (short)this.fixedValues[index];
        for (int i = 0; i < numValues; ++i) {
            if (this.byteValues[index] != null) {
                value = this.byteValues[index].get(i);
            }
            this.shortValues[index].add(value);
        }
        this.byteValues[index] = null;
        this.fixedValues[index] = -1;
    }

    private void inflateToByteArray(int index) {
        if (this.shortValues[index] != null || this.intValues[index] != null || this.byteValues[index] != null) {
            throw new IllegalStateException("Asked to inflate to an byte array, but an array is already used.");
        }
        int numValues = this.size();
        this.byteValues[index] = new ByteArrayList(this.getNewArraySize(numValues));
        for (int i = 0; i < numValues; ++i) {
            this.byteValues[index].add((byte)this.fixedValues[index]);
        }
        this.fixedValues[index] = -1;
    }
}

