/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.primitive;

import com.cognos.xqe.util.primitive.CompactIntArrayList;
import com.cognos.xqe.util.primitive.IntArrayComparator;

public class ConstantCompactIntArrayList
extends CompactIntArrayList {
    private final int[][] intValues;
    private final short[][] shortValues;
    private final byte[][] byteValues;
    private int[] fixedValues;

    public ConstantCompactIntArrayList(CompactIntArrayList other) {
        super(other.getArrayWidth());
        this.fixedValues = other.getFixedValues();
        this.intValues = other.getIntArrayValues();
        this.shortValues = other.getShortArrayValues();
        this.byteValues = other.getByteArrayValues();
    }

    @Override
    public int[] get(int index) {
        return this.get(index, null);
    }

    @Override
    public int[] get(int index, int[] outputArray) {
        if (outputArray == null || outputArray.length < this.intValues.length) {
            outputArray = new int[this.intValues.length];
        }
        for (int i = 0; i < this.intValues.length; ++i) {
            outputArray[i] = this.byteValues[i] != null ? this.byteValues[i][index] : (this.shortValues[i] != null ? this.shortValues[i][index] : (this.intValues[i] != null ? this.intValues[i][index] : this.fixedValues[i]));
        }
        return outputArray;
    }

    @Override
    public int size() {
        int numItems = 0;
        for (int i = 0; i < this.intValues.length; ++i) {
            if (this.byteValues[i] != null) {
                numItems = this.byteValues[i].length;
                break;
            }
            if (this.shortValues[i] != null) {
                numItems = this.shortValues[i].length;
                break;
            }
            if (this.intValues[i] == null) continue;
            numItems = this.intValues[i].length;
            break;
        }
        if (numItems == 0 && this.fixedValues != null) {
            numItems = 1;
        }
        return numItems;
    }

    @Override
    public boolean add(int[] newArray) {
        throw new UnsupportedOperationException("Cannot add to a constant list.");
    }

    @Override
    public int[] set(int index, int[] newArray) {
        throw new UnsupportedOperationException("Cannot set to a constant list.");
    }

    @Override
    public void trim() {
        throw new UnsupportedOperationException("Cannot trim to a constant list.");
    }

    @Override
    public long estimateMemoryUsage() {
        int numIntArrays = 0;
        int numShortArrays = 0;
        int numByteArrays = 0;
        for (int i = 0; i < this.intValues.length; ++i) {
            if (this.intValues[i] != null) {
                ++numIntArrays;
                continue;
            }
            if (this.shortValues[i] != null) {
                ++numShortArrays;
                continue;
            }
            if (this.byteValues[i] == null) continue;
            ++numByteArrays;
        }
        return ConstantCompactIntArrayList.estimateMemoryUsage(this.size(), numIntArrays, numShortArrays, numByteArrays);
    }

    @Override
    public int getArrayWidth() {
        return this.intValues.length;
    }

    @Override
    public int[] getMemoryUsageStats() {
        int[] bytesPerArrayPosition = new int[this.intValues.length];
        for (int i = 0; i < this.intValues.length; ++i) {
            bytesPerArrayPosition[i] = this.intValues[i] != null ? 4 : (this.shortValues[i] != null ? 2 : (this.byteValues[i] != null ? 1 : 0));
        }
        return bytesPerArrayPosition;
    }

    @Override
    public void swap(int index1, int index2) {
        for (int i = 0; i < this.intValues.length; ++i) {
            int value1;
            if (this.byteValues[i] != null) {
                value1 = this.byteValues[i][index1];
                this.byteValues[i][index1] = this.byteValues[i][index2];
                this.byteValues[i][index2] = value1;
                continue;
            }
            if (this.shortValues[i] != null) {
                value1 = this.shortValues[i][index1];
                this.shortValues[i][index1] = this.shortValues[i][index2];
                this.shortValues[i][index2] = value1;
                continue;
            }
            if (this.intValues[i] == null) continue;
            value1 = this.intValues[i][index1];
            this.intValues[i][index1] = this.intValues[i][index2];
            this.intValues[i][index2] = value1;
        }
    }

    @Override
    public int compare(int index1, int index2) {
        return IntArrayComparator.getInstance().compare(this.intValues, this.shortValues, this.byteValues, index1, index2);
    }

    @Override
    public int compare(int index, int[] theValue) {
        return IntArrayComparator.getInstance().compare(this.intValues, this.shortValues, this.byteValues, this.fixedValues, index, theValue);
    }

    @Override
    protected int[][] getIntArrayValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected short[][] getShortArrayValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected byte[][] getByteArrayValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int[] getFixedValues() {
        throw new UnsupportedOperationException();
    }
}

