/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.primitive;

import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.JavaObjectMemorySize;
import com.cognos.xqe.util.primitive.DoubleList;

public class DoubleArrayList
implements DoubleList {
    private int elementCount;
    private double[] elements;
    private static final int MAX_ARRAY_INDEX = 0x7FFFFFFA;
    private static final int CHUNK_SIZE = 0x8000000;
    private static final String CAPACITY_EXCEEDS_MSG_FORMAT = "Requested capacity %d exceeds the maximum allowed size %d.";

    public DoubleArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException(String.format("The capacity is invalid: %d.  It must be >= 0.", capacity));
        }
        if (capacity > 0x7FFFFFFB) {
            throw new IllegalArgumentException(String.format(CAPACITY_EXCEEDS_MSG_FORMAT, capacity, 0x7FFFFFFB));
        }
        this.elements = new double[capacity];
    }

    @Override
    public void add(double element) {
        this.ensureCapacity(this.elementCount + 1);
        this.elements[this.elementCount++] = element;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public double[] toArray() {
        double[] arrayToReturn = new double[this.elementCount];
        System.arraycopy(this.elements, 0, arrayToReturn, 0, this.elementCount);
        return arrayToReturn;
    }

    public double get(int index) {
        return this.elements[index];
    }

    public void trim() {
        if (this.elementCount != this.elements.length) {
            double[] newElements = new double[this.elementCount];
            System.arraycopy(this.elements, 0, newElements, 0, this.elementCount);
            this.elements = newElements;
        }
    }

    private void ensureCapacity(int capacity) {
        if (this.elements.length < capacity) {
            if (capacity > 0x7FFFFFFB) {
                throw new IllegalArgumentException(String.format(CAPACITY_EXCEEDS_MSG_FORMAT, capacity, 0x7FFFFFFB));
            }
            int inflateTo = 0;
            inflateTo = this.elements.length < 0x1FFFFFFE ? this.elements.length << 1 : (this.elements.length < 0x77FFFFFA ? this.elements.length + 0x8000000 : 0x7FFFFFFB);
            int newCapacity = Math.max(capacity, inflateTo);
            XQEDebugLog.out.printf("Inflate array from %d to %d elements real %d\n", this.elements.length, inflateTo, newCapacity);
            double[] newElements = new double[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
            this.elements = newElements;
        }
    }

    public long estimateMemoryUsage() {
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectShallowSize(this.getClass());
        return estimatedSize += JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(8, this.elements.length);
    }
}

