/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.primitive;

import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.JavaObjectMemorySize;
import com.cognos.xqe.util.primitive.LongIterator;
import com.cognos.xqe.util.primitive.LongList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;

public class LongArrayList
implements LongList,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int THIRTY_ONE = 31;
    private static final long HIGH_MASK = -4294967296L;
    private static final long LOW_MASK = 0xFFFFFFFFL;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final int MAX_ARRAY_INDEX = 0x7FFFFFFA;
    private static final int CHUNK_SIZE = 0x8000000;
    private static final String COMMA_SPACE = ", ";
    private static final String ERRMSG_ILLEGAL_RANGE = "Illegal range";
    private static final String ERRMSG_INDEX = "Index: ";
    private static final String ERRMSG_SIZE = ", Size: ";
    private transient long[] mElementData;
    private int mSize;
    private transient int mModCount = 0;
    private static final String CAPACITY_EXCEEDS_MSG_FORMAT = "Requested capacity %d exceeds the maximum allowed size %d.";

    public static final LongArrayList fromElements(long ... elements) {
        return new LongArrayList(elements);
    }

    private static void checkIndex(int index, int size) throws IndexOutOfBoundsException {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(ERRMSG_INDEX + index + ERRMSG_SIZE + size);
        }
    }

    private static void checkRange(int fromIndex, int toIndex, int size) throws IndexOutOfBoundsException {
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > size) {
            throw new IndexOutOfBoundsException(ERRMSG_ILLEGAL_RANGE);
        }
    }

    public LongArrayList() {
        this.mElementData = new long[10];
        this.mSize = 0;
    }

    public LongArrayList(int initialCapacity) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("initialCapacity < 1");
        }
        if (initialCapacity > 0x7FFFFFFB) {
            throw new IllegalArgumentException(String.format(CAPACITY_EXCEEDS_MSG_FORMAT, initialCapacity, 0x7FFFFFFB));
        }
        this.mElementData = new long[initialCapacity];
        this.mSize = 0;
    }

    public LongArrayList(LongList list) {
        this(list.size());
        if (list instanceof LongArrayList) {
            this.addAll(((LongArrayList)list).mElementData);
        } else {
            this.addAll(list);
        }
    }

    public LongArrayList(long ... elements) {
        this.mElementData = new long[elements.length];
        this.mSize = elements.length;
        System.arraycopy(elements, 0, this.mElementData, 0, elements.length);
    }

    public void ensureCapacity(int capacity) {
        if (this.mElementData.length < capacity) {
            if (capacity > 0x7FFFFFFB) {
                throw new IllegalArgumentException(String.format(CAPACITY_EXCEEDS_MSG_FORMAT, capacity, 0x7FFFFFFB));
            }
            int inflateTo = 0;
            inflateTo = this.mElementData.length < 0x1FFFFFFE ? this.mElementData.length << 1 : (this.mElementData.length < 0x77FFFFFA ? this.mElementData.length + 0x8000000 : 0x7FFFFFFB);
            int newCapacity = Math.max(capacity, inflateTo);
            XQEDebugLog.out.printf("Inflate array from %d to %d elements real %d\n", this.mElementData.length, inflateTo, newCapacity);
            long[] newElements = new long[newCapacity];
            System.arraycopy(this.mElementData, 0, newElements, 0, this.mElementData.length);
            this.mElementData = newElements;
        }
    }

    @Override
    public void add(long element) {
        this.ensureCapacity(this.mSize + 1);
        this.mElementData[this.mSize++] = element;
        ++this.mModCount;
    }

    @Override
    public void add(int index, long element) throws IndexOutOfBoundsException {
        LongArrayList.checkIndex(index, this.mSize + 1);
        this.addFast(index, element);
    }

    @Override
    public void addFast(int index, long element) throws IndexOutOfBoundsException {
        this.ensureCapacity(this.mSize + 1);
        System.arraycopy(this.mElementData, index, this.mElementData, index + 1, this.mSize - index);
        this.mElementData[index] = element;
        ++this.mSize;
        ++this.mModCount;
    }

    @Override
    public void addAll(LongList c) {
        this.addAll(this.mSize, c);
    }

    public void addAll(long[] elements) {
        this.addAll(this.mSize, elements, 0, elements.length);
    }

    public void addAll(long[] elements, int start, int length) {
        this.addAll(this.mSize, elements, start, length);
    }

    @Override
    public void addAll(int index, LongList c) throws IndexOutOfBoundsException {
        LongArrayList.checkIndex(index, this.mSize + 1);
        this.ensureCapacity(this.mSize + c.size());
        System.arraycopy(this.mElementData, index, this.mElementData, index + c.size(), this.mSize - index);
        LongIterator iter = c.iterator();
        while (iter.hasNext()) {
            this.mElementData[index++] = iter.next();
        }
        this.mSize += c.size();
        ++this.mModCount;
    }

    public void addAll(int index, long[] elements) throws IndexOutOfBoundsException {
        this.addAll(index, elements, 0, elements.length);
    }

    public void addAll(int index, long[] elements, int start, int length) throws IndexOutOfBoundsException {
        if (start < 0 || start > elements.length) {
            throw new IllegalArgumentException(ERRMSG_ILLEGAL_RANGE);
        }
        if (start + length > elements.length) {
            throw new IllegalArgumentException(ERRMSG_ILLEGAL_RANGE);
        }
        LongArrayList.checkIndex(index, this.mSize + 1);
        this.ensureCapacity(this.mSize + length);
        System.arraycopy(this.mElementData, index, this.mElementData, index + length, this.mSize - index);
        System.arraycopy(elements, start, this.mElementData, index, length);
        this.mSize += length;
        ++this.mModCount;
    }

    @Override
    public void clear() {
        this.mSize = 0;
        ++this.mModCount;
    }

    @Override
    public boolean contains(long element) {
        return -1 != this.indexOf(element);
    }

    @Override
    public boolean containsAll(LongList c) {
        LongIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    private boolean containsInRange(int fromIndex, int toIndex, long element) throws IndexOutOfBoundsException {
        return -1 != this.indexOfInRange(fromIndex, toIndex, element);
    }

    @Override
    public long first() throws IndexOutOfBoundsException {
        return this.get(0);
    }

    @Override
    public long get(int index) throws IndexOutOfBoundsException {
        LongArrayList.checkIndex(index, this.mSize);
        return this.mElementData[index];
    }

    @Override
    public long getFast(int index) {
        return this.mElementData[index];
    }

    @Override
    public int indexOf(long element) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mElementData[i] != element) continue;
            return i;
        }
        return -1;
    }

    private int indexOfInRange(int fromIndex, int toIndex, long element) throws IndexOutOfBoundsException {
        LongArrayList.checkRange(fromIndex, toIndex, this.mSize);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (this.mElementData[i] != element) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.mSize;
    }

    @Override
    public LongIterator iterator() {
        return new Iter(this);
    }

    @Override
    public long last() throws IndexOutOfBoundsException {
        return this.get(this.mSize - 1);
    }

    @Override
    public int lastIndexOf(long element) {
        for (int i = this.mSize - 1; i >= 0; --i) {
            if (this.mElementData[i] != element) continue;
            return i;
        }
        return -1;
    }

    private int lastIndexOfInRange(int fromIndex, int toIndex, long element) throws IndexOutOfBoundsException {
        LongArrayList.checkRange(fromIndex, toIndex, this.mSize);
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (this.mElementData[i] != element) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void fillRange(long element, int fromIndex, int toIndex) throws IndexOutOfBoundsException {
        LongArrayList.checkRange(fromIndex, toIndex, this.mSize);
        int rangeSize = toIndex - fromIndex;
        if (rangeSize > 0) {
            Arrays.fill(this.mElementData, fromIndex, toIndex, element);
            ++this.mModCount;
        }
    }

    @Override
    public void pad(long element, int size) {
        if (this.mSize >= size) {
            return;
        }
        this.ensureCapacity(size);
        Arrays.fill(this.mElementData, this.mSize, size, element);
        this.mSize = size;
        ++this.mModCount;
    }

    @Override
    public boolean remove(long element) {
        int index = this.indexOf(element);
        if (index != -1) {
            this.removeAtFast(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(LongList c) {
        LongIterator iter = c.iterator();
        boolean updated = false;
        while (iter.hasNext()) {
            updated |= this.remove(iter.next());
        }
        return updated;
    }

    @Override
    public long removeAt(int index) throws IndexOutOfBoundsException {
        LongArrayList.checkIndex(index, this.mSize);
        long element = this.mElementData[index];
        this.removeAtFast(index);
        return element;
    }

    @Override
    public void removeAtFast(int index) {
        --this.mSize;
        ++this.mModCount;
        System.arraycopy(this.mElementData, index + 1, this.mElementData, index, this.mSize - index);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) throws IndexOutOfBoundsException {
        LongArrayList.checkRange(fromIndex, toIndex, this.mSize);
        this.removeRangeFast(fromIndex, toIndex);
    }

    @Override
    public void removeRangeFast(int fromIndex, int toIndex) {
        int rangeSize = toIndex - fromIndex;
        if (rangeSize > 0) {
            if (this.mSize - toIndex > 0) {
                System.arraycopy(this.mElementData, toIndex, this.mElementData, fromIndex, this.mSize - toIndex);
            }
            this.mSize -= rangeSize;
            ++this.mModCount;
        }
    }

    @Override
    public boolean retainAll(LongList c) {
        LongIterator iter = this.iterator();
        boolean updated = false;
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
        }
        return updated;
    }

    @Override
    public long set(int index, long element) throws IndexOutOfBoundsException {
        LongArrayList.checkIndex(index, this.mSize);
        long oldElement = this.mElementData[index];
        this.mElementData[index] = element;
        return oldElement;
    }

    @Override
    public void setFast(int index, long element) {
        this.mElementData[index] = element;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public LongList subList(int fromIndex, int toIndex) throws IndexOutOfBoundsException {
        LongArrayList.checkRange(fromIndex, toIndex, this.mSize);
        return new SubList(fromIndex, toIndex);
    }

    @Override
    public long[] toArray() {
        long[] copy = new long[this.mSize];
        System.arraycopy(this.mElementData, 0, copy, 0, this.mSize);
        return copy;
    }

    @Override
    public long[] toArrayRange(int fromIndex, int toIndex) {
        LongArrayList.checkRange(fromIndex, toIndex, this.mSize);
        int copySize = toIndex - fromIndex;
        long[] copy = new long[copySize];
        System.arraycopy(this.mElementData, fromIndex, copy, 0, copySize);
        return copy;
    }

    public void trimToSize() {
        if (this.mSize < this.mElementData.length) {
            long[] newElements = new long[this.mSize];
            System.arraycopy(this.mElementData, 0, newElements, 0, this.mSize);
            this.mElementData = newElements;
        }
    }

    @Override
    public int hashCode() {
        return LongArrayList.hashCode(this.mElementData, 0, this.mSize);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongList)) {
            return false;
        }
        return LongArrayList.equals(this, (LongList)o);
    }

    public String toString() {
        return LongArrayList.toString(this.mElementData, 0, this.mSize);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int expectedModCount = this.mModCount;
        s.defaultWriteObject();
        s.writeInt(this.mElementData.length);
        for (int i = 0; i < this.mSize; ++i) {
            s.writeLong(this.mElementData[i]);
        }
        if (this.mModCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.mElementData = new long[arrayLength];
        for (int i = 0; i < this.mSize; ++i) {
            this.mElementData[i] = s.readLong();
        }
    }

    public long estimateMemoryUsage() {
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectShallowSize(this.getClass());
        return estimatedSize += JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(8, this.mElementData.length);
    }

    private static boolean equals(LongList l1, LongList l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        LongIterator iter1 = l1.iterator();
        LongIterator iter2 = l2.iterator();
        while (iter1.hasNext()) {
            if (!iter2.hasNext()) {
                return false;
            }
            if (iter1.next() == iter2.next()) continue;
            return false;
        }
        return true;
    }

    private static int hashCode(long[] elements, int firstIndex, int lastIndex) {
        int hashCode = 0;
        for (int i = firstIndex; i < lastIndex; ++i) {
            hashCode = 31 * hashCode + (int)(0xFFFFFFFFL & elements[i]);
            hashCode = 31 * hashCode + (int)((0xFFFFFFFF00000000L & elements[i]) >> 32);
        }
        return hashCode;
    }

    private static String toString(long[] elements, int firstIndex, int lastIndex) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        for (int i = firstIndex; i < lastIndex; ++i) {
            if (i > firstIndex) {
                buffer.append(COMMA_SPACE);
            }
            buffer.append(elements[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    private final class Iter
    implements LongIterator {
        private final LongList list;
        private int index = -1;
        private boolean valid = false;
        private int expectedModCount = LongArrayList.access$1200(LongArrayList.this);

        private Iter(LongList theList) {
            this.list = theList;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.list.size();
        }

        @Override
        public long next() throws IllegalStateException {
            if (!this.hasNext()) {
                throw new IllegalStateException("At end of sequence");
            }
            if (this.expectedModCount != LongArrayList.this.mModCount) {
                throw new ConcurrentModificationException();
            }
            this.valid = true;
            return this.list.get(++this.index);
        }

        @Override
        public void remove() throws IllegalStateException {
            if (!this.valid) {
                throw new IllegalStateException("Remove invalid until call to next()");
            }
            if (this.expectedModCount != LongArrayList.this.mModCount) {
                throw new ConcurrentModificationException();
            }
            this.list.removeAt(this.index--);
            ++this.expectedModCount;
            this.valid = false;
        }

        @Override
        public void replace(long element) throws IllegalStateException {
            if (!this.valid) {
                throw new IllegalStateException("Replace invalid until call to next()");
            }
            if (this.expectedModCount != LongArrayList.this.mModCount) {
                throw new ConcurrentModificationException();
            }
            this.list.set(this.index, element);
            this.valid = false;
        }
    }

    private final class SubList
    implements LongList,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int fromIndex;
        private int toIndex;

        private SubList(int theFromIndex, int theToIndex) {
            this.fromIndex = theFromIndex;
            this.toIndex = theToIndex;
        }

        @Override
        public void add(long element) {
            this.checkSubListRange();
            LongArrayList.this.addFast(this.toIndex, element);
            ++this.toIndex;
        }

        @Override
        public void add(int index, long element) throws IndexOutOfBoundsException {
            this.checkSubListRange();
            LongArrayList.checkIndex(index, this.size() + 1);
            LongArrayList.this.addFast(index + this.fromIndex, element);
            ++this.toIndex;
        }

        @Override
        public void addFast(int index, long element) {
            LongArrayList.this.addFast(index + this.fromIndex, element);
            ++this.toIndex;
        }

        @Override
        public void addAll(LongList c) {
            this.checkSubListRange();
            LongArrayList.this.addAll(this.fromIndex, c);
            this.toIndex += c.size();
        }

        @Override
        public void addAll(int index, LongList c) throws IndexOutOfBoundsException {
            this.checkSubListRange();
            LongArrayList.checkIndex(index, this.size() + 1);
            LongArrayList.this.addAll(this.fromIndex + index, c);
            this.toIndex += c.size();
        }

        @Override
        public void clear() {
            if (this.size() > 0) {
                this.checkSubListRange();
                LongArrayList.this.removeRangeFast(this.fromIndex, this.toIndex);
                this.toIndex = this.fromIndex;
            }
        }

        @Override
        public boolean contains(long element) {
            this.checkSubListRange();
            return LongArrayList.this.containsInRange(this.fromIndex, this.toIndex, element);
        }

        @Override
        public boolean containsAll(LongList c) {
            this.checkSubListRange();
            LongIterator iter = c.iterator();
            while (iter.hasNext()) {
                if (LongArrayList.this.containsInRange(this.fromIndex, this.toIndex, iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public long first() throws IndexOutOfBoundsException {
            this.checkSubListRange();
            return LongArrayList.this.getFast(this.fromIndex);
        }

        @Override
        public long get(int index) throws IndexOutOfBoundsException {
            this.checkSubListRange();
            LongArrayList.checkIndex(index, this.size());
            return LongArrayList.this.getFast(this.fromIndex + index);
        }

        @Override
        public long getFast(int index) {
            return LongArrayList.this.getFast(index);
        }

        @Override
        public int indexOf(long element) {
            this.checkSubListRange();
            int index = LongArrayList.this.indexOfInRange(this.fromIndex, this.toIndex, element);
            if (-1 == index) {
                return -1;
            }
            return index - this.fromIndex;
        }

        @Override
        public boolean isEmpty() {
            return this.fromIndex == this.toIndex;
        }

        @Override
        public LongIterator iterator() {
            return new Iter(this);
        }

        @Override
        public long last() throws IndexOutOfBoundsException {
            this.checkSubListRange();
            return LongArrayList.this.getFast(this.fromIndex - 1);
        }

        @Override
        public int lastIndexOf(long element) {
            this.checkSubListRange();
            return LongArrayList.this.lastIndexOfInRange(this.fromIndex, this.toIndex, element) - this.fromIndex;
        }

        @Override
        public void fillRange(long element, int theFromIndex, int theToIndex) throws IndexOutOfBoundsException {
            this.checkSubListRange();
            LongArrayList.checkRange(theFromIndex, theToIndex, this.size());
            int rangeSize = theToIndex - theFromIndex;
            if (rangeSize > 0) {
                LongArrayList.this.fillRange(element, this.fromIndex + theFromIndex, this.fromIndex + theToIndex);
            }
        }

        @Override
        public void pad(long element, int size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(long element) {
            int index = this.indexOf(element);
            if (-1 != index) {
                this.removeAtFast(index);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(LongList c) {
            LongIterator iter = c.iterator();
            boolean updated = false;
            while (iter.hasNext()) {
                updated |= this.remove(iter.next());
            }
            return updated;
        }

        @Override
        public long removeAt(int index) throws IndexOutOfBoundsException {
            this.checkSubListRange();
            LongArrayList.checkIndex(index, this.size());
            long result = LongArrayList.this.removeAt(this.fromIndex + index);
            --this.toIndex;
            return result;
        }

        @Override
        public void removeAtFast(int index) {
            LongArrayList.this.removeAtFast(this.fromIndex + index);
            --this.toIndex;
        }

        @Override
        public void removeRange(int theFromIndex, int theToIndex) throws IndexOutOfBoundsException {
            this.checkSubListRange();
            LongArrayList.checkRange(theFromIndex, theToIndex, this.size());
            LongArrayList.this.removeRange(this.fromIndex + theFromIndex, this.fromIndex + theToIndex);
            this.toIndex -= theToIndex - theFromIndex;
        }

        @Override
        public void removeRangeFast(int theFromIndex, int theToIndex) {
            LongArrayList.this.removeRangeFast(this.fromIndex + theFromIndex, this.fromIndex + theToIndex);
            this.toIndex -= theToIndex - theFromIndex;
        }

        @Override
        public boolean retainAll(LongList c) {
            LongIterator iter = this.iterator();
            boolean updated = false;
            while (iter.hasNext()) {
                if (c.contains(iter.next())) continue;
                iter.remove();
            }
            return updated;
        }

        @Override
        public long set(int index, long element) throws IndexOutOfBoundsException {
            this.checkSubListRange();
            LongArrayList.checkIndex(index, this.size());
            return LongArrayList.this.set(this.fromIndex + index, element);
        }

        @Override
        public void setFast(int index, long element) {
            LongArrayList.this.setFast(this.fromIndex + index, element);
        }

        @Override
        public int size() {
            return this.toIndex - this.fromIndex;
        }

        @Override
        public LongList subList(int theFromIndex, int theToIndex) throws IndexOutOfBoundsException {
            this.checkSubListRange();
            LongArrayList.checkRange(theFromIndex, theToIndex, this.size());
            return new SubList(this.fromIndex + theFromIndex, this.fromIndex + theToIndex);
        }

        @Override
        public long[] toArray() {
            this.checkSubListRange();
            return LongArrayList.this.toArrayRange(this.fromIndex, this.toIndex);
        }

        @Override
        public long[] toArrayRange(int theFromIndex, int theToIndex) {
            this.checkSubListRange();
            LongArrayList.checkRange(theFromIndex, theToIndex, this.size());
            return LongArrayList.this.toArrayRange(this.fromIndex + theFromIndex, this.fromIndex + theToIndex);
        }

        @Override
        public int hashCode() {
            return LongArrayList.hashCode(LongArrayList.this.mElementData, 0, this.size());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LongList)) {
                return false;
            }
            return LongArrayList.equals(this, (LongList)o);
        }

        public String toString() {
            return LongArrayList.toString(LongArrayList.this.mElementData, this.fromIndex, this.toIndex);
        }

        private void checkSubListRange() throws IndexOutOfBoundsException {
            if (this.fromIndex >= LongArrayList.this.mSize || this.toIndex > LongArrayList.this.mSize) {
                throw new IndexOutOfBoundsException("Sub-list is out of range");
            }
        }
    }
}

