/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.reference;

import com.cognos.xqe.query.engine.IContextable;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.reference.IResourceHolder;
import java.util.concurrent.atomic.AtomicReference;

public final class SimpleResourceHolder<T extends IReleasable>
implements IResourceHolder<T> {
    private final AtomicReference<T> mReferent;
    private final boolean mSessionScope;

    public SimpleResourceHolder(T resource) {
        this.mReferent = new AtomicReference<T>(resource);
        this.mSessionScope = resource instanceof IContextable ? ((IContextable)resource).isSessionScope() : false;
    }

    public SimpleResourceHolder(T resource, boolean sessionScope) {
        this.mReferent = new AtomicReference<T>(resource);
        this.mSessionScope = sessionScope;
    }

    @Override
    public T reset(T value) {
        return (T)((IReleasable)this.mReferent.getAndSet(value));
    }

    @Override
    public T acquire() {
        return (T)((IReleasable)this.mReferent.get());
    }

    @Override
    public boolean isValid() {
        return null != this.acquire();
    }

    @Override
    public void release() {
        IReleasable resource = (IReleasable)this.mReferent.get();
        if (null != resource && this.mReferent.compareAndSet(resource, null)) {
            resource.release();
        }
    }

    @Override
    public boolean isSessionScope() {
        return this.mSessionScope;
    }
}

