/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.resource;

import com.cognos.xqe.cache.ICaching;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ReleasableResourceTracker {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final String LINE_END = System.getProperty("line.separator");
    private static final AtomicInteger GLOBAL_UNREPORTED_RELEASE_COUNT = new AtomicInteger(0);
    private static final AtomicInteger UNRELEASED_COUNT = new AtomicInteger(0);
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources", LogLevel.ERROR);
    private static final int MAGIC64 = 64;
    private static final boolean IS64BITARCH = Integer.valueOf(System.getProperty("sun.arch.data.model")) == 64;
    private final Collection<ResourceEntry> mResourceList;
    private final Collection<ReleasableResourceTracker> mNestedTrackers;
    private ReleasableResourceTracker mNestingTracker = null;

    public ReleasableResourceTracker() {
        this.mResourceList = new ConcurrentLinkedQueue<ResourceEntry>();
        this.mNestedTrackers = new ConcurrentLinkedQueue<ReleasableResourceTracker>();
    }

    public ReleasableResourceTracker(boolean useMap) {
        if (useMap) {
            int maxWorkerThreads = Runtime.getRuntime().availableProcessors() * 2;
            if (IS64BITARCH) {
                maxWorkerThreads *= 2;
            }
            this.mResourceList = Collections.newSetFromMap(new ConcurrentHashMap(maxWorkerThreads, 0.75f, maxWorkerThreads));
            this.mNestedTrackers = Collections.newSetFromMap(new ConcurrentHashMap(maxWorkerThreads, 0.75f, maxWorkerThreads));
        } else {
            this.mResourceList = new ConcurrentLinkedQueue<ResourceEntry>();
            this.mNestedTrackers = new ConcurrentLinkedQueue<ReleasableResourceTracker>();
        }
    }

    public static int getUnreleasedNonCacheableCount() {
        return UNRELEASED_COUNT.get();
    }

    public void addInstance(IReleasable resource, StackTraceElement[] stack) {
        UNRELEASED_COUNT.incrementAndGet();
        ResourceEntry trackingRef = new ResourceEntry(resource, stack);
        this.mResourceList.add(trackingRef);
    }

    public boolean removeInstance(IReleasable inst) {
        boolean found = false;
        Iterator<ResourceEntry> iter = this.mResourceList.iterator();
        while (iter.hasNext()) {
            ResourceEntry ref = iter.next();
            if (ref.getResource() != inst) continue;
            iter.remove();
            UNRELEASED_COUNT.decrementAndGet();
            found = true;
            break;
        }
        return found;
    }

    public void addNestedTracker(ReleasableResourceTracker tracker) {
        if (tracker == null) {
            throw new IllegalArgumentException();
        }
        if (null != tracker.mNestingTracker) {
            throw new IllegalArgumentException("null != tracker.mNestingTracker");
        }
        if (!this.mNestedTrackers.add(tracker)) {
            throw new IllegalArgumentException("!mNestedTrackers.add(tracker)");
        }
        tracker.mNestingTracker = this;
    }

    private boolean removeNestedTracker(ReleasableResourceTracker tracker) {
        if (tracker == null) {
            throw new IllegalArgumentException();
        }
        return this.mNestedTrackers.remove(tracker);
    }

    public void removeFromNestingTracker() {
        if (null == this.mNestingTracker) {
            throw new IllegalArgumentException("null == tracker.mNestingTracker");
        }
        this.mNestingTracker.removeNestedTracker(this);
    }

    public int reportAndCleanup(boolean excludeCaching) {
        int result = 0;
        for (ReleasableResourceTracker tracker : this.mNestedTrackers) {
            int nestedCachingNotReleased = tracker.reportAndCleanup(excludeCaching);
            result += nestedCachingNotReleased;
        }
        List<ResourceEntry> instancesToRelease = this.getAndSetUnreleasedInstances(excludeCaching);
        GLOBAL_UNREPORTED_RELEASE_COUNT.addAndGet(instancesToRelease.size());
        this.mResourceList.removeAll(instancesToRelease);
        ReleasableResourceTracker.reportAndRelease(instancesToRelease);
        return result += this.mResourceList.size();
    }

    public int getNumberOfUnreleasedInstances(boolean excludeCaching) {
        int result = 0;
        for (ReleasableResourceTracker tracker : this.mNestedTrackers) {
            result += tracker.getNumberOfUnreleasedInstances(excludeCaching);
        }
        return result += this.getThisNumberOfUnreleasedInstances(excludeCaching);
    }

    private int getThisNumberOfUnreleasedInstances(boolean excludeCaching) {
        int result = 0;
        for (ResourceEntry ref : this.mResourceList) {
            boolean exclude = false;
            if (excludeCaching && ref.mResource instanceof ICaching) {
                ICaching iCaching = (ICaching)((Object)ref.mResource);
                exclude = iCaching.isCaching();
            }
            if (exclude || ref.isReleased()) continue;
            ++result;
        }
        return result;
    }

    private List<ResourceEntry> getAndSetUnreleasedInstances(boolean excludeCaching) {
        ArrayList<ResourceEntry> instancesToRelease = new ArrayList<ResourceEntry>(this.mResourceList.size());
        for (ResourceEntry ref : this.mResourceList) {
            boolean attemptCompareAndRelease = true;
            if (excludeCaching && ref.mResource instanceof ICaching) {
                ICaching iCaching = (ICaching)((Object)ref.mResource);
                boolean bl = attemptCompareAndRelease = !iCaching.isCaching();
            }
            if (!attemptCompareAndRelease || !ref.compareAndSetRelease()) continue;
            instancesToRelease.add(ref);
        }
        return instancesToRelease;
    }

    private static void reportAndRelease(List<ResourceEntry> resourceList) {
        if (ERROR_LOGGER.isOn()) {
            StringBuilder buffer = new StringBuilder();
            for (ResourceEntry ref : resourceList) {
                buffer.delete(0, buffer.length());
                buffer.append("release() was not called for object of type ").append(ref.toString());
                buffer.append(", created at:").append(LINE_END);
                ref.appendStackTrace(buffer);
                String msg = buffer.toString();
                ERROR_LOGGER.log(msg);
                XQEDebugLog.err.println(msg);
            }
        }
        if (ERROR_LOGGER.isOn() && !resourceList.isEmpty()) {
            ERROR_LOGGER.log("Cleaning up unreleased resources (" + resourceList + ")");
        }
        for (ResourceEntry ref : resourceList) {
            try {
                ref.release();
            }
            catch (Throwable ex) {
                ERROR_LOGGER.log(ex);
            }
        }
    }

    public static void reportGlobalUnreleasedSummary() {
        int count = GLOBAL_UNREPORTED_RELEASE_COUNT.get();
        if (count > 0) {
            XQEDebugLog.err.println("*** A total of " + Integer.toString(count) + " provider resource(s) have not been properly released (release() method has not been called).\n*** Please make sure logging is enabled and check the log file (event group \"" + "Resources" + "\") for details.\n");
        }
    }

    public static void decrementGlobalUnreleasedSummary() {
        GLOBAL_UNREPORTED_RELEASE_COUNT.decrementAndGet();
    }

    private static final class ResourceEntry {
        private final String mClassName;
        private final StackTraceElement[] mStack;
        private final IReleasable mResource;
        private final AtomicBoolean mReleased = new AtomicBoolean(false);

        ResourceEntry(IReleasable resource, StackTraceElement[] stack) {
            this.mResource = resource;
            this.mClassName = this.mResource.getClass().getCanonicalName();
            this.mStack = stack;
        }

        private IReleasable getResource() {
            return this.mResource;
        }

        private boolean compareAndSetRelease() {
            return this.mReleased.compareAndSet(false, true);
        }

        public String toString() {
            return this.mClassName;
        }

        private boolean isReleased() {
            return this.mReleased.get();
        }

        private void release() {
            this.mResource.release();
        }

        private void appendStackTrace(StringBuilder builder) {
            for (StackTraceElement element : this.mStack) {
                builder.append(element.toString()).append(LINE_END);
            }
        }
    }
}

