/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.xml.reader;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class XMLAttributes {
    private Entry[] entries = null;

    XMLAttributes() {
    }

    void initialize(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, null);
        int attributeCount = reader.getAttributeCount();
        this.entries = new Entry[attributeCount];
        for (int i = 0; i < attributeCount; ++i) {
            this.entries[i] = new Entry(reader.getAttributeName(i), reader.getAttributeType(i), reader.isAttributeSpecified(i), reader.getAttributeValue(i));
        }
    }

    public int getCount() {
        return this.entries.length;
    }

    public QName getName(int index) {
        return this.entries[index].name;
    }

    public String getLocalName(int index) {
        return this.entries[index].name.getLocalPart();
    }

    public String getNamespaceURI(int index) {
        return this.entries[index].name.getNamespaceURI();
    }

    public String getPrefix(int index) {
        return this.entries[index].name.getPrefix();
    }

    public String getType(int index) {
        return this.entries[index].type;
    }

    public boolean isSpecified(int index) {
        return this.entries[index].specified;
    }

    public String getValue(int index) {
        return this.entries[index].value;
    }

    private static final class Entry {
        protected final QName name;
        protected final String type;
        protected final boolean specified;
        protected final String value;

        Entry(QName theName, String theType, boolean isSpecified, String theValue) {
            this.name = theName;
            this.type = theType;
            this.specified = isSpecified;
            this.value = theValue;
        }
    }
}

