/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.xml.reader;

import com.cognos.xqe.util.xml.reader.XMLAttributes;
import com.cognos.xqe.util.xml.reader.XMLElement;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class XMLElementReader {
    private final XMLStreamReader streamReader;
    private boolean valid = true;
    private final LinkedList<XMLElement> elementStack = new LinkedList();
    private XMLElement currentElement = null;
    private int currentDepth = 0;

    public XMLElementReader(XMLStreamReader theStreamReader) throws XMLStreamException {
        this.streamReader = theStreamReader;
        this.moveToRoot();
    }

    public XMLAttributes getAttributes() throws IllegalStateException {
        this.assertValid();
        if (null == this.currentElement) {
            return null;
        }
        return this.currentElement.getAttributes();
    }

    public int getDepth() {
        if (null == this.currentElement) {
            return -1;
        }
        return this.currentElement.getDepth();
    }

    public String getLocalName() throws IllegalStateException {
        this.assertValid();
        if (null == this.currentElement) {
            return null;
        }
        return this.currentElement.getName().getLocalPart();
    }

    public QName getName() throws IllegalStateException {
        this.assertValid();
        if (null == this.currentElement) {
            return null;
        }
        return this.currentElement.getName();
    }

    public String getNamespaceURI() throws IllegalStateException {
        this.assertValid();
        if (null == this.currentElement) {
            return null;
        }
        return this.currentElement.getName().getNamespaceURI();
    }

    public String getElementText() throws XMLStreamException, IllegalStateException {
        this.assertValid();
        return this.streamReader.getElementText();
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean next(String localName) throws XMLStreamException, IllegalStateException {
        while (this.nextChild()) {
            if (this.getLocalName().equals(localName)) {
                return true;
            }
            if (this.next(localName)) {
                return true;
            }
            this.returnToParent();
        }
        if (this.nextSibling()) {
            if (this.getLocalName().equals(localName)) {
                return true;
            }
            this.next(localName);
        }
        return false;
    }

    public boolean next(QName name) throws XMLStreamException, IllegalStateException {
        while (this.nextChild()) {
            if (this.getName().equals(name)) {
                return true;
            }
            if (this.next(name)) {
                return true;
            }
            this.returnToParent();
        }
        if (this.nextSibling()) {
            if (this.getName().equals(name)) {
                return true;
            }
            this.next(name);
        }
        return false;
    }

    public boolean next(QName name, int depth) throws XMLStreamException, IllegalStateException {
        if (depth < this.getDepth()) {
            throw new IllegalArgumentException("depth cannot be strictly less than current depth");
        }
        while (depth > this.getDepth() && this.nextChild()) {
            if (depth == this.getDepth() && this.getName().equals(name)) {
                return true;
            }
            if (this.next(name, depth)) {
                return true;
            }
            this.returnToParent();
        }
        if (depth >= this.getDepth() && this.nextSibling()) {
            if (depth == this.getDepth() && this.getName().equals(name)) {
                return true;
            }
            if (this.next(name, depth)) {
                return true;
            }
        }
        return false;
    }

    public boolean nextChild() throws XMLStreamException, IllegalStateException {
        this.assertValid();
        if (StaxUtil.testOnEndElement(this.streamReader, this.currentElement.getName())) {
            return false;
        }
        XMLElement parentElement = this.elementStack.peek();
        if (null != parentElement && StaxUtil.testOnEndElement(this.streamReader, parentElement.getName())) {
            return false;
        }
        this.nextTag();
        if (StaxUtil.testOnEndElement(this.streamReader)) {
            this.streamReader.require(2, this.currentElement.getName().getNamespaceURI(), this.currentElement.getName().getLocalPart());
            return false;
        }
        this.streamReader.require(1, null, null);
        this.enterElement();
        return true;
    }

    public boolean nextChild(String localName) throws XMLStreamException, IllegalStateException {
        while (this.nextChild()) {
            if (this.getLocalName().equals(localName)) {
                return true;
            }
            this.returnToParent();
        }
        return false;
    }

    public boolean nextChild(QName name) throws XMLStreamException, IllegalStateException {
        while (this.nextChild()) {
            if (this.getName().equals(name)) {
                return true;
            }
            this.returnToParent();
        }
        return false;
    }

    public boolean nextSibling() throws XMLStreamException, IllegalStateException {
        XMLElement parentElement;
        this.assertValid();
        if (StaxUtil.testOnStartElement(this.streamReader, this.currentElement.getName())) {
            StaxUtil.skipElement(this.streamReader);
        }
        if (null == (parentElement = this.elementStack.peek())) {
            return false;
        }
        if (StaxUtil.testOnEndElement(this.streamReader, parentElement.getName())) {
            return false;
        }
        if (!StaxUtil.testOnEndElement(this.streamReader, this.currentElement.getName())) {
            StaxUtil.moveToEndElement(this.streamReader, this.currentElement.getName());
        }
        this.streamReader.require(2, this.currentElement.getName().getNamespaceURI(), this.currentElement.getName().getLocalPart());
        this.nextTag();
        if (StaxUtil.testOnStartElement(this.streamReader)) {
            this.leaveElement();
            this.enterElement();
            return true;
        }
        this.streamReader.require(2, parentElement.getName().getNamespaceURI(), parentElement.getName().getLocalPart());
        return false;
    }

    public boolean nextSibling(String localName) throws XMLStreamException, IllegalStateException {
        while (this.nextSibling()) {
            if (!this.getLocalName().equals(localName)) continue;
            return true;
        }
        return false;
    }

    public boolean nextSibling(QName name) throws XMLStreamException, IllegalStateException {
        while (this.nextSibling()) {
            if (!this.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean returnToParent() throws XMLStreamException, IllegalStateException {
        this.assertValid();
        XMLElement parentElement = this.elementStack.peek();
        if (null == parentElement) {
            return false;
        }
        if (StaxUtil.testOnEndElement(this.streamReader, parentElement.getName())) {
            this.leaveElement();
            return true;
        }
        if (StaxUtil.testOnStartElement(this.streamReader, this.currentElement.getName())) {
            StaxUtil.skipElement(this.streamReader);
        }
        if (!StaxUtil.testOnEndElement(this.streamReader, this.currentElement.getName())) {
            StaxUtil.moveToEndElement(this.streamReader, this.currentElement.getName());
        }
        this.streamReader.require(2, this.currentElement.getName().getNamespaceURI(), this.currentElement.getName().getLocalPart());
        this.leaveElement();
        return true;
    }

    public boolean returnToAncestor(int distance) throws XMLStreamException, IllegalStateException {
        if (distance < 1) {
            throw new IllegalArgumentException("distance was less than one");
        }
        for (int i = 0; i < distance; ++i) {
            if (this.returnToParent()) continue;
            return false;
        }
        return true;
    }

    public boolean returnToAncestor(String localName) throws XMLStreamException, IllegalStateException {
        while (this.returnToParent()) {
            if (!this.getLocalName().equals(localName)) continue;
            return true;
        }
        return false;
    }

    public boolean returnToAncestor(QName name) throws XMLStreamException, IllegalStateException {
        while (this.returnToParent()) {
            if (!this.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void close() throws XMLStreamException {
        this.valid = false;
        this.streamReader.close();
        this.currentElement = null;
        this.elementStack.clear();
    }

    private void moveToRoot() throws XMLStreamException {
        StaxUtil.moveToElement(this.streamReader);
        this.enterElement();
    }

    private void enterElement() throws XMLStreamException {
        this.streamReader.require(1, null, null);
        ++this.currentDepth;
        if (null != this.currentElement) {
            this.elementStack.addFirst(this.currentElement);
        }
        XMLAttributes attrs = new XMLAttributes();
        attrs.initialize(this.streamReader);
        this.currentElement = new XMLElement(this.streamReader.getName(), this.currentDepth, attrs);
    }

    private void leaveElement() throws XMLStreamException {
        --this.currentDepth;
        this.currentElement = this.elementStack.poll();
    }

    private boolean nextTag() throws XMLStreamException {
        int event = this.streamReader.next();
        while (8 != event) {
            if (1 == event || 2 == event) {
                return true;
            }
            event = this.streamReader.next();
        }
        return false;
    }

    private void assertValid() throws IllegalStateException {
        if (!this.valid) {
            throw new IllegalStateException("The XMLElementReader was not valid.");
        }
    }
}

