/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.xml.serializer;

import com.cognos.xqe.util.pool.XQEXMLInputFactoryPool;
import com.cognos.xqe.util.pool.XQEXMLOutputFactoryPool;
import com.cognos.xqe.util.xml.serializer.Deserializer;
import com.cognos.xqe.util.xml.serializer.Processor;
import com.cognos.xqe.util.xml.serializer.Serializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DefaultProcessor
implements Processor {
    private final Serializer serializer;
    private final Deserializer deserializer = new Deserializer();

    public DefaultProcessor() {
        this(false);
    }

    public DefaultProcessor(boolean setIncludeType) {
        this.serializer = new Serializer(setIncludeType);
    }

    @Override
    public <T> T deserialize(Class<? extends T> clazz, FileInputStream input) throws Exception {
        XMLInputFactory factory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
        XMLStreamReader reader = factory.createXMLStreamReader(new BufferedInputStream(input));
        XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(factory);
        return this.deserialize(clazz, reader);
    }

    @Override
    public <T> T deserialize(Class<? extends T> clazz, StringReader input) throws Exception {
        XMLInputFactory factory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
        XMLStreamReader reader = factory.createXMLStreamReader(input);
        XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(factory);
        return this.deserialize(clazz, reader);
    }

    @Override
    public <T> T deserialize(Class<? extends T> clazz, XMLStreamReader input) throws Exception {
        T object = null;
        object = this.deserializer.read(clazz, input);
        return object;
    }

    @Override
    public void serialize(Object obj, FileOutputStream output) throws Exception {
        XMLOutputFactory factory = XQEXMLOutputFactoryPool.getInstance().borrowXMLOutputFactory();
        XMLStreamWriter writer = factory.createXMLStreamWriter(new BufferedOutputStream(output));
        XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(factory);
        this.serialize(obj, writer);
    }

    @Override
    public void serialize(Object obj, StringWriter output) throws Exception {
        XMLOutputFactory factory = XQEXMLOutputFactoryPool.getInstance().borrowXMLOutputFactory();
        XMLStreamWriter writer = factory.createXMLStreamWriter(output);
        XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(factory);
        this.serialize(obj, writer);
    }

    @Override
    public void serialize(Object obj, XMLStreamWriter output) throws Exception {
        this.serializer.write(obj, output);
    }

    @Override
    public void reset() {
        this.serializer.reset();
        this.deserializer.reset();
    }

    @Override
    public void removeSerializerMask() {
        this.serializer.removeSerializerMask();
    }

    @Override
    public void setSerializerMask(List<String> mask) {
        this.serializer.setSerializerMask(mask);
    }
}

