/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.xml.stax;

import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ChildElementIterator {
    private final XMLStreamReader reader;
    private int depth = 0;
    private boolean reachedEnd = false;

    public ChildElementIterator(XMLStreamReader theReader) throws XMLStreamException {
        if (1 != theReader.getEventType()) {
            throw new IllegalStateException("The XMLStreamReader was not positioned at a START_ELEMENT");
        }
        this.reader = theReader;
        if (2 == this.reader.next()) {
            this.reachedEnd = true;
        }
    }

    public boolean next() throws XMLStreamException {
        if (this.reachedEnd) {
            return false;
        }
        this.moveToNextChild();
        return !this.reachedEnd;
    }

    public void skipToEnd() throws XMLStreamException {
        while (this.next()) {
            StaxUtil.skipElement(this.reader);
        }
    }

    private void moveToNextChild() throws XMLStreamException {
        int eventType = this.reader.getEventType();
        while (8 != eventType) {
            if (1 == eventType) {
                ++this.depth;
                if (this.depth == 1) {
                    return;
                }
            } else if (2 == eventType) {
                --this.depth;
                if (this.depth == -1) {
                    this.reachedEnd = true;
                    return;
                }
            }
            eventType = this.reader.next();
        }
        this.reachedEnd = true;
    }
}

