/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.xml.stax;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.pool.XQEXMLInputFactoryPool;
import com.cognos.xqe.util.pool.XQEXMLOutputFactoryPool;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class StaxUtil {
    private static Method newXMLInputFactoryMethod;
    private static Method newXMLOutputFactoryMethod;
    private static Constructor<?> newXMLEventWriterImplCtor;

    public static Object createXMLInputFactory() throws Exception {
        Object xmlInputFactory = null;
        xmlInputFactory = newXMLInputFactoryMethod != null ? newXMLInputFactoryMethod.invoke(null, new Object[0]) : XMLInputFactory.newInstance();
        return xmlInputFactory;
    }

    public static Object createXMLOutputFactory() throws Exception {
        Object xmlOutputFactory = null;
        xmlOutputFactory = newXMLOutputFactoryMethod != null ? newXMLOutputFactoryMethod.invoke(null, new Object[0]) : XMLOutputFactory.newInstance();
        return xmlOutputFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = null;
        try {
            xmlInputFactory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        boolean success = false;
        try {
            StaxUtil.configureInputFactory(xmlInputFactory, false, true, false);
            XMLStreamReader returnValue = xmlInputFactory.createXMLStreamReader(inputStream);
            success = true;
            XMLStreamReader xMLStreamReader = returnValue;
            return xMLStreamReader;
        }
        finally {
            block9: {
                try {
                    XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(xmlInputFactory);
                }
                catch (Exception ex) {
                    if (!success) break block9;
                    throw XQERuntimeException.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = null;
        try {
            xmlInputFactory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        XMLStreamReader returnedReader = null;
        try {
            StaxUtil.configureInputFactory(xmlInputFactory, false, true, false);
            XMLStreamReader xMLStreamReader = returnedReader = xmlInputFactory.createXMLStreamReader(reader);
            return xMLStreamReader;
        }
        finally {
            block9: {
                try {
                    XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(xmlInputFactory);
                }
                catch (Exception ex) {
                    if (returnedReader == null) break block9;
                    throw XQERuntimeException.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createXMLStreamReader(String documentString) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = null;
        try {
            xmlInputFactory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        XMLStreamReader returnedReader = null;
        try {
            StaxUtil.configureInputFactory(xmlInputFactory, false, true, false);
            XMLStreamReader xMLStreamReader = returnedReader = xmlInputFactory.createXMLStreamReader(new StringReader(documentString));
            return xMLStreamReader;
        }
        finally {
            block9: {
                try {
                    XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(xmlInputFactory);
                }
                catch (Exception ex) {
                    if (returnedReader == null) break block9;
                    throw XQERuntimeException.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLEventReader createXMLEventReader(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = null;
        try {
            xmlInputFactory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        XMLEventReader returnedReader = null;
        try {
            StaxUtil.configureInputFactory(xmlInputFactory, false, true, false);
            XMLEventReader xMLEventReader = returnedReader = xmlInputFactory.createXMLEventReader(inputStream);
            return xMLEventReader;
        }
        finally {
            block9: {
                try {
                    XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(xmlInputFactory);
                }
                catch (Exception ex) {
                    if (returnedReader == null) break block9;
                    throw XQERuntimeException.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = null;
        try {
            xmlInputFactory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        XMLEventReader returnedReader = null;
        try {
            StaxUtil.configureInputFactory(xmlInputFactory, false, true, false);
            XMLEventReader xMLEventReader = returnedReader = xmlInputFactory.createXMLEventReader(reader);
            return xMLEventReader;
        }
        finally {
            block9: {
                try {
                    XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(xmlInputFactory);
                }
                catch (Exception ex) {
                    if (returnedReader == null) break block9;
                    throw XQERuntimeException.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLEventReader createXMLEventReader(String documentString) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = null;
        try {
            xmlInputFactory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        XMLEventReader returnedReader = null;
        try {
            StaxUtil.configureInputFactory(xmlInputFactory, false, true, false);
            XMLEventReader xMLEventReader = returnedReader = xmlInputFactory.createXMLEventReader(new StringReader(documentString));
            return xMLEventReader;
        }
        finally {
            block9: {
                try {
                    XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(xmlInputFactory);
                }
                catch (Exception ex) {
                    if (returnedReader == null) break block9;
                    throw XQERuntimeException.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLEventReader createXMLEventReader(XMLStreamReader streamReader) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = null;
        try {
            xmlInputFactory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        XMLEventReader returnedReader = null;
        try {
            StaxUtil.configureInputFactory(xmlInputFactory, false, true, false);
            XMLEventReader xMLEventReader = returnedReader = xmlInputFactory.createXMLEventReader(streamReader);
            return xMLEventReader;
        }
        finally {
            block9: {
                try {
                    XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(xmlInputFactory);
                }
                catch (Exception ex) {
                    if (returnedReader == null) break block9;
                    throw XQERuntimeException.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        XMLOutputFactory xmlOutputFactory = null;
        try {
            xmlOutputFactory = XQEXMLOutputFactoryPool.getInstance().borrowXMLOutputFactory();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        XMLStreamWriter returnedWriter = null;
        try {
            StaxUtil.configureOutputFactory(xmlOutputFactory, false);
            XMLStreamWriter xMLStreamWriter = returnedWriter = xmlOutputFactory.createXMLStreamWriter(outputStream);
            return xMLStreamWriter;
        }
        finally {
            block9: {
                try {
                    XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(xmlOutputFactory);
                }
                catch (Exception ex) {
                    if (returnedWriter == null) break block9;
                    throw XQERuntimeException.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        XMLOutputFactory xmlOutputFactory = null;
        try {
            xmlOutputFactory = XQEXMLOutputFactoryPool.getInstance().borrowXMLOutputFactory();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        XMLStreamWriter returnedWriter = null;
        try {
            StaxUtil.configureOutputFactory(xmlOutputFactory, false);
            XMLStreamWriter xMLStreamWriter = returnedWriter = xmlOutputFactory.createXMLStreamWriter(writer);
            return xMLStreamWriter;
        }
        finally {
            block9: {
                try {
                    XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(xmlOutputFactory);
                }
                catch (Exception ex) {
                    if (returnedWriter == null) break block9;
                    throw XQERuntimeException.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLEventWriter createXMLEventWriter(OutputStream outputStream) throws XMLStreamException {
        XMLOutputFactory xmlOutputFactory = null;
        try {
            xmlOutputFactory = XQEXMLOutputFactoryPool.getInstance().borrowXMLOutputFactory();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        XMLEventWriter returnedWriter = null;
        try {
            StaxUtil.configureOutputFactory(xmlOutputFactory, false);
            XMLEventWriter xMLEventWriter = returnedWriter = xmlOutputFactory.createXMLEventWriter(outputStream);
            return xMLEventWriter;
        }
        finally {
            block9: {
                try {
                    XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(xmlOutputFactory);
                }
                catch (Exception ex) {
                    if (returnedWriter == null) break block9;
                    throw XQERuntimeException.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        XMLOutputFactory xmlOutputFactory = null;
        try {
            xmlOutputFactory = XQEXMLOutputFactoryPool.getInstance().borrowXMLOutputFactory();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        XMLEventWriter returnedWriter = null;
        try {
            StaxUtil.configureOutputFactory(xmlOutputFactory, false);
            XMLEventWriter xMLEventWriter = returnedWriter = xmlOutputFactory.createXMLEventWriter(writer);
            return xMLEventWriter;
        }
        finally {
            block9: {
                try {
                    XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(xmlOutputFactory);
                }
                catch (Exception ex) {
                    if (returnedWriter == null) break block9;
                    throw XQERuntimeException.wrap(ex);
                }
            }
        }
    }

    public static XMLEventWriter createXMLEventWriter(XMLStreamWriter streamWriter) throws XMLStreamException {
        Exception exception;
        XMLEventWriter returnedWriter;
        block8: {
            if (null == newXMLEventWriterImplCtor) {
                throw new UnsupportedOperationException();
            }
            XMLOutputFactory xmlOutputFactory = null;
            try {
                xmlOutputFactory = XQEXMLOutputFactoryPool.getInstance().borrowXMLOutputFactory();
            }
            catch (Exception ex) {
                throw XQERuntimeException.wrap(ex);
            }
            returnedWriter = null;
            exception = null;
            try {
                StaxUtil.configureOutputFactory(xmlOutputFactory, false);
                returnedWriter = (XMLEventWriter)newXMLEventWriterImplCtor.newInstance(xmlOutputFactory, streamWriter);
            }
            catch (Exception ex) {
                exception = ex;
            }
            try {
                XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(xmlOutputFactory);
            }
            catch (Exception ex) {
                if (exception != null) break block8;
                exception = ex;
            }
        }
        if (exception != null) {
            throw XQERuntimeException.wrap(exception);
        }
        return returnedWriter;
    }

    public static void configureInputFactory(XMLInputFactory theFactory, boolean isValidating, boolean isNamespaceAware, boolean isCoalescing) {
        theFactory.setProperty("javax.xml.stream.isValidating", isValidating);
        theFactory.setProperty("javax.xml.stream.isNamespaceAware", isNamespaceAware);
        theFactory.setProperty("javax.xml.stream.isCoalescing", isCoalescing);
    }

    public static void configureOutputFactory(XMLOutputFactory theFactory, boolean isRepairingNamespaces) {
        theFactory.setProperty("javax.xml.stream.isRepairingNamespaces", isRepairingNamespaces);
    }

    public static boolean testOnStartElement(XMLStreamReader reader) {
        return 1 == reader.getEventType();
    }

    public static boolean testOnStartElement(XMLStreamReader reader, String localName) {
        return 1 == reader.getEventType() && reader.getLocalName().equals(localName);
    }

    public static boolean testOnStartElement(XMLStreamReader reader, QName name) {
        return 1 == reader.getEventType() && reader.getName().equals(name);
    }

    public static boolean testOnEndElement(XMLStreamReader reader) {
        return 2 == reader.getEventType();
    }

    public static boolean testOnEndElement(XMLStreamReader reader, String localName) {
        return 2 == reader.getEventType() && reader.getLocalName().equals(localName);
    }

    public static boolean testOnEndElement(XMLStreamReader reader, QName name) {
        return 2 == reader.getEventType() && reader.getName().equals(name);
    }

    public static boolean moveToElement(XMLStreamReader reader) throws XMLStreamException {
        int event = reader.next();
        while (event != 8) {
            if (1 == event) {
                return true;
            }
            event = reader.next();
        }
        return false;
    }

    public static boolean moveToElement(XMLStreamReader reader, int depth) throws XMLStreamException {
        int depthChange = 0;
        int event = reader.next();
        while (event != 8) {
            if (1 == event) {
                if (depth == ++depthChange) {
                    return true;
                }
            } else if (2 == event) {
                --depthChange;
            }
            event = reader.next();
        }
        return false;
    }

    public static boolean moveToElement(XMLStreamReader reader, String localName) throws XMLStreamException {
        int event = reader.next();
        while (event != 8) {
            if (1 == event && reader.getLocalName().equals(localName)) {
                return true;
            }
            event = reader.next();
        }
        return false;
    }

    public static boolean moveToElement(XMLStreamReader reader, String localName, int depth) throws XMLStreamException {
        int depthChange = 0;
        int event = reader.next();
        while (event != 8) {
            if (1 == event) {
                if (depth == ++depthChange && reader.getLocalName().equals(localName)) {
                    return true;
                }
            } else if (2 == event) {
                --depthChange;
            }
            event = reader.next();
        }
        return false;
    }

    public static boolean moveToElement(XMLStreamReader reader, QName name) throws XMLStreamException {
        int event = reader.next();
        while (event != 8) {
            if (1 == event && reader.getName().equals(name)) {
                return true;
            }
            event = reader.next();
        }
        return false;
    }

    public static boolean moveToElement(XMLStreamReader reader, QName name, int depth) throws XMLStreamException {
        int depthChange = 0;
        int event = reader.next();
        while (event != 8) {
            if (1 == event) {
                if (depth == ++depthChange && reader.getName().equals(name)) {
                    return true;
                }
            } else if (2 == event) {
                --depthChange;
            }
            event = reader.next();
        }
        return false;
    }

    public static boolean skipElement(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, null);
        int depthChange = 0;
        int event = reader.next();
        while (event != 8) {
            if (1 == event) {
                ++depthChange;
            } else if (2 == event && --depthChange == -1) {
                return true;
            }
            event = reader.next();
        }
        return false;
    }

    public static boolean moveToEndElement(XMLStreamReader reader) throws XMLStreamException {
        int event = reader.next();
        while (event != 8) {
            if (2 == event) {
                return true;
            }
            event = reader.next();
        }
        return false;
    }

    public static boolean moveToEndElement(XMLStreamReader reader, int depth) throws XMLStreamException {
        int depthChange = 0;
        int event = reader.next();
        while (event != 8) {
            if (2 == event) {
                if (depth == depthChange) {
                    return true;
                }
                --depthChange;
            } else if (1 == event) {
                ++depthChange;
            }
            event = reader.next();
        }
        return false;
    }

    public static boolean moveToEndElement(XMLStreamReader reader, String localName) throws XMLStreamException {
        int event = reader.next();
        while (event != 8) {
            if (2 == event && reader.getLocalName().equals(localName)) {
                return true;
            }
            event = reader.next();
        }
        return false;
    }

    public static boolean moveToEndElement(XMLStreamReader reader, String localName, int depth) throws XMLStreamException {
        int depthChange = 0;
        int event = reader.next();
        while (event != 8) {
            if (2 == event) {
                if (--depthChange == depth && reader.getLocalName().equals(localName)) {
                    return true;
                }
            } else if (1 == event) {
                ++depthChange;
            }
            event = reader.next();
        }
        return false;
    }

    public static boolean moveToEndElement(XMLStreamReader reader, QName name) throws XMLStreamException {
        int event = reader.next();
        while (event != 8) {
            if (2 == event && reader.getName().equals(name)) {
                return true;
            }
            event = reader.next();
        }
        return false;
    }

    public static boolean moveToEndElement(XMLStreamReader reader, QName name, int depth) throws XMLStreamException {
        int depthChange = 0;
        int event = reader.next();
        while (event != 8) {
            if (2 == event) {
                if (depth == --depthChange && reader.getName().equals(name)) {
                    return true;
                }
            } else if (1 == event) {
                ++depthChange;
            }
            event = reader.next();
        }
        return false;
    }

    public static String eventTypeToString(int eventType) {
        switch (eventType) {
            case 10: {
                return "ATTRIBUTE";
            }
            case 12: {
                return "CDATA";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 11: {
                return "DTD";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 1: {
                return "START_ELEMENT";
            }
        }
        throw new IllegalArgumentException("eventType was out of range");
    }

    private StaxUtil() {
    }

    static {
        try {
            Class<?> jaxpFactoryHelperClass = Class.forName("com.ibm.xml.jaxp.util.JAXPFactoryHelper");
            newXMLInputFactoryMethod = jaxpFactoryHelperClass.getMethod("newXMLInputFactory", new Class[0]);
            newXMLOutputFactoryMethod = jaxpFactoryHelperClass.getMethod("newXMLOutputFactory", new Class[0]);
            Class<?> xmlEventWriterImplClass = Class.forName("com.ibm.xml.xlxp.internal.s1.api.stax.XMLEventWriterImpl");
            newXMLEventWriterImplCtor = xmlEventWriterImplClass.getConstructor(XMLOutputFactory.class, XMLStreamWriter.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

