/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.developer.schemas.bibus._3.DispatcherTransportVar;
import com.cognos.developer.schemas.bibus._3.EnvironmentVar;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.RoutingInfo;
import com.cognos.developer.schemas.bibus._3.UserCapabilityCache;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.utils.XMLString;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.AtomElement;
import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.translator.XMLElementsParser;
import com.cognos.xqebifw.adminconsole.fragmentproducer.utilities.StringUtils;
import javax.xml.stream.XMLStreamException;
import org.apache.axis.encoding.Base64;

public final class FragmentUtils {
    private static final String STR_ITEM = "item";
    private static final String STR_NAME = "name";
    private static final String STR_VALUE = "value";
    private static FragmentUtils instance = null;

    protected static synchronized FragmentUtils getInstance() {
        if (instance == null) {
            instance = new FragmentUtils();
        }
        return instance;
    }

    private FragmentUtils() {
    }

    public static BiBusHeader constructBiBusHeader(StageContext context) {
        try {
            BiBusHeader biBusHeader = new BiBusHeader();
            XMLString xmlBiBusHeader = context.getBusHeader();
            if (xmlBiBusHeader != null) {
                AtomElement eBiBusHeader = XMLElementsParser.parse(xmlBiBusHeader.toString());
                FragmentUtils.setCAM(biBusHeader, eBiBusHeader);
                FragmentUtils.setHdrSession(biBusHeader, eBiBusHeader);
                FragmentUtils.setUserPreferenceVars(biBusHeader, eBiBusHeader);
                FragmentUtils.setDispatcherTransportVars(biBusHeader, eBiBusHeader);
                FragmentUtils.setUserCapabilityCache(biBusHeader, eBiBusHeader);
                FragmentUtils.setRoutingInfo(biBusHeader, eBiBusHeader);
            }
            return biBusHeader;
        }
        catch (XMLStreamException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
    }

    protected static void setRoutingInfo(BiBusHeader biBusHeader, AtomElement eBiBusHeader) {
        AtomElement eRouting = eBiBusHeader.getElementIgnoreNamespace("routing");
        AtomElement eServerGroup = null;
        eServerGroup = eRouting == null ? null : eRouting.getElementIgnoreNamespace("routingServerGroup");
        if (eServerGroup == null) {
            return;
        }
        String serverGroup = eServerGroup.getText();
        if (serverGroup == null || serverGroup.length() == 0) {
            return;
        }
        RoutingInfo rsgRouting = new RoutingInfo();
        rsgRouting.setRoutingServerGroup(serverGroup);
        biBusHeader.setRouting(rsgRouting);
    }

    public static void setCAM(BiBusHeader biBusHeader, AtomElement eBiBusHeader) {
        String sId;
        AtomElement eCAM = eBiBusHeader.getElementIgnoreNamespace("CAM");
        AtomElement eCAMPassport = null;
        eCAMPassport = eCAM == null ? null : eCAM.getElementIgnoreNamespace("CAMPassport");
        AtomElement eId = null;
        eId = eCAMPassport == null ? null : eCAMPassport.getElementIgnoreNamespace("id");
        if (eId != null && (sId = eId.getText()) != null && sId.length() > 0) {
            String sUserSessionID;
            CAMPassport camPassport = new CAMPassport();
            camPassport.setId(sId);
            CAM cam = new CAM();
            cam.setCAMPassport(camPassport);
            biBusHeader.setCAM(cam);
            AtomElement eUserSessionID = null;
            eUserSessionID = eCAM == null ? null : eCAM.getElementIgnoreNamespace("userSessionID");
            if (eUserSessionID != null && (sUserSessionID = eUserSessionID.getText()) != null && sUserSessionID.length() > 0) {
                cam.setUserSessionID(sUserSessionID.getBytes());
            }
        }
    }

    public static void setHdrSession(BiBusHeader biBusHeader, AtomElement eBiBusHeader) {
        HdrSession hdrSession = new HdrSession();
        biBusHeader.setHdrSession(hdrSession);
        AtomElement eHdrSession = eBiBusHeader.getElementIgnoreNamespace("hdrSession");
        FragmentUtils.setEnvironmentVars(hdrSession, eHdrSession);
        FragmentUtils.setFormFieldVars(hdrSession, eHdrSession);
        FragmentUtils.setCookieVars(hdrSession, eHdrSession);
    }

    public static void setEnvironmentVars(HdrSession hdrSession, AtomElement eHdrSession) {
        AtomElement eEnvironmentVars = null;
        eEnvironmentVars = eHdrSession == null ? null : eHdrSession.getElementIgnoreNamespace("environmentVars");
        AtomElement[] eItems = null;
        eItems = eEnvironmentVars == null ? null : eEnvironmentVars.getElementsIgnoreNamespace(STR_ITEM);
        if (eItems != null && eItems.length != 0) {
            EnvironmentVar[] environmentVars = new EnvironmentVar[eItems.length];
            hdrSession.setEnvironmentVars(environmentVars);
            for (int i = 0; i < eItems.length; ++i) {
                environmentVars[i] = new EnvironmentVar();
                AtomElement eNode = eItems[i].getElementIgnoreNamespace(STR_NAME);
                String value = eNode.getText();
                environmentVars[i].setName(value);
                eNode = eItems[i].getElementIgnoreNamespace(STR_VALUE);
                value = eNode.getText();
                if (value == null) {
                    environmentVars[i].setValue("");
                    continue;
                }
                environmentVars[i].setValue(value);
            }
        }
    }

    public static void setFormFieldVars(HdrSession hdrSession, AtomElement eHdrSession) {
        AtomElement eFormFieldVars = null;
        eFormFieldVars = eHdrSession == null ? null : eHdrSession.getElementIgnoreNamespace("formFieldVars");
        AtomElement[] eItems = null;
        eItems = eFormFieldVars == null ? null : eFormFieldVars.getElementsIgnoreNamespace(STR_ITEM);
        if (eItems != null && eItems.length != 0) {
            FormFieldVar[] formFieldVars = new FormFieldVar[eItems.length];
            hdrSession.setFormFieldVars(formFieldVars);
            for (int i = 0; i < eItems.length; ++i) {
                formFieldVars[i] = new FormFieldVar();
                AtomElement eNode = eItems[i].getElementIgnoreNamespace(STR_NAME);
                String value = eNode.getText();
                formFieldVars[i].setName(value);
                eNode = eItems[i].getElementIgnoreNamespace(STR_VALUE);
                value = eNode.getText();
                if (value == null) {
                    formFieldVars[i].setValue("");
                    continue;
                }
                formFieldVars[i].setValue(value);
            }
        }
    }

    public static void setCookieVars(HdrSession hdrSession, AtomElement eHdrSession) {
        AtomElement eCookieVars = null;
        eCookieVars = eHdrSession == null ? null : eHdrSession.getElementIgnoreNamespace("cookieVars");
        AtomElement[] eItems = null;
        eItems = eCookieVars == null ? null : eCookieVars.getElementsIgnoreNamespace(STR_ITEM);
        if (eItems != null && eItems.length != 0) {
            CookieVar[] cookieVars = new CookieVar[eItems.length];
            hdrSession.setCookieVars(cookieVars);
            for (int i = 0; i < eItems.length; ++i) {
                cookieVars[i] = new CookieVar();
                AtomElement eNode = eItems[i].getElementIgnoreNamespace(STR_NAME);
                String value = eNode.getText();
                cookieVars[i].setName(value);
                eNode = eItems[i].getElementIgnoreNamespace(STR_VALUE);
                value = eNode.getText();
                if (value == null) {
                    cookieVars[i].setValue("");
                    continue;
                }
                cookieVars[i].setValue(value);
            }
        }
    }

    public static void setUserPreferenceVars(BiBusHeader biBusHeader, AtomElement eBiBusHeader) {
        AtomElement eUserPreferenceVars = null;
        eUserPreferenceVars = eBiBusHeader == null ? null : eBiBusHeader.getElementIgnoreNamespace("userPreferenceVars");
        AtomElement[] eItems = null;
        eItems = eUserPreferenceVars == null ? null : eUserPreferenceVars.getElementsIgnoreNamespace(STR_ITEM);
        if (eItems != null && eItems.length != 0) {
            UserPreferenceVar[] userPreferenceVars = new UserPreferenceVar[eItems.length];
            biBusHeader.setUserPreferenceVars(userPreferenceVars);
            for (int i = 0; i < eItems.length; ++i) {
                userPreferenceVars[i] = new UserPreferenceVar();
                AtomElement eNode = eItems[i].getElementIgnoreNamespace(STR_NAME);
                String value = eNode.getText();
                userPreferenceVars[i].setName(value);
                eNode = eItems[i].getElementIgnoreNamespace(STR_VALUE);
                value = eNode.getText();
                if (value == null) {
                    userPreferenceVars[i].setValue("");
                    continue;
                }
                userPreferenceVars[i].setValue(value);
            }
        }
    }

    public static void setDispatcherTransportVars(BiBusHeader biBusHeader, AtomElement eBiBusHeader) {
        AtomElement eDispatcherTransportVars = null;
        eDispatcherTransportVars = eBiBusHeader == null ? null : eBiBusHeader.getElementIgnoreNamespace("dispatcherTransportVars");
        AtomElement[] eItems = null;
        eItems = eDispatcherTransportVars == null ? null : eDispatcherTransportVars.getElementsIgnoreNamespace(STR_ITEM);
        if (eItems != null && eItems.length != 0) {
            DispatcherTransportVar[] dispatcherTransportVars = new DispatcherTransportVar[eItems.length];
            biBusHeader.setDispatcherTransportVars(dispatcherTransportVars);
            for (int i = 0; i < eItems.length; ++i) {
                dispatcherTransportVars[i] = new DispatcherTransportVar();
                AtomElement eNode = eItems[i].getElementIgnoreNamespace(STR_NAME);
                String value = eNode.getText();
                dispatcherTransportVars[i].setName(value);
                eNode = eItems[i].getElementIgnoreNamespace(STR_VALUE);
                value = eNode.getText();
                if (value == null) {
                    dispatcherTransportVars[i].setValue("");
                    continue;
                }
                dispatcherTransportVars[i].setValue(value);
            }
        }
    }

    public static void setUserCapabilityCache(BiBusHeader biBusHeader, AtomElement eBiBusHeader) {
        AtomElement eUserCapabilityCache = null;
        eUserCapabilityCache = eBiBusHeader == null ? null : eBiBusHeader.getElementIgnoreNamespace("userCapabilityCache");
        AtomElement eUserCapabilities = null;
        eUserCapabilities = eUserCapabilityCache == null ? null : eUserCapabilityCache.getElementIgnoreNamespace("userCapabilities");
        AtomElement[] eItems = null;
        eItems = eUserCapabilities == null ? null : eUserCapabilities.getElementsIgnoreNamespace(STR_ITEM);
        if (eItems != null && eItems.length != 0) {
            String signature;
            UserCapabilityCache userCapabilityCache = new UserCapabilityCache();
            biBusHeader.setUserCapabilityCache(userCapabilityCache);
            UserCapabilityEnum[] userCapabilities = new UserCapabilityEnum[eItems.length];
            userCapabilityCache.setUserCapabilities(userCapabilities);
            for (int i = 0; i < eItems.length; ++i) {
                String value = eItems[i].getText();
                userCapabilities[i] = UserCapabilityEnum.fromString((String)value);
            }
            AtomElement eSignature = null;
            eSignature = eUserCapabilityCache == null ? null : eUserCapabilityCache.getElementIgnoreNamespace("signature");
            if (eSignature != null && (signature = eSignature.getText()) != null && signature.length() > 0) {
                byte[] bytes = Base64.decode((String)signature);
                userCapabilityCache.setSignature(bytes);
            }
        }
    }

    public static String getUserPreference(BiBusHeader biBusHeader, String sPreferenceName) {
        UserPreferenceVar[] preferences;
        if (biBusHeader != null && (preferences = biBusHeader.getUserPreferenceVars()) != null) {
            for (int i = 0; i < preferences.length; ++i) {
                if (!sPreferenceName.equals(preferences[i].getName())) continue;
                return preferences[i].getValue();
            }
        }
        return null;
    }

    public static String getFragmentStringParameter(StageContext stageContext, String sName, String sDefault) {
        String sResult = stageContext.getRequestParameters().getValue(sName);
        if (sResult == null && (sResult = stageContext.getEnv().getParameter(sName)) == null) {
            sResult = StringUtils.getString(stageContext.getTransientParams().getValue(sName), sDefault);
        }
        return sResult;
    }

    public static int getFragmentIntParameter(StageContext stageContext, String sName, int nDefault) {
        String sResult = FragmentUtils.getFragmentStringParameter(stageContext, sName, null);
        return StringUtils.getInt(sResult, nDefault);
    }
}

