/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.EnvironmentVar;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.portal.fragment.producer.helpers.Preferences;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.utils.Parameters;
import com.cognos.xqebifw.adminconsole.fragmentproducer.c8.C8GlobalVars;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.FragmentUtils;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.Parameter;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.WebKit;
import com.cognos.xqebifw.adminconsole.fragmentproducer.utilities.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebParameters {
    private static final String STR_COLON = ":";
    private static final String SERVER_PROTOCOL = "SERVER_PROTOCOL";
    public static final String REQUEST_METHOD = "REQUEST_METHOD";
    public static final String FRAGMENT_PATH_INFO = "PATH_INFO";
    public static final String HOST_SCRIPT_NAME = "SCRIPT_NAME";
    public static final String HOST_SERVER_NAME = "SERVER_NAME";
    public static final String HTTP_HOST = "HTTP_HOST";
    public static final String HTTP_SERVER_PORT = "SERVER_PORT";
    public static final String HTTP_USER_AGENT = "HTTP_USER_AGENT";
    public static final String WEB_CONTENT_ROOT = "WEB_CONTENT_ROOT";
    public static final String USER_DEFAULT_LINE_PER_PAGE = "linesPerPage";
    public static final String ADVANCED_TOOLKIT_TOGGLED = "uiRendererAdvancedSearchDivToggled";
    public static final String SUMBIT_MULTIPLE_FILTERS = "uiRendererSubmitMultipleFiltersFlag";
    public static final String REFINEMENT_VIEWER_MORE_NAV_FLAG = "isRefinementMoreFlag";
    protected static final Pattern PROTOCOL_PATTERN = Pattern.compile("^\\w+");
    public static final String UIDS_SPLITTER = "\t";
    public static final Pattern UIDS_SPLITTER_PATTERN = Pattern.compile("\t");
    public static final Pattern UIDS_BLOCS_SPLITTER_PATTERN = Pattern.compile("##");
    private HashMap<String, Parameter> mmapUserPreferenceVars = new HashMap();
    private HashMap<String, Parameter> mmapFormFieldVars = new HashMap();
    private HashMap<String, Parameter> mmapEnvironmentVars = new HashMap();
    private String mfragmentAgent;
    private boolean misLoaded;
    private BiBusHeader mbiBusHeader;
    private WebKit mwebKit = new WebKit();

    public WebParameters() {
        this.setLocale(Locale.getDefault());
    }

    public WebParameters(StageContext context) {
        this();
        this.loadParameters(context);
    }

    public void addUserPreferenceVars(UserPreferenceVar[] userPreferenceVars) {
        if (userPreferenceVars == null) {
            return;
        }
        for (int i = 0; i < userPreferenceVars.length; ++i) {
            String name = userPreferenceVars[i].getName();
            String value = userPreferenceVars[i].getValue();
            Parameter param = new Parameter(name, value);
            this.mmapUserPreferenceVars.put(name, param);
        }
    }

    public String getUserPreferenceVar(String varName) {
        Parameter param = this.mmapUserPreferenceVars.get(varName);
        if (param == null) {
            return null;
        }
        return param.getValue();
    }

    public void addFormFieldVars(FormFieldVar[] formFieldVars) {
        if (formFieldVars == null) {
            return;
        }
        for (int i = 0; i < formFieldVars.length; ++i) {
            String oldValue;
            String value;
            Parameter param;
            String name = formFieldVars[i].getName();
            Parameter oldParam = this.mmapFormFieldVars.put(name, param = new Parameter(name, value = formFieldVars[i].getValue()));
            if (oldParam == null || value.equals(oldValue = oldParam.getValue())) continue;
            if ("backURL".equals(oldValue)) {
                if (value.length() != 0) continue;
                this.mmapFormFieldVars.put(name, oldParam);
                continue;
            }
            this.mmapFormFieldVars.put(name, oldParam);
        }
    }

    public String getFormFieldVar(String varName) {
        Parameter param = this.mmapFormFieldVars.get(varName);
        if (param == null) {
            return null;
        }
        return param.getValue();
    }

    private void addEnvironmentVars(EnvironmentVar[] environmentVars) {
        if (environmentVars == null) {
            return;
        }
        for (int i = 0; i < environmentVars.length; ++i) {
            String name = environmentVars[i].getName();
            String value = null;
            value = SERVER_PROTOCOL.equals(name) ? C8GlobalVars.getGatewayProtocol() : environmentVars[i].getValue();
            Parameter param = new Parameter(name, value);
            this.mmapEnvironmentVars.put(name, param);
        }
    }

    public String getEnvironmentVar(String varName) {
        Parameter param = this.mmapEnvironmentVars.get(varName);
        if (param == null) {
            return null;
        }
        return param.getValue();
    }

    public void setFragmentAgent(String fragmentAgent) {
        this.mfragmentAgent = fragmentAgent;
    }

    public String getFragmentAgent() {
        return this.mfragmentAgent;
    }

    public void setSkin(String skin) {
        this.mwebKit.setSkin(skin);
    }

    public String getSkin() {
        return this.mwebKit.getSkin();
    }

    public void setContentLocale(Locale contentLocale) {
        this.mwebKit.setContentLocale(contentLocale);
    }

    public Locale getContentLocale() {
        return this.mwebKit.getContentLocale();
    }

    public Locale getProductLocale() {
        return this.mwebKit.getProductLocale();
    }

    public void setProductLocale(Locale productLocale) {
        this.mwebKit.setProductLocale(productLocale);
    }

    public void setLocale(Locale locale) {
        this.mwebKit.setContentLocale(locale);
        this.mwebKit.setProductLocale(locale);
    }

    public BiBusHeader getBiBusHeader() {
        return this.mbiBusHeader;
    }

    public void setBiBusHeader(BiBusHeader biBusHeader) {
        this.mbiBusHeader = biBusHeader;
    }

    public String getVar(String varName) {
        Parameter param = this.getParameter(varName);
        if (param == null) {
            return null;
        }
        return param.getValue();
    }

    public Parameter getParameter(String varName) {
        Parameter param = this.mmapFormFieldVars.get(varName);
        if (param == null) {
            param = this.mmapEnvironmentVars.get(varName);
        }
        if (param == null) {
            param = this.mmapUserPreferenceVars.get(varName);
        }
        return param;
    }

    public Parameter[] getHtmlFormVars(String namePrefix) {
        ArrayList<Parameter> vParams = new ArrayList<Parameter>();
        for (Map.Entry<String, Parameter> entry : this.mmapFormFieldVars.entrySet()) {
            Parameter param = entry.getValue();
            if (!param.getName().startsWith(namePrefix)) continue;
            vParams.add(param);
        }
        return vParams.toArray(new Parameter[vParams.size()]);
    }

    public URL getCGIUrl() throws MalformedURLException {
        Parameter param = this.mmapEnvironmentVars.get(SERVER_PROTOCOL);
        if (param == null) {
            return null;
        }
        String protocol = param.getValue();
        Matcher mather = PROTOCOL_PATTERN.matcher(protocol);
        if (mather.find(0)) {
            protocol = mather.group();
        }
        param = this.mmapEnvironmentVars.get(HOST_SCRIPT_NAME);
        String script = param.getValue();
        param = this.mmapEnvironmentVars.get(HTTP_HOST);
        String host = param.getValue();
        int pos = host.indexOf(STR_COLON);
        if (pos != -1) {
            host = host.substring(0, pos);
        }
        URL url = null;
        param = this.mmapEnvironmentVars.get(HTTP_SERVER_PORT);
        String portIn = param.getValue();
        if (portIn == null) {
            url = new URL(protocol, host, script);
        } else {
            try {
                int port = Integer.parseInt(portIn);
                url = new URL(protocol, host, port, script);
            }
            catch (NumberFormatException e) {
                url = new URL(protocol, host, script);
            }
        }
        return url;
    }

    public String getWebContentRoot() {
        Parameter param = this.mmapEnvironmentVars.get(WEB_CONTENT_ROOT);
        if (param == null) {
            return null;
        }
        return param.getValue();
    }

    public WebKit getWebKit() {
        return this.mwebKit;
    }

    public boolean isLoaded() {
        return this.misLoaded;
    }

    public void loadParameters(StageContext context) {
        WebParameters.readWebParameter(context, this);
        this.misLoaded = true;
    }

    public static void readWebParameter(StageContext context, WebParameters targetWebParameters) {
        try {
            BiBusHeader biBusHeader = FragmentUtils.constructBiBusHeader(context);
            targetWebParameters.setBiBusHeader(biBusHeader);
            String xmlFullBiBusHeader = context.getBusHeader().toString();
            targetWebParameters.setFullBiBusHeaderXML(xmlFullBiBusHeader);
            UserPreferenceVar[] userPreferenceVars = biBusHeader.getUserPreferenceVars();
            targetWebParameters.addUserPreferenceVars(userPreferenceVars);
            HdrSession hdrSession = biBusHeader.getHdrSession();
            FormFieldVar[] formFieldVars = hdrSession.getFormFieldVars();
            targetWebParameters.addFormFieldVars(formFieldVars);
            EnvironmentVar[] environmentVars = hdrSession.getEnvironmentVars();
            targetWebParameters.addEnvironmentVars(environmentVars);
            Preferences preferences = context.getPreferences();
            String skin = preferences.getSkin();
            targetWebParameters.setSkin(skin);
            Locale locale = StringUtils.parseLocale(preferences.getContentLocale());
            targetWebParameters.setContentLocale(locale);
            locale = StringUtils.parseLocale(preferences.getProductLocale());
            targetWebParameters.setProductLocale(locale);
            if (targetWebParameters.getEnvironmentVar(HTTP_USER_AGENT) == null) {
                String fragmentAgent;
                Parameters parameters = context.getRequestParameters();
                targetWebParameters.mfragmentAgent = fragmentAgent = parameters.getValue("frag-agent");
            }
            URL url = targetWebParameters.getCGIUrl();
            targetWebParameters.mwebKit.setCGIUrl(url);
            String webContentRoot = targetWebParameters.getWebContentRoot();
            targetWebParameters.mwebKit.setWebContentRoot(webContentRoot);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setFullBiBusHeaderXML(String xmlFullBiBusHeader) {
        this.mwebKit.setFullBiBusHeaderXML(xmlFullBiBusHeader);
    }
}

