/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.qsat.server;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.adminconsole.qsat.fragmentproducer.ui.page.XqeQSATPage;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OptionsXMLProcessor {
    public static final String SLASH_DELIMITER = "\"/\"";
    private static final String AMP = "&amp;";
    private static final String APOS = "&apos;";
    private static final String LT = "&lt;";
    private static final String GT = "&gt;";
    private static final String QUOT = "&quot;";
    String inputTaskParameters = null;
    private Document xmlDoc = null;
    private static final String ITEM_ELEMENT = "item";
    private static final String ITEM_ELEMENT_TYPE = "xsi:type";
    private static final String ITEM_ELEMENT_TYPE_VALUE_BOOL = "bus:genericOptionBoolean";
    private static final String ITEM_ELEMENT_TYPE_VALUE_STRARR = "bus:genericOptionStringArray";
    private static final String ITEM_ELEMENT_TYPE_VALUE_STR = "bus:genericOptionString";
    private static final String ITEM_ELEMENT_TYPE_VALUE_CMMONITOROPTIONGUID = "cm:monitorOptionGUID";
    private static final String ITEM_ELEMENT_TYPE_VALUE_BUSMONITOROPTIONGUID = "bus:monitorOptionGUID";
    private static final String ITEM_ELEMENT_NAME = "name";
    private static final String ITEM_ELEMENT_VALUE = "value";
    private static final int XMLENCODE_BUFFER_MULTIPLIER = 4;
    XQELogger errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public void initializeInputOptionsXML(String input) {
        this.generateSpecificOptionsDocument(input);
    }

    public String initializeOutputOptionsXML(String type, String outputParams) {
        return this.formOutputOptionsXml(type, outputParams);
    }

    private void generateSpecificOptionsDocument(String input) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.xmlDoc = docBuilder.parse(new InputSource(new StringReader(input)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getInputTaskType() {
        String taskName = null;
        boolean taskEnabled = false;
        NodeList nodes = this.xmlDoc.getElementsByTagName(ITEM_ELEMENT);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            Node attribute = attributes.getNamedItem(ITEM_ELEMENT_TYPE);
            if (!attribute.getNodeValue().equals(ITEM_ELEMENT_TYPE_VALUE_BOOL)) continue;
            NodeList childrens = node.getChildNodes();
            for (int j = 0; j < childrens.getLength(); ++j) {
                Node temp = childrens.item(j);
                if (temp.getNodeName().equals(ITEM_ELEMENT_NAME)) {
                    taskName = OptionsXMLProcessor.getExtendedNodeValue(temp);
                }
                if (temp.getNodeName().equals(ITEM_ELEMENT_VALUE)) {
                    taskEnabled = Boolean.parseBoolean(OptionsXMLProcessor.getExtendedNodeValue(temp));
                }
                if (taskName == null || "".equals(taskName) || !taskEnabled) continue;
                if (taskName.toLowerCase().indexOf("http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#clearCache".toLowerCase()) >= 0) {
                    taskName = "Clear cache";
                } else if (taskName.toLowerCase().indexOf("http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#DumpCacheState".toLowerCase()) >= 0) {
                    taskName = "Write cache state";
                }
                return taskName;
            }
        }
        return null;
    }

    public String getInputTaskParameters() {
        NodeList nodes = this.xmlDoc.getElementsByTagName(ITEM_ELEMENT);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            Node attribute = attributes.getNamedItem(ITEM_ELEMENT_TYPE);
            if (!attribute.getNodeValue().equals(ITEM_ELEMENT_TYPE_VALUE_STRARR)) continue;
            NodeList childrens = node.getChildNodes();
            for (int j = 0; j < childrens.getLength(); ++j) {
                Node temp = childrens.item(j);
                if (!temp.getNodeName().equals(ITEM_ELEMENT_VALUE)) continue;
                NodeList grandChildrens = temp.getChildNodes();
                for (int k = 0; k < grandChildrens.getLength(); ++k) {
                    Node probableNode = grandChildrens.item(k);
                    if (!probableNode.getNodeName().equals(ITEM_ELEMENT)) continue;
                    this.inputTaskParameters = OptionsXMLProcessor.getExtendedNodeValue(probableNode);
                    try {
                        this.inputTaskParameters = URLDecoder.decode(this.inputTaskParameters, "UTF-8");
                        this.inputTaskParameters = OptionsXMLProcessor.xmlDecode(this.inputTaskParameters);
                    }
                    catch (UnsupportedEncodingException e) {
                        this.errorLogger.log(e);
                        throw new RuntimeException(e);
                    }
                    return this.inputTaskParameters;
                }
            }
        }
        return null;
    }

    public String getInputElement(String elementType) {
        if (this.inputTaskParameters != null) {
            int firstIndexOfSlash = this.inputTaskParameters.indexOf(SLASH_DELIMITER);
            int secondIndexOfSlash = this.inputTaskParameters.indexOf(SLASH_DELIMITER, firstIndexOfSlash + 3);
            int thirdIndexOfSlash = this.inputTaskParameters.indexOf(SLASH_DELIMITER, secondIndexOfSlash + 3);
            if (elementType.equals("DataSources")) {
                return this.inputTaskParameters.substring(0, firstIndexOfSlash);
            }
            if (elementType.equals("Catalogs")) {
                return this.inputTaskParameters.substring(firstIndexOfSlash + 3, secondIndexOfSlash);
            }
            if (elementType.equals("Package")) {
                if (secondIndexOfSlash != -1) {
                    return this.inputTaskParameters.substring(firstIndexOfSlash + 3, secondIndexOfSlash);
                }
                return this.inputTaskParameters.substring(firstIndexOfSlash + 3);
            }
            if (thirdIndexOfSlash != -1 && (this.inputTaskParameters.endsWith("\"/\"ESSBASE") || this.inputTaskParameters.endsWith("\"/\"SAPBW") || this.inputTaskParameters.endsWith("\"/\"LOLAP"))) {
                return this.inputTaskParameters.substring(secondIndexOfSlash + 3, thirdIndexOfSlash);
            }
            return this.inputTaskParameters.substring(secondIndexOfSlash + 3, this.inputTaskParameters.length());
        }
        return null;
    }

    public static String xmlEncode(String value) {
        int rsize = value.length() * 4;
        StringBuilder sbuf = new StringBuilder(rsize);
        block7: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '\'': {
                    sbuf.append(APOS);
                    continue block7;
                }
                case '<': {
                    sbuf.append(LT);
                    continue block7;
                }
                case '>': {
                    sbuf.append(GT);
                    continue block7;
                }
                case '&': {
                    sbuf.append(AMP);
                    continue block7;
                }
                case '\"': {
                    sbuf.append(QUOT);
                    continue block7;
                }
                default: {
                    sbuf.append(x);
                }
            }
        }
        return sbuf.toString();
    }

    public static String xmlDecode(String value) {
        StringBuilder sbuf = new StringBuilder(value.length());
        int i = 0;
        while (i < value.length()) {
            char x = value.charAt(i);
            if (x != '&') {
                sbuf.append(x);
                ++i;
                continue;
            }
            if (value.startsWith(APOS, i)) {
                sbuf.append('\'');
                i += APOS.length();
                continue;
            }
            if (value.startsWith(LT, i)) {
                sbuf.append('<');
                i += LT.length();
                continue;
            }
            if (value.startsWith(GT, i)) {
                sbuf.append('>');
                i += GT.length();
                continue;
            }
            if (value.startsWith(AMP, i)) {
                sbuf.append('&');
                i += AMP.length();
                continue;
            }
            if (value.startsWith(QUOT, i)) {
                sbuf.append('\"');
                i += QUOT.length();
                continue;
            }
            sbuf.append('&');
            ++i;
        }
        return sbuf.toString();
    }

    private String formOutputOptionsXml(String type, String outputParams) {
        StringBuilder buff = new StringBuilder();
        buff.append("<options xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"bus:optionArrayProp\">");
        buff.append("<value xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:option[2]\">");
        buff.append("<item xsi:type=\"bus:genericOptionBoolean\">");
        if (type.toLowerCase().indexOf("http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#clearCache") >= 0) {
            buff.append("<name   xsi:type=\"xsd:string\">http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#clearCache</name>");
        } else {
            buff.append("<name      xsi:type=\"xsd:string\">http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#DumpCacheState</name>");
        }
        buff.append("<value xsi:type=\"xsd:boolean\">true</value>");
        buff.append("</item> ");
        buff.append("<item xsi:type=\"bus:genericOptionStringArray\">");
        if (type.toLowerCase().indexOf("http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#clearCache") >= 0) {
            buff.append("<name  xsi:type=\"xsd:string\">http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#clearCacheContext</name>");
        } else {
            buff.append("<name xsi:type=\"xsd:string\">http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#DumpCacheStateContext</name>");
        }
        buff.append("<value xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"xsd:string[1]\">");
        buff.append("<item xsi:type=\"xsd:string\">" + outputParams + "</item>  ");
        buff.append("</value> ");
        buff.append("</item>");
        buff.append("</value>");
        buff.append("</options>");
        return buff.toString();
    }

    private static String getExtendedNodeValue(Node node) {
        String nodeValue = node.getNodeValue();
        if (nodeValue == null) {
            nodeValue = "";
        }
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            String temp = child.getNodeValue();
            if (temp != null) {
                nodeValue = nodeValue + temp;
            }
            if (child.getChildNodes().getLength() <= 0) continue;
            nodeValue = nodeValue + OptionsXMLProcessor.getExtendedNodeValue(nodes.item(i));
        }
        return nodeValue;
    }

    public static void main(String[] args) {
        String input = "&lt;options xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"bus:optionArrayProp\"&gt; &lt;value xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:option[2]\"&gt; &lt;item xsi:type=\"bus:genericOptionBoolean\"&gt;&lt;name xsi:type=\"xsd:string\"&gt;http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#clearCache&lt;/name&gt;&lt;value xsi:type=\"xsd:boolean\"&gt;true&lt;/value&gt;&lt;/item&gt; &lt;item xsi:type=\"bus:genericOptionStringArray\"&gt;&lt;name xsi:type=\"xsd:string\"&gt;http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#clearCacheContext&lt;/name&gt;&lt;value xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"xsd:string[1]\"&gt; &lt;item xsi:type=\"xsd:string\"&gt;A/B/C&lt;/item&gt; &lt;/value&gt; &lt;/item&gt;&lt;/value&gt; &lt;/options&gt;";
        OptionsXMLProcessor options = new OptionsXMLProcessor();
        options.initializeInputOptionsXML(input);
        options.getInputTaskParameters();
        String inputOperation = options.getInputTaskType();
        String inputDs = options.getInputElement("DataSources");
        String inputCtlg = options.getInputElement("Catalogs");
        String inputCube = options.getInputElement("Cubes");
        System.out.println(inputOperation + inputDs + inputCtlg + inputCube);
    }

    public String getDatasourceType() {
        String taskValue = null;
        String type = null;
        String taskName = null;
        boolean taskEnabled = false;
        NodeList nodes = this.xmlDoc.getElementsByTagName(ITEM_ELEMENT);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            Node attribute = attributes.getNamedItem(ITEM_ELEMENT_TYPE);
            if (!attribute.getNodeValue().equals(ITEM_ELEMENT_TYPE_VALUE_BOOL)) continue;
            NodeList childrens = node.getChildNodes();
            for (int j = 0; j < childrens.getLength(); ++j) {
                Node temp = childrens.item(j);
                if (temp.getNodeName().equals(ITEM_ELEMENT_NAME)) {
                    taskName = OptionsXMLProcessor.getExtendedNodeValue(temp);
                }
                if (temp.getNodeName().equals(ITEM_ELEMENT_VALUE)) {
                    taskEnabled = Boolean.parseBoolean(OptionsXMLProcessor.getExtendedNodeValue(temp));
                }
                if (taskName == null || taskName.equals("") || !taskEnabled) continue;
                type = taskName.toLowerCase().indexOf("http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#clearCache".toLowerCase()) >= 0 || taskName.toLowerCase().indexOf("http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#DumpCacheState".toLowerCase()) >= 0 ? ((taskValue = this.getInputTaskParameters()).endsWith("\"/\"DMR") ? "DMR" : (taskValue.endsWith("\"/\"ESSBASE") ? "ESSBASE" : (taskValue.endsWith("\"/\"SAPBW") ? "SAPBW" : "LOLAP"))) : (XqeQSATPage.getFullyQualifiedOMCubeOperation(taskName) != null ? "ROLAP" : "LOLAP");
                if (type == null || type.equals("")) continue;
                return type;
            }
        }
        return type;
    }

    public String[] getROLAPCubes() {
        ArrayList<String> cubeNamesList = new ArrayList<String>();
        NodeList nodes = this.xmlDoc.getElementsByTagName(ITEM_ELEMENT);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            Node attribute = attributes.getNamedItem(ITEM_ELEMENT_TYPE);
            if (!attribute.getNodeValue().equals(ITEM_ELEMENT_TYPE_VALUE_STRARR)) continue;
            NodeList childrens = node.getChildNodes();
            for (int j = 0; j < childrens.getLength(); ++j) {
                Node temp = childrens.item(j);
                if (!temp.getNodeName().equals(ITEM_ELEMENT_VALUE)) continue;
                NodeList grandChildrens = temp.getChildNodes();
                for (int k = 0; k < grandChildrens.getLength(); ++k) {
                    Node probableNode = grandChildrens.item(k);
                    if (!probableNode.getNodeName().equals(ITEM_ELEMENT)) continue;
                    try {
                        cubeNamesList.add(OptionsXMLProcessor.xmlDecode(URLDecoder.decode(OptionsXMLProcessor.getExtendedNodeValue(probableNode), "UTF-8")));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        this.errorLogger.log(e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return cubeNamesList.toArray(new String[0]);
    }

    public String getROLAPDispatcher() {
        NodeList nodes = this.xmlDoc.getElementsByTagName(ITEM_ELEMENT);
        block0: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            Node attribute = attributes.getNamedItem(ITEM_ELEMENT_TYPE);
            if (!attribute.getNodeValue().equals(ITEM_ELEMENT_TYPE_VALUE_CMMONITOROPTIONGUID) && !attribute.getNodeValue().equals(ITEM_ELEMENT_TYPE_VALUE_BUSMONITOROPTIONGUID)) continue;
            NodeList childrens = node.getChildNodes();
            for (int j = 0; j < childrens.getLength(); ++j) {
                Node temp = childrens.item(j);
                if (temp.getNodeName().equals(ITEM_ELEMENT_NAME)) {
                    if (!OptionsXMLProcessor.getExtendedNodeValue(temp).equals("dispatcherID")) continue block0;
                    continue;
                }
                if (!temp.getNodeName().equals(ITEM_ELEMENT_VALUE)) continue;
                return OptionsXMLProcessor.getExtendedNodeValue(temp);
            }
        }
        return null;
    }
}

