/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5QuerySubject;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DescribeDataSourceQueryRequestAdapter
extends RequestAdapter {
    private static final String DESCRIBEDATASOURCEQUERY_ELEMENT_NAME = "describeDataSourceQuery";

    @Override
    public ResponseAdapter executeRequest(RequestEnvironment environment) throws XQEException {
        long startTime = System.currentTimeMillis();
        BIBusEnvelope requestEnvelope = environment.getRequestEnvelope();
        Element v5RootElement = requestEnvelope.getBody().element(DESCRIBEDATASOURCEQUERY_ELEMENT_NAME);
        v5RootElement.detach();
        Document requestDocument = DocumentHelper.createDocument((Element)v5RootElement);
        MetricsService.collectMetricInfo(environment, "requestType", DESCRIBEDATASOURCEQUERY_ELEMENT_NAME);
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        IXQEQueryNode planTree = null;
        boolean success = false;
        try {
            planTree = this.getEngine().describeDataSourceQueryRequest(requestDocument, environment);
            success = true;
            this.logV5Request(v5RootElement, "queriesPlanned", environment.getReportName());
            Document responseDocument = DocumentHelper.createDocument();
            Element responseElement = responseDocument.addElement("response");
            responseEnvelope.getBody().add(responseElement);
            SQLQueryItemList queryItems = null;
            int type = planTree.getType();
            if (type == 101016) {
                queryItems = ((V5SqlQuery)planTree).getQueryItemList();
            }
            if (type == 101074) {
                queryItems = ((V5QuerySubject)planTree).getQueryItemList();
            }
            DescribeDataSourceQueryRequestAdapter.createDescribeDataSourceResponse(requestDocument, queryItems, environment, responseElement);
        }
        catch (UnresolvedParameterException up) {
            throw up;
        }
        catch (Throwable t) {
            this.failQueryReThrowAsXQERTE(environment, v5RootElement, t, "isV5QueryPlanned");
        }
        long time = System.currentTimeMillis() - startTime;
        if (success) {
            MetricsService.collectMetricInfo(environment, "isV5QueryPlanned", "true", time);
        } else {
            MetricsService.collectMetricInfo(environment, "isV5QueryPlanned", "failed", time);
        }
        List attachmentList = Collections.emptyList();
        return new SimpleResponseAdapter(responseEnvelope, attachmentList);
    }

    @Override
    public String getOperationName() {
        return DESCRIBEDATASOURCEQUERY_ELEMENT_NAME;
    }

    @Override
    public void setEngine(QueryEngine newEngine) {
        super.setEngine(newEngine);
    }

    public static void createDescribeDataSourceResponse(Document requestDocument, SQLQueryItemList queryItems, RequestEnvironment environment, Element responseElem) {
        if (queryItems.size() == 0) {
            return;
        }
        Element connectionID = responseElem.addElement("connectionID");
        connectionID.addAttribute("value", "***");
        Element describeDataSourceQueryResult = responseElem.addElement("describeDataSourceQueryResult");
        Element mdProjectedItems = describeDataSourceQueryResult.addElement("mdProjectedItems");
        for (SQLQueryItem queryItem : queryItems) {
            if (queryItem.getName() == null) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_AliasNotFound);
            }
            Element mdProjectedItem = mdProjectedItems.addElement("mdProjectedItem");
            mdProjectedItem.addAttribute("name", queryItem.getName());
        }
        boolean enableQfb = false;
        Element queryFeedback = requestDocument.getRootElement().element("queryFeedback");
        if (queryFeedback != null) {
            Iterator it = CollectionCast.uncheckedCast(queryFeedback.elementIterator("property"));
            while (it.hasNext()) {
                Element propertyElement = (Element)it.next();
                String property = propertyElement.attributeValue("name");
                if (!"columnList".equals(property)) continue;
                enableQfb = true;
            }
        }
        if (enableQfb) {
            Element queryFeedbackResultElem = responseElem.addElement("queryFeedbackResult");
            Element propertyElem = queryFeedbackResultElem.addElement("property");
            Element columnListElem = propertyElem.addElement("columnList");
            for (SQLQueryItem queryItem : queryItems) {
                Element itemElem = columnListElem.addElement("item");
                itemElem.addAttribute("name", queryItem.getName());
                IDataType dt = queryItem.getDataType();
                itemElem.addAttribute("fdt", dt.toString());
                itemElem.addAttribute("sqlName", queryItem.getName());
                itemElem.addAttribute("type", dt.getTypeName());
                itemElem.addAttribute("length", String.valueOf(dt.getLength()));
                itemElem.addAttribute("precision", String.valueOf(dt.getPrecision()));
                itemElem.addAttribute("scale", String.valueOf(dt.getScale()));
                itemElem.addAttribute("nullsAllowed", String.valueOf(queryItem.isNullable()));
            }
        }
    }
}

