/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.ma.XMARequest;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.SecurityContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.util.MetadataHelper;
import com.cognos.xqe.util.IParameterMaps;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.cognos.xqebifw.bibushandler.RSVP4JResponseAdapter;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public class ExecuteMetadataRequestAdapter
extends RequestAdapter {
    private static final String UTF_8 = "UTF-8";
    protected static final String FALSE = "false";
    protected static final String TRUE = "true";
    private IUsageIndicator executionTime;
    protected static final String DATA_SOURCE = "dataSource";
    protected static final String COOKIES = "cookies";

    @Override
    public ResponseAdapter executeRequest(RequestEnvironment reqEnv) throws XQEException, IOException {
        return this.executeRequest(reqEnv, true);
    }

    public void initUsageCount() {
        String name = "maExecutionTime";
        this.executionTime = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.COMPONENT_EXECUTION_TIME, name);
    }

    public void recordApplyTime(long ms) {
        this.executionTime.add(ms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseAdapter executeRequest(RequestEnvironment reqEnv, boolean bAddContentType) throws XQEException, IOException {
        long startTime = System.currentTimeMillis();
        XQELogger pLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Timing", LogLevel.INFO);
        if (pLogger.isOn()) {
            pLogger.log(OperationEnum.START, "Start of preparing metadata request.");
        }
        ZipiContext.setQRDName(ZipiContext.getQRDName());
        ZipiBridge.setObjPath(ZipiContext.getQRDName());
        QueryEngine qEngine = this.getEngine();
        BIBusEnvelope requestEnvelope = reqEnv.getRequestEnvelope();
        Element v5RootElement = requestEnvelope.getBody().element("Metadata").createCopy();
        Element maRootElement = requestEnvelope.getBody().element("Metadata");
        maRootElement.detach();
        Document requestDocument = DocumentHelper.createDocument((Element)maRootElement);
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        MultiRequestContext multiRequestContext = qEngine.configureMultiRequestContext(reqEnv, requestDocument);
        multiRequestContext.incrementRefCount();
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        List attachmentList = Collections.emptyList();
        boolean bCacheMAResult = QueryEngine.getInstance().getCacheManager().cacheMAQueryResult();
        long modelModificationTime = 0L;
        String maQueryKey = null;
        SecurityContext securityContext = null;
        Element documentRootElem = null;
        byte[] byteResult = null;
        try {
            ROLAPContext.queryEnter(executionEnvironment);
            try {
                Object modelPath;
                Parameters parameters = reqEnv.getRequestParameters();
                Element parametersElement = requestDocument.getRootElement().element("parameters");
                if (parametersElement != null) {
                    parameters.prepare(parametersElement, null);
                }
                String elementName = null;
                if (bCacheMAResult) {
                    elementName = MetadataHelper.getMAQueryTypeForCaching(maRootElement);
                }
                if (bAddContentType && elementName != null) {
                    String passport = ((RequestEnvironment)executionEnvironment.getRequestEnvironment()).getCAMPassport();
                    Element connectionElem = executionEnvironment.getConnectionElement();
                    Element dataSourceElem = connectionElem.element(DATA_SOURCE);
                    modelPath = dataSourceElem.attributeValue("value");
                    MetadataConnection metadataConnection = MetadataService.getInstance().getConnection("MFW4J", (String)modelPath, executionEnvironment, true);
                    List<IModelDataSource> dataSources = metadataConnection.getModelDataSources();
                    bCacheMAResult = MetadataHelper.isMACacheSupported(dataSources, executionEnvironment);
                    if (bCacheMAResult) {
                        byte[] cachedMAResult;
                        ArrayList<IDataSource> ds = new ArrayList<IDataSource>();
                        ds.addAll(executionEnvironment.getDataSources());
                        securityContext = new SecurityContext(reqEnv, metadataConnection, ds, executionEnvironment.getGovernors());
                        maQueryKey = (String)modelPath + maRootElement.element(elementName).asXML();
                        modelModificationTime = metadataConnection.getModelModificationTime(passport, requestEnvelope);
                        TreeSet<String> allCookieNames = null;
                        IParameterMaps cookies = reqEnv.getOrCreateCookieMap();
                        if (cookies != null) {
                            Map<String, String> mapContent = cookies.getAllEntries(COOKIES);
                            allCookieNames = new TreeSet<String>(mapContent.keySet());
                        }
                        if ((cachedMAResult = QueryEngine.getInstance().getCacheManager().getMAResult(maQueryKey, securityContext, allCookieNames, modelModificationTime)) != null) {
                            ByteArrayInputStream resultStream = new ByteArrayInputStream(cachedMAResult);
                            attachmentList = new ArrayList(1);
                            attachmentList.add(resultStream);
                            pLogger.log("Cached metadata result is returned.");
                            SimpleResponseAdapter simpleResponseAdapter = new SimpleResponseAdapter(responseEnvelope, attachmentList);
                            return simpleResponseAdapter;
                        }
                    }
                } else {
                    bCacheMAResult = false;
                }
                IXQEQueryNode planTree = null;
                try {
                    planTree = qEngine.prepareMetadataRequest(requestDocument, reqEnv);
                    this.logV5Request(v5RootElement, "queriesPlanned", reqEnv.getReportName());
                }
                catch (DataSourceException e) {
                    throw e;
                }
                catch (Throwable t) {
                    this.failQueryReThrowAsXQERTE(reqEnv, v5RootElement, t, "");
                }
                long time = System.currentTimeMillis() - startTime;
                MetricsService.collectMetricInfo(reqEnv, "isV5QueryPlanned", TRUE, time);
                if (pLogger.isOn()) {
                    pLogger.log(OperationEnum.END, "End of preparing metadata request.");
                }
                startTime = System.currentTimeMillis();
                if (pLogger.isOn()) {
                    pLogger.log(OperationEnum.START, "Start of executing metadata request.");
                }
                if (null == planTree) {
                    modelPath = new SimpleResponseAdapter(responseEnvelope, attachmentList);
                    return modelPath;
                }
                XQETrace trace = new XQETrace();
                QueryEngineLoggingUtils.addExecutionTraceLevels(trace, reqEnv);
                executionEnvironment.setTrace(trace);
                String infoValue = FALSE;
                try {
                    XMARequest xMARequest = (XMARequest)planTree.getChild(0);
                    xMARequest.getPlanningEnvironment().setPlanningActive(reqEnv);
                    boolean needToRemoveCubeName = false;
                    try {
                        String cmDataSourceName = ROLAPContext.getCMDataSourceName(xMARequest.getPlanningEnvironment());
                        if (cmDataSourceName != null) {
                            needToRemoveCubeName = ROLAPContext.setCurrentCubeName(cmDataSourceName);
                        }
                        int reTry = 1;
                        int attemptToFixOLAPMemberRules = 0;
                        while (reTry == 1 && attemptToFixOLAPMemberRules < 2) {
                            reTry = 0;
                            XDataContext dataContext = executionEnvironment.pushDataContext();
                            try {
                                this.initUsageCount();
                                long runTime = System.currentTimeMillis();
                                XmlValue response = (XmlValue)xMARequest.execute(dataContext);
                                this.recordApplyTime(System.currentTimeMillis() - runTime);
                                QueryEngineLoggingUtils.dumpRuntreeLog(executionEnvironment, xMARequest);
                                QueryEngineLoggingUtils.dumpExecutionLog(executionEnvironment, xMARequest, response);
                                documentRootElem = (Element)response.getNode();
                                if (bAddContentType) {
                                    byteResult = ExecuteMetadataRequestAdapter.generateMetadataResponse(documentRootElem, bAddContentType && !reqEnv.getRSVP4J());
                                    if (byteResult != null) {
                                        IParameterMaps cookies;
                                        if (bCacheMAResult && (cookies = reqEnv.getOrCreateCookieMap()) != null) {
                                            Map<String, String> mapContent = cookies.getAllEntries(COOKIES);
                                            TreeSet<String> allCookieNames = new TreeSet<String>(mapContent.keySet());
                                            QueryEngine.getInstance().getCacheManager().storeMAResult(maQueryKey, securityContext, allCookieNames, modelModificationTime, byteResult);
                                        }
                                        ByteArrayInputStream resultStream = new ByteArrayInputStream(byteResult);
                                        attachmentList = new ArrayList(1);
                                        attachmentList.add(resultStream);
                                    }
                                } else {
                                    responseEnvelope.getBody().add(documentRootElem);
                                }
                                infoValue = TRUE;
                            }
                            catch (LogonFailureException ex) {
                                throw ex;
                            }
                            catch (XQERuntimeException xre) {
                                int[] stateVars = new int[]{reTry, attemptToFixOLAPMemberRules};
                                stateVars = RSAPIDataset.handleAttemptToFixOLAPMemberRules(xMARequest, xre, stateVars);
                                reTry = stateVars[0];
                                attemptToFixOLAPMemberRules = stateVars[1];
                            }
                            finally {
                                xMARequest.getPlanningEnvironment().setPlanningInactive();
                                executionEnvironment.popDataContext(dataContext);
                            }
                        }
                    }
                    finally {
                        ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
                    }
                }
                finally {
                    time = System.currentTimeMillis() - startTime;
                    MetricsService.collectMetricInfo(reqEnv, "isV5QueryExecuted", infoValue, time);
                    if (pLogger.isOn()) {
                        pLogger.log(OperationEnum.END, "End of executing metadata request.");
                    }
                }
            }
            finally {
                ROLAPContext.queryExit(executionEnvironment);
            }
        }
        finally {
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
        if (!reqEnv.getRSVP4J()) return new SimpleResponseAdapter(responseEnvelope, attachmentList);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(byteResult);
        return new RSVP4JResponseAdapter(responseEnvelope, list);
    }

    @Override
    public String getOperationName() {
        return "Metadata";
    }

    @Override
    public void setEngine(QueryEngine newEngine) {
        super.setEngine(newEngine);
    }

    static InputStream generateMetadataResponse(Element metadataResponseElement, RequestEnvironment environment, boolean bAddContentType) throws IOException {
        return new ByteArrayInputStream(ExecuteMetadataRequestAdapter.generateMetadataResponse(metadataResponseElement, bAddContentType));
    }

    static byte[] generateMetadataResponse(Element metadataResponseElement, boolean bAddContentType) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, UTF_8));
        if (bAddContentType) {
            writer.write("Content-Type: text/xml; charset=utf-8\r\n\r\n");
        }
        XMLWriter xmlWriter = new XMLWriter((Writer)writer);
        xmlWriter.write(metadataResponseElement);
        ((Writer)writer).flush();
        ((Writer)writer).close();
        return baos.toByteArray();
    }
}

