/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.exception.ISOAPFault;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.provider.IMetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQueryResultIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDataMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchyMemberLoader;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPProvider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryResultIteratorFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.DummyVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCubeDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SOAPFaultResponseAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import java.io.IOException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocumentFactory;

public class FMRequestAdapter
extends RequestAdapter {
    private static final String ALL_LEVEL_NAME_TAG = "allLevelName";
    private static final String LOCALE_ATTR = "locale";
    private static final String LINE_SEPARATOR = "line.separator";
    public static final String START_ROOT_TAG = "<root>";
    public static final String END_ROOT_TAG = "</root>";
    private static final String BLANK_FILLER_NAME = ".[]";
    public static final String BLANK = "";
    private static final String START_KEY_TAG = "<key>";
    private static final String END_KEY_TAG = "</key>";
    private static final int DEFAULT_RANGE = 100;
    private static final String TRUE = "true";
    private static final String QUERY_NAME = "FMRequestMemberQuery";
    public static final String DEFAULT_RUN_LOCALE = "en-us";
    public static final String MODELDEFAULTLOCALE = "modelDefaultLocale";
    public static final String PRODUCTLOCALE = "productLocale";
    public static final String RUNLOCALE = "runLocale";
    public static final String CONTENTLOCALE = "contentLocale";
    public static final String ROLAP_FM_SOAP_OP_NAME = "ROLAPFMRequests";
    public static final String VALIDATE_ELEMENT_NAME = "validateV5";
    public static final String ROLAP_GET_MEMBERS_ELEMENT_NAME = "rolapGetMembers";
    public static final String VALIDATE_RESPONSE_ELEMENT_NAME = "validateV5Response";
    public static final String STANDALONE_EXPRESSION_ELEMENT_NAME = "standaloneExpression";
    public static final String ROLAP_GET_MEMBERS_RESPONSE_ELEMENT_NAME = "rolapGetMembersResponse";
    public static final String ROLAP_MEMBERS_ELEMENT_NAME = "members";
    public static final String WARNING_ELEMENT_NAME = "warning";
    public static final String ERROR_ELEMENT_NAME = "error";
    public static final String START_NAME = "start";
    public static final String COUNT_NAME = "count";
    public static final String TOTAL_NAME = "total";
    public static final String ID_ATTRIBUTE_NAME = "id";
    public static final String HAS_ERROR_ATTRIBUTE_NAME = "hasError";
    public static final String EXCPETION_ELEMENT_NAME = "exception";
    public static final String MEMBER_ELEMENT_NAME = "member";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String UNIQUE_NAME_ELEMENT_NAME = "uniqueName";
    public static final String CAPTION_ELEMENT_NAME = "caption";
    public static final String LEVEL_KEYS_ELEMENT_NAME = "levelKeys";
    public static final String KEY_ELEMENT_NAME = "key";
    public static final String RELMODELPATH_ELEMENT_NAME = "relModelPath";
    public static final String ROLAPMODEL_ELEMENT_NAME = "rolapModel";
    public static final String QUERY_HIERARCHY_ROOTS_ELEMENT_NAME = "queryHierarchyRoots";
    public static final String QUERY_CHILDREN_ELEMENT_NAME = "queryChildren";
    public static final String CUBE_ELEMENT_NAME = "cube";
    public static final String DIM_NAME = "dimension";
    public static final String HIER_NAME = "hierarchy";
    public static final String RANGE_ELEMENT_NAME = "range";
    public static final String EXPRESSION_LOCALE_ATTRIBUTE_NAME = "expressionLocale";
    public static final String HAS_ALL_LEVEL_ATTRIBUTE_NAME = "hasAllLevel";
    public static final String YES = "yes";
    public static final String ALL_MEMBER_NAME_ATTRIBUTE_NAME = "allMemberName";
    public static final String LEVEL_REF_ELEMENT_NAME = "levelRef";
    public static final String LEVEL_KEY_REF_ELEMENT_NAME = "levelKeyRef";
    public static final String RELATEDATTRIBUTEREF_ELEMENT_NAME = "relatedAttributeRef";
    public static final String DEFAULTATTRIBUTEREF_ELEMENT_NAME = "defaultAttributeRef";
    public static final String ORDERATTRIBUTEREF_ELEMENT_NAME = "orderAttributeRef";
    public static final String CAPTIONATTRIBUTEREF_ELEMENT_NAME = "captionAttributeRef";
    public static final String DESCRIPTIONATTRIBUTEREF_ELEMENT_NAME = "descriptionAttributeRef";
    public static final String ATTRIBUTE_ELEMENT_NAME = "attribute";
    public static final String REFOBJECT_ATTRIBUTE_NAME = "refObject";
    public static final String QUERY_ITEM_ELEMENT_NAME = "queryItem";
    public static final String ORDER_ATTRIBUTE_NAME = "order";
    public static final String CS_COMPATIBLE_ELEMENT_NAME = "cubingServicesCompatible";
    public static final String LEVEL_ELEMENT_NAME = "level";
    public static final String MUN_ELEMENT_NAME = "mun";
    public static final String MODELITEM_ELEMENT_NAME = "modelItem";
    public static final String PATH_ELEMENT_NAME = "path";
    public static final String FILLERDATAMEMBERCAPTION_TYPE = "fillerDataMemberCaptionType";
    public static final String PARENT = "parent";
    public static final String EXPRESSIONS = "expressions";
    public static final String DEPLOYMENT_ATTR_NAME = "deployment";
    public static final String RECURSIVE = "recursive";
    public static final String SHOWMEMBERS_ATTR_NAME = "showMembers";
    private static final int PC_MEMBER_KEY_IDX = 1;
    public static final String CALCULATEDMEMBER_ELEMENT_NAME = "calculatedMember";
    public static final String CALC_MEM_KEY = "CALC_MEM";
    private static final String ALLMEMBERCAPTION_TAG = "allMemberCaption";
    private static final String VIRTUALCUBE = "virtualCube";
    public static final String VIRTUAL_MEM_KEY = "VIRTUAL_MEM";
    public static final String TIME_ATTRIBUTE_VALUE = "time";
    public static final String RELATIVE_TIME_MEM_KEY = "RELATIVE_TIME_MEM";
    public static final String RELATIVE_TIME_CURRENT_PERIOD_KEY = "RELATIVE_TIME_MEM_CURRENT_PERIOD";
    public static final String RELATIVE_TIME_PRIOR_PERIOD_KEY = "RELATIVE_TIME_MEM_PRIOR_PERIOD";
    public static final String RELATIVE_TIME_NEXT_PERIOD_KEY = "RELATIVE_TIME_MEM_NEXT_PERIOD";
    public static final String RELATIVE_TIME_PERIOD_TO_DATE_KEY = "RELATIVE_TIME_MEM_PERIOD_TO_DATE";
    public static final String RELATIVE_TIME_PERIOD_TO_DATE_LAST_CHILD_KEY = "RELATIVE_TIME_MEM_PERIOD_TO_DATE_LAST_CHILD";
    public static final String RELATIVE_TIME_PRIOR_PERIOD_TO_DATE_KEY = "RELATIVE_TIME_MEM_PRIOR_PERIOD_TO_DATE";
    public static final String RELATIVE_TIME_NEXT_PERIOD_TO_DATE_KEY = "RELATIVE_TIME_MEM_NEXT_PERIOD_TO_DATE";
    public static final String RELATIVE_TIME_PERIOD_TO_DATE_CHANGE_KEY = "RELATIVE_TIME_MEM_PERIOD_TO_DATE_CHANGE";
    public static final String RELATIVE_TIME_PERIOD_TO_DATE_GROWTH_KEY = "RELATIVE_TIME_MEM_PERIOD_TO_DATE_GROWTH";
    public static final String RELATIVE_TIME_NEXT_PERIOD_TO_DATE_CHANGE_KEY = "RELATIVE_TIME_MEM_NEXT_PERIOD_TO_DATE_CHANGE";
    public static final String RELATIVE_TIME_NEXT_PERIOD_TO_DATE_GROWTH_KEY = "RELATIVE_TIME_MEM_NEXT_PERIOD_TO_DATE_GROWTH";
    public static final String RELATIVE_TIME_PERIOD_CHILD_REF_KEY = "RELATIVE_TIME_MEM_PERIOD_CHILD_REF";
    public static final String RELATIVE_TIME_CUSTOM_SIMPLE = "RELATIVE_TIME_MEM_CUSTOM_SIMPLE";
    public static final String RELATIVE_TIME_CUSTOM_PERIOD_TO_DATE = "RELATIVE_TIME_MEM_CUSTOM_PERIOD_TO_DATE";
    public static final String RELATIVE_TIME_CUSTOM_ROLLING_TOTAL = "RELATIVE_TIME_MEM_CUSTOM_ROLLING_TOTAL";
    public static final String HASRELATIVETIMEMEMBERS_ATTRIBUTE_NAME = "hasRelativeTimeMembers";
    public static final String CURRENTPERIODEXPRESSION_ELEMENT_NAME = "currentPeriodExpression";
    public static final String SHOWRELATIVETIMEPRIORPERIODMEMBERS_ATTRIBUTE_NAME = "showRelativeTimePriorPeriodMembers";
    public static final String SHOWRELATIVETIMENEXTPERIODMEMBERS_ATTRIBUTE_NAME = "showRelativeTimeNextPeriodMembers";
    public static final String SHOWRELATIVETIMESUBTREEMEMBERS_ATTRIBUTE_NAME = "showRelativeTimeSubtreeMembers";
    public static final String CUSTOM_SIMPLE_RELATIVE_TIME_MEMBER = "customSimpleRelativeTimeMember";
    public static final String CUSTOM_PTD_RELATIVE_TIME_MEMBER = "customPTDRelativeTimeMember";
    public static final String CUSTOM_ROLLIN_TOTAL_RELATIVE_TIME_MEMBER = "customRollingTotalRelativeTimeMember";
    public static final String TODATE_PERIOD = "todatePeriod";
    public static final String TARGET_PERIOD = "targetPeriod";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAdapter executeRequest(RequestEnvironment reqEnv) throws XQEException, IOException {
        Operation op = Operation.NONE;
        BIBusEnvelope requestEnvelope = reqEnv.getRequestEnvelope();
        Element v5RootElement = requestEnvelope.getBody().element(ROLAP_GET_MEMBERS_ELEMENT_NAME);
        if (v5RootElement != null) {
            op = Operation.GETMEMBERS;
        } else {
            v5RootElement = requestEnvelope.getBody().element(VALIDATE_ELEMENT_NAME);
            if (v5RootElement != null) {
                op = Operation.VALIDATEV5;
            }
        }
        if (v5RootElement != null) {
            v5RootElement.detach();
            Document requestDocument = DocumentHelper.createDocument((Element)v5RootElement);
            if (null == reqEnv.getSessionContextID()) {
                reqEnv.setSessionContextID(new UID().toString());
            }
            ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
            ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
            MultiRequestContext multiRequestContext = QueryEngine.getInstance().configureMultiRequestContext(reqEnv, requestDocument);
            multiRequestContext.incrementRefCount();
            PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
            try {
                List<MemberInfo> memberInfoList = null;
                List<ExpressionInfo> validatedExpressionList = null;
                int[] range = new int[]{0, 100, -1};
                reqEnv.extractParametersFromCommand(requestEnvelope, v5RootElement);
                try {
                    if (op == Operation.GETMEMBERS) {
                        RequestLocales requestLocales = new RequestLocales(reqEnv, v5RootElement);
                        memberInfoList = this.getMemberInfo(v5RootElement, range, executionEnvironment, planEnv, requestLocales);
                    } else if (op == Operation.VALIDATEV5) {
                        validatedExpressionList = this.getValidateExpressions(v5RootElement, planEnv);
                    }
                }
                catch (Throwable throwable) {
                    SOAPFaultResponseAdapter soapFault;
                    SOAPFaultResponseAdapter sOAPFaultResponseAdapter = soapFault = this.buildSoapFaultResponseAdapter(throwable);
                    multiRequestContext.decrementRefCount();
                    executionEnvironmentContext.exit();
                    return sOAPFaultResponseAdapter;
                }
                BIBusEnvelope responseEnvelope = new BIBusEnvelope();
                List attachmentList = null;
                responseEnvelope.setBIBusHeader((Element)requestEnvelope.getBIBusHeader().detach());
                if (op == Operation.GETMEMBERS) {
                    Element getMembersResponseElement = DOMDocumentFactory.getInstance().createElement(ROLAP_GET_MEMBERS_RESPONSE_ELEMENT_NAME);
                    Element membersElement = DOMDocumentFactory.getInstance().createElement(ROLAP_MEMBERS_ELEMENT_NAME);
                    Element startElement = DOMDocumentFactory.getInstance().createElement(START_NAME);
                    startElement.setText(String.valueOf(range[0]));
                    Element countElement = DOMDocumentFactory.getInstance().createElement(COUNT_NAME);
                    int total = range[2];
                    if (memberInfoList != null) {
                        countElement.setText(String.valueOf(memberInfoList.size()));
                        if (total < 0) {
                            total = memberInfoList.size();
                        }
                    } else {
                        countElement.setText("0");
                        if (total < 0) {
                            total = 0;
                        }
                    }
                    Element totalElement = DOMDocumentFactory.getInstance().createElement(TOTAL_NAME);
                    totalElement.setText(String.valueOf(total));
                    membersElement.add(startElement);
                    membersElement.add(countElement);
                    membersElement.add(totalElement);
                    if (memberInfoList != null) {
                        for (MemberInfo memberInfo : memberInfoList) {
                            Element memberInfoElement = this.generateMemberInfoElement(memberInfo);
                            membersElement.add(memberInfoElement);
                        }
                    }
                    getMembersResponseElement.add(membersElement);
                    responseEnvelope.getBody().add(getMembersResponseElement);
                } else if (op == Operation.VALIDATEV5) {
                    Element validateResponseElement = DOMDocumentFactory.getInstance().createElement(VALIDATE_RESPONSE_ELEMENT_NAME);
                    for (ExpressionInfo expressionInfo : validatedExpressionList) {
                        Element standaloneExpressionElement = this.generateStandaloneExpressionElement(expressionInfo);
                        validateResponseElement.add(standaloneExpressionElement);
                    }
                    responseEnvelope.getBody().add(validateResponseElement);
                }
                attachmentList = Collections.EMPTY_LIST;
                SimpleResponseAdapter simpleResponseAdapter = new SimpleResponseAdapter(responseEnvelope, attachmentList);
                return simpleResponseAdapter;
            }
            finally {
                multiRequestContext.decrementRefCount();
                executionEnvironmentContext.exit();
            }
        }
        return NULL_RESPONSE_ADAPTER;
    }

    private SOAPFaultResponseAdapter buildSoapFaultResponseAdapter(Throwable throwable) {
        StackTraceElement[] stes = throwable.getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append("Exception msg: " + throwable.getMessage());
        sb.append(System.getProperty(LINE_SEPARATOR));
        for (int index = 0; index < stes.length; ++index) {
            sb.append(stes[index].toString());
            sb.append(System.getProperty(LINE_SEPARATOR));
        }
        String msg = sb.toString();
        XQEDebugLog.out.println(msg);
        ROLAPLog.logError("ROLAPCubes.FMAPI", msg, throwable);
        ISOAPFault iSOAPFault = throwable instanceof ISOAPFault ? (ISOAPFault)((Object)throwable) : new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, throwable);
        Fault fault = iSOAPFault.getFault();
        return new SOAPFaultResponseAdapter(fault, false);
    }

    private Element generateStandaloneExpressionElement(ExpressionInfo expressionInfo) {
        Element standaloneResponseElement = DOMDocumentFactory.getInstance().createElement(STANDALONE_EXPRESSION_ELEMENT_NAME);
        String id = expressionInfo.getId();
        if (id != null) {
            standaloneResponseElement.addAttribute(ID_ATTRIBUTE_NAME, id);
        }
        boolean hasError = expressionInfo.isHasError();
        standaloneResponseElement.addAttribute(HAS_ERROR_ATTRIBUTE_NAME, String.valueOf(hasError));
        if (hasError) {
            Element errorResponseElement = DOMDocumentFactory.getInstance().createElement(ERROR_ELEMENT_NAME);
            errorResponseElement.setText(expressionInfo.getMessage());
            standaloneResponseElement.add(errorResponseElement);
        }
        return standaloneResponseElement;
    }

    public Element generateMemberInfoElement(MemberInfo memberInfo) {
        Element memberResponseElement = DOMDocumentFactory.getInstance().createElement(MEMBER_ELEMENT_NAME);
        Element nameElement = DOMDocumentFactory.getInstance().createElement(NAME);
        nameElement.addText(memberInfo.getName());
        memberResponseElement.add(nameElement);
        Element captionElement = DOMDocumentFactory.getInstance().createElement(CAPTION_ELEMENT_NAME);
        captionElement.addText(memberInfo.getCaption());
        memberResponseElement.add(captionElement);
        Element munElement = DOMDocumentFactory.getInstance().createElement(MUN_ELEMENT_NAME);
        Element firstModelItem = DOMDocumentFactory.getInstance().createElement(MODELITEM_ELEMENT_NAME);
        firstModelItem.addText(UniqueNameGenerator.createUniqueName(memberInfo.getFirstModelItem()));
        munElement.add(firstModelItem);
        munElement.addText("->:[");
        munElement.addText("RO");
        munElement.addText("].");
        Element secondModelItem = DOMDocumentFactory.getInstance().createElement(MODELITEM_ELEMENT_NAME);
        secondModelItem.addText(UniqueNameGenerator.createUniqueName(memberInfo.getSecondModelItem()));
        munElement.add(secondModelItem);
        munElement.addText(".");
        Element path = DOMDocumentFactory.getInstance().createElement(PATH_ELEMENT_NAME);
        path.addText(memberInfo.getPath());
        munElement.add(path);
        memberResponseElement.add(munElement);
        Element levelKeyElement = DOMDocumentFactory.getInstance().createElement(LEVEL_KEYS_ELEMENT_NAME);
        IValue[] levelKeys = memberInfo.getLevelKeys().getKeyValues();
        if (levelKeys != null) {
            StringBuilder sb = new StringBuilder();
            for (IValue key : levelKeys) {
                sb.append(START_KEY_TAG);
                if (!key.isNull()) {
                    sb.append(StringEscapeUtils.escapeXml((String)key.toString()));
                } else {
                    sb.append(BLANK);
                }
                sb.append(END_KEY_TAG);
            }
            levelKeyElement.addText(sb.toString());
        }
        memberResponseElement.add(levelKeyElement);
        return memberResponseElement;
    }

    private List<MemberInfo> getMemberInfo(Element operationElement, int[] range, ExecutionEnvironment execEnv, PlanningEnvironment planEnv, RequestLocales requestLocales) throws Exception {
        Element relModelPathElement = operationElement.element(RELMODELPATH_ELEMENT_NAME);
        String relModelPath = relModelPathElement.getText();
        Element rolapModelElement = operationElement.element(ROLAPMODEL_ELEMENT_NAME);
        Element queryOperationElement = operationElement.element(QUERY_HIERARCHY_ROOTS_ELEMENT_NAME);
        if (queryOperationElement != null) {
            return this.getHierarchyRoots(queryOperationElement, relModelPath, rolapModelElement, execEnv, planEnv, requestLocales);
        }
        queryOperationElement = operationElement.element(QUERY_CHILDREN_ELEMENT_NAME);
        Element rangeElement = queryOperationElement.element(RANGE_ELEMENT_NAME);
        if (rangeElement != null) {
            int start = Integer.valueOf(rangeElement.attributeValue(START_NAME));
            int count = Integer.valueOf(rangeElement.attributeValue(COUNT_NAME));
            range[0] = start;
            range[1] = count;
        }
        if (this.isVirtualCube(rolapModelElement)) {
            return this.getChildrenVirtual(queryOperationElement, rolapModelElement, requestLocales, range);
        }
        Element hierNameElement = queryOperationElement.element(HIER_NAME);
        String hierName = hierNameElement.getText();
        Element hierElement = this.getHierarchyElement(rolapModelElement, hierName);
        boolean isRecursiveHierarchy = this.isRecursiveHierarchy(hierElement);
        if (isRecursiveHierarchy) {
            return this.getChildrenRecursive(queryOperationElement, relModelPath, rolapModelElement, hierElement, range, execEnv, planEnv);
        }
        return this.getChildrenStandard(queryOperationElement, relModelPath, rolapModelElement, hierElement, range, planEnv, requestLocales);
    }

    private List<MemberInfo> getChildrenVirtual(Element queryOperationElement, Element rolapModelElement, RequestLocales requestLocales, int[] range) throws Exception {
        Element dimNameElement = queryOperationElement.element(DIM_NAME);
        String dimName = dimNameElement.getText();
        Element hierNameElement = queryOperationElement.element(HIER_NAME);
        String hierName = hierNameElement.getText();
        ROLAPVirtualCubeModel model = new ROLAPVirtualCubeModel(dimName, rolapModelElement, requestLocales);
        Element munElement = queryOperationElement.element(MUN_ELEMENT_NAME);
        String levelNameFromMUN = this.getLevelName(munElement);
        String parentMemberName = this.getParentPath(munElement);
        String modelPath = this.getSecondModelItem(munElement);
        String memberUniqueName = UniqueNameGenerator.join(modelPath, parentMemberName);
        ArrayList<Member> children = model.getChildrenMembers(memberUniqueName, hierName, levelNameFromMUN);
        ArrayList<MemberInfo> childList = new ArrayList<MemberInfo>();
        for (Member childMember : children) {
            childList.add(new MemberInfo(childMember));
        }
        return this.getChildrenWithinRange(range, childList);
    }

    private String getSecondModelItem(Element munElement) {
        List modelInfoElements = munElement.elements(MODELITEM_ELEMENT_NAME);
        return ((Element)modelInfoElements.get(1)).getText();
    }

    private String getModelDefaultLocale(Element queryOperationElement) {
        Element modelDefaultLocaleElement = queryOperationElement.element(MODELDEFAULTLOCALE);
        if (modelDefaultLocaleElement != null) {
            return modelDefaultLocaleElement.getText();
        }
        return queryOperationElement.element(PRODUCTLOCALE).getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MemberInfo> getChildrenRecursive(Element queryOperationElement, String relModelPath, Element rolapModelElement, Element hierElement, int[] range, ExecutionEnvironment execEnv, PlanningEnvironment planEnv) throws Exception {
        RSAPIDataset dataset;
        ArrayList<MemberInfo> children = new ArrayList();
        Element dimNameElement = queryOperationElement.element(DIM_NAME);
        String dimName = dimNameElement.getText();
        Element hierNameElement = queryOperationElement.element(HIER_NAME);
        String hierName = hierNameElement.getText();
        boolean isCubingServicesCompatible = this.isCubingServicesCompatible(queryOperationElement);
        boolean isFillerInheritsCaptionFromParent = this.isFillerInheritsCaptionFromParent(hierElement);
        boolean isShowDataMember = this.isShowDataMember(hierElement);
        Element munElement = queryOperationElement.element(MUN_ELEMENT_NAME);
        String parentPath = this.getParentPath(munElement);
        Element levelKeysElement = queryOperationElement.element(LEVEL_KEYS_ELEMENT_NAME);
        String levelKeysTxt = levelKeysElement.getText();
        String[] keys = null;
        if (levelKeysTxt != null && levelKeysTxt.length() > 0) {
            Document doc = DocumentHelper.parseText((String)(START_ROOT_TAG + levelKeysTxt + END_ROOT_TAG));
            List keyElements = doc.getRootElement().elements(KEY_ELEMENT_NAME);
            keys = new String[1];
            String levelKey = ((Element)keyElements.get(keyElements.size() - 1)).getText();
            if (levelKey.contains("?data")) {
                return new ArrayList<MemberInfo>();
            }
            if (levelKey.contains(CALC_MEM_KEY)) {
                return children;
            }
            keys[0] = levelKey;
        }
        if (keys == null) {
            children = this.getTopLevelMembersFromV5Query(relModelPath, queryOperationElement, rolapModelElement, execEnv, planEnv, isCubingServicesCompatible, parentPath);
            this.addCalculatedMembers(hierElement, dimName, hierName, parentPath, isCubingServicesCompatible, children);
            this.setModelInfo(dimName, hierName, null, isCubingServicesCompatible, children);
            return children;
        }
        planEnv.setMetdataConnection(this.getMetadataConnection(relModelPath, execEnv));
        ArrayList<SelectAttribute> selectAttributes = new ArrayList<SelectAttribute>();
        ArrayList<SortAttribute> sortAttributes = new ArrayList<SortAttribute>();
        Element dimensionElement = rolapModelElement.element(DIM_NAME);
        Map<String, SelectAttribute> attributesMap = this.createSelectAttributeMap(dimensionElement.elements(ATTRIBUTE_ELEMENT_NAME));
        LevelInfo[] levelInfos = this.getParentChildAttributes(dimensionElement, hierElement, attributesMap, selectAttributes, sortAttributes);
        String[] queryItems = null;
        String parentName = null;
        if (isShowDataMember && isFillerInheritsCaptionFromParent) {
            parentName = this.getParentName(planEnv, execEnv, relModelPath, selectAttributes, sortAttributes, levelInfos[1], keys);
        }
        if ((dataset = this.createV5QueryandGetDataset(relModelPath, planEnv, keys, selectAttributes, sortAttributes, queryItems = levelInfos[0].getLevelQueryItems())) != null) {
            try (IROLAPQueryResultIterator resultIterator = ROLAPQueryResultIteratorFactory.getIterator(dataset, execEnv);){
                String[] parentInfo = new String[]{parentPath, parentName};
                children = this.getRecursiveChildrenMemberNames(resultIterator, parentInfo, isCubingServicesCompatible, isShowDataMember, isFillerInheritsCaptionFromParent, keys[0], levelInfos[1]);
            }
            this.addCalculatedMembers(hierElement, dimName, hierName, parentPath, isCubingServicesCompatible, children);
            this.setModelInfo(dimName, hierName, null, isCubingServicesCompatible, children);
        }
        return this.getChildrenWithinRange(range, children);
    }

    private RSAPIDataset createV5QueryandGetDataset(String relModelPath, PlanningEnvironment planEnv, String[] keys, List<SelectAttribute> selectAttributes, List<SortAttribute> sortAttributes, String[] queryItems) {
        V5QuerySet querySet = this.createV5QuerySet(planEnv, relModelPath, selectAttributes, sortAttributes, queryItems, keys);
        ROLAPContext.setRelQueryExecuting();
        PlannedV5QuerySet plannedQuerySet = QueryPlanner.getInstance().planQuery(querySet, planEnv);
        RSAPIDataset dataset = ROLAPMemberQuery.getDataset(QUERY_NAME, plannedQuerySet);
        return dataset;
    }

    private List<MemberInfo> getChildrenWithinRange(int[] range, List<MemberInfo> children) {
        range[2] = children.size();
        if (range[0] >= 0 && range[0] < children.size() && children.size() > range[1] + range[0]) {
            return children.subList(range[0], range[0] + range[1]);
        }
        if (range[0] >= 0 && range[0] < children.size() && children.size() < range[1] + range[0]) {
            return children.subList(range[0], children.size());
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getParentName(PlanningEnvironment planEnv, ExecutionEnvironment execEnv, String relModelPath, List<SelectAttribute> selectAttributes, List<SortAttribute> sortAttributes, LevelInfo childLevelInfo, String[] keys) {
        RSAPIDataset dataset = this.createV5QueryandGetDataset(relModelPath, planEnv, keys, selectAttributes, sortAttributes, childLevelInfo.getLevelQueryItems());
        if (dataset != null) {
            IROLAPQueryResultIterator resultIterator = ROLAPQueryResultIteratorFactory.getIterator(dataset, execEnv);
            try {
                if (resultIterator.hasNext()) {
                    IValue[] values = resultIterator.next().getColumns();
                    String string = values[childLevelInfo.getCaptionColumnIndex()].toString();
                    return string;
                }
            }
            finally {
                resultIterator.close();
                planEnv.setPlanningActive(execEnv.getRequestEnvironment());
            }
        }
        return BLANK;
    }

    private boolean isShowDataMember(Element hierElement) {
        String showMemberAttribute = hierElement.attributeValue(SHOWMEMBERS_ATTR_NAME);
        return showMemberAttribute != null && showMemberAttribute.equals(YES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MemberInfo> getChildrenStandard(Element queryOperationElement, String relModelPath, Element rolapModelElement, Element hierElement, int[] range, PlanningEnvironment planEnv, RequestLocales requestLocales) throws Exception {
        RequestInfo reqInfo = new RequestInfo(queryOperationElement, relModelPath, rolapModelElement, range, planEnv, requestLocales);
        if (reqInfo.getIsCalcMember()) {
            return new ArrayList<MemberInfo>();
        }
        LevelInfo childrenLevelInfo = null;
        childrenLevelInfo = reqInfo.getKeys() == null ? reqInfo.getReqLevelInfo() : this.getNextLevelInfo(reqInfo.getLevelNameFromMUN(), reqInfo.getLevelInfos());
        if (childrenLevelInfo == null) {
            return new ArrayList<MemberInfo>();
        }
        List<MemberInfo> children = new ArrayList<MemberInfo>();
        RSAPIDataset dataset = null;
        if (reqInfo.getRelativeTimeMemberType() == 0 || reqInfo.getKeys() != null) {
            planEnv.setMetdataConnection(this.getMetadataConnection(reqInfo.getRelModelPath(), reqInfo.getExecutionEnvironmet()));
            dataset = this.createV5QueryandGetDataset(reqInfo.getRelModelPath(), planEnv, reqInfo.getKeys(), reqInfo.getSelectAttributes(), reqInfo.getSortAttributes(), reqInfo.getReqLevelQueryItems());
            if (dataset == null) {
                return new ArrayList<MemberInfo>();
            }
            try (IROLAPQueryResultIterator resultIterator = ROLAPQueryResultIteratorFactory.getIterator(dataset, (ExecutionEnvironment)reqInfo.getRequestEnvironment().getExecutionEnvironment());){
                children = this.getChildrenMemberNames(resultIterator, reqInfo.getParentPath(), childrenLevelInfo, reqInfo.getLevelInfos(), reqInfo.getIsCubingServicesCompatible(), reqInfo.getIsFillerInheritsCaptionFromParent());
            }
        }
        if (this.isRelativeTimeEnabled(reqInfo.getModelHierarchyElement()) && this.isTimeLevel(childrenLevelInfo)) {
            children = this.addRelativeTimeMembers(reqInfo, childrenLevelInfo, reqInfo.getLevelInfos(), children);
        }
        if (reqInfo.getRelativeTimeMemberType() == 0) {
            this.addCalculatedMembers(hierElement, reqInfo.getDimensionName(), reqInfo.getHierarchyName(), reqInfo.getParentPath(), reqInfo.getIsCubingServicesCompatible(), children);
        }
        this.setModelInfo(reqInfo.getDimensionName(), reqInfo.getHierarchyName(), childrenLevelInfo.getLevelName(), reqInfo.getIsCubingServicesCompatible(), children);
        return this.getChildrenWithinRange(range, children);
    }

    private String getAllLevelName(Element hierElement, RequestLocales requestLocales) {
        List allLevelNameElements = hierElement.elements(ALL_LEVEL_NAME_TAG);
        String allLevelName = this.getAllLevelName(allLevelNameElements, requestLocales.getModelDefaultLocale());
        if (allLevelName == null) {
            allLevelName = "(All)";
        }
        return allLevelName;
    }

    private void addCalculatedMembers(Element hierElement, String dimName, String hierName, String parentPath, boolean isCubingServicesCompatible, List<MemberInfo> children) {
        List calculatedMemberDefs = hierElement.elements(CALCULATEDMEMBER_ELEMENT_NAME);
        boolean isRecursiveHierarchy = this.isRecursiveHierarchy(hierElement);
        if (calculatedMemberDefs == null || calculatedMemberDefs.size() == 0) {
            return;
        }
        String parentMun = null;
        parentMun = parentPath != null ? (!isCubingServicesCompatible ? UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(dimName, hierName), parentPath) : UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(hierName), parentPath)) : (!isCubingServicesCompatible ? UniqueNameGenerator.createUniqueName(dimName, hierName) : UniqueNameGenerator.createUniqueName(hierName));
        for (int index = 0; index < calculatedMemberDefs.size(); ++index) {
            MemberInfo calculatedMemberInfo;
            Element calculatedMemberElement = (Element)calculatedMemberDefs.get(index);
            if (parentPath == null && this.isRoot(calculatedMemberElement)) {
                calculatedMemberInfo = this.createCalculatedMemberInfo((Element)calculatedMemberDefs.get(index), isRecursiveHierarchy, isCubingServicesCompatible);
                children.add(calculatedMemberInfo);
                continue;
            }
            if (!this.isChild(calculatedMemberElement, parentMun)) continue;
            calculatedMemberInfo = this.createCalculatedMemberInfo((Element)calculatedMemberDefs.get(index), isRecursiveHierarchy, isCubingServicesCompatible);
            children.add(calculatedMemberInfo);
        }
    }

    private boolean isRoot(Element calculatedMemberElement) {
        return calculatedMemberElement.element(PARENT) == null;
    }

    private boolean isChild(Element calculatedMemberElement, String parentPath) {
        Element parentElement = calculatedMemberElement.element(PARENT);
        if (parentElement != null) {
            String calcParentPath = parentElement.attributeValue(NAME);
            return calcParentPath.equals(parentPath);
        }
        return false;
    }

    private MemberInfo createCalculatedMemberInfo(Element calculatedMemberElement, boolean isRecursive, boolean isCubingServicesCompatible) {
        String name = calculatedMemberElement.attributeValue(NAME);
        Element parentElement = calculatedMemberElement.element(PARENT);
        MemberInfo memberInfo = new MemberInfo(name);
        memberInfo.setName(name);
        StringValue value = DataValueFactory.createStringValue();
        value.set(CALC_MEM_KEY);
        memberInfo.setLevelKeys(new IValue[]{value});
        if (parentElement != null) {
            String parentPath = parentElement.attributeValue(NAME);
            String[] parentParts = null;
            String[] parentName = null;
            try {
                parentParts = UniqueNameParser.parseNoThrow(parentPath);
                if (parentParts != null) {
                    if (!isCubingServicesCompatible) {
                        parentName = new String[parentParts.length - 2];
                        System.arraycopy(parentParts, 2, parentName, 0, parentName.length);
                    } else {
                        parentName = new String[parentParts.length - 1];
                        System.arraycopy(parentParts, 1, parentName, 0, parentName.length);
                    }
                } else {
                    parentName = new String[]{parentPath};
                }
            }
            catch (Exception e) {
                parentName = new String[]{parentPath};
            }
            memberInfo.setPath(UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(parentName), UniqueNameGenerator.createUniqueName(name)));
        } else {
            memberInfo.setPath(UniqueNameGenerator.createUniqueName(name));
        }
        return memberInfo;
    }

    private List<MemberInfo> addRelativeTimeMembers(RequestInfo reqInfo, LevelInfo childrenLevelInfo, LevelInfo[] levelInfos, List<MemberInfo> siblings) {
        List customMemberElements;
        boolean isPeriodToDateMember;
        String allLevelName = this.getAllLevelName(reqInfo.getModelHierarchyElement(), reqInfo.getRequestLocales());
        String parentLevelName = reqInfo.getLevelNameFromMUN();
        int rtMemberType = reqInfo.getRelativeTimeMemberType();
        String memberNamePath = reqInfo.getParentPath();
        String locale = reqInfo.getRequestLocales().getModelDefaultLocale();
        ArrayList<MemberInfo> children = new ArrayList<MemberInfo>();
        if (rtMemberType == 5 || rtMemberType == 6 || rtMemberType == 11 || rtMemberType == 12) {
            return children;
        }
        boolean isAllOrRootLevel = parentLevelName == null || parentLevelName.length() == 0 || parentLevelName.equals(allLevelName);
        boolean isChildRefMember = rtMemberType == 7;
        boolean isCurrentPriorOrNextPeriodMember = rtMemberType == 1 || rtMemberType == 2 || rtMemberType == 9;
        boolean bl = isPeriodToDateMember = rtMemberType == 3 || rtMemberType == 4 || rtMemberType == 10 || rtMemberType == 8;
        if (!(isAllOrRootLevel || isChildRefMember || isCurrentPriorOrNextPeriodMember || isPeriodToDateMember)) {
            return siblings;
        }
        if (siblings == null || siblings.size() == 0) {
            return children;
        }
        CurrentPeriodInfo currentPeriodInfo = new CurrentPeriodInfo(reqInfo, childrenLevelInfo, siblings, isAllOrRootLevel);
        if ((isChildRefMember || isCurrentPriorOrNextPeriodMember || isPeriodToDateMember) && this.isShowRelativeTimeSubtreeMembers(reqInfo.getModelHierarchyElement())) {
            for (int i = 0; i < siblings.size(); ++i) {
                MemberInfo refMemberInfo = siblings.get(i);
                if ((rtMemberType == 3 || rtMemberType == 4 || rtMemberType == 10 || rtMemberType == 8) && i == currentPeriodInfo.getCurrentPeriodIndex()) {
                    int memberType = 8;
                    if (childrenLevelInfo.getLevelNumber() >= levelInfos.length - 1) {
                        memberType = 7;
                    }
                    MemberInfo memberInfo = this.createRelativeTimeMemberInfo(memberType, memberNamePath, childrenLevelInfo, refMemberInfo, currentPeriodInfo, i, locale);
                    children.add(memberInfo);
                    break;
                }
                MemberInfo memberInfo = this.createRelativeTimeMemberInfo(7, memberNamePath, childrenLevelInfo, refMemberInfo, null, i, locale);
                children.add(memberInfo);
            }
        } else if (isAllOrRootLevel) {
            children.addAll(siblings);
        }
        if (isAllOrRootLevel) {
            List elements;
            MemberInfo memberInfo = this.createRelativeTimeMemberInfo(1, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), currentPeriodInfo, 0, locale);
            children.add(memberInfo);
            if (currentPeriodInfo.getPriorPeriod() != null) {
                memberInfo = this.createRelativeTimeMemberInfo(2, memberNamePath, childrenLevelInfo, currentPeriodInfo.getPriorPeriod(), null, 0, locale);
                children.add(memberInfo);
            }
            if (currentPeriodInfo.getNextPeriod() != null) {
                memberInfo = this.createRelativeTimeMemberInfo(9, memberNamePath, childrenLevelInfo, currentPeriodInfo.getNextPeriod(), null, 0, locale);
                children.add(memberInfo);
            }
            memberInfo = this.createRelativeTimeMemberInfo(3, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), currentPeriodInfo, 0, locale);
            children.add(memberInfo);
            if (currentPeriodInfo.getPriorPeriod() != null) {
                memberInfo = this.createRelativeTimeMemberInfo(4, memberNamePath, childrenLevelInfo, currentPeriodInfo.getPriorPeriod(), currentPeriodInfo, 0, locale);
                children.add(memberInfo);
            }
            if (currentPeriodInfo.getNextPeriod() != null) {
                memberInfo = this.createRelativeTimeMemberInfo(10, memberNamePath, childrenLevelInfo, currentPeriodInfo.getNextPeriod(), currentPeriodInfo, 0, locale);
                children.add(memberInfo);
            }
            memberInfo = this.createRelativeTimeMemberInfo(5, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), null, 0, locale);
            children.add(memberInfo);
            memberInfo = this.createRelativeTimeMemberInfo(6, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), null, 0, locale);
            children.add(memberInfo);
            if (currentPeriodInfo.getNextPeriod() != null) {
                memberInfo = this.createRelativeTimeMemberInfo(11, memberNamePath, childrenLevelInfo, currentPeriodInfo.getNextPeriod(), null, 0, locale);
                children.add(memberInfo);
                memberInfo = this.createRelativeTimeMemberInfo(12, memberNamePath, childrenLevelInfo, currentPeriodInfo.getNextPeriod(), null, 0, locale);
                children.add(memberInfo);
            }
            if ((elements = reqInfo.hierarchyElement.elements()) != null) {
                for (Element elem : elements) {
                    String elementTypeName = elem.getQName().getName();
                    if (elementTypeName.equalsIgnoreCase(CUSTOM_SIMPLE_RELATIVE_TIME_MEMBER)) {
                        if (!elem.element(TARGET_PERIOD).attributeValue(NAME).equals(childrenLevelInfo.levelName)) continue;
                        memberInfo = this.createRelativeTimeMemberInfo(13, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), currentPeriodInfo, 0, elem, locale);
                        children.add(memberInfo);
                        continue;
                    }
                    if (elementTypeName.equalsIgnoreCase(CUSTOM_PTD_RELATIVE_TIME_MEMBER)) {
                        if (!TRUE.equalsIgnoreCase(elem.attributeValue("isLifeTodate")) && !elem.element(TODATE_PERIOD).attributeValue(NAME).equals(childrenLevelInfo.levelName)) continue;
                        memberInfo = this.createRelativeTimeMemberInfo(14, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), currentPeriodInfo, 0, elem, locale);
                        children.add(memberInfo);
                        continue;
                    }
                    if (!elementTypeName.equalsIgnoreCase(CUSTOM_ROLLIN_TOTAL_RELATIVE_TIME_MEMBER)) continue;
                    memberInfo = this.createRelativeTimeMemberInfo(15, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), currentPeriodInfo, 0, elem, locale);
                    children.add(memberInfo);
                }
            }
        } else if (rtMemberType == 1) {
            MemberInfo memberInfo = this.createRelativeTimeMemberInfo(1, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), currentPeriodInfo, 0, locale);
            children.add(memberInfo);
            if (currentPeriodInfo.getPriorPeriod() != null) {
                memberInfo = this.createRelativeTimeMemberInfo(2, memberNamePath, childrenLevelInfo, currentPeriodInfo.getPriorPeriod(), null, 0, locale);
                children.add(memberInfo);
            }
            if (currentPeriodInfo.getNextPeriod() != null) {
                memberInfo = this.createRelativeTimeMemberInfo(9, memberNamePath, childrenLevelInfo, currentPeriodInfo.getNextPeriod(), null, 0, locale);
                children.add(memberInfo);
            }
            if ((customMemberElements = reqInfo.hierarchyElement.elements(CUSTOM_SIMPLE_RELATIVE_TIME_MEMBER)) != null) {
                for (Element elem : customMemberElements) {
                    if (!elem.element(TARGET_PERIOD).attributeValue(NAME).equals(childrenLevelInfo.levelName)) continue;
                    memberInfo = this.createRelativeTimeMemberInfo(13, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), currentPeriodInfo, 0, elem, locale);
                    children.add(memberInfo);
                }
            }
        } else if (rtMemberType == 3) {
            if (childrenLevelInfo.getLevelNumber() < levelInfos.length - 1) {
                MemberInfo memberInfo = this.createRelativeTimeMemberInfo(3, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), currentPeriodInfo, 0, locale);
                children.add(memberInfo);
                if (currentPeriodInfo.getPriorPeriod() != null) {
                    memberInfo = this.createRelativeTimeMemberInfo(4, memberNamePath, childrenLevelInfo, currentPeriodInfo.getPriorPeriod(), currentPeriodInfo, 0, locale);
                    children.add(memberInfo);
                }
                if (currentPeriodInfo.getNextPeriod() != null) {
                    memberInfo = this.createRelativeTimeMemberInfo(10, memberNamePath, childrenLevelInfo, currentPeriodInfo.getNextPeriod(), currentPeriodInfo, 0, locale);
                    children.add(memberInfo);
                }
                memberInfo = this.createRelativeTimeMemberInfo(5, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), null, 0, locale);
                children.add(memberInfo);
                memberInfo = this.createRelativeTimeMemberInfo(6, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), null, 0, locale);
                children.add(memberInfo);
                if (currentPeriodInfo.getNextPeriod() != null) {
                    memberInfo = this.createRelativeTimeMemberInfo(11, memberNamePath, childrenLevelInfo, currentPeriodInfo.getNextPeriod(), null, 0, locale);
                    children.add(memberInfo);
                    memberInfo = this.createRelativeTimeMemberInfo(12, memberNamePath, childrenLevelInfo, currentPeriodInfo.getNextPeriod(), null, 0, locale);
                    children.add(memberInfo);
                }
                if ((customMemberElements = reqInfo.hierarchyElement.elements(CUSTOM_PTD_RELATIVE_TIME_MEMBER)) != null) {
                    for (Element elem : customMemberElements) {
                        Element todateElement = elem.element(TODATE_PERIOD);
                        if (todateElement == null || !todateElement.attributeValue(NAME).equals(childrenLevelInfo.levelName)) continue;
                        memberInfo = this.createRelativeTimeMemberInfo(14, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), currentPeriodInfo, 0, elem, locale);
                        children.add(memberInfo);
                    }
                }
            } else {
                MemberInfo memberInfo = this.createRelativeTimeMemberInfo(1, memberNamePath, childrenLevelInfo, currentPeriodInfo.getCurrentPeriod(), null, 0, locale);
                children.add(memberInfo);
                if (currentPeriodInfo.getPriorPeriod() != null) {
                    memberInfo = this.createRelativeTimeMemberInfo(2, memberNamePath, childrenLevelInfo, currentPeriodInfo.getPriorPeriod(), null, 0, locale);
                    children.add(memberInfo);
                }
                if (currentPeriodInfo.getNextPeriod() != null) {
                    memberInfo = this.createRelativeTimeMemberInfo(9, memberNamePath, childrenLevelInfo, currentPeriodInfo.getNextPeriod(), null, 0, locale);
                    children.add(memberInfo);
                }
            }
        }
        return children;
    }

    private MemberInfo createRelativeTimeMemberInfo(int rtMemberType, String parentPath, LevelInfo levelInfo, MemberInfo refMemberInfo, CurrentPeriodInfo cpInfo, int childPos, String locale) {
        return this.createRelativeTimeMemberInfo(rtMemberType, parentPath, levelInfo, refMemberInfo, cpInfo, childPos, null, locale);
    }

    private MemberInfo createRelativeTimeMemberInfo(int rtMemberType, String parentPath, LevelInfo levelInfo, MemberInfo refMemberInfo, CurrentPeriodInfo cpInfo, int childPos, Element customMemberElement, String locale) {
        String memberName = null;
        String memberCaption = null;
        if (rtMemberType == 7) {
            memberName = Integer.toString(childPos);
            memberCaption = refMemberInfo.getCaption();
        } else if (rtMemberType == 8) {
            memberName = Integer.toString(childPos);
            memberCaption = ROLAPRelativeTimeMember.getMemberCaption(rtMemberType, levelInfo.getLevelName(), levelInfo.getLevelType(), refMemberInfo.getCaption(), locale);
        } else if (rtMemberType == 15 || rtMemberType == 13 || rtMemberType == 14) {
            memberCaption = memberName = customMemberElement.attributeValue(NAME);
        } else {
            memberName = ROLAPRelativeTimeMember.getMemberName(rtMemberType, levelInfo.getLevelName());
            memberCaption = ROLAPRelativeTimeMember.getMemberCaption(rtMemberType, levelInfo.getLevelName(), levelInfo.getLevelType(), refMemberInfo.getCaption(), locale);
        }
        MemberInfo memberInfo = new MemberInfo(memberCaption);
        memberInfo.setName(memberName);
        if (rtMemberType == 1 || rtMemberType == 2 || rtMemberType == 9 || rtMemberType == 7 || rtMemberType == 3 || rtMemberType == 4 || rtMemberType == 10 || rtMemberType == 8) {
            IValue[] refMemberLevelKeys = refMemberInfo.getLevelKeys().getKeyValues();
            ArrayList<IValue> memberLevelKeys = new ArrayList<IValue>();
            StringValue levelKey = DataValueFactory.createStringValue();
            levelKey.set(this.getRelativeTimeTypeStr(rtMemberType));
            memberLevelKeys.add(levelKey);
            for (int i = 0; i < refMemberLevelKeys.length; ++i) {
                memberLevelKeys.add(refMemberLevelKeys[i]);
            }
            if (cpInfo != null) {
                int i;
                IValue[] levelKeys;
                MemberInfo periodMemberInfo = cpInfo.getCurrentPeriod();
                if (periodMemberInfo != null) {
                    levelKey = DataValueFactory.createStringValue();
                    levelKey.set(RELATIVE_TIME_CURRENT_PERIOD_KEY);
                    memberLevelKeys.add(levelKey);
                    levelKeys = periodMemberInfo.getLevelKeys().getKeyValues();
                    for (i = 0; i < levelKeys.length; ++i) {
                        memberLevelKeys.add(levelKeys[i]);
                    }
                }
                if ((periodMemberInfo = cpInfo.getPriorPeriod()) != null) {
                    levelKey = DataValueFactory.createStringValue();
                    levelKey.set(RELATIVE_TIME_PRIOR_PERIOD_KEY);
                    memberLevelKeys.add(levelKey);
                    levelKeys = periodMemberInfo.getLevelKeys().getKeyValues();
                    for (i = 0; i < levelKeys.length; ++i) {
                        memberLevelKeys.add(levelKeys[i]);
                    }
                }
                if ((periodMemberInfo = cpInfo.getNextPeriod()) != null) {
                    levelKey = DataValueFactory.createStringValue();
                    levelKey.set(RELATIVE_TIME_NEXT_PERIOD_KEY);
                    memberLevelKeys.add(levelKey);
                    levelKeys = periodMemberInfo.getLevelKeys().getKeyValues();
                    for (i = 0; i < levelKeys.length; ++i) {
                        memberLevelKeys.add(levelKeys[i]);
                    }
                }
            }
            memberInfo.setLevelKeys(memberLevelKeys.toArray(new IValue[memberLevelKeys.size()]));
        } else {
            StringValue value = DataValueFactory.createStringValue();
            value.set(this.getRelativeTimeTypeStr(rtMemberType));
            memberInfo.setLevelKeys(new IValue[]{value});
        }
        String[] parentParts = null;
        try {
            parentParts = UniqueNameParser.parseNoThrow(parentPath);
        }
        catch (Exception e) {
            parentParts = new String[]{parentPath};
        }
        if (parentParts != null) {
            memberInfo.setPath(UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(parentParts), UniqueNameGenerator.createUniqueName(memberName)));
        } else {
            memberInfo.setPath(UniqueNameGenerator.createUniqueName(memberName));
        }
        return memberInfo;
    }

    private int getRelativeTimeTypeID(String rtTypeStr) {
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_CURRENT_PERIOD_KEY)) {
            return 1;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_PRIOR_PERIOD_KEY)) {
            return 2;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_NEXT_PERIOD_KEY)) {
            return 9;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_PERIOD_TO_DATE_KEY)) {
            return 3;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_PERIOD_TO_DATE_LAST_CHILD_KEY)) {
            return 8;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_PRIOR_PERIOD_TO_DATE_KEY)) {
            return 4;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_NEXT_PERIOD_TO_DATE_KEY)) {
            return 10;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_PERIOD_TO_DATE_CHANGE_KEY)) {
            return 5;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_PERIOD_TO_DATE_GROWTH_KEY)) {
            return 6;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_NEXT_PERIOD_TO_DATE_CHANGE_KEY)) {
            return 11;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_NEXT_PERIOD_TO_DATE_GROWTH_KEY)) {
            return 12;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_PERIOD_CHILD_REF_KEY)) {
            return 7;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_CUSTOM_SIMPLE)) {
            return 13;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_CUSTOM_PERIOD_TO_DATE)) {
            return 14;
        }
        if (rtTypeStr.equalsIgnoreCase(RELATIVE_TIME_CUSTOM_ROLLING_TOTAL)) {
            return 15;
        }
        return 0;
    }

    private String getRelativeTimeTypeStr(int rtTypeId) {
        if (rtTypeId == 1) {
            return RELATIVE_TIME_CURRENT_PERIOD_KEY;
        }
        if (rtTypeId == 2) {
            return RELATIVE_TIME_PRIOR_PERIOD_KEY;
        }
        if (rtTypeId == 9) {
            return RELATIVE_TIME_NEXT_PERIOD_KEY;
        }
        if (rtTypeId == 3) {
            return RELATIVE_TIME_PERIOD_TO_DATE_KEY;
        }
        if (rtTypeId == 8) {
            return RELATIVE_TIME_PERIOD_TO_DATE_LAST_CHILD_KEY;
        }
        if (rtTypeId == 4) {
            return RELATIVE_TIME_PRIOR_PERIOD_TO_DATE_KEY;
        }
        if (rtTypeId == 10) {
            return RELATIVE_TIME_NEXT_PERIOD_TO_DATE_KEY;
        }
        if (rtTypeId == 5) {
            return RELATIVE_TIME_PERIOD_TO_DATE_CHANGE_KEY;
        }
        if (rtTypeId == 6) {
            return RELATIVE_TIME_PERIOD_TO_DATE_GROWTH_KEY;
        }
        if (rtTypeId == 11) {
            return RELATIVE_TIME_NEXT_PERIOD_TO_DATE_CHANGE_KEY;
        }
        if (rtTypeId == 12) {
            return RELATIVE_TIME_NEXT_PERIOD_TO_DATE_GROWTH_KEY;
        }
        if (rtTypeId == 7) {
            return RELATIVE_TIME_PERIOD_CHILD_REF_KEY;
        }
        if (rtTypeId == 13) {
            return RELATIVE_TIME_CUSTOM_SIMPLE;
        }
        if (rtTypeId == 14) {
            return RELATIVE_TIME_CUSTOM_PERIOD_TO_DATE;
        }
        if (rtTypeId == 15) {
            return RELATIVE_TIME_CUSTOM_ROLLING_TOTAL;
        }
        return null;
    }

    private boolean isRelativeTimeEnabled(Element hierElement) {
        String value = hierElement.attributeValue(HASRELATIVETIMEMEMBERS_ATTRIBUTE_NAME);
        return TRUE.equalsIgnoreCase(value);
    }

    private boolean isShowRelativeTimePriorPeriodMembers(Element hierElement) {
        String value = hierElement.attributeValue(SHOWRELATIVETIMEPRIORPERIODMEMBERS_ATTRIBUTE_NAME);
        return value == null || YES.equalsIgnoreCase(value);
    }

    private boolean isShowRelativeTimeNextPeriodMembers(Element hierElement) {
        String value = hierElement.attributeValue(SHOWRELATIVETIMENEXTPERIODMEMBERS_ATTRIBUTE_NAME);
        return value == null || YES.equalsIgnoreCase(value);
    }

    private boolean isShowRelativeTimeSubtreeMembers(Element hierElement) {
        String value = hierElement.attributeValue(SHOWRELATIVETIMESUBTREEMEMBERS_ATTRIBUTE_NAME);
        return value == null || YES.equalsIgnoreCase(value);
    }

    private boolean isTimeLevel(LevelInfo levelInfo) {
        int levelType = levelInfo.getLevelType();
        return levelType == 4 || levelType == 5 || levelType == 6 || levelType == 7 || levelType == 8 || levelType == 9 || levelType == 10 || levelType == 11 || levelType == 12 || levelType == 13 || levelType == 14 || levelType == 15 || levelType == 16 || levelType == 17;
    }

    private Element getHierarchyElement(Element rolapModelElement, String hierName) {
        Element dimensionElement = rolapModelElement.element(DIM_NAME);
        Element hierElement = null;
        List hierElements = dimensionElement.elements(HIER_NAME);
        if (hierElements != null) {
            for (int index = 0; index < hierElements.size(); ++index) {
                hierElement = (Element)hierElements.get(index);
                if (!hierName.equals(hierElement.attributeValue(NAME))) continue;
                return hierElement;
            }
        }
        return (Element)hierElements.get(0);
    }

    private boolean isFillerInheritsCaptionFromParent(Element hierElement) {
        String parentFillerAttribute = hierElement.attributeValue(FILLERDATAMEMBERCAPTION_TYPE);
        return parentFillerAttribute != null && parentFillerAttribute.equals(PARENT);
    }

    private String getParentPath(Element munElement) {
        return munElement.element(PATH_ELEMENT_NAME).getText();
    }

    private LevelInfo getLevelInfo(String levelNameFromMUN, LevelInfo[] levelInfos) {
        if (levelNameFromMUN.equals("(All)")) {
            return levelInfos[0];
        }
        for (LevelInfo levelInfo : levelInfos) {
            if (!levelNameFromMUN.equals(levelInfo.getLevelName())) continue;
            return levelInfo;
        }
        return levelInfos[0];
    }

    private LevelInfo getNextLevelInfo(String levelNameFromMUN, LevelInfo[] levelInfos) {
        if (levelNameFromMUN.equals("(All)")) {
            return levelInfos[1];
        }
        for (int index = 0; index < levelInfos.length - 1; ++index) {
            LevelInfo levelInfo = levelInfos[index];
            if (!levelNameFromMUN.equals(levelInfo.getLevelName())) continue;
            return levelInfos[index + 1];
        }
        return null;
    }

    private String getLevelName(Element munElement) {
        List modelInfoElements = munElement.elements(MODELITEM_ELEMENT_NAME);
        String firstModelInfo = ((Element)modelInfoElements.get(0)).getText();
        int levelNameStartIdx = firstModelInfo.lastIndexOf("].[");
        int levelNameEndIdx = firstModelInfo.indexOf("]", levelNameStartIdx + "].[".length());
        return firstModelInfo.substring(levelNameStartIdx + "].[".length(), levelNameEndIdx);
    }

    private void setModelInfo(String dimName, String hierName, String levelName, boolean isCubingServicesCompatible, List<MemberInfo> memberInfos) {
        String[] firstModelItem = levelName == null ? new String[]{dimName, hierName} : new String[]{dimName, hierName, levelName};
        String[] secondModelItem = null;
        secondModelItem = !isCubingServicesCompatible ? new String[]{dimName, hierName} : new String[]{hierName};
        for (MemberInfo memberInfo : memberInfos) {
            memberInfo.setFirstModelItem(firstModelItem);
            memberInfo.setSecondModelItem(secondModelItem);
        }
    }

    private List<MemberInfo> getHierarchyRoots(Element queryOperationElement, String relModelPath, Element rolapModelElement, ExecutionEnvironment execEnv, PlanningEnvironment planEnv, RequestLocales requestLocales) throws Exception {
        if (this.isVirtualCube(rolapModelElement)) {
            return this.getHierarchyRootsVirtual(queryOperationElement, relModelPath, rolapModelElement, requestLocales);
        }
        return this.getHierarchyRootsRegular(queryOperationElement, relModelPath, rolapModelElement, execEnv, planEnv, requestLocales);
    }

    private boolean isVirtualCube(Element rolapModelElement) {
        return rolapModelElement.element(VIRTUALCUBE) != null;
    }

    private List<MemberInfo> getHierarchyRootsVirtual(Element queryOperationElement, String relModelPath, Element rolapModelElement, RequestLocales requestLocales) throws Exception {
        Element dimNameElement = queryOperationElement.element(DIM_NAME);
        String dimName = dimNameElement.getText();
        Element hierNameElement = queryOperationElement.element(HIER_NAME);
        String hierName = hierNameElement.getText();
        ROLAPVirtualCubeModel model = new ROLAPVirtualCubeModel(dimName, rolapModelElement, requestLocales);
        List<MemberInfo> rootsList = this.getVirtualHierarchyRoots(model, hierName, requestLocales);
        return rootsList;
    }

    private List<MemberInfo> getVirtualHierarchyRoots(ROLAPVirtualCubeModel model, String hierName, RequestLocales requestLocales) throws Exception {
        IROLAPMember[] rootMembers = model.getHierarchyRootMembers(hierName);
        ArrayList<MemberInfo> roots = new ArrayList<MemberInfo>();
        for (IROLAPMember rootMember : rootMembers) {
            roots.add(new MemberInfo(rootMember));
        }
        return roots;
    }

    private List<MemberInfo> getHierarchyRootsRegular(Element queryOperationElement, String relModelPath, Element rolapModelElement, ExecutionEnvironment execEnv, PlanningEnvironment planEnv, RequestLocales requestLocales) throws Exception {
        RequestInfo reqInfo = new RequestInfo(queryOperationElement, relModelPath, rolapModelElement, null, planEnv, requestLocales);
        String dimName = reqInfo.getDimensionName();
        String hierName = reqInfo.getHierarchyName();
        List<MemberInfo> roots = null;
        boolean isCubingServicesCompatible = reqInfo.getIsCubingServicesCompatible();
        boolean isRecursiveHierarchy = reqInfo.getIsRecursiveHierarchy();
        boolean hasAllMember = reqInfo.getHierarchyHasAllMember();
        if (hasAllMember) {
            MemberInfo allMemberInfo = this.createAllMemberInfo(isCubingServicesCompatible, isRecursiveHierarchy, dimName, hierName, rolapModelElement, requestLocales);
            roots = new ArrayList<MemberInfo>();
            roots.add(allMemberInfo);
        } else {
            roots = isRecursiveHierarchy ? this.getTopLevelMembersFromV5Query(relModelPath, queryOperationElement, rolapModelElement, execEnv, planEnv, isCubingServicesCompatible, null) : this.getHierarchyRootsFromStandard(reqInfo, planEnv);
        }
        return roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MemberInfo> getTopLevelMembersFromV5Query(String relModelPath, Element queryOperationElement, Element rolapModelElement, ExecutionEnvironment execEnv, PlanningEnvironment planEnv, boolean isCubingServicesCompatible, String parentPath) {
        Element dimNameElement = queryOperationElement.element(DIM_NAME);
        String dimName = dimNameElement.getText();
        Element hierNameElement = queryOperationElement.element(HIER_NAME);
        String hierName = hierNameElement.getText();
        List<MemberInfo> roots = null;
        planEnv.setMetdataConnection(this.getMetadataConnection(relModelPath, execEnv));
        ArrayList<SelectAttribute> selectAttributes = new ArrayList<SelectAttribute>();
        ArrayList<SortAttribute> sortAttributes = new ArrayList<SortAttribute>();
        Element dimensionElement = rolapModelElement.element(DIM_NAME);
        Element hierElement = this.getHierarchyElement(rolapModelElement, hierName);
        Map<String, SelectAttribute> attributesMap = this.createSelectAttributeMap(dimensionElement.elements(ATTRIBUTE_ELEMENT_NAME));
        LevelInfo[] levelInfos = this.getParentChildAttributes(dimensionElement, hierElement, attributesMap, selectAttributes, sortAttributes);
        V5QuerySet querySet = this.createV5QuerySet(planEnv, relModelPath, selectAttributes, sortAttributes, null, null);
        ROLAPContext.setRelQueryExecuting();
        PlannedV5QuerySet plannedQuerySet = QueryPlanner.getInstance().planQuery(querySet, planEnv);
        RSAPIDataset dataset = ROLAPMemberQuery.getDataset(QUERY_NAME, plannedQuerySet);
        if (dataset != null) {
            try (IROLAPQueryResultIterator resultIterator = ROLAPQueryResultIteratorFactory.getIterator(dataset, execEnv);){
                roots = this.getRecursiveRootMemberNames(resultIterator, isCubingServicesCompatible, parentPath, levelInfos[1]);
                this.addCalculatedMembers(hierElement, dimName, hierName, null, isCubingServicesCompatible, roots);
            }
            this.setModelInfo(dimName, hierName, null, isCubingServicesCompatible, roots);
        }
        return roots;
    }

    private List<MemberInfo> getRecursiveRootMemberNames(IROLAPQueryResultIterator resultIterator, boolean isCubingServicesCompatible, String parentPath, LevelInfo childrenLevelInfo) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>();
        HashMap<IValue, IValue[]> memberKeyToMemberValueMap = new HashMap<IValue, IValue[]>();
        while (resultIterator.hasNext()) {
            IValue[] values = resultIterator.next().getColumns();
            IValue[] copiedValues = new IValue[values.length];
            for (int index = 0; index < values.length; ++index) {
                copiedValues[index] = (IValue)values[index].copy();
            }
            memberKeyToMemberValueMap.put(copiedValues[1], copiedValues);
        }
        HashSet<IValue> topLevelMemberKeys = ROLAPHierarchyMemberLoader.getTopLevelMemberKeys(memberKeyToMemberValueMap);
        Iterator<IValue> iterator = topLevelMemberKeys.iterator();
        while (iterator.hasNext()) {
            IValue[] values = (IValue[])memberKeyToMemberValueMap.get(iterator.next());
            IValue[] rowValues = new IValue[]{(IValue)values[1].copy()};
            String caption = values[childrenLevelInfo.getCaptionColumnIndex()].toString();
            String name = values[childrenLevelInfo.getNameColumnIndex()].toString();
            if (names.contains(name)) continue;
            MemberInfo memberInfo = new MemberInfo(caption);
            memberInfo.setName(name);
            memberInfo.setLevelKeys(rowValues);
            memberInfos.add(memberInfo);
            if (!isCubingServicesCompatible) {
                name = rowValues[0].toString();
            }
            if (parentPath == null) {
                memberInfo.setPath(UniqueNameGenerator.createUniqueName(name));
            } else {
                memberInfo.setPath(UniqueNameGenerator.appendUniqueName(parentPath, name));
            }
            names.add(name);
        }
        return memberInfos;
    }

    private LevelInfo[] getParentChildAttributes(Element dimensionElement, Element hierElement, Map<String, SelectAttribute> attributesMap, List<SelectAttribute> selectAttributes, List<SortAttribute> sortAttributes) {
        LevelInfo[] levelInfos = new LevelInfo[2];
        List levelRefsElements = hierElement.elements(LEVEL_REF_ELEMENT_NAME);
        Element parentLevelRefElement = (Element)levelRefsElements.get(0);
        Element memberLevelRefElement = (Element)levelRefsElements.get(1);
        levelInfos[0] = this.getLevelInfo(selectAttributes, sortAttributes, dimensionElement, attributesMap, parentLevelRefElement, 0);
        levelInfos[1] = this.getLevelInfo(selectAttributes, sortAttributes, dimensionElement, attributesMap, memberLevelRefElement, 1);
        return levelInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MemberInfo> getHierarchyRootsFromStandard(RequestInfo reqInfo, PlanningEnvironment planEnv) {
        List<MemberInfo> roots = null;
        Element hierElement = reqInfo.getModelHierarchyElement();
        planEnv.setMetdataConnection(this.getMetadataConnection(reqInfo.getRelModelPath(), reqInfo.getExecutionEnvironmet()));
        List<SelectAttribute> selectAttributes = reqInfo.getSelectAttributes();
        List<SortAttribute> sortAttributes = reqInfo.getSortAttributes();
        LevelInfo levelInfo = reqInfo.getReqLevelInfo();
        LevelInfo[] levelInfos = reqInfo.getLevelInfos();
        V5QuerySet querySet = this.createV5QuerySet(planEnv, reqInfo.getRelModelPath(), selectAttributes, sortAttributes, null, null);
        ROLAPContext.setRelQueryExecuting();
        PlannedV5QuerySet plannedQuerySet = QueryPlanner.getInstance().planQuery(querySet, planEnv);
        RSAPIDataset dataset = ROLAPMemberQuery.getDataset(QUERY_NAME, plannedQuerySet);
        if (dataset != null) {
            String levelName = levelInfo.getLevelName();
            try (IROLAPQueryResultIterator resultIterator = ROLAPQueryResultIteratorFactory.getIterator(dataset, reqInfo.getExecutionEnvironmet());){
                roots = this.getMemberNames(resultIterator, levelInfo);
                if (this.isRelativeTimeEnabled(hierElement)) {
                    roots = this.addRelativeTimeMembers(reqInfo, levelInfo, levelInfos, roots);
                }
                this.addCalculatedMembers(hierElement, reqInfo.getDimensionName(), reqInfo.getHierarchyName(), null, reqInfo.getIsCubingServicesCompatible(), roots);
            }
            this.setModelInfo(reqInfo.getDimensionName(), reqInfo.getHierarchyName(), levelName, reqInfo.getIsCubingServicesCompatible(), roots);
        }
        return roots;
    }

    private boolean isCubingServicesCompatible(Element queryOperationElement) {
        String cubingServicesCompatibleAttrValue;
        Element csCompatibleElement = queryOperationElement.element(CS_COMPATIBLE_ELEMENT_NAME);
        boolean isCubingServicesCompatible = false;
        if (csCompatibleElement != null && (cubingServicesCompatibleAttrValue = csCompatibleElement.getText()) != null && cubingServicesCompatibleAttrValue.equalsIgnoreCase(TRUE)) {
            isCubingServicesCompatible = true;
        }
        return isCubingServicesCompatible;
    }

    private List<MemberInfo> getMemberNames(IROLAPQueryResultIterator resultIterator, LevelInfo levelInfo) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>();
        int[] levelKeys = levelInfo.getLevelKeyColumnIndices();
        while (resultIterator.hasNext()) {
            IValue[] rowValues = new IValue[levelKeys.length];
            IValue[] values = resultIterator.next().getColumns();
            if (values.length > 0) {
                for (int col = 0; col < levelKeys.length; ++col) {
                    IValue v = values[levelKeys[col]];
                    rowValues[col] = (IValue)v.copy();
                }
            }
            String name = values[levelInfo.getNameColumnIndex()].toString();
            String caption = values[levelInfo.getCaptionColumnIndex()].toString();
            if (names.contains(name)) continue;
            MemberInfo memberInfo = new MemberInfo(caption);
            memberInfo.setName(name);
            memberInfo.setLevelKeys(rowValues);
            memberInfos.add(memberInfo);
            memberInfo.setPath(UniqueNameGenerator.createUniqueName(name));
            names.add(name);
        }
        return memberInfos;
    }

    private List<MemberInfo> getChildrenMemberNames(IROLAPQueryResultIterator resultIterator, String parentPath, LevelInfo levelInfo, LevelInfo[] levelInfos, boolean isCubingServicesCompatible, boolean isFillerInheritsCaptionFromParent) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>();
        int[] levelKeys = levelInfo.getLevelKeyColumnIndices();
        while (resultIterator.hasNext()) {
            IValue[] rowValues = new IValue[levelKeys.length];
            IValue[] values = resultIterator.next().getColumns();
            if (values.length > 0) {
                for (int col = 0; col < levelKeys.length; ++col) {
                    IValue v = values[levelKeys[col]];
                    rowValues[col] = (IValue)v.copy();
                }
            }
            String caption = null;
            String name = null;
            IValue val = values[levelInfo.getCaptionColumnIndex()];
            if (val.isNull()) {
                if (isFillerInheritsCaptionFromParent) {
                    caption = this.getCaptionFromParent(values, levelInfo, levelInfos);
                    name = BLANK;
                } else {
                    name = caption = BLANK;
                }
            } else {
                caption = values[levelInfo.getCaptionColumnIndex()].toString();
                name = values[levelInfo.getNameColumnIndex()].toString();
            }
            MemberInfo memberInfo = new MemberInfo(caption);
            memberInfo.setLevelKeys(rowValues);
            if (!isCubingServicesCompatible) {
                name = memberInfo.getMUNKeyIdentifier(levelInfo.getMUNKeys());
            }
            if (names.contains(name)) continue;
            memberInfo.setName(name);
            String modifiedParentPath = parentPath;
            if (isCubingServicesCompatible && !BLANK.equals(name)) {
                modifiedParentPath = this.checkIfRemovePaddingMembers(parentPath);
            }
            memberInfo.setPath(UniqueNameGenerator.appendUniqueName(modifiedParentPath, name));
            memberInfos.add(memberInfo);
            names.add(name);
        }
        return memberInfos;
    }

    private List<MemberInfo> getRecursiveChildrenMemberNames(IROLAPQueryResultIterator resultIterator, String[] parentInfo, boolean isCubingServicesCompatible, boolean isShowDataMember, boolean isFillerInheritsCaptionFromParent, String key, LevelInfo childrenLevelInfo) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>();
        while (resultIterator.hasNext()) {
            IValue[] rowValues = new IValue[1];
            IValue[] values = resultIterator.next().getColumns();
            rowValues[0] = (IValue)values[1].copy();
            String caption = values[childrenLevelInfo.getCaptionColumnIndex()].toString();
            String name = values[1].toString();
            MemberInfo memberInfo = new MemberInfo(caption);
            memberInfo.setLevelKeys(rowValues);
            if (names.contains(name)) continue;
            memberInfo.setName(name);
            if (isCubingServicesCompatible) {
                name = caption;
            }
            memberInfo.setPath(UniqueNameGenerator.appendUniqueName(parentInfo[0], name));
            memberInfos.add(memberInfo);
            names.add(name);
        }
        if (isShowDataMember && memberInfos.size() > 0) {
            memberInfos.add(this.createDataMember(parentInfo[0], isCubingServicesCompatible, isFillerInheritsCaptionFromParent, key, parentInfo[1]));
        }
        return memberInfos;
    }

    private MemberInfo createDataMember(String parentPath, boolean isCubingServicesCompatible, boolean isFillerInheritsCaptionFromParent, String key, String parentName) {
        String caption = isFillerInheritsCaptionFromParent ? parentName : BLANK;
        String name = caption;
        String munKeyIdentifier = ROLAPDataMember.generateMUNKeyIdentifier(key);
        MemberInfo memberInfo = new MemberInfo(caption);
        memberInfo.setName(name);
        if (!isCubingServicesCompatible) {
            memberInfo.setPath(UniqueNameGenerator.appendUniqueName(parentPath, munKeyIdentifier));
        } else {
            memberInfo.setPath(UniqueNameGenerator.appendUniqueName(parentPath, name));
        }
        StringValue value = DataValueFactory.createStringValue();
        value.set(munKeyIdentifier);
        memberInfo.setLevelKeys(new IValue[]{value});
        return memberInfo;
    }

    private String checkIfRemovePaddingMembers(String parentPath) {
        if (parentPath.endsWith(BLANK_FILLER_NAME)) {
            int lastIdx = parentPath.lastIndexOf(BLANK_FILLER_NAME);
            return this.checkIfRemovePaddingMembers(parentPath.substring(0, lastIdx));
        }
        return parentPath;
    }

    private String getCaptionFromParent(IValue[] values, LevelInfo levelInfo, LevelInfo[] levelInfos) {
        int levelNumber = levelInfo.getLevelNumber();
        if (levelNumber > 0 && levelNumber < levelInfos.length) {
            LevelInfo parentLevelInfo = levelInfos[levelNumber - 1];
            IValue value = values[parentLevelInfo.getCaptionColumnIndex()];
            if (!value.isNull()) {
                return value.toString();
            }
            return this.getCaptionFromParent(values, parentLevelInfo, levelInfos);
        }
        return values[levelInfo.getCaptionColumnIndex()].toString();
    }

    private void printRow(IValue[] values, int count) {
        StringBuilder sb = new StringBuilder();
        sb.append("Row[" + count + "]: ");
        int index = 0;
        for (IValue value : values) {
            sb.append(value.toString());
            if (index >= values.length) continue;
            sb.append(", ");
            ++index;
        }
        System.out.println(sb.toString());
    }

    private boolean getHasAllMember(Element hierElement) {
        String value = hierElement.attributeValue(HAS_ALL_LEVEL_ATTRIBUTE_NAME);
        return YES.equalsIgnoreCase(value);
    }

    private MemberInfo createAllMemberInfo(boolean isCubingServicesCompatible, boolean isRecursiveHierarchy, String dimName, String hierName, Element rolapModelElement, RequestLocales requestLocales) {
        Element hierElement = this.getHierarchyElement(rolapModelElement, hierName);
        return this.generateAllMemberInfo(isCubingServicesCompatible, isRecursiveHierarchy, dimName, hierName, hierElement, requestLocales);
    }

    private MemberInfo generateAllMemberInfo(boolean isCubingServicesCompatible, boolean isRecursive, String dimName, String hierName, Element hierElement, RequestLocales requestLocales) {
        String allLevelName = this.getAllLevelName(hierElement, requestLocales);
        String[] firstModelItem = isRecursive ? new String[]{dimName, hierName} : new String[]{dimName, hierName, allLevelName};
        String allMemberName = hierElement.attributeValue(ALL_MEMBER_NAME_ATTRIBUTE_NAME);
        if (allMemberName == null) {
            allMemberName = "All";
        }
        String[] secondModelItem = isCubingServicesCompatible ? new String[]{hierName} : new String[]{dimName, hierName};
        String allMemberCaption = null;
        List allMemberCaptionElements = hierElement.elements(ALLMEMBERCAPTION_TAG);
        allMemberCaption = this.getAllMemberCaption(allMemberCaptionElements, requestLocales.getModelDefaultLocale());
        if (allMemberCaption == null) {
            allMemberCaption = allMemberName;
        }
        MemberInfo memberInfo = new MemberInfo(allMemberCaption);
        memberInfo.setName(allMemberName);
        memberInfo.setFirstModelItem(firstModelItem);
        memberInfo.setSecondModelItem(secondModelItem);
        memberInfo.setPath(UniqueNameGenerator.createUniqueName(allMemberName));
        memberInfo.setLevelKeys(null);
        return memberInfo;
    }

    private String getAllMemberCaption(List allMemberCaptionElements, String modelDefaultLocale) {
        if (allMemberCaptionElements != null && allMemberCaptionElements.size() > 0) {
            for (int index = 0; index < allMemberCaptionElements.size(); ++index) {
                Element allMemberCaptionElem = (Element)allMemberCaptionElements.get(index);
                String locale = allMemberCaptionElem.attributeValue(LOCALE_ATTR);
                if (!locale.equals(modelDefaultLocale)) continue;
                return allMemberCaptionElem.getText();
            }
        }
        return null;
    }

    private String getAllLevelName(List allLevelNameElements, String modelDefaultLocale) {
        if (allLevelNameElements != null && allLevelNameElements.size() > 0) {
            for (int index = 0; index < allLevelNameElements.size(); ++index) {
                String c8StyleLocaleString;
                Element allLevelNameElm = (Element)allLevelNameElements.get(index);
                String locale = allLevelNameElm.attributeValue(LOCALE_ATTR);
                if (!locale.equals(c8StyleLocaleString = LocaleConverter.localeToStr(LocaleConverter.strToLocale(modelDefaultLocale)))) continue;
                return allLevelNameElm.getText();
            }
        }
        return null;
    }

    private LevelInfo[] getLevelAttributesAndName(Element rolapModelElement, String hierarchyName, List<SelectAttribute> selectAttributes, List<SortAttribute> sortAttributes) {
        Element dimensionElement = rolapModelElement.element(DIM_NAME);
        Element hierElement = this.getHierarchyElement(rolapModelElement, hierarchyName);
        Map<String, SelectAttribute> attributesMap = this.createSelectAttributeMap(dimensionElement.elements(ATTRIBUTE_ELEMENT_NAME));
        List levelRefElements = hierElement.elements(LEVEL_REF_ELEMENT_NAME);
        LevelInfo[] levelInfos = new LevelInfo[levelRefElements.size()];
        for (int levelIdx = 0; levelIdx < levelRefElements.size(); ++levelIdx) {
            Element levelRefElement = (Element)levelRefElements.get(levelIdx);
            levelInfos[levelIdx] = this.getLevelInfo(selectAttributes, sortAttributes, dimensionElement, attributesMap, levelRefElement, levelIdx);
        }
        this.setupMUNs(dimensionElement, levelRefElements, levelInfos);
        return levelInfos;
    }

    private int getLevelCount(Element rolapModelElement, String hierarchyName) {
        Element dimensionElement = rolapModelElement.element(DIM_NAME);
        Element hierElement = this.getHierarchyElement(rolapModelElement, hierarchyName);
        List levelRefElements = hierElement.elements(LEVEL_REF_ELEMENT_NAME);
        return levelRefElements.size();
    }

    public void setupMUNs(Element dimensionElement, List levelRefElements, LevelInfo[] levelInfos) {
        HashSet<String> ancestorLevelKeys = new HashSet<String>();
        for (int levelIdx = 0; levelIdx < levelRefElements.size(); ++levelIdx) {
            Element levelRefElement = (Element)levelRefElements.get(levelIdx);
            Element levelElement = this.getLevelElement(dimensionElement, levelRefElement.attributeValue(NAME));
            List levelKeyRefList = levelElement.elements(LEVEL_KEY_REF_ELEMENT_NAME);
            boolean[] bKeys = new boolean[levelKeyRefList.size()];
            for (int index = 0; index < levelKeyRefList.size(); ++index) {
                Element leveKeyRefElement = (Element)levelKeyRefList.get(index);
                String attributeName = leveKeyRefElement.attributeValue(NAME);
                bKeys[index] = !ancestorLevelKeys.contains(attributeName);
                ancestorLevelKeys.add(attributeName);
            }
            levelInfos[levelIdx].setMUNKeys(bKeys);
        }
    }

    private LevelInfo getRootLevelAttributesAndName(Element rolapModelElement, String hierarchyName, List<SelectAttribute> selectAttributes, List<SortAttribute> sortAttributes) {
        Element dimensionElement = rolapModelElement.element(DIM_NAME);
        Element hierElement = this.getHierarchyElement(rolapModelElement, hierarchyName);
        Map<String, SelectAttribute> attributesMap = this.createSelectAttributeMap(dimensionElement.elements(ATTRIBUTE_ELEMENT_NAME));
        Element rootLevelRefElement = (Element)hierElement.elements(LEVEL_REF_ELEMENT_NAME).get(0);
        return this.getLevelInfo(selectAttributes, sortAttributes, dimensionElement, attributesMap, rootLevelRefElement, 0);
    }

    private boolean isRecursiveHierarchy(Element hierElement) {
        String deploymentType = hierElement.attributeValue(DEPLOYMENT_ATTR_NAME);
        return deploymentType != null && deploymentType.equals(RECURSIVE);
    }

    private LevelInfo getLevelInfo(List<SelectAttribute> selectAttributes, List<SortAttribute> sortAttributes, Element dimensionElement, Map<String, SelectAttribute> attributesMap, Element levelRefElement, int levelNumber) {
        LevelInfo levelInfo = new LevelInfo(selectAttributes, sortAttributes, dimensionElement, attributesMap, levelRefElement, levelNumber);
        return levelInfo;
    }

    private Element getLevelElement(Element dimensionElement, String levelName) {
        List levelElements = dimensionElement.elements(LEVEL_ELEMENT_NAME);
        for (int index = 0; index < levelElements.size(); ++index) {
            Element levelElement = (Element)levelElements.get(index);
            if (!levelName.equals(levelElement.attributeValue(NAME))) continue;
            return levelElement;
        }
        return null;
    }

    private Map<String, SelectAttribute> createSelectAttributeMap(List elements) {
        HashMap<String, SelectAttribute> map = new HashMap<String, SelectAttribute>();
        if (elements != null) {
            for (int index = 0; index < elements.size(); ++index) {
                Element attributeElement = (Element)elements.get(index);
                String name = attributeElement.attributeValue(NAME);
                String queryItem = attributeElement.element(QUERY_ITEM_ELEMENT_NAME).attributeValue(REFOBJECT_ATTRIBUTE_NAME);
                SelectAttribute sa = new SelectAttribute(name, queryItem);
                map.put(name, sa);
            }
        }
        return map;
    }

    private MetadataConnection getMetadataConnection(String relModelPath, ExecutionEnvironment execEnv) {
        return MetadataService.getInstance().getConnection("MFW4J", relModelPath, execEnv, true);
    }

    private V5QuerySet createV5QuerySet(PlanningEnvironment planEnv, String relModelPath, List<SelectAttribute> selectAttributes, List<SortAttribute> sortAttributes, String[] queryItems, String[] levelKeys) {
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        XQETrace trace = planEnv.getTrace();
        boolean loggingOn = (trace.getTraceLevel() & 0x100) != 0;
        trace.removeTraceLevel(256);
        MetricsService.startCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        V5QuerySet v5QuerySet = (V5QuerySet)nodeFactory.createV5Node("querySet");
        planEnv.getNodeIndex().addNode(v5QuerySet);
        v5QuerySet.setPropertyValue(EXPRESSION_LOCALE_ATTRIBUTE_NAME, LocaleConverter.localeToStr(reqEnv.getExpressionLocale()));
        String modelPath = relModelPath;
        v5QuerySet.setPropertyValue("modelPath", modelPath);
        ((RequestEnvironment)planEnv.getRequestEnvironment()).setModelPath(modelPath);
        IXQEQueryNode query = nodeFactory.createNode(101006);
        query.setPropertyValue(NAME, QUERY_NAME);
        query.setPropertyValue(V5Query.QueryHint.EXECUTION_OPTIMIZATION.getPropertyName(), "allRows");
        query.setPropertyValue(V5Query.QueryHint.QUERY_PROCESSING.getPropertyName(), "minimizeLocal");
        query.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), false);
        query.setPropertyValue("containsQueryHint", true);
        v5QuerySet.addChild(query);
        IXQEQueryNode selection = nodeFactory.createNode(101009);
        selection.setPropertyValue("autoSummary", false);
        query.addChild(selection);
        IXQEQueryNode source = nodeFactory.createNode(101007);
        source.setPropertyValue("relational", true);
        query.addChild(source);
        IXQEQueryNode groupBody = nodeFactory.createNode(101051);
        groupBody.setPropertyValue(NAME, QUERY_NAME);
        if (queryItems != null && levelKeys != null) {
            for (int index = 0; index < queryItems.length; ++index) {
                V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
                detailFilter.setBooleanPropertyValue("postAutoAggregation", "false");
                query.addChild(detailFilter);
                boolean bIsItemNumeric = FMRequestAdapter.isItemNumeric(planEnv, queryItems[index]);
                IXQEQueryNode filterExpression = nodeFactory.createNode(101013);
                filterExpression.setPropertyValue("expression", FMRequestAdapter.createINExpressionForMembers(queryItems[index], levelKeys[index], !bIsItemNumeric));
                detailFilter.addChild(filterExpression);
            }
        }
        for (SelectAttribute selectAttribute : selectAttributes) {
            IXQEQueryNode dataItem = nodeFactory.createNode(101003);
            String dataItemName = selectAttribute.getName();
            dataItem.setPropertyValue(NAME, dataItemName);
            dataItem.setPropertyValue("aggregate", "none");
            selection.addChild(dataItem);
            IXQEQueryNode expression = nodeFactory.createNode(101004);
            expression.setPropertyValue("expression", selectAttribute.getQueryItem());
            dataItem.addChild(expression);
            IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", dataItemName);
            groupBody.addChild(dataItemRef);
        }
        IXQEQueryNode qrd = nodeFactory.createNode(101055);
        qrd.setPropertyValue(NAME, QUERY_NAME);
        qrd.setPropertyValue("refQuery", QUERY_NAME);
        v5QuerySet.addChild(qrd);
        IXQEQueryNode edge = nodeFactory.createNode(101049);
        edge.setPropertyValue(NAME, QUERY_NAME);
        qrd.addChild(edge);
        IXQEQueryNode edgeGroup = nodeFactory.createNode(101050);
        edge.addChild(edgeGroup);
        V5ValueSet valueSet = (V5ValueSet)nodeFactory.createNode(101057);
        valueSet.setNameProperty(QUERY_NAME);
        valueSet.addChild(groupBody);
        edgeGroup.addChild(valueSet);
        for (SortAttribute sortObject : sortAttributes) {
            String refDataItemName = sortObject.getName();
            String sortOrder = "ascending";
            refDataItemName = sortObject.getName();
            String sortDirection = sortObject.getSortDirection();
            if ("desc".equals(sortDirection)) {
                sortOrder = "descending";
            } else if ("asc".equals(sortDirection)) {
                sortOrder = "ascending";
            }
            IXQEQueryNode sortItem = nodeFactory.createNode(101056);
            sortItem.setPropertyValue("refDataItem", refDataItemName);
            sortItem.setPropertyValue("sortOrder", sortOrder);
            valueSet.addChild(sortItem);
        }
        planEnv.setRoot(v5QuerySet);
        MetricsService.endCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        if (loggingOn) {
            trace.addTraceLevel(256);
        }
        planEnv.resetTreeHasBeenModified();
        return v5QuerySet;
    }

    public static boolean isItemNumeric(PlanningEnvironment env, String itemName) {
        List<IMetadata> mdList;
        IMetadataConnection iConn;
        MetadataConnection mdConn = env.getMetadataConnection();
        if (mdConn == null && null != env.getRequestEnvironment() && null != ((RequestEnvironment)env.getRequestEnvironment()).getExecutionEnvironment() && null != ((ExecutionEnvironment)((RequestEnvironment)env.getRequestEnvironment()).getExecutionEnvironment()).getMetadataConnection() && (iConn = ((ExecutionEnvironment)((RequestEnvironment)env.getRequestEnvironment()).getExecutionEnvironment()).getMetadataConnection()) instanceof MetadataConnection) {
            mdConn = (MetadataConnection)iConn;
        }
        if (null != mdConn && (mdList = mdConn.getEntities()) != null && mdList.size() != 0) {
            for (IMetadata mdItem : mdList) {
                List<IMetadata> qiList;
                IQuerySubject qs;
                if (!(mdItem instanceof IQuerySubject) || -1 == itemName.indexOf((qs = (IQuerySubject)mdItem).getV5UniqueName()) || (qiList = qs.getQueryItemsAndMeasures()) == null || qiList.size() == 0) continue;
                for (IMetadata qi : qiList) {
                    if (!qi.getV5UniqueName().equals(itemName)) continue;
                    return qi.getDataType().isNumeric();
                }
            }
        }
        return false;
    }

    public static String createINExpressionForMembers(String column, String value, boolean useQuotes) {
        StringBuilder tempExprBuilder = new StringBuilder();
        StringBuilder finalExprBuilder = new StringBuilder();
        if (value.equals(BLANK)) {
            useQuotes = false;
            value = null;
        }
        int countOrs = 0;
        boolean appendIsNull = false;
        int inCntr = 0;
        finalExprBuilder.append('(');
        tempExprBuilder.append(column);
        if (useQuotes) {
            tempExprBuilder.append(" in (").append('\'');
        } else {
            tempExprBuilder.append(" in (");
        }
        if (value == null) {
            appendIsNull = true;
        } else {
            if (inCntr > 0 && inCntr % 250 == 0) {
                if (useQuotes) {
                    tempExprBuilder.append('\'').append(") or ");
                    tempExprBuilder.append(column);
                    tempExprBuilder.append(" in (").append('\'');
                } else {
                    tempExprBuilder.append(") or ");
                    tempExprBuilder.append(column);
                    tempExprBuilder.append(" in (");
                }
                ++countOrs;
            } else if (inCntr > 0) {
                if (useQuotes) {
                    tempExprBuilder.append("','");
                } else {
                    tempExprBuilder.append(",");
                }
            }
            ++inCntr;
            tempExprBuilder.append(ROLAPQuery.escapeSQLString(value));
        }
        if (inCntr != 0) {
            if (useQuotes) {
                tempExprBuilder.append('\'').append(')');
            } else {
                tempExprBuilder.append(')');
            }
            finalExprBuilder.append((CharSequence)tempExprBuilder);
        }
        if (appendIsNull) {
            if (inCntr != 0) {
                finalExprBuilder.append(" or ");
            }
            finalExprBuilder.append(column).append(" is NULL");
        }
        finalExprBuilder.append(')');
        return finalExprBuilder.toString();
    }

    private List<ExpressionInfo> getValidateExpressions(Element operationElement, PlanningEnvironment planEnv) {
        Element expressionsExpression = operationElement.element(EXPRESSIONS);
        List standaloneExpressionList = expressionsExpression.elements(STANDALONE_EXPRESSION_ELEMENT_NAME);
        ArrayList<ExpressionInfo> expressionInfoList = new ArrayList<ExpressionInfo>();
        if (standaloneExpressionList != null) {
            for (int index = 0; index < standaloneExpressionList.size(); ++index) {
                Element standAloneExpressionElement = (Element)standaloneExpressionList.get(index);
                String id = standAloneExpressionElement.attributeValue(ID_ATTRIBUTE_NAME);
                String expressionLocale = standAloneExpressionElement.attributeValue(EXPRESSION_LOCALE_ATTRIBUTE_NAME);
                String expression = standAloneExpressionElement.getText();
                expressionInfoList.add(this.generateExpressionInfo(id, expression, expressionLocale, planEnv));
            }
        }
        return expressionInfoList;
    }

    private ExpressionInfo generateExpressionInfo(String id, String v5Expression, String expressionLocaleString, PlanningEnvironment planEnv) {
        boolean hasError = false;
        String message = null;
        Locale expressionLocale = expressionLocaleString == null ? ((RequestEnvironment)planEnv.getRequestEnvironment()).getRunLocale() : LocaleConverter.strToLocale(expressionLocaleString);
        try {
            IXQEQueryNode queryNode = null;
            queryNode = v5Expression.contains("#") ? RQPUtilities.createV5ValueExpression(v5Expression, planEnv, null, expressionLocale) : V5ExpressionProcessor.parse(v5Expression, planEnv, expressionLocale);
            hasError = queryNode.isValidPlannedQuery() == -1;
        }
        catch (Exception e) {
            hasError = true;
            message = e.getMessage();
        }
        return new ExpressionInfo(id, hasError, message);
    }

    @Override
    public String getOperationName() {
        return ROLAP_FM_SOAP_OP_NAME;
    }

    @Override
    protected boolean requiresCancelableRegistration() {
        return false;
    }

    @Override
    public boolean requiresMultiRequestContext() {
        return false;
    }

    class CurrentPeriodInfo {
        private final MemberInfo currentPeriod;
        private final int currentPeriodIdx;
        private final MemberInfo priorPeriod;
        private final MemberInfo nextPeriod;

        CurrentPeriodInfo(RequestInfo reqInfo, LevelInfo childrenLevelInfo, List<MemberInfo> siblings, boolean isAllOrRootLevel) {
            List<MemberInfo> currentPeriodChildren = this.getPeriodChildren(reqInfo, reqInfo.getCurrentPeriodKeys(), childrenLevelInfo);
            List<MemberInfo> priorPeriodChildren = this.getPeriodChildren(reqInfo, reqInfo.getPriorPeriodKeys(), childrenLevelInfo);
            List<MemberInfo> nextPeriodChildren = this.getPeriodChildren(reqInfo, reqInfo.getNextPeriodKeys(), childrenLevelInfo);
            int currentPeriodMemberIdx = -1;
            MemberInfo currentPeriodMemberInfo = null;
            MemberInfo priorPeriodMemberInfo = null;
            MemberInfo nextPeriodMemberInfo = null;
            if (currentPeriodChildren != null && currentPeriodChildren.size() > 0) {
                currentPeriodMemberInfo = this.getCurrentPeriodMember(reqInfo.getRelModelPath(), reqInfo.getRelativeTimeMemberType(), (ExecutionEnvironment)reqInfo.getRequestEnvironment().getExecutionEnvironment(), reqInfo.getRequestEnvironment(), childrenLevelInfo, reqInfo.getLevelInfos(), currentPeriodChildren);
                currentPeriodMemberIdx = this.getCurrentPeriodMemberIndex(currentPeriodMemberInfo, currentPeriodChildren);
                if (FMRequestAdapter.this.isShowRelativeTimePriorPeriodMembers(reqInfo.getModelHierarchyElement())) {
                    if (currentPeriodMemberIdx == 0 && priorPeriodChildren != null) {
                        priorPeriodMemberInfo = priorPeriodChildren.get(priorPeriodChildren.size() - 1);
                    } else if (currentPeriodMemberIdx > 0) {
                        priorPeriodMemberInfo = currentPeriodChildren.get(currentPeriodMemberIdx - 1);
                    }
                }
                if (FMRequestAdapter.this.isShowRelativeTimeNextPeriodMembers(reqInfo.getModelHierarchyElement())) {
                    if (currentPeriodMemberIdx == currentPeriodChildren.size() - 1 && nextPeriodChildren != null) {
                        nextPeriodMemberInfo = nextPeriodChildren.get(0);
                    } else if (currentPeriodMemberIdx < siblings.size() - 1) {
                        nextPeriodMemberInfo = currentPeriodChildren.get(currentPeriodMemberIdx + 1);
                    }
                }
            } else if (isAllOrRootLevel) {
                currentPeriodMemberInfo = this.getCurrentPeriodMember(reqInfo.getRelModelPath(), reqInfo.getRelativeTimeMemberType(), (ExecutionEnvironment)reqInfo.getRequestEnvironment().getExecutionEnvironment(), reqInfo.getRequestEnvironment(), childrenLevelInfo, reqInfo.getLevelInfos(), siblings);
                currentPeriodMemberIdx = this.getCurrentPeriodMemberIndex(currentPeriodMemberInfo, siblings);
                if (FMRequestAdapter.this.isShowRelativeTimePriorPeriodMembers(reqInfo.getModelHierarchyElement()) && currentPeriodMemberIdx > 0) {
                    priorPeriodMemberInfo = siblings.get(currentPeriodMemberIdx - 1);
                }
                if (FMRequestAdapter.this.isShowRelativeTimeNextPeriodMembers(reqInfo.getModelHierarchyElement()) && currentPeriodMemberIdx < siblings.size() - 1) {
                    nextPeriodMemberInfo = siblings.get(currentPeriodMemberIdx + 1);
                }
            }
            this.currentPeriod = currentPeriodMemberInfo;
            this.currentPeriodIdx = currentPeriodMemberIdx;
            this.priorPeriod = priorPeriodMemberInfo;
            this.nextPeriod = nextPeriodMemberInfo;
        }

        private MemberInfo getCurrentPeriodMember(String relModelPath, int rtMemberType, ExecutionEnvironment execEnv, RequestEnvironment reqEnv, LevelInfo levelInfo, LevelInfo[] levelInfos, List<MemberInfo> memberInfos) {
            int levelIdx;
            String cpExpression = null;
            for (levelIdx = levelInfo.getLevelNumber(); levelIdx <= levelInfos.length - 1 && ((cpExpression = levelInfos[levelIdx].getCurrentPeriodExpression()) == null || cpExpression.isEmpty()); ++levelIdx) {
            }
            if (cpExpression == null || cpExpression.isEmpty()) {
                return memberInfos.get(memberInfos.size() - 1);
            }
            if (levelIdx > levelInfo.getLevelNumber()) {
                return memberInfos.get(memberInfos.size() - 1);
            }
            String cpMemberName = this.getCurrentPeriodMemberName(relModelPath, execEnv, reqEnv, cpExpression, levelInfos[levelIdx]);
            if (cpMemberName == null || cpMemberName.isEmpty()) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidCurrentPeriodExpression, levelInfos[levelIdx].getLevelName());
            }
            MemberInfo cpMemberInfo = null;
            for (MemberInfo memInfo : memberInfos) {
                if (!memInfo.getName().equals(cpMemberName)) continue;
                cpMemberInfo = memInfo;
                break;
            }
            if (cpMemberInfo == null) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidCurrentPeriodExpression, levelInfos[levelIdx].getLevelName());
            }
            return cpMemberInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getCurrentPeriodMemberName(String relModelPath, ExecutionEnvironment execEnv, RequestEnvironment reqEnv, String cpExpression, LevelInfo levelInfo) {
            PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
            ArrayList<SelectAttribute> selAttrList = new ArrayList<SelectAttribute>();
            selAttrList.add(new SelectAttribute("cpMember", cpExpression));
            ArrayList sortAttrList = new ArrayList();
            RSAPIDataset dataSet = FMRequestAdapter.this.createV5QueryandGetDataset(relModelPath, planEnv, null, selAttrList, sortAttrList, null);
            if (dataSet == null) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidCurrentPeriodExpression, levelInfo.getLevelName());
            }
            try (IROLAPQueryResultIterator rsIter = ROLAPQueryResultIteratorFactory.getIterator(dataSet, execEnv);){
                if (!rsIter.hasNext()) {
                    throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidCurrentPeriodExpression, levelInfo.getLevelName());
                }
                IValue[] values = rsIter.next().getColumns();
                IValue v = values[0];
                String cpMemberName = v.toString();
                String[] parts = UniqueNameParser.parseNoThrow(cpMemberName);
                if (parts != null && parts.length > 0) {
                    String string = parts[parts.length - 1];
                    return string;
                }
                String string = cpMemberName;
                return string;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<MemberInfo> getPeriodChildren(RequestInfo reqInfo, String[] periodKeys, LevelInfo childrenLevelInfo) {
            RSAPIDataset ppDataset;
            List periodChildren = null;
            if (periodKeys != null && (ppDataset = FMRequestAdapter.this.createV5QueryandGetDataset(reqInfo.getRelModelPath(), reqInfo.getNewPlanningEnvironment(), periodKeys, reqInfo.getSelectAttributes(), reqInfo.getSortAttributes(), reqInfo.getReqLevelQueryItems())) != null) {
                try (IROLAPQueryResultIterator ppResultIterator = ROLAPQueryResultIteratorFactory.getIterator(ppDataset, (ExecutionEnvironment)reqInfo.getRequestEnvironment().getExecutionEnvironment());){
                    periodChildren = FMRequestAdapter.this.getChildrenMemberNames(ppResultIterator, reqInfo.getParentPath(), childrenLevelInfo, reqInfo.getLevelInfos(), reqInfo.getIsCubingServicesCompatible(), reqInfo.getIsFillerInheritsCaptionFromParent());
                }
            }
            return periodChildren;
        }

        private int getCurrentPeriodMemberIndex(MemberInfo cpMemberInfo, List<MemberInfo> levelSiblings) {
            if (cpMemberInfo == null) {
                return -1;
            }
            for (int i = 0; i < levelSiblings.size(); ++i) {
                MemberInfo memInfo = levelSiblings.get(i);
                if (!memInfo.getName().equalsIgnoreCase(cpMemberInfo.getName())) continue;
                return i;
            }
            return -1;
        }

        public MemberInfo getCurrentPeriod() {
            return this.currentPeriod;
        }

        public int getCurrentPeriodIndex() {
            return this.currentPeriodIdx;
        }

        public MemberInfo getPriorPeriod() {
            return this.priorPeriod;
        }

        public MemberInfo getNextPeriod() {
            return this.nextPeriod;
        }
    }

    class RequestInfo {
        private String relationalModelPath;
        private Element hierarchyElement;
        private RequestLocales requestLocales;
        private int[] range;
        private String dimensionName;
        private String hierarchyName;
        private boolean hierHasAllMember;
        private int relativeTimeMemberType;
        private String[] keys;
        private String[] currentPeriodKeys;
        private String[] priorPeriodKeys;
        private String[] nextPeriodKeys;
        private LevelInfo reqLevelInfo;
        private List<SelectAttribute> selectAttributes;
        private List<SortAttribute> sortAttributes;
        private String levelNameFromMUN;
        private LevelInfo[] levelInfos;
        private String parentPath;
        private boolean isCubingServicesCompatible;
        private boolean isFillerInheritsCaptionFromParent;
        private boolean isRecursiveHierarchy;
        private boolean isCalcMember;
        private RequestEnvironment requestEnvironment;

        RequestInfo(Element queryOperationElement, String relModelPath, Element rolapModelElement, int[] reqRange, PlanningEnvironment planEnv, RequestLocales reqLocales) throws Exception {
            Document doc;
            List keyElements;
            String levelKeysTxt;
            this.relationalModelPath = relModelPath;
            this.requestLocales = reqLocales;
            this.range = reqRange;
            Element dimNameElement = queryOperationElement.element(FMRequestAdapter.DIM_NAME);
            this.dimensionName = dimNameElement.getText();
            Element hierNameElement = queryOperationElement.element(FMRequestAdapter.HIER_NAME);
            this.hierarchyName = hierNameElement.getText();
            this.hierarchyElement = FMRequestAdapter.this.getHierarchyElement(rolapModelElement, this.hierarchyName);
            this.isCubingServicesCompatible = FMRequestAdapter.this.isCubingServicesCompatible(queryOperationElement);
            this.isFillerInheritsCaptionFromParent = FMRequestAdapter.this.isFillerInheritsCaptionFromParent(this.hierarchyElement);
            this.isRecursiveHierarchy = FMRequestAdapter.this.isRecursiveHierarchy(this.hierarchyElement);
            Element munElement = queryOperationElement.element(FMRequestAdapter.MUN_ELEMENT_NAME);
            if (munElement != null) {
                this.levelNameFromMUN = FMRequestAdapter.this.getLevelName(munElement);
                this.parentPath = munElement.element(FMRequestAdapter.PATH_ELEMENT_NAME).getText();
            }
            this.hierHasAllMember = FMRequestAdapter.this.getHasAllMember(this.hierarchyElement);
            Element levelKeysElement = queryOperationElement.element(FMRequestAdapter.LEVEL_KEYS_ELEMENT_NAME);
            if (levelKeysElement != null && (levelKeysTxt = levelKeysElement.getText()) != null && levelKeysTxt.length() > 0 && (keyElements = (doc = DocumentHelper.parseText((String)(FMRequestAdapter.START_ROOT_TAG + levelKeysTxt + FMRequestAdapter.END_ROOT_TAG))).getRootElement().elements(FMRequestAdapter.KEY_ELEMENT_NAME)).size() > 0) {
                int keyIdx = 0;
                String levelKey = ((Element)keyElements.get(keyIdx)).getText();
                if (levelKey.contains(FMRequestAdapter.CALC_MEM_KEY)) {
                    this.isCalcMember = true;
                    return;
                }
                if (levelKey.contains(FMRequestAdapter.RELATIVE_TIME_MEM_KEY)) {
                    this.relativeTimeMemberType = FMRequestAdapter.this.getRelativeTimeTypeID(levelKey);
                    ++keyIdx;
                }
                ArrayList<String> keysList = new ArrayList<String>();
                while (keyIdx < keyElements.size() && !(levelKey = ((Element)keyElements.get(keyIdx)).getText()).contains(FMRequestAdapter.RELATIVE_TIME_MEM_KEY)) {
                    keysList.add(levelKey);
                    ++keyIdx;
                }
                if (keysList.size() > 0) {
                    this.keys = keysList.toArray(new String[keysList.size()]);
                }
                if (keyIdx < keyElements.size() && levelKey.equals(FMRequestAdapter.RELATIVE_TIME_CURRENT_PERIOD_KEY)) {
                    ++keyIdx;
                    keysList.clear();
                    while (keyIdx < keyElements.size() && !(levelKey = ((Element)keyElements.get(keyIdx)).getText()).contains(FMRequestAdapter.RELATIVE_TIME_MEM_KEY)) {
                        keysList.add(levelKey);
                        ++keyIdx;
                    }
                    if (keysList.size() > 0) {
                        this.currentPeriodKeys = keysList.toArray(new String[keysList.size()]);
                    }
                }
                if (keyIdx < keyElements.size() && levelKey.equals(FMRequestAdapter.RELATIVE_TIME_PRIOR_PERIOD_KEY)) {
                    ++keyIdx;
                    keysList.clear();
                    while (keyIdx < keyElements.size() && !(levelKey = ((Element)keyElements.get(keyIdx)).getText()).contains(FMRequestAdapter.RELATIVE_TIME_MEM_KEY)) {
                        keysList.add(levelKey);
                        ++keyIdx;
                    }
                    if (keysList.size() > 0) {
                        this.priorPeriodKeys = keysList.toArray(new String[keysList.size()]);
                    }
                }
                if (keyIdx < keyElements.size() && levelKey.equals(FMRequestAdapter.RELATIVE_TIME_NEXT_PERIOD_KEY)) {
                    ++keyIdx;
                    keysList.clear();
                    while (keyIdx < keyElements.size() && !(levelKey = ((Element)keyElements.get(keyIdx)).getText()).contains(FMRequestAdapter.RELATIVE_TIME_MEM_KEY)) {
                        keysList.add(levelKey);
                        ++keyIdx;
                    }
                    if (keysList.size() > 0) {
                        this.nextPeriodKeys = keysList.toArray(new String[keysList.size()]);
                    }
                }
            }
            this.selectAttributes = new ArrayList<SelectAttribute>();
            this.sortAttributes = new ArrayList<SortAttribute>();
            if (queryOperationElement.getName().equals(FMRequestAdapter.QUERY_HIERARCHY_ROOTS_ELEMENT_NAME)) {
                this.reqLevelInfo = FMRequestAdapter.this.getRootLevelAttributesAndName(rolapModelElement, this.hierarchyName, this.selectAttributes, this.sortAttributes);
                ArrayList selectAttr = new ArrayList();
                ArrayList sortAttr = new ArrayList();
                this.levelInfos = FMRequestAdapter.this.getLevelAttributesAndName(rolapModelElement, this.hierarchyName, selectAttr, sortAttr);
            } else {
                this.levelInfos = FMRequestAdapter.this.getLevelAttributesAndName(rolapModelElement, this.hierarchyName, this.selectAttributes, this.sortAttributes);
                this.reqLevelInfo = FMRequestAdapter.this.getLevelInfo(this.levelNameFromMUN, this.levelInfos);
            }
            this.requestEnvironment = (RequestEnvironment)planEnv.getRequestEnvironment();
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public String getHierarchyName() {
            return this.hierarchyName;
        }

        public int getRelativeTimeMemberType() {
            return this.relativeTimeMemberType;
        }

        public String[] getKeys() {
            return this.keys;
        }

        public String[] getCurrentPeriodKeys() {
            return this.currentPeriodKeys;
        }

        public String[] getPriorPeriodKeys() {
            return this.priorPeriodKeys;
        }

        public String[] getNextPeriodKeys() {
            return this.nextPeriodKeys;
        }

        public LevelInfo getReqLevelInfo() {
            return this.reqLevelInfo;
        }

        public List<SelectAttribute> getSelectAttributes() {
            return this.selectAttributes;
        }

        public List<SortAttribute> getSortAttributes() {
            return this.sortAttributes;
        }

        public String getLevelNameFromMUN() {
            return this.levelNameFromMUN;
        }

        public LevelInfo[] getLevelInfos() {
            return this.levelInfos;
        }

        public String getParentPath() {
            return this.parentPath;
        }

        public boolean getIsCubingServicesCompatible() {
            return this.isCubingServicesCompatible;
        }

        public boolean getIsFillerInheritsCaptionFromParent() {
            return this.isFillerInheritsCaptionFromParent;
        }

        public boolean getIsCalcMember() {
            return this.isCalcMember;
        }

        public String[] getReqLevelQueryItems() {
            String[] queryItems = null;
            if (this.keys != null) {
                queryItems = this.reqLevelInfo.getLevelQueryItems();
            }
            return queryItems;
        }

        public RequestEnvironment getRequestEnvironment() {
            return this.requestEnvironment;
        }

        public PlanningEnvironment getNewPlanningEnvironment() {
            return QueryPlanner.setupEnvironment(this.requestEnvironment);
        }

        public ExecutionEnvironment getExecutionEnvironmet() {
            return (ExecutionEnvironment)this.requestEnvironment.getExecutionEnvironment();
        }

        public String getRelModelPath() {
            return this.relationalModelPath;
        }

        public Element getModelHierarchyElement() {
            return this.hierarchyElement;
        }

        public RequestLocales getRequestLocales() {
            return this.requestLocales;
        }

        public int[] getRange() {
            return this.range;
        }

        public boolean getHierarchyHasAllMember() {
            return this.hierHasAllMember;
        }

        public boolean getIsRecursiveHierarchy() {
            return this.isRecursiveHierarchy;
        }
    }

    class ROLAPVirtualCubeModel {
        private static final int LEVEL_NAME_IDX = 3;
        ROLAPVirtualDimension tempVirtualDim;
        String vcCubeName;
        ROLAPCube[] sourceCubes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ROLAPVirtualCubeModel(String dimName, Element rolapModelElement, RequestLocales requestLocales) throws Exception {
            Element virtualCubeXMLElement = rolapModelElement.element(FMRequestAdapter.VIRTUALCUBE);
            Provider provider = Provider.getProvider(ROLAPProvider.class.getName());
            this.sourceCubes = this.getSourceCubes(virtualCubeXMLElement);
            ROLAPVirtualCubeDef rolapVirtualCubeDef = new ROLAPVirtualCubeDef(virtualCubeXMLElement, provider, this.sourceCubes, requestLocales.getModelDefaultLocale());
            ROLAPCubeReservation[] res = ROLAPVirtualCube.reserveSourceCubes(this.sourceCubes);
            try {
                this.vcCubeName = virtualCubeXMLElement.attributeValue(FMRequestAdapter.NAME);
                DummyVirtualCube dvc = new DummyVirtualCube(this.vcCubeName, rolapVirtualCubeDef);
                rolapVirtualCubeDef.initializeConfig();
                IDimension[] sourceDimensions = rolapVirtualCubeDef.getSourceDimensions(dimName);
                this.tempVirtualDim = new ROLAPVirtualDimension(sourceDimensions, dimName, dvc);
            }
            finally {
                ROLAPVirtualCube.unreserveSourceCubes(res);
            }
        }

        public String getVirtualCubeName() {
            return this.vcCubeName;
        }

        private ROLAPCube[] getSourceCubes(Element virtualCubeXMLElement) throws Exception {
            List sourceCubeRefs = virtualCubeXMLElement.elements("sourceCubeRef");
            ROLAPCube[] mSourceCubes = new ROLAPCube[sourceCubeRefs.size()];
            ArrayList<String> mSourceCubeNames = new ArrayList<String>();
            for (Element sourceCubeRef : sourceCubeRefs) {
                mSourceCubeNames.add(sourceCubeRef.attributeValue(FMRequestAdapter.NAME));
            }
            int i = 0;
            for (String name : mSourceCubeNames) {
                ROLAPCube cube = ROLAPCubeManager.getInstance().getCube(name);
                if (cube == null) {
                    throw new XQERuntimeException(XQEMessageKeys.ROL_CannotFindSourceCube, name);
                }
                if (!cube.isRunning()) {
                    throw new XQERuntimeException(XQEMessageKeys.ROL_SourceCubeNotRunning, name);
                }
                mSourceCubes[i] = cube;
                ++i;
            }
            return mSourceCubes;
        }

        public IROLAPMember[] getHierarchyRootMembers(String hierName) throws Exception {
            IHierarchy hierarchy = this.tempVirtualDim.getHierarchy(hierName);
            if (hierarchy == null) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CannotFindVirtualHierarchy, hierName, this.tempVirtualDim.getName());
            }
            return ((ROLAPVirtualHierarchy)hierarchy).getROLAPRootMembers(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<Member> getChildrenMembers(String memberUniqueName, String hierName, String levelName) {
            IHierarchy hierarchy = this.tempVirtualDim.getHierarchy(hierName);
            if (hierarchy == null) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CannotFindVirtualHierarchy, hierName, this.tempVirtualDim.getName());
            }
            ILevel level = ((ROLAPVirtualHierarchy)hierarchy).getLevel(levelName);
            if (level == null && !hierarchy.isParentChild()) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CannotFindVirtualLevel, (Object)levelName, (Object)hierName, (Object)this.tempVirtualDim.getName());
            }
            try {
                String[] parts = UniqueNameParser.parse(memberUniqueName);
                int levelIndex = parts.length - 3;
                level = hierarchy.getLevel(levelIndex);
            }
            catch (UniqueNameParserException unpe) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CannotFindVirtualLevel, (Object)levelName, (Object)hierName, (Object)this.tempVirtualDim.getName());
            }
            ROLAPCubeReservation[] res = ROLAPVirtualCube.reserveSourceCubes(this.sourceCubes);
            try {
                IROLAPMember[] levelMembers;
                for (IROLAPMember member : levelMembers = ((ROLAPVirtualLevel)level).getROLAPMembers(true)) {
                    if (!member.getUniqueName().equals(memberUniqueName)) continue;
                    ArrayList<Member> childrenList = new ArrayList<Member>();
                    if (!(member instanceof ROLAPRelativeTimeMember)) {
                        IMember[] children = member.getChildMembers();
                        for (IMember child : children) {
                            childrenList.add((Member)child);
                        }
                    }
                    List<ROLAPCalculatedMember> calcList = member.getROLAPCalculatedMembers(true);
                    for (ROLAPCalculatedMember calc : calcList) {
                        childrenList.add(calc);
                    }
                    ArrayList<Member> arrayList = childrenList;
                    return arrayList;
                }
            }
            finally {
                ROLAPVirtualCube.unreserveSourceCubes(res);
            }
            return new ArrayList<Member>();
        }
    }

    class RequestLocales {
        private static final String CONNECTION = "connection";
        String modelDefaultLocale;

        RequestLocales(RequestEnvironment reqEnv, Element operationElement) {
            Element connectionElement = operationElement.element(CONNECTION);
            String runLocale = LocaleConverter.localeToStr(reqEnv.getRunLocale());
            Element modelDefaultLocaleElement = connectionElement.element(FMRequestAdapter.MODELDEFAULTLOCALE);
            this.modelDefaultLocale = modelDefaultLocaleElement != null ? modelDefaultLocaleElement.getText() : runLocale;
        }

        public String getModelDefaultLocale() {
            return this.modelDefaultLocale;
        }
    }

    class LevelInfo {
        int levelNumber;
        String levelName;
        int levelType;
        int[] levelKeyColumnIndices;
        int nameColumnIndex;
        int captionColumnIndex = -1;
        int descriptionColumnIndex = -1;
        String currentPeriodExpression;
        String[] levelQueryItems;
        boolean[] munKeys;

        LevelInfo(List<SelectAttribute> selectAttributes, List<SortAttribute> sortAttributes, Element dimensionElement, Map<String, SelectAttribute> attributesMap, Element levelRefElement, int levelNumb) {
            String attributeName;
            SortAttribute sortAttribute;
            String name;
            SelectAttribute sa;
            SelectAttribute sa2;
            String attributeName2;
            int index;
            Element levelElement = FMRequestAdapter.this.getLevelElement(dimensionElement, levelRefElement.attributeValue(FMRequestAdapter.NAME));
            if (levelElement == null) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CannotFindLevel, (Object)levelRefElement.attributeValue(FMRequestAdapter.NAME), (Object)levelRefElement.getParent().attributeValue(FMRequestAdapter.NAME), (Object)dimensionElement.attributeValue(FMRequestAdapter.NAME));
            }
            List levelKeyRefList = levelElement.elements(FMRequestAdapter.LEVEL_KEY_REF_ELEMENT_NAME);
            List relatedAttributeRefList = levelElement.elements(FMRequestAdapter.RELATEDATTRIBUTEREF_ELEMENT_NAME);
            List orderAttributeRefList = levelElement.elements(FMRequestAdapter.ORDERATTRIBUTEREF_ELEMENT_NAME);
            Element defaultAttributeRefElement = levelElement.element(FMRequestAdapter.DEFAULTATTRIBUTEREF_ELEMENT_NAME);
            Element captionAttributeRefElement = levelElement.element(FMRequestAdapter.CAPTIONATTRIBUTEREF_ELEMENT_NAME);
            Element descriptionAttributeRefElement = levelElement.element(FMRequestAdapter.DESCRIPTIONATTRIBUTEREF_ELEMENT_NAME);
            Element currentPeriodExpressionElement = levelElement.element(FMRequestAdapter.CURRENTPERIODEXPRESSION_ELEMENT_NAME);
            this.levelQueryItems = new String[levelKeyRefList.size()];
            this.levelName = levelElement.attributeValue(FMRequestAdapter.NAME);
            this.levelNumber = levelNumb;
            if (levelKeyRefList != null) {
                this.levelKeyColumnIndices = new int[levelKeyRefList.size()];
                for (index = 0; index < levelKeyRefList.size(); ++index) {
                    Element leveKeyRefElement = (Element)levelKeyRefList.get(index);
                    attributeName2 = leveKeyRefElement.attributeValue(FMRequestAdapter.NAME);
                    sa2 = attributesMap.get(attributeName2);
                    if (sa2 != null && !selectAttributes.contains(sa2)) {
                        sa2.setColumnIndex(selectAttributes.size());
                        selectAttributes.add(sa2);
                        this.levelKeyColumnIndices[index] = sa2.getColumnIndex();
                        this.levelQueryItems[index] = sa2.getQueryItem();
                    } else if (sa2 != null && selectAttributes.contains(sa2)) {
                        this.levelKeyColumnIndices[index] = sa2.getColumnIndex();
                        this.levelQueryItems[index] = sa2.getQueryItem();
                    }
                    if (sa2 == null) continue;
                    if (!selectAttributes.contains(sa2)) {
                        sa2.setColumnIndex(selectAttributes.size());
                        selectAttributes.add(sa2);
                    }
                    this.levelKeyColumnIndices[index] = sa2.getColumnIndex();
                    this.levelQueryItems[index] = sa2.getQueryItem();
                }
                if (defaultAttributeRefElement != null) {
                    String defaultAttributeName = defaultAttributeRefElement.attributeValue(FMRequestAdapter.NAME);
                    sa = attributesMap.get(defaultAttributeName);
                    if (sa != null && !selectAttributes.contains(sa)) {
                        sa.setColumnIndex(selectAttributes.size());
                        selectAttributes.add(sa);
                        this.nameColumnIndex = sa.getColumnIndex();
                    } else if (sa != null && selectAttributes.contains(sa)) {
                        this.nameColumnIndex = sa.getColumnIndex();
                    }
                    this.captionColumnIndex = this.nameColumnIndex;
                }
                if (captionAttributeRefElement != null) {
                    String captionAttributeName = captionAttributeRefElement.attributeValue(FMRequestAdapter.NAME);
                    sa = attributesMap.get(captionAttributeName);
                    if (sa != null && !selectAttributes.contains(sa)) {
                        sa.setColumnIndex(selectAttributes.size());
                        selectAttributes.add(sa);
                        this.captionColumnIndex = sa.getColumnIndex();
                    } else if (sa != null && selectAttributes.contains(sa)) {
                        this.captionColumnIndex = sa.getColumnIndex();
                    }
                }
                if (descriptionAttributeRefElement != null) {
                    String descriptionAttributeName = descriptionAttributeRefElement.attributeValue(FMRequestAdapter.NAME);
                    sa = attributesMap.get(descriptionAttributeName);
                    if (sa != null && !selectAttributes.contains(sa)) {
                        sa.setColumnIndex(selectAttributes.size());
                        selectAttributes.add(sa);
                        this.descriptionColumnIndex = sa.getColumnIndex();
                    } else if (sa != null && selectAttributes.contains(sa)) {
                        this.descriptionColumnIndex = sa.getColumnIndex();
                    }
                }
            }
            if (relatedAttributeRefList != null) {
                for (index = 0; index < relatedAttributeRefList.size(); ++index) {
                    Element relatedAttributeRefElement = (Element)relatedAttributeRefList.get(index);
                    attributeName2 = relatedAttributeRefElement.attributeValue(FMRequestAdapter.NAME);
                    sa2 = attributesMap.get(attributeName2);
                    if (sa2 == null || selectAttributes.contains(sa2)) continue;
                    selectAttributes.add(sa2);
                }
            }
            if (orderAttributeRefList != null && orderAttributeRefList.size() > 0) {
                for (index = 0; index < orderAttributeRefList.size(); ++index) {
                    Element orderAttributeRefElement = (Element)orderAttributeRefList.get(index);
                    name = orderAttributeRefElement.attributeValue(FMRequestAdapter.NAME);
                    String order = orderAttributeRefElement.attributeValue(FMRequestAdapter.ORDER_ATTRIBUTE_NAME);
                    SortAttribute sortAttribute2 = new SortAttribute(name, order);
                    sortAttributes.add(sortAttribute2);
                    SelectAttribute sa3 = attributesMap.get(name);
                    if (sa3 == null || selectAttributes.contains(sa3)) continue;
                    sa3.setColumnIndex(selectAttributes.size());
                    selectAttributes.add(sa3);
                }
            } else if (captionAttributeRefElement != null) {
                String attributeName3 = captionAttributeRefElement.attributeValue(FMRequestAdapter.NAME);
                sa = attributesMap.get(attributeName3);
                if (sa != null) {
                    name = sa.getName();
                    sortAttribute = new SortAttribute(name, "asc");
                    sortAttributes.add(sortAttribute);
                }
            } else if (defaultAttributeRefElement != null && (sa = attributesMap.get(attributeName = defaultAttributeRefElement.attributeValue(FMRequestAdapter.NAME))) != null) {
                name = sa.getName();
                sortAttribute = new SortAttribute(name, "asc");
                sortAttributes.add(sortAttribute);
            }
            this.levelType = this.getLevelType(dimensionElement, levelElement);
            if (currentPeriodExpressionElement != null) {
                this.currentPeriodExpression = currentPeriodExpressionElement.getText();
            }
        }

        private int getLevelType(Element dimensionElement, Element levelElement) {
            boolean isTypeDmension = false;
            String dimensionType = dimensionElement.attributeValue(FMRequestAdapter.TYPE);
            if (dimensionType == FMRequestAdapter.TIME_ATTRIBUTE_VALUE) {
                isTypeDmension = true;
            }
            String levelTypeStr = levelElement.attributeValue(FMRequestAdapter.TYPE);
            return ROLAPLevel.getType(levelTypeStr, isTypeDmension);
        }

        public int getLevelNumber() {
            return this.levelNumber;
        }

        public String[] getLevelQueryItems() {
            return this.levelQueryItems;
        }

        public String getLevelName() {
            return this.levelName;
        }

        public int getLevelType() {
            return this.levelType;
        }

        public int[] getLevelKeyColumnIndices() {
            return this.levelKeyColumnIndices;
        }

        public int getNameColumnIndex() {
            return this.nameColumnIndex;
        }

        public int getCaptionColumnIndex() {
            return this.captionColumnIndex;
        }

        public void setMUNKeys(boolean[] keysToUse) {
            this.munKeys = keysToUse;
        }

        public boolean[] getMUNKeys() {
            return this.munKeys;
        }

        public String getCurrentPeriodExpression() {
            return this.currentPeriodExpression;
        }
    }

    class ExpressionInfo {
        boolean hasError;
        String message;
        String id;

        ExpressionInfo(String strId, boolean bHasError, String strMessage) {
            this.hasError = bHasError;
            this.id = strId;
            this.message = strMessage;
        }

        public boolean isHasError() {
            return this.hasError;
        }

        public String getMessage() {
            return this.message;
        }

        public String getId() {
            return this.id;
        }
    }

    public class MemberInfo {
        String name;
        String caption;
        ROLAPMember.LevelKeys levelKeys;
        String path;
        String[] firstModelItem;
        String[] secondModelItem;

        public MemberInfo(String theCaption) {
            this.caption = theCaption;
        }

        public MemberInfo(Member member) {
            try {
                this.caption = member.getCaption();
            }
            catch (Exception e) {
                this.caption = member.getName();
            }
            this.setName(member.getName());
            if (member.getParent() == null) {
                this.setPath(UniqueNameGenerator.createUniqueName(this.name));
            } else {
                String parentPath = member.getParentUniqueName();
                String[] parentParts = null;
                String[] parentName = null;
                parentParts = UniqueNameParser.parseNoThrow(parentPath);
                if (parentParts != null) {
                    parentName = new String[parentParts.length - 2];
                    System.arraycopy(parentParts, 2, parentName, 0, parentName.length);
                } else {
                    parentName = new String[]{parentPath};
                }
                this.setPath(UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(parentName), UniqueNameGenerator.createUniqueName(this.name)));
            }
            StringValue value = DataValueFactory.createStringValue();
            if (member.isExtendedCalculatedMember()) {
                value.set(FMRequestAdapter.RELATIVE_TIME_MEM_KEY);
            } else {
                value.set(FMRequestAdapter.VIRTUAL_MEM_KEY);
            }
            this.setLevelKeys(new IValue[]{value});
            ILevel virtualLevel = member.getLevel();
            String dimName = member.getHierarchy().getDimension().getName();
            String hierName = member.getHierarchy().getName();
            this.firstModelItem = virtualLevel == null || virtualLevel.getHierarchy().isParentChild() ? new String[]{dimName, hierName} : new String[]{dimName, hierName, virtualLevel.getName()};
            this.secondModelItem = new String[]{dimName, hierName};
        }

        public MemberInfo(IMember member) {
            this.caption = member.getCaption();
            this.setName(member.getName());
            if (member.getParent() == null) {
                this.setPath(UniqueNameGenerator.createUniqueName(this.name));
            } else {
                String parentPath = member.getParentUniqueName();
                String[] parentParts = null;
                String[] parentName = null;
                parentParts = UniqueNameParser.parseNoThrow(parentPath);
                if (parentParts != null) {
                    parentName = new String[parentParts.length - 2];
                    System.arraycopy(parentParts, 2, parentName, 0, parentName.length);
                } else {
                    parentName = new String[]{parentPath};
                }
                this.setPath(UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(parentName), UniqueNameGenerator.createUniqueName(this.name)));
            }
            StringValue value = DataValueFactory.createStringValue();
            value.set(FMRequestAdapter.VIRTUAL_MEM_KEY);
            this.setLevelKeys(new IValue[]{value});
            ILevel virtualLevel = member.getLevel();
            String dimName = member.getHierarchy().getDimension().getName();
            String hierName = member.getHierarchy().getName();
            this.firstModelItem = virtualLevel == null || virtualLevel.getHierarchy().isParentChild() ? new String[]{dimName, hierName} : new String[]{dimName, hierName, virtualLevel.getName()};
            this.secondModelItem = new String[]{dimName, hierName};
        }

        public void setName(String theName) {
            this.name = theName;
        }

        public String getName() {
            return this.name;
        }

        public void setPath(String thePath) {
            this.path = thePath;
        }

        public String getPath() {
            return this.path;
        }

        public String getCaption() {
            return this.caption;
        }

        public void setLevelKeys(IValue[] lvKeys) {
            this.levelKeys = new ROLAPMember.LevelKeys(lvKeys);
        }

        public ROLAPMember.LevelKeys getLevelKeys() {
            return this.levelKeys;
        }

        public void setFirstModelItem(String[] modelItem) {
            this.firstModelItem = modelItem;
        }

        public String[] getFirstModelItem() {
            return this.firstModelItem;
        }

        public void setSecondModelItem(String[] modelItem) {
            this.secondModelItem = modelItem;
        }

        public String[] getSecondModelItem() {
            return this.secondModelItem;
        }

        public String getMUNKeyIdentifier(boolean[] bMUNKeys) {
            if (bMUNKeys == null) {
                return null;
            }
            StringBuilder result = new StringBuilder();
            boolean foundIdentifier = false;
            IValue[] mKeyValues = this.levelKeys.getKeyValues();
            for (int i = 0; i < bMUNKeys.length; ++i) {
                String idValue = FMRequestAdapter.BLANK;
                if (!bMUNKeys[i]) continue;
                if (mKeyValues[i] != null && !mKeyValues[i].isNull()) {
                    idValue = mKeyValues[i].toString();
                }
                idValue = StringUtils.replace((String)idValue, (String)"?", (String)"??");
                if (foundIdentifier) {
                    result.append("?");
                } else {
                    foundIdentifier = true;
                }
                result.append(idValue);
            }
            return result.toString();
        }
    }

    class SortAttribute {
        String name;
        String sortDirection;

        SortAttribute(String theName, String theSortDirection) {
            this.name = theName;
            this.sortDirection = theSortDirection;
        }

        public String getName() {
            return this.name;
        }

        public String getSortDirection() {
            return this.sortDirection;
        }
    }

    class SelectAttribute {
        private static final int NUMBER_31 = 31;
        String name;
        String queryItem;
        int columnIndex;

        SelectAttribute(String theName, String qryItem) {
            this.name = theName;
            this.queryItem = qryItem;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public void setColumnIndex(int colIdx) {
            this.columnIndex = colIdx;
        }

        public String getName() {
            return this.name;
        }

        public String getQueryItem() {
            return this.queryItem;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof SelectAttribute) {
                SelectAttribute that = (SelectAttribute)obj;
                return this.getName().equals(that.getName()) && this.getQueryItem().equals(that.getQueryItem());
            }
            return false;
        }

        public int hashCode() {
            int hash = 31 + this.getName().hashCode();
            hash = hash * 31 + this.getQueryItem().hashCode();
            return hash;
        }
    }

    public static enum Operation {
        NONE,
        GETMEMBERS,
        VALIDATEV5;

    }
}

