/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEFault;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.IteratorProfilingManager;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.io.ByteBufferOutputStream;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqebifw.bibushandler.ExecuteDetailQueryRequestAdapter;
import com.cognos.xqebifw.bibushandler.RSVP4JResponseAdapter;
import com.cognos.xqebifw.bibushandler.ReleaseDatasetRequestAdapter;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SOAPFaultResponseAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import com.cognos.xqebifw.bibushandler.XQEBinaryNodeSerializer;
import com.cognos.xqebifw.bibushandler.XQENodeSerializer;
import com.cognos.xqebifw.bibushandler.binaryprotocol.VarLenByteBufferOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GetPartialDatasetRequestAdapter
extends RequestAdapter {
    private static final String GET_PARTIAL_DATASET_ELEMENT_NAME = "getPartialDataset";
    private static final String MASTER_DATASET_ID = "masterDatasetId";
    private static final byte[] COMPRESSED_HEADER = "Content-Type: text/xml; charset=utf-8\r\nContent-Encoding: gzip\r\n\r\n".getBytes();
    private static final byte[] UNCOMPRESSED_HEADER = "Content-Type: text/xml; charset=utf-8\r\n\r\n".getBytes();
    static final String CELLS = "cells";
    private boolean compressAttachment = false;
    public static final String VALUE = "value";
    private static final String PARTIAL_DATASET_WAS_CREATED_IN_XML_FORMAT = "PartialDataset was created in XML format.";
    private static XQELogger infoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "RSAPI", LogLevel.INFO);
    private static XQELogger warnLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "RSAPI", LogLevel.WARN);
    public static final String VALUE_TRUE = "true";

    @Override
    public void init() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.compressAttachment = config.getBooleanProperty("general.compressPartialDataset", false);
        this.binaryAttachment = this.compressAttachment ? false : config.getBooleanProperty("general.binaryPartialDataset", true);
    }

    private EdgeChunkInfo getChunkInfoFromElement(Element anElement) {
        String sizeStr = anElement.attributeValue("chunksize");
        String startStr = anElement.attributeValue("chunkstart");
        EdgeChunkInfo info = new EdgeChunkInfo();
        info.name = anElement.attributeValue("name");
        if (startStr != null) {
            info.chunkStart = Integer.parseInt(startStr);
        }
        if (sizeStr != null) {
            info.chunkSize = Integer.parseInt(sizeStr);
        }
        return info;
    }

    private Map<String, EdgeChunkInfo> getEdgeChunkInfo(Element masterDatasetElement) {
        EdgeChunkInfo chunkInfo;
        HashMap<String, EdgeChunkInfo> chunkMap = new HashMap<String, EdgeChunkInfo>();
        List edgeElements = masterDatasetElement.elements("edge");
        Iterator edgeIterator = edgeElements.iterator();
        int i = 0;
        while (edgeIterator.hasNext()) {
            Element edgeElement = (Element)edgeIterator.next();
            chunkInfo = this.getChunkInfoFromElement(edgeElement);
            chunkMap.put(chunkInfo.name, chunkInfo);
            if (infoLogger.isOn()) {
                infoLogger.log(chunkInfo.toString());
            }
            ++i;
        }
        Element cellsElement = masterDatasetElement.element(CELLS);
        if (cellsElement != null) {
            chunkInfo = this.getChunkInfoFromElement(cellsElement);
            chunkMap.put(CELLS, chunkInfo);
            if (infoLogger.isOn()) {
                infoLogger.log(chunkInfo.toString());
            }
        }
        return chunkMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAdapter executeRequest(RequestEnvironment reqEnv) throws XQEException {
        String datasetId = null;
        try {
            List attachmentList;
            ByteArrayInputStream headerStream;
            ByteArrayInputStream resultStream;
            RSAPIPartialDataset partialDataset;
            block32: {
                XQETrace trace = new XQETrace();
                QueryEngineLoggingUtils.addExecutionTraceLevels(trace, reqEnv);
                IteratorProfilingManager.getInstance().registerProfiler(trace);
                partialDataset = null;
                resultStream = null;
                headerStream = null;
                MetricsService.collectMetricInfo(reqEnv, "requestType", GET_PARTIAL_DATASET_ELEMENT_NAME);
                BIBusEnvelope requestEnvelope = reqEnv.getRequestEnvelope();
                Element v5RootElement = requestEnvelope.getBody().element(GET_PARTIAL_DATASET_ELEMENT_NAME);
                v5RootElement.detach();
                Element releaseDatasetElement = v5RootElement.element("releaseDataset");
                if (releaseDatasetElement != null) {
                    releaseDatasetElement.detach();
                    List partialDatasetIDs = releaseDatasetElement.elements("partialDataset");
                    ReleaseDatasetRequestAdapter.releaseDataset(reqEnv, Collections.EMPTY_LIST, partialDatasetIDs, Collections.EMPTY_LIST);
                }
                Document requestDocument = DocumentHelper.createDocument((Element)v5RootElement);
                try {
                    OutputStream outStream;
                    boolean useBinaryProtocolForThisRequest;
                    Element masterDatasetElement = v5RootElement.element("masterDataset");
                    boolean bClose = false;
                    QueryEngine.getInstance().setCachedMultiRequestContext(reqEnv);
                    String remoteIsLittleEndian = v5RootElement.attributeValue("littleEndian");
                    Map<String, EdgeChunkInfo> chunkInfoMap = null;
                    if (masterDatasetElement != null) {
                        Element detailQuery;
                        datasetId = masterDatasetElement.attributeValue(MASTER_DATASET_ID);
                        if (remoteIsLittleEndian == null) {
                            remoteIsLittleEndian = masterDatasetElement.attributeValue("littleEndian");
                        }
                        if ((detailQuery = v5RootElement.element("detailQuery")) != null) {
                            RSAPIDataset detailDataset = ExecuteDetailQueryRequestAdapter.getDetailDataset(reqEnv, detailQuery, datasetId);
                            partialDataset = QueryEngine.getInstance().getPartialDataset(masterDatasetElement, detailDataset, (ExecutionEnvironment)reqEnv.getExecutionEnvironment(), true);
                        } else {
                            Element reExecute = v5RootElement.element("reExecute");
                            String reExecuteValue = reExecute.attributeValue(VALUE);
                            partialDataset = QueryEngine.getInstance().getPartialDataset(requestDocument, (ExecutionEnvironment)reqEnv.getExecutionEnvironment(), reExecuteValue.equals(VALUE_TRUE));
                        }
                        QueryEngine.getInstance().storePartialDataset(partialDataset);
                        chunkInfoMap = this.getEdgeChunkInfo(masterDatasetElement);
                    } else {
                        String close;
                        Element partialDatasetElement = v5RootElement.element("partialDataset");
                        String partialDatasetId = partialDatasetElement.attributeValue("id");
                        if (partialDatasetId == null) {
                            throw new XQEException(XQEMessageKeys.EXE_MissingPartialDatasetId);
                        }
                        partialDataset = QueryEngine.getInstance().getPartialDatasetByID(partialDatasetId);
                        if (partialDataset == null) {
                            throw new XQEException(XQEMessageKeys.EXE_MissingPartialDataset);
                        }
                        RSAPIDataset masterDataset = partialDataset.getMasterDataset();
                        if (masterDataset != null) {
                            ZipiBridge.setZipiContextAndObjPath(masterDataset.getName());
                        }
                        if ((bClose = VALUE_TRUE.equals(close = partialDatasetElement.attributeValue("close"))) && partialDataset.pause()) {
                            QueryEngine.getInstance().releasePartialDataset(partialDatasetId);
                        }
                        datasetId = partialDatasetElement.attributeValue(MASTER_DATASET_ID);
                        chunkInfoMap = this.getEdgeChunkInfo(partialDatasetElement);
                    }
                    ByteBufferOutputStream baos = new ByteBufferOutputStream();
                    if (reqEnv.getRSVP4J() || bClose) break block32;
                    if (this.compressAttachment) {
                        useBinaryProtocolForThisRequest = false;
                        headerStream = new ByteArrayInputStream(COMPRESSED_HEADER);
                        outStream = new BufferedOutputStream(new GZIPOutputStream(baos));
                    } else {
                        headerStream = new ByteArrayInputStream(UNCOMPRESSED_HEADER);
                        boolean endiannessMismatch = VarLenByteBufferOutputStream.endiannessMismatch(remoteIsLittleEndian);
                        if (this.binaryAttachment && !endiannessMismatch) {
                            useBinaryProtocolForThisRequest = true;
                            outStream = new VarLenByteBufferOutputStream();
                        } else {
                            useBinaryProtocolForThisRequest = false;
                            outStream = new BufferedOutputStream(baos);
                        }
                    }
                    try {
                        MetricsService.startCollectingMetric(reqEnv, "generateRSAPIXML");
                        if (useBinaryProtocolForThisRequest) {
                            outStream.write(BIN_STREAM_TYPE);
                            byte[] resultBytes = XQEBinaryNodeSerializer.buildPartialDataset((VarLenByteBufferOutputStream)outStream, partialDataset, datasetId, chunkInfoMap);
                            resultStream = new ByteArrayInputStream(resultBytes);
                            XQEDebugLog.out.println("PartialDataset was created in binary format.");
                        } else {
                            outStream.write(XML_STREAM_TYPE);
                            XQENodeSerializer serializer = new XQENodeSerializer();
                            serializer.generateGetPartialDatasetResponse(outStream, partialDataset, datasetId, chunkInfoMap);
                            resultStream = new ByteArrayInputStream(baos.getBuf());
                            XQEDebugLog.out.println(PARTIAL_DATASET_WAS_CREATED_IN_XML_FORMAT);
                            if (warnLogger.isOn()) {
                                warnLogger.log(PARTIAL_DATASET_WAS_CREATED_IN_XML_FORMAT);
                            }
                        }
                        MetricsService.endCollectingMetric(reqEnv, "generateRSAPIXML");
                    }
                    finally {
                        outStream.close();
                        if (useBinaryProtocolForThisRequest) {
                            baos.close();
                        }
                    }
                }
                catch (DataSourceException dse) {
                    MetricsService.collectMetricInfo(reqEnv, "generateRSAPIXML", "failed");
                    throw dse;
                }
                catch (IOException e) {
                    MetricsService.collectMetricInfo(reqEnv, "generateRSAPIXML", "failed");
                    SOAPFaultResponseAdapter bClose = new SOAPFaultResponseAdapter(new XQEFault(new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e)), false);
                    IteratorProfilingManager.getInstance().unregisterProfiler();
                    return bClose;
                }
            }
            if (resultStream == null) {
                attachmentList = Collections.emptyList();
            } else {
                attachmentList = new ArrayList(1);
                SequenceInputStream sequenceStream = new SequenceInputStream(headerStream, resultStream);
                attachmentList.add(sequenceStream);
            }
            BIBusEnvelope responseEnvelope = new BIBusEnvelope();
            IteratorProfilingManager.getInstance().logProfiling(partialDataset.getMasterDataset(), (IExecutionEnvironment)reqEnv.getExecutionEnvironment());
            if (reqEnv.getRSVP4J()) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(partialDataset);
                list.add(reqEnv);
                RSVP4JResponseAdapter rSVP4JResponseAdapter = new RSVP4JResponseAdapter(responseEnvelope, list);
                return rSVP4JResponseAdapter;
            }
            SimpleResponseAdapter simpleResponseAdapter = new SimpleResponseAdapter(responseEnvelope, attachmentList);
            return simpleResponseAdapter;
        }
        finally {
            IteratorProfilingManager.getInstance().unregisterProfiler();
        }
    }

    @Override
    public String getOperationName() {
        return GET_PARTIAL_DATASET_ELEMENT_NAME;
    }

    @Override
    public boolean hasCompressedAttachment() {
        return this.compressAttachment;
    }

    public static class EdgeChunkInfo {
        public static final int RELATIVE_TO_LAST = -5;
        public static final int FROM_TOP = -4;
        String name;
        int chunkStart = 0;
        int chunkSize = 0;

        public int getChunkStart() {
            return this.chunkStart;
        }

        public int getChunkSize() {
            return this.chunkSize;
        }

        public String toString() {
            StringBuilder bldr = new StringBuilder("Edge ");
            bldr.append(this.name);
            bldr.append(": chunk start -> ");
            bldr.append(this.chunkStart);
            bldr.append(", chunk size -> ");
            bldr.append(this.chunkSize);
            return bldr.toString();
        }
    }
}

