/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.rsapi.RSAPICachedEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqebifw.bibushandler.GetDetailQueriesRequestAdapter;
import com.cognos.xqebifw.bibushandler.XQENodeSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class RSVP4JHelper {
    public static List<Object> generateExecuteResponse(IXQEQueryNode[] datasets) {
        ArrayList<Object> response = new ArrayList<Object>();
        RSAPIDataset dataset = null;
        for (int i = 0; i < datasets.length; ++i) {
            dataset = RSVP4JHelper.copyDatasetForRSVP4J((RSAPIDataset)datasets[i]);
            response.add(dataset);
            PlannedV5QuerySet querySet = (PlannedV5QuerySet)datasets[i].getParent();
            MasterDetailProvider mdProvider = querySet.getMasterDetailProvider();
            List<MasterDetailLink> mdLinks = mdProvider.getMasterDetailLinks(dataset.getName());
            if (mdLinks.isEmpty()) continue;
            RSVP4JHelper.serializeDetailQueries(response, querySet, mdLinks);
        }
        return response;
    }

    private static RSAPIDataset copyDatasetForRSVP4J(RSAPIDataset rsapiDataset) {
        RSAPIDataset dataset = new RSAPIDataset();
        dataset.setName(rsapiDataset.getName());
        dataset.setRefQueryName(rsapiDataset.getRefQueryName());
        dataset.setUniqueID(rsapiDataset.getUniqueID());
        dataset.setCellRowset(rsapiDataset.getCellRowset());
        for (RSAPIEdge e : rsapiDataset.getEdges()) {
            RSAPIEdge edge = new RSAPIEdge();
            edge.setName(e.getName());
            for (RSAPIEdgeRowset r : e.getRowsets()) {
                RSAPICachedEdgeRowset rowset = new RSAPICachedEdgeRowset(r);
                edge.addRowset(rowset);
            }
            dataset.addEdge(edge);
        }
        dataset.setQueryPlan(rsapiDataset.getQueryPlan());
        return dataset;
    }

    private static void serializeDetailQueries(List<Object> response, PlannedV5QuerySet querySet, List<MasterDetailLink> mdLinks) {
        Map<String, List<MasterDetailLink>> detailQRDs = GetDetailQueriesRequestAdapter.arrangeMDLinksByDetailQueries(mdLinks);
        Parameters parameters = querySet.getRequestParameters();
        for (Map.Entry<String, List<MasterDetailLink>> entry : detailQRDs.entrySet()) {
            List<MasterDetailLink> links = entry.getValue();
            if (links.size() == 0) continue;
            String datasetName = entry.getKey();
            RSAPIDataset detailRSAPIDataset = GetDetailQueriesRequestAdapter.findDatasetByName(querySet, datasetName);
            response.add(detailRSAPIDataset.getUniqueID());
            Element parametersElem = Parameters.createParametersElement();
            response.add(links);
            for (MasterDetailLink mdLink : links) {
                String parameterName = mdLink.getParameterName();
                if (!mdLink.isParameterLink()) {
                    parameterName = mdLink.getName();
                }
                parameterName = parameterName.trim();
                String refDataItem = mdLink.getMasterRefDataItem();
                String refParameterName = UniqueNameGenerator.createUniqueName(mdLink.getMasterQrdName(), refDataItem);
                Parameter parameter = null;
                String queryName = detailRSAPIDataset.getRefQueryName();
                if (parameters != null) {
                    parameter = parameters.getParameter(parameterName, queryName);
                }
                if (parameter == null) {
                    parameter = parameters.getParameter(parameterName);
                }
                if (parameter == null || !parameter.isMasterDetailLinkParameter()) {
                    parameter = new Parameter(parameterName, queryName);
                    parameter.setMasterDetailLinkParameter(true);
                }
                Element paramItem = parameter.createParameterElement(refParameterName);
                parametersElem.add(paramItem);
            }
            Parameters.setParametersArraySize(parametersElem, links.size());
            response.add(parametersElem);
        }
    }

    static List<Object> generateValidateResponse(String charsetName, IXQEQueryNode planTree, List<String> datasetNames, RequestEnvironment environment, Element missingMembersElement, Element queryFeedback, String operationName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, charsetName);
        ArrayList<Object> masterdatasetList = new ArrayList<Object>();
        XQENodeSerializer.generateValidateResponse(writer, planTree, datasetNames, environment, missingMembersElement, queryFeedback, operationName, masterdatasetList);
        ((Writer)writer).flush();
        ((Writer)writer).close();
        byte[] attachmentBytes = baos.toByteArray();
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(attachmentBytes);
        result.addAll(masterdatasetList);
        return result;
    }
}

