/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import java.util.Collections;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class UpdateRequestAdapter
extends RequestAdapter {
    private static final String UPDATE_ELEMENT_NAME = "update";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAdapter executeRequest(RequestEnvironment reqEnv) {
        long startTime = System.currentTimeMillis();
        BIBusEnvelope requestEnvelope = reqEnv.getRequestEnvelope();
        Element v5RootElement = requestEnvelope.getBody().element(UPDATE_ELEMENT_NAME);
        v5RootElement.detach();
        Document requestDocument = DocumentHelper.createDocument((Element)v5RootElement);
        MetricsService.collectMetricInfo(reqEnv, "requestType", UPDATE_ELEMENT_NAME);
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        MultiRequestContext multiRequestContext = QueryEngine.getInstance().configureMultiRequestContext(reqEnv, requestDocument);
        multiRequestContext.incrementRefCount();
        boolean success = false;
        try {
            this.getEngine().updateQueryRequest(requestDocument, reqEnv);
            success = true;
            this.logV5Request(v5RootElement, "queriesPlanned", reqEnv.getReportName());
        }
        catch (Throwable t) {
            this.failQueryReThrowAsXQERTE(reqEnv, v5RootElement, t, "isV5QueryPlanned");
        }
        finally {
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
        Document responseDocument = DocumentHelper.createDocument();
        Element responseElement = responseDocument.addElement("response");
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        responseEnvelope.getBody().add(responseElement);
        this.createUpdateResponse(UPDATE_ELEMENT_NAME, reqEnv, responseElement);
        long time = System.currentTimeMillis() - startTime;
        if (success) {
            MetricsService.collectMetricInfo(reqEnv, "isV5QueryPlanned", "true", time);
        } else {
            MetricsService.collectMetricInfo(reqEnv, "isV5QueryPlanned", "failed", time);
        }
        List attachmentList = Collections.emptyList();
        return new SimpleResponseAdapter(responseEnvelope, attachmentList);
    }

    @Override
    public String getOperationName() {
        return UPDATE_ELEMENT_NAME;
    }

    @Override
    public void setEngine(QueryEngine newEngine) {
        super.setEngine(newEngine);
    }

    private void createUpdateResponse(String returnStatus, RequestEnvironment environment, Element responseElem) {
        if (returnStatus != null) {
            Element connectionID = responseElem.addElement("connectionID");
            connectionID.addAttribute("value", "***");
            Element updateSubjectResult = responseElem.addElement("updateSubjectResult");
            Element statusMessage = updateSubjectResult.addElement("statusMessage");
            statusMessage.addAttribute("name", returnStatus);
        }
    }
}

