/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content.CMCacheService;

import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.ContentManagerCacheService_PortType;
import com.cognos.developer.schemas.bibus._3.DataSourceConnection;
import com.cognos.developer.schemas.bibus._3.DataSourceCredential;
import com.cognos.developer.schemas.bibus._3.DataSourceSignon;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.QueryCacheResult;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.AxisFaultBridge;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.MapCast;
import com.cognos.xqe.util.Timer;
import com.cognos.xqe.util.xml.XMLUtils;
import com.cognos.xqebifw.bibushandler.content.BaseCMCommand;
import com.cognos.xqebifw.bibushandler.content.CMConnection;
import com.cognos.xqebifw.bibushandler.content.CMDataSource;
import com.cognos.xqebifw.bibushandler.content.CMEntity;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMObject;
import com.cognos.xqebifw.bibushandler.content.CMQuery;
import com.cognos.xqebifw.bibushandler.content.CMSignon;
import com.cognos.xqebifw.bibushandler.content.CMUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.xml.soap.Node;
import org.apache.axis.AxisFault;
import org.apache.commons.collections.map.Flat3Map;
import org.w3c.dom.NodeList;

public final class CMDataSourceViaCMCService
extends CMDataSource {
    private static final ClassEnum DATASOURCE_CLASSENUM = ClassEnum.fromString((String)"dataSource");
    private static final ClassEnum DATASOURCECONNECTION_CLASSENUM = ClassEnum.fromString((String)"dataSourceConnection");
    private static final ClassEnum DATASOURCESIGNON_CLASSENUM = ClassEnum.fromString((String)"dataSourceSignon");
    private static final ClassEnum DATASOURCECREDENTAIL_CLASSENUM = ClassEnum.fromString((String)"dataSourceCredential");
    private static final String[] SEC_BLOB_TRAVERSAL = new String[]{"CAM", "exception", "promptInfo", "securityBlob"};

    public static CMDataSource createDS(String name, CMEntity cmEntity, IRequestEnvironment env) throws CMDataSource.SSOException {
        CMDataSourceViaCMCService cmD = null;
        try {
            cmD = new CMDataSourceViaCMCService(name, cmEntity, env);
            if (!CMEntityPool.tryUsingCMCacheService()) {
                return null;
            }
        }
        catch (CMDataSource.RolapException e) {
            throw e;
        }
        catch (CMDataSource.SSOException e) {
            throw e;
        }
        catch (XQERuntimeException e) {
            throw e;
        }
        return cmD;
    }

    private CMDataSourceViaCMCService(String name, CMEntity cmEntity, final IRequestEnvironment env) throws CMDataSource.SSOException {
        super(name, cmEntity);
        Timer timer = CMQuery.getAndStartTimerForUsageStats();
        try {
            ((RequestEnvironment)env).getCMRequestExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((RequestEnvironment)env).resetEnvelopeFromExecutor();
                        CMDataSourceViaCMCService.this.queryForCMInfo(env);
                    }
                    catch (CMDataSource.SSOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (CMDataSource.RolapException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof CMDataSource.SSOException) {
                throw (CMDataSource.SSOException)cause;
            }
            throw e;
        }
        finally {
            CMQuery.updateCMUsageStats(timer);
        }
    }

    private void queryForCMInfo(IRequestEnvironment env) throws CMDataSource.SSOException {
        BiBusHeader bibusHeader = CMUtils.buildBiBusHeader(env);
        ContentManagerCacheService_PortType port = null;
        try {
            port = BaseCMCommand.getContentManagerCacheServicePort(bibusHeader);
            SearchPathSingleObject searchPathSingleObject = new SearchPathSingleObject();
            searchPathSingleObject.set_value(this.buildSearchPath(env));
            ClassEnum searchType = DATASOURCESIGNON_CLASSENUM;
            ClassEnum[] entries = new ClassEnum[]{DATASOURCESIGNON_CLASSENUM};
            ArrayList<Option> optionList = new ArrayList<Option>();
            CMUtils.setOptionsForQueryCache(optionList, env);
            Option[] options = new Option[]{};
            if (optionList.size() > 0) {
                options = optionList.toArray(new Option[optionList.size()]);
            }
            QueryCacheResult qcResult = port.queryCache(searchPathSingleObject, searchType, entries, options);
            CMEntityPool.setIsCMCacheServiceEnabled(true);
            CMUtils.updateCMCacheContext(qcResult.getOptions(), env);
            BaseClass[] resultObjects = qcResult.getObjects();
            if (resultObjects.length == 0) {
                throw new CMDataSource.RolapException(this);
            }
            LinkedList<CMSignon> dataSourceSignons = new LinkedList<CMSignon>();
            LinkedList<CMSignon> dataSourceCredentials = new LinkedList<CMSignon>();
            this.connections = MapCast.uncheckedCast(new Flat3Map());
            for (BaseClass object : resultObjects) {
                CMSignon cmSignon;
                if (object.getObjectClass().getValue() == DATASOURCECONNECTION_CLASSENUM) {
                    CMConnection cmConnection = new CMConnection((DataSourceConnection)object);
                    if (!cmConnection.getBooleanProperty("disabled", false)) {
                        this.connections.put(cmConnection.getDefaultName(), cmConnection);
                    }
                    if (this.dataSource != null) continue;
                    this.createDataSource((DataSourceConnection)object);
                    continue;
                }
                if (object.getObjectClass().getValue() == DATASOURCESIGNON_CLASSENUM) {
                    cmSignon = new CMSignon((DataSourceSignon)object);
                    if (cmSignon.getBooleanProperty("disabled", false)) continue;
                    dataSourceSignons.add(cmSignon);
                    continue;
                }
                if (object.getObjectClass().getValue() != DATASOURCECREDENTAIL_CLASSENUM || (cmSignon = new CMSignon((DataSourceCredential)object)).getBooleanProperty("disabled", false)) continue;
                dataSourceCredentials.add(cmSignon);
            }
            this.addSignonsAsChildrenOfConnection(dataSourceSignons, dataSourceCredentials);
        }
        catch (AxisFault axisFault) {
            AxisFaultBridge axisFaultBridge = new AxisFaultBridge(axisFault);
            boolean bIsCMCacheDisabled = false;
            bIsCMCacheDisabled = CMUtils.parseFaultForDisabledCMCache(axisFaultBridge.getDumpToString());
            if (!bIsCMCacheDisabled) {
                boolean bIsSSO = this.parseFaultForAuthException(axisFaultBridge);
                if (bIsSSO) {
                    throw new CMDataSource.SSOException(this, this.getSecurityBlob(axisFault));
                }
                throw axisFaultBridge.makeXQESOAPFaultException();
            }
        }
        catch (CMDataSource.RolapException e) {
            throw e;
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    private String buildSearchPath(IRequestEnvironment env) {
        String modelPath = env.getModelPath();
        int endIndex = -1;
        if (modelPath != null) {
            endIndex = modelPath.lastIndexOf("model[@name='model']");
        }
        String packagePath = null;
        packagePath = modelPath == null || endIndex == -1 ? new String("/content/package[@defaultName='dummyName']/") : modelPath.substring(0, endIndex);
        StringBuilder searchPath = new StringBuilder();
        searchPath.append(packagePath);
        searchPath.append("personalDataSourceSignon(");
        searchPath.append(XMLUtils.xPathLiteral(this.dsName));
        searchPath.append(")");
        String searchPathStr = searchPath.toString();
        return searchPathStr;
    }

    private void createDataSource(DataSourceConnection dsConnection) {
        if (dsConnection.getAncestors().getValue() != null) {
            AncestorInfo[] ancestors;
            for (AncestorInfo member : ancestors = dsConnection.getAncestors().getValue()) {
                if (member.getObjectClass() != DATASOURCE_CLASSENUM) continue;
                this.dataSource = new CMObject(member);
                break;
            }
        }
    }

    private boolean parseFaultForAuthException(AxisFaultBridge axisFaultBridge) {
        for (String faultStr : axisFaultBridge.getHeadersAsString()) {
            if (faultStr.indexOf("camAuthNegotiate") == -1) continue;
            return true;
        }
        return false;
    }

    private String getSecurityBlob(AxisFault fault) {
        ArrayList headers = fault.getHeaders();
        String blob = null;
        for (int i = 0; blob == null && i < headers.size(); ++i) {
            Node header = (Node)headers.get(i);
            blob = this.traverseNode((org.w3c.dom.Node)header, SEC_BLOB_TRAVERSAL, 0);
        }
        return blob;
    }

    private String traverseNode(org.w3c.dom.Node node, String[] traversalList, int index) {
        if (index == traversalList.length) {
            return node.getFirstChild().getNodeValue();
        }
        if (index > traversalList.length) {
            return null;
        }
        NodeList childList = node.getChildNodes();
        String text = null;
        for (int i = 0; text == null && i < childList.getLength(); ++i) {
            org.w3c.dom.Node childNode = childList.item(i);
            if (!traversalList[index].equals(childNode.getNodeName())) continue;
            text = this.traverseNode(childNode, traversalList, index + 1);
        }
        return text;
    }
}

