/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.DataSourceCredential;
import com.cognos.developer.schemas.bibus._3.DataSourceSignon;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.xqe.bibushandler.content.ICMSignon;
import com.cognos.xqebifw.bibushandler.content.CMObject;
import com.cognos.xqebifw.bibushandler.content.CMQuery;
import org.dom4j.Element;

public class CMSignon
extends CMObject
implements ICMSignon {
    protected static final String CREDENTIALS_PROPERTY = "credentials";
    private volatile String connectionName = null;

    public CMSignon(Element itemElement) {
        super(itemElement);
    }

    public CMSignon(DataSourceSignon dsSignon) {
        super((BaseClass)dsSignon);
        if (dsSignon.getCredentials().getValue() != null) {
            this.addProperty(PropEnum.credentials.toString(), dsSignon.getCredentials().getValue());
        }
    }

    public CMSignon(DataSourceCredential dsCredential) {
        super((BaseClass)dsCredential);
        if (dsCredential.getCredentials().getValue() != null) {
            this.addProperty(PropEnum.credentials.toString(), dsCredential.getCredentials().getValue());
        }
        this.setDataSourceConnectionName(dsCredential);
    }

    @Override
    public String getCredential() {
        return this.getStringProperty(CREDENTIALS_PROPERTY);
    }

    @Override
    public String getConnectionName() {
        if (this.connectionName == null) {
            this.connectionName = this.getDataSourceConnectionName();
            if (this.connectionName != null) {
                return this.connectionName;
            }
            String searchPath = this.getSearchPath();
            if (searchPath != null) {
                this.connectionName = CMQuery.getSearchPathPropName(searchPath, "dataSourceConnection");
            }
        }
        return this.connectionName;
    }

    protected void setDataSourceConnectionName(DataSourceCredential dsCredential) {
        StringProp nameProp = dsCredential.getDataSourceConnectionName();
        if (null != nameProp) {
            this.setDataSourceConnectionName(nameProp.getValue());
        }
    }

    protected void setDataSourceConnectionName(String dataSourceConnectionName) {
        this.connectionName = dataSourceConnectionName;
        if (null != this.connectionName) {
            this.addProperty("dataSourceConnectionName", this.connectionName);
        }
    }
}

