/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.FormatEnum;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.content.ICryptoHandle;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.secbridge.CAMImpersonate;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.reference.IResourceHolder;
import com.cognos.xqebifw.bibushandler.content.BaseCMCommand;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.Dispatcher.CMDataSourceViaDispatcher;
import com.cognos.xqebifw.bibushandler.datasource.JCAMImpersonator;
import java.util.Locale;
import org.apache.axis.client.Stub;
import org.dom4j.Element;

public class GenCredCommand
extends BaseCMCommand {
    private static final int FORM_FIELD_SIZE = 1;
    private static final int NAMESPACE_HEADER_SIZE = 7;
    private static final int NAMESPACE_TRAILER_SIZE = 2;
    private static final String CAM_CREDENTIAL = "CAMCredential";
    private static final String CAM_NAMESPACE = "CAMNamespace";
    private static final String GENERATE_CREDENTIAL = "generateCredential";
    private static final String SEARCH_PATH = "/content";
    private static final String SECURITYBLOB = "securityBlob";
    private static final String EXCEPTION = "exception";
    private static final String PROMPT_INFO = "promptInfo";
    private static final String UNEXPECTED_EXCEPTION = "Unexpected exception occurred ";
    private static final String UNEXPECTED_XQE_EXCEPTION = "Unexpected XQERuntimeException exception occurred ";
    private JCAMImpersonator.DelegatedCredential credential = null;
    private IResourceHolder<? extends ICryptoHandle> cryptoHandle = null;
    private String encryptedCredentials = null;
    private volatile String base64EncodedSecurityBlob = null;
    private static final XQELogger SECBRIDGE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SecBridge", LogLevel.TRACE);

    private BiBusHeader buildHeader(String namespace, CAMPassport camPassport) {
        String newNamespace = null;
        BiBusHeader bibusHeader = new BiBusHeader();
        CAM cam = new CAM();
        cam.setAction(GENERATE_CREDENTIAL);
        camPassport.setCanCallLogon(false);
        camPassport.setIsAnonymous(false);
        cam.setCAMPassport(camPassport);
        if (this.base64EncodedSecurityBlob != null) {
            cam.setSecurityBlob(this.base64EncodedSecurityBlob.getBytes());
        }
        newNamespace = GenCredCommand.extractNamespace(namespace);
        HdrSession hdrSession = new HdrSession();
        FormFieldVar[] vars = new FormFieldVar[]{new FormFieldVar()};
        vars[0].setName(CAM_NAMESPACE);
        vars[0].setFormat(FormatEnum.not_encrypted);
        vars[0].setValue(newNamespace);
        hdrSession.setFormFieldVars(vars);
        bibusHeader.setHdrSession(hdrSession);
        bibusHeader.setCAM(cam);
        SECBRIDGE_LOGGER.log("Bibus Header:" + bibusHeader.toString());
        return bibusHeader;
    }

    private void generateCredentials(String namespace, CAMPassport camPassport, boolean isKerberos, Locale errMsgLocale) {
        boolean done = this.queryCM(namespace, camPassport);
        if (!done) {
            if (isKerberos) {
                SECBRIDGE_LOGGER.log("Create Credential (Java) - instantiating JCAMImpersonator");
                JCAMImpersonator helper = new JCAMImpersonator();
                while (!done) {
                    SECBRIDGE_LOGGER.log("Generate Credential (Java) helper.camImpUsrNegotiate");
                    this.base64EncodedSecurityBlob = helper.camImpUsrNegotiate(this.base64EncodedSecurityBlob);
                    SECBRIDGE_LOGGER.log("Create Credential (Java) - returning security token to CAM");
                    done = this.queryCM(namespace, camPassport);
                }
                SECBRIDGE_LOGGER.log("Create Credential (Java) - retrieving subject");
                this.credential = helper.getDelegatedCredential();
            } else {
                String camSecBlobCryptoHandle = null;
                String tmpCryptoHandleId = null;
                try {
                    while (!done) {
                        SECBRIDGE_LOGGER.log("Generate Credential (native) calling CAMImpersonate.camImpUsrNegotiate");
                        camSecBlobCryptoHandle = CAMImpersonate.camImpUsrNegotiate(errMsgLocale, this.base64EncodedSecurityBlob, tmpCryptoHandleId);
                        int index = camSecBlobCryptoHandle.indexOf("<>");
                        if (index == -1 || camSecBlobCryptoHandle.length() <= index + 2) {
                            SECBRIDGE_LOGGER.log("Generate Credential (native) Unexpected exception occurred while parsing camSecBlobCryptoHandle");
                            throw new XQERuntimeException(XQEMessageKeys.WSB_CAM_NEGOTIATION_FAILURE);
                        }
                        this.base64EncodedSecurityBlob = camSecBlobCryptoHandle.substring(0, index);
                        tmpCryptoHandleId = camSecBlobCryptoHandle.substring(index + 2);
                        done = this.queryCM(namespace, camPassport);
                    }
                }
                catch (XQERuntimeException ex) {
                    SECBRIDGE_LOGGER.log(UNEXPECTED_XQE_EXCEPTION + ex.toString());
                    if (ex.getMessageKey() != XQEMessageKeys.WSB_BRIDGE_INIT_ERROR) {
                        throw new XQERuntimeException(XQEMessageKeys.WSB_CAM_NEGOTIATION_FAILURE, (Throwable)ex);
                    }
                    throw ex;
                }
                catch (Exception ex) {
                    SECBRIDGE_LOGGER.log(UNEXPECTED_EXCEPTION + ex.toString());
                    throw new XQERuntimeException(XQEMessageKeys.WSB_CAM_NEGOTIATION_FAILURE, (Throwable)ex);
                }
                this.cryptoHandle = CMEntityPool.instance().getOrCreateCryptoHandle(tmpCryptoHandleId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queryCM(String namespace, CAMPassport camPassport) {
        boolean bl;
        block10: {
            ContentManagerService_PortType port = null;
            try {
                BIBusEnvelope envelope;
                Element camElem;
                Element camCred;
                BiBusHeader bibusHeader = this.buildHeader(namespace, camPassport);
                port = BaseCMCommand.getContentManagerServicePort(bibusHeader);
                SearchPathMultipleObject smo = new SearchPathMultipleObject(SEARCH_PATH);
                PropEnum[] props = new PropEnum[]{};
                port.query(smo, props, null, null);
                if (this.base64EncodedSecurityBlob == null && null != (camCred = (camElem = (envelope = BaseCMCommand.getBIBusEnvelope((Stub)port)).getCAM()).element(CAM_CREDENTIAL))) {
                    this.encryptedCredentials = camCred.getText();
                }
                bl = true;
                if (port == null) break block10;
            }
            catch (Throwable e2) {
                boolean bl2;
                block11: {
                    try {
                        Exception e2;
                        boolean isNegotiateException = false;
                        try {
                            BIBusEnvelope envelope = BaseCMCommand.getBIBusEnvelope((Stub)port);
                            if (CMDataSourceViaDispatcher.parseAuthException(envelope)) {
                                this.base64EncodedSecurityBlob = envelope.getCAM().element(EXCEPTION).element(PROMPT_INFO).element(SECURITYBLOB).getText();
                                isNegotiateException = true;
                                SECBRIDGE_LOGGER.log("Generate Credential - SSO Exception recieved as part of negotiation");
                            }
                        }
                        catch (Exception ex) {
                            e2 = ex;
                        }
                        if (!isNegotiateException) {
                            throw new XQERuntimeException(XQEMessageKeys.CM_UnableToRetrieveCredentials, (Throwable)e2, namespace);
                        }
                        bl2 = false;
                        if (port == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (port != null) {
                            GenCredCommand.returnContentManagerServicePort(port);
                        }
                        throw throwable;
                    }
                    GenCredCommand.returnContentManagerServicePort(port);
                }
                return bl2;
            }
            GenCredCommand.returnContentManagerServicePort(port);
        }
        return bl;
    }

    private static String extractNamespace(String camNamespace) {
        String namespace = null;
        namespace = camNamespace.trim();
        int nsLength = namespace.length() - 2;
        namespace = namespace.substring(7, nsLength);
        return namespace;
    }

    public GenCredCommand(String namespace, CAMPassport camPassport, String connectionString, Locale locale) {
        boolean isKerberos = connectionString.contains("ibmcognos.authentication=java_krb5");
        this.generateCredentials(namespace, camPassport, isKerberos, locale);
    }

    public String getEncryptedCredentials() {
        return this.encryptedCredentials;
    }

    public JCAMImpersonator.DelegatedCredential getDelegatedCredential() {
        return this.credential;
    }

    public IResourceHolder<? extends ICryptoHandle> getCryptoHandle() {
        return this.cryptoHandle;
    }
}

