/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.cubingservices.DQServer;
import com.cognos.xqebifw.cubingservices.IServerListener;
import com.cognos.xqebifw.cubingservices.RequestWorker;
import com.cognos.xqebifw.cubingservices.Session;
import com.cognos.xqebifw.cubingservices.V5QueryHandler;
import com.cognos.xqebifw.cubingservices.WorkerThreadPool;
import com.cognos.xqebifw.cubingservices.messaging.MsgBox;
import com.cognos.xqebifw.cubingservices.messaging.XMLAResponseMessage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RequestDispatcher
implements IServerListener {
    private static final int DEFAULT_RETRY_COUNT = 7200;
    private static final int DEFAULT_SLEEP_PERIOD = 1000;
    protected int retryCount = 7200;
    protected int sleepPeriod = 1000;
    public static final int DEFAULT_QUERY_CONCURRENCY = 21;
    public static final int DEFAULT_MAX_CONCURRENCY = 21;
    public static final int DEFAULT_CONCURRENCY_INCREMENT = 10;
    protected volatile int maxConcurrency = 21;
    public static final long DISPATCH_TIMEOUT = 10L;
    public static final long MAX_DISPATCH_TIMEOUTS = 1000L;
    public static final int COM_QUERY_KEEP_ALIVE = 2000;
    public static final int BUF_SIZE = 262144;
    public static final int QUERY_LISTEN_PRIORITY = 9;
    public static final int QUERY_IO_PRIORITY = 8;
    protected int priority;
    private volatile boolean shutDown = false;
    protected boolean active = false;
    protected V5QueryHandler v5QueryHandler;
    protected long dispatchTimeout;
    private static final int MAX_CONSECUTIVE_RETRIES_ON_EMPTY_SELECT = 1000;
    private int consecutiveRetriesOnEmptySelect = 0;
    protected WorkerThreadPool threadPool;
    protected final AtomicInteger poolSize = new AtomicInteger();
    protected final LinkedBlockingQueue<MsgBox> availableMsgBoxes = new LinkedBlockingQueue();
    protected int commPort = 0;
    protected ServerSocket commSocket;
    private ServerSocketChannel commChannel;
    private Selector commSelector;
    private InetSocketAddress commAddr;
    private SelectionKey commSelectionKey;
    protected final ConcurrentHashMap<Long, Session> allSess = new ConcurrentHashMap();
    protected final AtomicLong sessionID = new AtomicLong(1L);
    private static XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
    private final int threadSize = configuration.getIntProperty("general.maxNumberOfThreads[@value]", -1);
    protected static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Disp", LogLevel.ERROR);
    protected boolean sendBackPortNumber = true;
    private List<SelectionKey> readSelectionKeys = new ArrayList<SelectionKey>();

    public int getCommPort() {
        return this.commPort;
    }

    public boolean initialize(V5QueryHandler handler) {
        this.v5QueryHandler = handler;
        this.priority = 9;
        this.dispatchTimeout = 10L;
        if (this.v5QueryHandler != null) {
            this.v5QueryHandler.registerServerListener(this);
        }
        this.setConcurrency(21, 21);
        this.setupServiceListener();
        this.setupServerURL();
        this.sendBackBoundPortNumbers();
        this.threadPool = new WorkerThreadPool(new LinkedBlockingQueue<Runnable>(), 21, 21, 2000L);
        this.active = this.threadPool.start();
        return this.active;
    }

    protected synchronized void setConcurrency(int core, int max) {
        this.maxConcurrency = max;
        int currentConcurrency = this.getQueryConcurrency();
        if (core > max) {
            core = max;
        }
        if (currentConcurrency >= core && currentConcurrency <= max) {
            return;
        }
        if (currentConcurrency > max) {
            for (int i = currentConcurrency - max; i > 0; --i) {
                MsgBox b = this.availableMsgBoxes.poll();
                if (b == null) {
                    return;
                }
                this.poolSize.decrementAndGet();
            }
            return;
        }
        this.addMsgBox(core, max, currentConcurrency);
    }

    protected void addMsgBox(int core, int max, int currentConcurrency) {
        if (currentConcurrency < core) {
            int numToAdd = core - currentConcurrency;
            ByteBuffer memSeg = ByteBuffer.allocateDirect(262144 * numToAdd);
            int l = memSeg.limit();
            int p = (numToAdd - 1) * 262144;
            int i = numToAdd - 1;
            while (i >= 0) {
                memSeg.position(p).limit(l);
                ByteBuffer buffer = memSeg.slice();
                MsgBox msgBox = new MsgBox(buffer);
                if (this.availableMsgBoxes.offer(msgBox)) {
                    this.poolSize.incrementAndGet();
                }
                --i;
                p -= 262144;
                l -= 262144;
            }
        }
    }

    public static MsgBox createOneTimeUseMsgBox() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(262144);
        MsgBox msgBox = new MsgBox(buffer);
        return msgBox;
    }

    private void setupServerURL() {
        StringBuilder url = new StringBuilder("http://");
        try {
            url.append(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, "Unable to determine server name");
        }
        url.append(":").append(this.commPort).append("/").append("IBMXmlAnalysis");
        V5QueryHandler.setServerURL(url.toString());
    }

    private void closeSocket(Session s) {
        SocketChannel socketChannel;
        if (s != null && (socketChannel = s.getChannel()) != null) {
            this.closeSocket(socketChannel.socket());
        }
    }

    private void closeSocket(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException ie) {
                LOGGER.log("Could not close socket due to " + ie.toString());
            }
        }
    }

    public void listen() {
        Thread t = Thread.currentThread();
        t.setPriority(this.priority);
        CountDownLatch dispatched = null;
        while (!this.isShutDown()) {
            int numSelected = 0;
            int numDispatched = 0;
            int numCancelled = 0;
            this.applyReadOps();
            try {
                numSelected = this.commSelector.select();
            }
            catch (IOException ioe) {
                this.setShutDown(ioe);
            }
            catch (ClosedSelectorException cse) {
                this.setShutDown(cse);
                break;
            }
            if (this.continueOnEmptySelect(numSelected)) continue;
            dispatched = new CountDownLatch(numSelected);
            long tickSumm = 0L;
            Set<SelectionKey> readyKeys = this.commSelector.selectedKeys();
            Iterator<SelectionKey> iter = readyKeys.iterator();
            while (iter.hasNext()) {
                SelectionKey key = iter.next();
                iter.remove();
                Session s = this.createSession(key, this.commSelector);
                if (s != null) {
                    s.addTick();
                    if (s.isTerminated()) {
                        this.closeSocket(s);
                        ++numCancelled;
                        dispatched.countDown();
                        s.removeTick();
                        if (LOGGER.isOn(LogLevel.INFO)) {
                            LOGGER.log(LogLevel.INFO, "Session found but isTerminated. " + s.toString());
                        }
                    } else if (!s.inUse()) {
                        s.getSelKey().interestOps(0);
                        s.setDispatched(dispatched);
                        if (this.execCom(s)) {
                            ++numDispatched;
                        } else {
                            LOGGER.log("Threadpool rejected session. " + s.toString());
                            ++numCancelled;
                            s.setFree();
                            dispatched.countDown();
                        }
                    } else {
                        dispatched.countDown();
                        s.removeTick();
                    }
                    if (tickSumm == Long.MAX_VALUE) continue;
                    if (tickSumm < Long.MAX_VALUE - s.getTick()) {
                        tickSumm += s.getTick();
                        continue;
                    }
                    tickSumm = Long.MAX_VALUE;
                    continue;
                }
                ++numCancelled;
                dispatched.countDown();
            }
            long timeout = this.getDispatchTimeout(numSelected, numDispatched, numCancelled, tickSumm);
            try {
                if (dispatched.await(timeout, TimeUnit.MILLISECONDS)) continue;
                if (LOGGER.isOn(LogLevel.INFO)) {
                    LOGGER.log(LogLevel.INFO, "Dispatch timeout");
                }
                numDispatched = -1;
            }
            catch (InterruptedException ie) {
                LOGGER.log("Dispatch latch await interrupted.", (Throwable)ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markForRead(SelectionKey selectionKey) {
        if (selectionKey != null) {
            List<SelectionKey> list = this.readSelectionKeys;
            synchronized (list) {
                this.readSelectionKeys.add(selectionKey);
            }
            this.commSelector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyReadOps() {
        List<SelectionKey> list = this.readSelectionKeys;
        synchronized (list) {
            for (SelectionKey selectionKey : this.readSelectionKeys) {
                if (!selectionKey.isValid()) continue;
                selectionKey.interestOps(1);
            }
            this.readSelectionKeys.clear();
        }
    }

    private boolean continueOnEmptySelect(int numSelected) {
        if (numSelected == 0) {
            if (!this.commSelector.isOpen()) {
                this.setShutDown("Communication selector is closed.");
            } else if (this.consecutiveRetriesOnEmptySelect >= 1000) {
                this.setShutDown("Max retries on emtpy select reached.");
            }
            ++this.consecutiveRetriesOnEmptySelect;
            return true;
        }
        this.consecutiveRetriesOnEmptySelect = 0;
        return false;
    }

    private Session createSession(SelectionKey key, Selector sel) {
        if (!key.isValid()) {
            if (LOGGER.isOn(LogLevel.INFO)) {
                LOGGER.log(LogLevel.INFO, "Channel selection key is invalid, cannot create session.");
            }
            return null;
        }
        Socket acptSoc = null;
        try {
            if (key.isAcceptable()) {
                ServerSocketChannel server = (ServerSocketChannel)key.channel();
                SocketChannel accptChan = server.accept();
                if (accptChan == null) {
                    LOGGER.log("Null channel on accept, cannot create session.");
                    return null;
                }
                acptSoc = accptChan.socket();
                acptSoc.setTcpNoDelay(true);
                accptChan.configureBlocking(false);
                SelectionKey readKey = accptChan.register(sel, 1);
                if (readKey == null || !readKey.isValid()) {
                    LOGGER.log("Invalid readKey.");
                    this.closeSocket(acptSoc);
                    return null;
                }
                Session sesAccpt = this.getNewQuerySession(readKey, accptChan);
                Object att = readKey.attach(sesAccpt);
                if (att != null) {
                    LOGGER.log("Overwrote an attachment. Cancelling.");
                    this.terminateSession(sesAccpt);
                    this.closeSocket(acptSoc);
                    return null;
                }
                return sesAccpt;
            }
        }
        catch (IOException ioe) {
            LOGGER.log(ioe);
            this.closeSocket(acptSoc);
            return null;
        }
        catch (CancelledKeyException cke) {
            LOGGER.log(cke);
            this.closeSocket(acptSoc);
            return null;
        }
        try {
            if (key.isReadable()) {
                Object obj = key.attachment();
                if (obj == null) {
                    if (LOGGER.isOn(LogLevel.INFO)) {
                        LOGGER.log(LogLevel.INFO, "Readable socket with no attachment.");
                    }
                    return null;
                }
                Session sesRead = (Session)obj;
                if (sesRead.isTerminated()) {
                    if (LOGGER.isOn(LogLevel.INFO)) {
                        LOGGER.log(LogLevel.INFO, "Readable session is terminated." + sesRead.toString());
                    }
                    this.closeSocket(sesRead);
                    return null;
                }
                return sesRead;
            }
        }
        catch (CancelledKeyException cke) {
            LOGGER.log(cke);
            return null;
        }
        if (LOGGER.isOn(LogLevel.INFO)) {
            LOGGER.log(LogLevel.INFO, "Socket not acceptable or readable.");
        }
        return null;
    }

    public boolean isShutDown() {
        return this.shutDown;
    }

    public void setShutDown(Exception reason) {
        LOGGER.log(reason);
        this.shutDown = true;
    }

    public void setShutDown(String reason) {
        LOGGER.log(reason);
        this.shutDown = true;
    }

    @Override
    public void shutdown() {
        if (this.active) {
            this.setShutDown("Shutdown request to terminate communication.");
            this.commSelector.wakeup();
            this.threadPool.stopNow();
            this.active = false;
        }
    }

    protected long getDispatchTimeout(int seld, int dispd, int cancd, long tickd) {
        int readPending = seld - cancd;
        long delay = 0L;
        if (tickd == Long.MAX_VALUE) {
            delay = 1000L;
        } else {
            delay = readPending + dispd * dispd;
            if (tickd < Long.MAX_VALUE - delay) {
                if ((delay += tickd) > 1000L) {
                    delay = 1000L;
                }
            } else {
                delay = 1000L;
            }
        }
        return delay * this.dispatchTimeout;
    }

    public boolean execCom(Session s) {
        RequestWorker comWorker = new RequestWorker(this, s);
        FutureTask<Session> comTask = new FutureTask<Session>(comWorker);
        try {
            this.threadPool.execute(comTask);
        }
        catch (RejectedExecutionException e) {
            if (!this.isShutDown()) {
                this.terminateSession(s);
                LOGGER.log(e);
            }
            return false;
        }
        return true;
    }

    protected void sendBackBoundPortNumbers() {
        if (this.sendBackPortNumber) {
            try {
                int queryServicePort = 0;
                String parentPort = System.getProperty("ParentProcessPort");
                if (parentPort != null) {
                    queryServicePort = Integer.parseInt(parentPort);
                }
                Socket socket = new Socket((String)null, queryServicePort);
                BufferedOutputStream outStream = new BufferedOutputStream(socket.getOutputStream());
                StringBuilder strBldr = new StringBuilder();
                strBldr.append(String.valueOf(this.commPort));
                strBldr.append(XMLAResponseMessage.CRLF);
                strBldr.append(String.valueOf(DQServer.getLocalProcessId()));
                strBldr.append(XMLAResponseMessage.CRLF);
                ((OutputStream)outStream).write(strBldr.toString().getBytes());
                ((OutputStream)outStream).flush();
                ((OutputStream)outStream).close();
                socket.close();
            }
            catch (Exception e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, "Unable to determine communication port number");
            }
        }
    }

    public final int getQueryConcurrency() {
        return this.poolSize.get();
    }

    public final int getNumAvailableMsgBoxes() {
        return this.availableMsgBoxes.size();
    }

    public void run() {
        this.listen();
        this.closeAllSessions();
        this.availableMsgBoxes.clear();
        this.commSelectionKey.cancel();
        try {
            this.commChannel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.commSelector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public V5QueryHandler getQueryHandler() {
        return this.v5QueryHandler;
    }

    private void setupServiceListener() {
        String localPort;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.commPort = 0;
        if (config != null) {
            this.commPort = config.getIntProperty("network.xqeService[@port]", 0);
        }
        if ((localPort = System.getProperty("LocalProcessPort")) != null) {
            this.commPort = Integer.parseInt(localPort);
            this.sendBackPortNumber = false;
        }
        try {
            this.commChannel = ServerSocketChannel.open();
            this.commSocket = this.commChannel.socket();
            this.commSelector = Selector.open();
            this.commAddr = new InetSocketAddress(this.commPort);
            this.commSocket.bind(this.commAddr);
            this.commPort = this.commSocket.getLocalPort();
            this.commChannel.configureBlocking(false);
            this.commSelectionKey = this.commChannel.register(this.commSelector, 16);
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, "Unable to initialize communications");
        }
    }

    protected Session getNewQuerySession(SelectionKey key, SocketChannel channel) {
        Session newSess = this.produceSession();
        newSess.setSelKey(key);
        newSess.setChannel(channel);
        return newSess;
    }

    public boolean terminateSession(Session s) {
        SocketChannel channel;
        s.setTerminated();
        long id = s.getId();
        SelectionKey k = s.getSelKey();
        if (k != null) {
            k.attach(null);
        }
        if ((channel = s.getChannel()) != null) {
            try {
                channel.close();
            }
            catch (Exception e) {
                LOGGER.log("Error terminating session", (Throwable)e);
            }
        }
        s.cleanup();
        Session o = this.allSess.remove(id);
        if (o == null) {
            LOGGER.log("ID not found in map, possible duplicate termination.");
            return false;
        }
        return true;
    }

    protected void closeAllSessions() {
        Enumeration<Session> ss = this.allSess.elements();
        while (ss.hasMoreElements()) {
            Session s = ss.nextElement();
            this.terminateSession(s);
        }
    }

    protected MsgBox getQueryMsgBox() {
        MsgBox cmb = null;
        try {
            cmb = this.availableMsgBoxes.take();
        }
        catch (InterruptedException e1) {
            return null;
        }
        return cmb;
    }

    protected void returnQueryMsgBox(MsgBox box) {
        box.reset();
        if (this.getQueryConcurrency() > this.maxConcurrency) {
            this.poolSize.decrementAndGet();
        } else {
            boolean recycled = this.availableMsgBoxes.offer(box);
            if (!recycled) {
                LOGGER.log(LogLevel.WARN, "Unable to recycle message box.");
            }
        }
    }

    private Session produceSession() {
        long newId;
        Session prevSession;
        Session newSession = new Session();
        while ((prevSession = this.allSess.putIfAbsent(newId = this.sessionID.getAndIncrement(), newSession)) != null) {
        }
        newSession.setId(newId);
        return newSession;
    }

    @Override
    public void setThreadPoolSize(int maxPoolSize, int corePoolSize) {
        if (this.threadSize != -1) {
            this.setConcurrency(this.threadSize, this.threadSize);
        } else {
            this.setConcurrency(corePoolSize, maxPoolSize);
        }
        this.threadPool.setCorePoolSize(corePoolSize);
        this.threadPool.setMaximumPoolSize(maxPoolSize);
    }
}

