/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.concurrent.ThreadPool;
import com.cognos.xqebifw.cubingservices.RequestDispatcher;
import com.cognos.xqebifw.cubingservices.SSLSession;
import com.cognos.xqebifw.cubingservices.Session;
import com.cognos.xqebifw.cubingservices.V5QueryHandler;
import com.cognos.xqebifw.cubingservices.WorkerThreadPool;
import com.cognos.xqebifw.cubingservices.messaging.MsgBox;
import com.cognos.xqebifw.cubingservices.messaging.SSLMsgBox;
import com.cognos.xqebifw.cubingservices.messaging.XMLAResponseMessage;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SSLSocket;

public class SSLRequestDispatcher
extends RequestDispatcher {
    private static final LinkedBlockingQueue<SSLSession> AVAILABLE_SESSIONS = new LinkedBlockingQueue();
    private static final ThreadPool SOCKET_READER_POOL = ThreadPool.getInstance();

    @Override
    public boolean initialize(V5QueryHandler handler) {
        this.v5QueryHandler = handler;
        this.priority = 9;
        this.dispatchTimeout = 10L;
        if (this.v5QueryHandler != null) {
            this.v5QueryHandler.registerServerListener(this);
        }
        this.setConcurrency(21, 21);
        this.setupServiceListener();
        this.setupServerURL();
        this.sendBackBoundPortNumbers();
        this.threadPool = new WorkerThreadPool(new LinkedBlockingQueue<Runnable>(), 21, 21, 2000L);
        this.active = this.threadPool.start();
        return this.active;
    }

    @Override
    protected void addMsgBox(int core, int max, int currentConcurrency) {
        if (currentConcurrency < core) {
            int numToAdd = core - currentConcurrency;
            for (int i = numToAdd - 1; i >= 0; --i) {
                SSLMsgBox msgBox = new SSLMsgBox();
                if (!this.availableMsgBoxes.offer(msgBox)) continue;
                this.poolSize.incrementAndGet();
            }
        }
    }

    public static MsgBox createOneTimeUseMsgBox() {
        SSLMsgBox sslMsgBox = new SSLMsgBox();
        return sslMsgBox;
    }

    protected void setupServerURL() {
        StringBuilder url = new StringBuilder("https://");
        try {
            url.append(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, "Unable to determine server name");
        }
        url.append(":").append(this.commPort).append("/").append("IBMXmlAnalysis");
        V5QueryHandler.setServerURL(url.toString());
    }

    @Override
    protected void sendBackBoundPortNumbers() {
        if (this.sendBackPortNumber) {
            try {
                int queryServicePort = 0;
                String parentPort = System.getProperty("ParentProcessPort");
                if (parentPort != null) {
                    queryServicePort = Integer.parseInt(parentPort);
                }
                SSLSocket sslSocket = (SSLSocket)CryptoProvider.createSocket((String)null, (int)queryServicePort, (boolean)true);
                BufferedOutputStream outStream = new BufferedOutputStream(sslSocket.getOutputStream());
                StringBuilder strBldr = new StringBuilder();
                strBldr.append(String.valueOf(this.commPort));
                strBldr.append(XMLAResponseMessage.CRLF);
                strBldr.append(String.valueOf(SSLRequestDispatcher.getLocalProcessId()));
                strBldr.append(XMLAResponseMessage.CRLF);
                ((OutputStream)outStream).write(strBldr.toString().getBytes());
                ((OutputStream)outStream).flush();
                ((OutputStream)outStream).close();
                sslSocket.close();
            }
            catch (Exception e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, "Unable to determine communication port number");
            }
        }
    }

    private static int getLocalProcessId() {
        String beanName = ManagementFactory.getRuntimeMXBean().getName();
        return Integer.parseInt(beanName.substring(0, beanName.indexOf("@")));
    }

    @Override
    public void listen() {
        Thread t = Thread.currentThread();
        t.setPriority(this.priority);
        SocketListener socketListener = new SocketListener();
        Thread listenerThread = new Thread(new FutureTask(socketListener), "ListenerThread");
        listenerThread.start();
        SSLSession availableSession = null;
        while (!this.isShutDown()) {
            try {
                availableSession = AVAILABLE_SESSIONS.take();
                if (availableSession == null) continue;
                availableSession.setUsed();
                if (!this.execCom(availableSession)) {
                    LOGGER.log("Threadpool rejected session. " + availableSession.toString());
                    availableSession.setFree();
                }
                availableSession = null;
            }
            catch (Exception e) {
                LOGGER.log("Socket Exception.", (Throwable)e);
            }
        }
    }

    public static void addAvailableSession(SSLSession availableSession) {
        AVAILABLE_SESSIONS.offer(availableSession);
    }

    public static ThreadPool getSocketReaderPool() {
        return SOCKET_READER_POOL;
    }

    @Override
    public void shutdown() {
        if (this.active) {
            this.setShutDown("Shutdown request to terminate communication.");
            this.threadPool.stopNow();
            SOCKET_READER_POOL.shutdown();
            AVAILABLE_SESSIONS.clear();
            this.active = false;
        }
    }

    @Override
    public void run() {
        this.listen();
        super.closeAllSessions();
        this.availableMsgBoxes.clear();
        try {
            this.commSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setupServiceListener() {
        String localPort;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.commPort = 0;
        if (config != null) {
            this.commPort = config.getIntProperty("network.xqeService[@port]", 0);
        }
        if ((localPort = System.getProperty("LocalProcessPort")) != null) {
            this.commPort = Integer.parseInt(localPort);
            this.sendBackPortNumber = false;
        }
        try {
            this.commSocket = CryptoProvider.createServerSocket((int)this.commPort, (boolean)true);
            this.commPort = this.commSocket.getLocalPort();
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, "Unable to initialize communications");
        }
    }

    protected SSLSession getNewQuerySession(SSLSocket sslSocket) {
        SSLSession newSess = this.produceSession();
        newSess.setSSLSocket(sslSocket);
        return newSess;
    }

    protected SSLSession produceSession() {
        long newId;
        Session prevSession;
        SSLSession newSession = new SSLSession();
        while ((prevSession = (Session)this.allSess.putIfAbsent(newId = this.sessionID.getAndIncrement(), newSession)) != null) {
        }
        newSession.setId(newId);
        return newSession;
    }

    @Override
    public boolean terminateSession(Session s) {
        s.setTerminated();
        try {
            ((SSLSession)s).closeSocket();
        }
        catch (Exception exception) {
            // empty catch block
        }
        long id = s.getId();
        s.cleanup();
        Object o = this.allSess.remove(id);
        if (o == null) {
            LOGGER.log("ID not found in map, possible duplicate termination.");
            return false;
        }
        return true;
    }

    private class SocketListener<V>
    implements Callable<V> {
        private SocketListener() {
        }

        @Override
        public V call() {
            SSLSocket sslSocket = null;
            try {
                while (!SSLRequestDispatcher.this.isShutDown()) {
                    sslSocket = (SSLSocket)SSLRequestDispatcher.this.commSocket.accept();
                    sslSocket.setTcpNoDelay(true);
                    AVAILABLE_SESSIONS.offer(SSLRequestDispatcher.this.getNewQuerySession(sslSocket));
                }
            }
            catch (IOException ioe) {
                SSLRequestDispatcher.this.setShutDown(ioe);
            }
            catch (IllegalStateException ie) {
                SSLRequestDispatcher.this.setShutDown(ie);
            }
            return null;
        }
    }
}

