/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices.messaging;

import com.cognos.xqebifw.cubingservices.Session;
import com.cognos.xqebifw.cubingservices.messaging.AbstractSocketOutputStream;
import com.cognos.xqebifw.cubingservices.messaging.HTTPSocketChannelOutputStream;
import com.cognos.xqebifw.cubingservices.messaging.XMLAMessage;
import com.cognos.xqebifw.cubingservices.messaging.XMLAResponseMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;

public class MsgBox {
    protected static final int CHANNEL_READ_TIMEOUT = 300000;
    protected static final long MAX_RETRY = 1000000L;
    protected static final long RETRY_TIMEOUT = 10L;
    private Session session;
    protected CommState status;
    protected static final int EOS = -1;
    protected static final int MIN_LENGTH_HTTP = "POST /IBMXmlAnalysis HTTP/1.1\r\n".length();
    protected byte[] data;
    private ByteBuffer buf;
    FileChannel saveChannel = null;

    public boolean isOk() {
        return this.status == CommState.OK;
    }

    protected MsgBox() {
    }

    public MsgBox(ByteBuffer directBuffer) {
        this.buf = directBuffer;
        this.reset();
    }

    public void reset() {
        this.session = null;
        this.status = CommState.OK;
        this.data = null;
        if (this.buf != null) {
            this.buf.clear();
        }
    }

    private int readData(SocketChannel readChannel, int minAmount, Session runSess) {
        int count = -1;
        int total = 0;
        this.buf.clear();
        long startTime = System.currentTimeMillis();
        do {
            try {
                count = readChannel.read(this.buf);
                if (runSess != null) {
                    runSess.setRunning();
                }
                if (count != 0) continue;
                if (System.currentTimeMillis() - startTime > 300000L) {
                    this.status = CommState.TIMEOUT;
                }
                Thread.sleep(1L);
            }
            catch (ClosedByInterruptException cbi) {
                this.status = CommState.INTERRUPTED;
            }
            catch (NotYetConnectedException nce) {
                this.status = CommState.READ_NOT_CONNECTED;
            }
            catch (AsynchronousCloseException ace) {
                this.status = CommState.CHANNEL_CLOSED;
            }
            catch (ClosedChannelException coc) {
                this.status = CommState.CHANNEL_CLOSED;
            }
            catch (IOException aioe) {
                this.status = CommState.IOERROR;
            }
            catch (InterruptedException e) {
                this.status = CommState.INTERRUPTED;
            }
        } while ((total += count) < minAmount && count != -1 && this.isOk());
        if (!this.isOk()) {
            return total;
        }
        if (count == -1) {
            return count;
        }
        return total;
    }

    private void readRest(SocketChannel readChannel, int pos, int total) {
        int chunkLen = this.buf.capacity();
        int amount = 0;
        int count = -1;
        while (total > 0) {
            if (total > chunkLen) {
                amount = chunkLen;
                total -= chunkLen;
            } else {
                amount = total;
                total = 0;
            }
            count = this.readData(readChannel, amount, null);
            if (!this.isOk()) {
                return;
            }
            if (count == -1) {
                this.status = CommState.END_OF_STREAM;
                return;
            }
            byte[] dataStream = this.getStream(this.buf);
            if (dataStream == null) {
                this.status = CommState.PROTOCOL_READ_ERROR;
                return;
            }
            pos = this.moveArr(this.data, dataStream, pos, 0);
        }
    }

    private void readRest(XMLAMessage inMsg, SocketChannel readChannel, int pos, int total) {
        int chunkLen = this.buf.capacity();
        int amount = 0;
        int count = -1;
        byte[] dataStream = null;
        while (total > 0) {
            if (total > chunkLen) {
                amount = chunkLen;
                total -= chunkLen;
            } else {
                amount = total;
                total = 0;
            }
            count = this.readData(readChannel, amount, null);
            if (!this.isOk()) {
                return;
            }
            if (count == -1) {
                this.status = CommState.END_OF_STREAM;
                return;
            }
            dataStream = this.getStream(this.buf);
            if (dataStream == null) {
                this.status = CommState.PROTOCOL_READ_ERROR;
                return;
            }
            pos = this.moveArr(this.data, dataStream, pos, 0, amount);
        }
        inMsg.setDataStream(dataStream);
        inMsg.setLastOffset(amount);
        inMsg.setLastLimit(this.buf.limit());
        inMsg.setLastPosition(this.buf.position());
    }

    private int readMoreData(SocketChannel readChannel, int minAmount, Session runSess) {
        int count = -1;
        int total = 0;
        long startTime = System.currentTimeMillis();
        do {
            try {
                count = readChannel.read(this.buf);
                if (runSess != null) {
                    runSess.setRunning();
                }
                if (count != 0) continue;
                int savedPos = this.buf.position();
                if (savedPos >= this.buf.limit()) {
                    ByteBuffer tmp = ByteBuffer.allocateDirect(this.buf.capacity() * 2);
                    this.buf.flip();
                    tmp.put(this.buf);
                    tmp.position(savedPos);
                    tmp.limit(tmp.capacity());
                    this.buf = tmp;
                } else if (System.currentTimeMillis() - startTime > 300000L) {
                    this.status = CommState.TIMEOUT;
                }
                Thread.sleep(1L);
            }
            catch (ClosedByInterruptException cbi) {
                this.status = CommState.INTERRUPTED;
            }
            catch (NotYetConnectedException nce) {
                this.status = CommState.READ_NOT_CONNECTED;
            }
            catch (AsynchronousCloseException ace) {
                this.status = CommState.CHANNEL_CLOSED;
            }
            catch (ClosedChannelException coc) {
                this.status = CommState.CHANNEL_CLOSED;
            }
            catch (IOException aioe) {
                this.status = CommState.IOERROR;
            }
            catch (InterruptedException e) {
                this.status = CommState.INTERRUPTED;
            }
        } while ((total += count) < minAmount && count != -1 && this.isOk());
        if (!this.isOk()) {
            return total;
        }
        if (count == -1) {
            return count;
        }
        return total;
    }

    private byte[] getStream(ByteBuffer b) {
        b.flip();
        int amount = b.limit() - b.position();
        if (amount <= 0) {
            return null;
        }
        byte[] m = new byte[amount];
        b.get(m);
        return m;
    }

    protected int moveArr(byte[] target, byte[] source, int tgtIdx, int srcIdx) {
        int len = source.length - srcIdx;
        return this.moveArr(target, source, tgtIdx, srcIdx, len);
    }

    protected int moveArr(byte[] target, byte[] source, int tgtIdx, int srcIdx, int len) {
        System.arraycopy(source, srcIdx, target, tgtIdx, len);
        return tgtIdx + len;
    }

    public CommState unwrapXMLAMsg(Session sesRead) {
        this.status = CommState.OK;
        this.session = sesRead;
        SocketChannel readChannel = this.session.getChannel();
        int count = this.readData(readChannel, MIN_LENGTH_HTTP, sesRead);
        this.session.removeTick();
        if (!this.isOk()) {
            return this.status;
        }
        int lastLimit = this.buf.limit();
        int lastPosition = this.buf.position();
        byte[] dataStream = this.getStream(this.buf);
        if (dataStream == null) {
            this.status = CommState.PROTOCOL_READ_ERROR;
            return this.status;
        }
        ByteArrayInputStream bs = new ByteArrayInputStream(dataStream);
        XMLAMessage inMsg = (XMLAMessage)this.session.getLastInputMessage();
        if (inMsg == null) {
            inMsg = new XMLAMessage(bs, true);
        } else {
            inMsg.resetInput(bs);
        }
        CommState rc = CommState.OK;
        inMsg.setStatus(rc);
        int hdrsLen = 0;
        int entLen = -1;
        long retNo = 0L;
        while (!inMsg.hasHdrs()) {
            try {
                inMsg.unpack();
            }
            catch (Exception e) {
                this.status = CommState.HTTP_BAD_MSG_HEADER;
            }
            if (!this.isOk()) {
                return this.status;
            }
            if (inMsg.getStatus() == CommState.EOS) {
                inMsg.setStatus(CommState.OK);
            }
            if (!this.isOk()) {
                return this.status;
            }
            hdrsLen = inMsg.getMsgLength();
            if (hdrsLen < -1) {
                this.status = CommState.HTTP_INTERNAL_ERROR;
            }
            if (!this.isOk()) {
                return this.status;
            }
            entLen = inMsg.getEntLen();
            if (inMsg.hasHdrs() && (entLen < 0 || this.buf.position() >= hdrsLen + entLen)) continue;
            if (++retNo > 1000000L) {
                this.status = CommState.PROTOCOL_READ_TIMEDOUT;
                return this.status;
            }
            try {
                TimeUnit.MICROSECONDS.sleep(retNo * 10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Thread.yield();
            this.buf.limit(lastLimit);
            this.buf.position(lastPosition);
            count = this.readMoreData(readChannel, 1, sesRead);
            if (!this.isOk()) {
                return this.status;
            }
            lastLimit = this.buf.limit();
            lastPosition = this.buf.position();
            dataStream = this.getStream(this.buf);
            if (dataStream == null) {
                this.status = CommState.PROTOCOL_READ_ERROR;
                return this.status;
            }
            bs = new ByteArrayInputStream(dataStream);
            inMsg.resetInput(bs);
        }
        if (entLen > 0) {
            if (hdrsLen + entLen > this.buf.capacity()) {
                this.data = new byte[entLen];
                int tpos = 0;
                int spos = hdrsLen - 1;
                tpos = this.moveArr(this.data, dataStream, tpos, spos);
                this.readRest(readChannel, tpos, entLen - (count - hdrsLen));
                if (!this.isOk()) {
                    return this.status;
                }
                bs = new ByteArrayInputStream(this.data);
                inMsg.setInput(bs);
            }
        } else if (inMsg.isChunked()) {
            if (dataStream != null) {
                inMsg.setDataStream(dataStream);
                dataStream = null;
                bs = null;
            }
            inMsg.setChunkCtx(lastLimit, lastPosition, hdrsLen);
            boolean done = false;
            byte[] chunk = null;
            while (!done) {
                chunk = this.getChunk(inMsg, readChannel);
                if (!this.isOk()) {
                    return this.status;
                }
                if (chunk == null) {
                    this.status = CommState.HTTP_CHUNK_ERROR;
                    return this.status;
                }
                if (chunk.length > 0) {
                    inMsg.addChunk(chunk);
                    continue;
                }
                done = true;
            }
            int footersLen = 0;
            retNo = 0L;
            while (!inMsg.hasFooters()) {
                int lineL = -1;
                retNo = 0L;
                inMsg.setStatus(CommState.OK);
                while (lineL < 0) {
                    lineL = inMsg.readHdrLine(retNo == 0L);
                    if (inMsg.getStatus() == CommState.EOS) {
                        inMsg.setStatus(CommState.OK);
                    }
                    if (!this.isOk()) {
                        return this.status;
                    }
                    if (lineL >= 0) continue;
                    if (++retNo > 1000000L) {
                        this.status = CommState.PROTOCOL_READ_TIMEDOUT;
                        return this.status;
                    }
                    try {
                        TimeUnit.MICROSECONDS.sleep(retNo * 10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Thread.yield();
                    this.buf.clear();
                    count = this.readData(readChannel, 1, null);
                    if (!this.isOk()) {
                        return this.status;
                    }
                    inMsg.setLastLimit(this.buf.limit());
                    inMsg.setLastPosition(this.buf.position());
                    byte[] ds = this.getStream(this.buf);
                    if (ds == null) {
                        this.status = CommState.PROTOCOL_READ_ERROR;
                        return this.status;
                    }
                    inMsg.setDataStream(ds);
                    inMsg.setInput(new ByteArrayInputStream(inMsg.getDataStream()));
                    inMsg.setLastOffset(0);
                }
                footersLen = inMsg.getMsgLength() - hdrsLen;
                if (footersLen < 0) {
                    this.status = CommState.HTTP_INTERNAL_ERROR;
                }
                if (this.isOk()) continue;
                return this.status;
            }
            inMsg.setDataStream(null);
            byte[] allChunks = inMsg.getCoalescedChunk();
            if (allChunks == null) {
                this.status = CommState.HTTP_CHUNK_ERROR;
                return this.status;
            }
            bs = new ByteArrayInputStream(allChunks);
            inMsg.setInput(bs);
        } else {
            throw new IllegalStateException("Invalid incoming message");
        }
        this.session.setLastInputMessage(inMsg);
        return this.status;
    }

    private byte[] getChunk(XMLAMessage inMsg, SocketChannel readChannel) {
        byte[] chunk = null;
        int lineL = this.getChunkSize(inMsg, readChannel);
        if (lineL < 0) {
            this.status = CommState.BAD_MSG_BODY;
        }
        if (!this.isOk()) {
            return chunk;
        }
        inMsg.setLastOffset(inMsg.getLastOffset() + lineL - inMsg.skipLen());
        chunk = this.getChunkData(inMsg, readChannel);
        return chunk;
    }

    private int getChunkSize(XMLAMessage inMsg, SocketChannel readChannel) {
        int lineL = -1;
        int count = -1;
        long retNo = 0L;
        inMsg.setStatus(CommState.OK);
        while (lineL < 0) {
            lineL = inMsg.readEntLine(retNo == 0L);
            if (!this.isOk()) {
                return lineL;
            }
            if (lineL >= 0) continue;
            if (++retNo > 1000000L) {
                this.status = CommState.PROTOCOL_READ_TIMEDOUT;
                return lineL;
            }
            try {
                TimeUnit.MICROSECONDS.sleep(retNo * 10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Thread.yield();
            this.buf.clear();
            count = this.readData(readChannel, 1, null);
            inMsg.setLastLimit(this.buf.limit());
            inMsg.setLastPosition(this.buf.position());
            byte[] ds = this.getStream(this.buf);
            if (ds == null) {
                this.status = CommState.PROTOCOL_READ_ERROR;
                return lineL;
            }
            inMsg.setDataStream(ds);
            inMsg.setInput(new ByteArrayInputStream(inMsg.getDataStream()));
            inMsg.setLastOffset(0);
        }
        return lineL;
    }

    private byte[] getChunkData(XMLAMessage inMsg, SocketChannel readChannel) {
        byte[] chunk = null;
        int chunkLen = inMsg.getLastChunkLen();
        if (chunkLen < 0) {
            throw new IllegalArgumentException("Invalid chunk length " + chunkLen);
        }
        if (chunkLen == 0) {
            return new byte[0];
        }
        if (inMsg.getLastOffset() + chunkLen > inMsg.getLastPosition()) {
            this.data = new byte[chunkLen];
            int tpos = 0;
            int spos = inMsg.getLastOffset();
            tpos = this.moveArr(this.data, inMsg.getDataStream(), tpos, spos);
            int haveLen = inMsg.getLastPosition() - inMsg.getLastOffset();
            int needLen = chunkLen - haveLen;
            this.readRest(inMsg, readChannel, tpos, needLen);
            if (!this.isOk()) {
                return chunk;
            }
            inMsg.setInput(new ByteArrayInputStream(inMsg.getDataStream()));
            try {
                inMsg.getInputStream().skip(needLen);
            }
            catch (Exception e) {
                this.status = CommState.BAD_MSG_BODY;
            }
            if (!this.isOk()) {
                return chunk;
            }
            return this.data;
        }
        chunk = new byte[chunkLen];
        this.moveArr(chunk, inMsg.getDataStream(), 0, inMsg.getLastOffset(), chunkLen);
        try {
            inMsg.getInputStream().skip(chunkLen);
        }
        catch (Exception e) {
            this.status = CommState.BAD_MSG_BODY;
        }
        inMsg.setLastOffset(inMsg.getLastOffset() + chunkLen);
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommState wrapXMLAMsg(Session sesWrite) {
        this.status = CommState.OK;
        this.data = null;
        this.session = sesWrite;
        SocketChannel writeChannel = this.session.getChannel();
        HTTPSocketChannelOutputStream httpSocketChannelOutputStream = new HTTPSocketChannelOutputStream(this.buf, writeChannel);
        try {
            XMLAResponseMessage outMsg = (XMLAResponseMessage)sesWrite.getLastOutputMessage();
            sesWrite.setLastOutputMessage(null);
            try {
                outMsg.pack();
            }
            catch (Exception e) {
                CommState commState = this.status = CommState.HTTP_BAD_MSG_HEADER;
                try {
                    httpSocketChannelOutputStream.close();
                }
                catch (IOException e2) {
                    this.status = CommState.IOERROR;
                }
                return commState;
            }
            this.data = outMsg.getMessageStatus();
            if (this.data == null || this.data.length == 0) {
                CommState commState = this.status = CommState.HTTP_BAD_MSG_STATUS;
                return commState;
            }
            if (this.writeMessageInfo(outMsg, httpSocketChannelOutputStream, this.data) != CommState.OK) {
                CommState commState = this.status;
                return commState;
            }
            this.data = outMsg.getMessageHeader();
            if (this.data != null && this.data.length > 0) {
                if (this.writeMessageInfo(outMsg, httpSocketChannelOutputStream, this.data) != CommState.OK) {
                    CommState commState = this.status;
                    return commState;
                }
                if (this.writeMessageBody(outMsg, httpSocketChannelOutputStream) != CommState.OK) {
                    CommState commState = this.status;
                    return commState;
                }
            }
        }
        finally {
            try {
                httpSocketChannelOutputStream.close();
            }
            catch (IOException e) {
                this.status = CommState.IOERROR;
            }
        }
        return this.status;
    }

    protected CommState writeMessageInfo(XMLAResponseMessage responseMessage, AbstractSocketOutputStream abstractSocketOutputStream, byte[] info) {
        try {
            responseMessage.writeMessageInfo(abstractSocketOutputStream, info);
        }
        catch (ClosedByInterruptException cbie) {
            this.status = CommState.INTERRUPTED;
        }
        catch (NotYetConnectedException nyce) {
            this.status = CommState.WRITE_NOT_CONNECTED;
        }
        catch (AsynchronousCloseException ace) {
            this.status = CommState.CHANNEL_CLOSED;
        }
        catch (ClosedChannelException cce) {
            this.status = CommState.CHANNEL_CLOSED;
        }
        catch (IOException ioe) {
            this.status = CommState.IOERROR;
        }
        return this.status;
    }

    protected CommState writeMessageBody(XMLAResponseMessage responseMessage, AbstractSocketOutputStream abstractSocketOutputStream) {
        try {
            responseMessage.writeMessageBody(abstractSocketOutputStream);
        }
        catch (ClosedByInterruptException cbie) {
            this.status = CommState.INTERRUPTED;
        }
        catch (NotYetConnectedException nyce) {
            this.status = CommState.WRITE_NOT_CONNECTED;
        }
        catch (AsynchronousCloseException ace) {
            this.status = CommState.CHANNEL_CLOSED;
        }
        catch (ClosedChannelException cce) {
            this.status = CommState.CHANNEL_CLOSED;
        }
        catch (IOException ioe) {
            this.status = CommState.HTTP_WRITER_ERROR;
        }
        return this.status;
    }

    public static enum CommState {
        EOS,
        OK,
        CHANNEL_CLOSED,
        INTERRUPTED,
        IOERROR,
        READ_NOT_CONNECTED,
        END_OF_STREAM,
        PROTOCOL_READ_ERROR,
        BAD_MSG_BODY,
        PROTOCOL_BAD_HDR,
        PROTOCOL_READ_TIMEDOUT,
        BUFFER_SIZE_EXCEEDED,
        HTTP_METHOD_UNSUPPORTED,
        HTTP_HDR_PARSE_ERROR,
        HTTP_HDR_CODEC_UNSUPP,
        HTTP_HDR_ENCRYPT_UNSUPP,
        HTTP_UNKNOWN_SERVLET,
        HTTP_UNAUTHORIZED,
        HTTP_NO_SOAP_ACTION,
        HTTP_BAD_SOAP_ACTION,
        HTTP_BAD_SOAP_MESSAGE,
        HTTP_SOAP_MESSAGE_ERROR,
        HTTP_WRITER_ERROR,
        HTTP_BAD_MSG_STATUS,
        HTTP_BAD_MSG_HEADER,
        HTTP_CHUNK_ERROR,
        HTTP_INTERNAL_ERROR,
        HTTP_BAD_CHUNK_SIZE,
        HTTP_NO_CHUNK_SIZE,
        HTTP_FORBIDDEN,
        WRITE_NOT_CONNECTED,
        TIMEOUT;

    }
}

