/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.management;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.management.XqeMBeanServer;
import com.cognos.xqe.management.XqeRMIAuthenticator;
import com.cognos.xqe.management.XqeRMIConnector;
import com.cognos.xqe.metrics.MemoryMetricsUpdater;
import com.cognos.xqe.metrics.MetricsManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqebifw.management.PackageCacheMetrics;
import com.cognos.xqebifw.management.WaitDataCollector;
import com.cognos.xqebifw.management.XqeSALMetrics;
import com.cognos.xqebifw.management.XqeSystemMetricsProxyCreator;
import com.cognos.xqebifw.metrics.XqeSystemMetricsManager;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public final class XqeAgent {
    private static final int C_100 = 100;
    public static final String DISPATCHER_PASSWORD = "disp_sharedsecret";
    private static XQELogger mLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MIB", LogLevel.ERROR);
    public static final String LOCALHOST = "localhost";
    private static final String STR_SLASH = "/";
    private static boolean isXqeJmxUrlRegistered = false;
    private static final int DISP_HESSIAN_CONNECTOR_MAX_RETRIES = 100;
    public static final String INTERNAL_DISP = "internalDispatcher";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String COLON = ":";
    private boolean htmlEnabled = false;
    private int htmlPort = 0;
    private MemoryMetricsUpdater memoryMetricsUpdater;
    private static SingletonHelper<XqeAgent> singletonHelper = new SingletonHelper<XqeAgent>(){

        @Override
        protected XqeAgent newInstance() {
            return new XqeAgent();
        }

        @Override
        protected void initializeImpl(XqeAgent theInstance) {
            theInstance.initialize();
        }

        @Override
        protected void releaseImpl(XqeAgent theInstance) {
            theInstance.terminate();
        }
    };
    private MBeanServer mbeanServer = null;

    public static XqeAgent getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    public static boolean isXqeJmxUrlRegistered() {
        return isXqeJmxUrlRegistered;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    private void initialize() {
        this.memoryMetricsUpdater = new MemoryMetricsUpdater();
        this.mbeanServer = XqeMBeanServer.getInstance();
        System.setProperty("mx4j.remote.resolver.pkgs", "com.cognos.pogo.monitoring.jmx.remote.resolver");
        XqeSALMetrics.start(this.mbeanServer);
        XqeSystemMetricsManager.start(this.mbeanServer);
        WaitDataCollector.registerMBean();
        PackageCacheMetrics.registerMBean();
        MetricsManager.createAllMetrics();
        this.memoryMetricsUpdater.startMemoryMetricsUpdateTask();
    }

    private void terminate() {
        XqeSALMetrics.stop();
        XqeSystemMetricsManager.stop();
        WaitDataCollector.unregisterMBean();
        PackageCacheMetrics.unregisterMBean();
        XqeAgent.deregisterXqeJmxUrl();
        this.memoryMetricsUpdater.stopMemoryMetricsUpdateTask();
    }

    public static synchronized void updateDispatcherMBeans(final ICCLConfiguration cclConfig) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                String errorMessage = "ERROR: Failed connecting to Dispatcher's Hessian Connection Server. Could not register XQE's JMX URL in Dispatchers MBeanServer.";
                int retryCount = 0;
                int sleepTime = 5000;
                try {
                    JMXConnector cntor = null;
                    for (retryCount = 0; retryCount < 100; ++retryCount) {
                        block10: {
                            try {
                                Thread.sleep(5000L);
                                cntor = XqeAgent.getDispatcherJMXConnection(cclConfig);
                                MBeanServerConnection mbeanServerConnection = null;
                                if (cntor == null) break block10;
                                mbeanServerConnection = cntor.getMBeanServerConnection();
                                ObjectName obName = new ObjectName("com.cognos:type=config,service=XqeJMXConfigMBean");
                                mbeanServerConnection.setAttribute(obName, new Attribute("Url", XqeRMIConnector.getConnectionString()));
                                mbeanServerConnection.setAttribute(obName, new Attribute("Credentials", XqeRMIAuthenticator.getLocalCredentials()));
                                Boolean returnState = (Boolean)mbeanServerConnection.invoke(obName, "checkUrlAndPassword", new Object[]{XqeRMIConnector.getConnectionString(), XqeRMIAuthenticator.getLocalCredentials()}, new String[]{XqeAgent.JAVA_LANG_STRING, XqeAgent.JAVA_LANG_STRING});
                                ObjectName metricsName = new ObjectName(XqeSystemMetricsProxyCreator.getMBeanName());
                                mbeanServerConnection.invoke(metricsName, "createProxies", new Object[]{XqeRMIConnector.getConnectionString()}, new String[]{XqeAgent.JAVA_LANG_STRING});
                                if (!returnState.booleanValue()) break block10;
                                isXqeJmxUrlRegistered = true;
                            }
                            catch (SecurityException x) {
                                mLogger.log(x);
                                this.closeConnector(cntor);
                                continue;
                            }
                            catch (IOException e) {
                                mLogger.log(LogLevel.INFO, (Throwable)e);
                                this.closeConnector(cntor);
                                continue;
                                {
                                    catch (Throwable throwable) {
                                        this.closeConnector(cntor);
                                        throw throwable;
                                    }
                                }
                            }
                            this.closeConnector(cntor);
                            break;
                        }
                        this.closeConnector(cntor);
                        continue;
                    }
                    if (retryCount >= 100) {
                        mLogger.log(errorMessage);
                    }
                }
                catch (Exception e) {
                    mLogger.log(e);
                }
            }

            private void closeConnector(JMXConnector cntor) {
                if (cntor != null) {
                    try {
                        cntor.close();
                    }
                    catch (IOException e1) {
                        mLogger.log(e1);
                    }
                }
            }
        }.start();
    }

    public static JMXConnector getDispatcherJMXConnection(ICCLConfiguration cclConfig) {
        try {
            String errorStr = "Unable to determine dispatcher JMX URL from dispatcher URL ";
            String dispAddr = cclConfig.getValue(INTERNAL_DISP, false);
            String password = cclConfig.getValue(DISPATCHER_PASSWORD, false);
            byte[] token = CryptoProvider.getToken((byte[])password.getBytes());
            URL url = new URL(dispAddr);
            String dispJxmUrl = XqeAgent.makeDispatcherJmxUrl(url, false);
            if (dispJxmUrl == null) {
                throw new IllegalStateException(errorStr + dispAddr);
            }
            JMXConnector cntor = XqeAgent.getDispatcherJMXConnection(dispJxmUrl, token);
            if (cntor == null && url.getHost().equalsIgnoreCase(LOCALHOST)) {
                dispJxmUrl = XqeAgent.makeDispatcherJmxUrl(url, true);
                if (dispJxmUrl == null) {
                    throw new IllegalStateException(errorStr + dispAddr);
                }
                cntor = XqeAgent.getDispatcherJMXConnection(dispJxmUrl, token);
            }
            XqeRMIAuthenticator.setLocalCredentials(password);
            XqeRMIAuthenticator.setDispatcherJmxUrl(dispJxmUrl);
            return cntor;
        }
        catch (Exception ex) {
            mLogger.log(ex);
            return null;
        }
    }

    public static JMXConnector getDispatcherJMXConnection() {
        return XqeAgent.getDispatcherJMXConnection(XQECCLConfigurationFactory.getInstance());
    }

    private XqeAgent() {
    }

    public static String normalizeLocalhost(String host, boolean useIP) throws UnknownHostException {
        if (host.equalsIgnoreCase(LOCALHOST)) {
            if (useIP) {
                return InetAddress.getLocalHost().getHostAddress();
            }
            return InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        return host.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterXqeJmxUrl() {
        JMXConnector cntor = null;
        try {
            String credentials = XqeRMIAuthenticator.getLocalCredentials();
            if (credentials != null) {
                String jmxUrl = XqeRMIAuthenticator.getDispatcherJmxUrl();
                JMXServiceURL url = new JMXServiceURL(jmxUrl);
                HashMap<String, Object> env = new HashMap<String, Object>();
                byte[] token = CryptoProvider.getToken((byte[])credentials.getBytes());
                env.put("jmx.remote.credentials", token);
                env.put("request.waiting.timeout", 300000);
                cntor = JMXConnectorFactory.connect(url, env);
                MBeanServerConnection mbeanServerConnection = cntor.getMBeanServerConnection();
                ObjectName obName = new ObjectName("com.cognos:type=config,service=XqeJMXConfigMBean");
                mbeanServerConnection.invoke(obName, "removeXqeJMXURL", new Object[]{XqeRMIConnector.getConnectionString()}, new String[]{JAVA_LANG_STRING});
            }
        }
        catch (ConnectException connectException) {
        }
        catch (SocketException socketException) {
        }
        catch (Exception exception) {
        }
        finally {
            XqeAgent.closeConnector(cntor);
        }
    }

    private static void closeConnector(JMXConnector cntor) {
        if (cntor != null) {
            try {
                cntor.close();
            }
            catch (IOException e1) {
                mLogger.log(e1);
            }
        }
    }

    public static String makeDispatcherJmxUrl(URL dispURL, boolean useIP) {
        int endIndex;
        String ctx = "/p2pd";
        String path = dispURL.getPath();
        if (path != null && path.length() > 1 && (endIndex = path.indexOf(STR_SLASH, 1)) != -1) {
            ctx = path.substring(0, endIndex);
        }
        String hessian = "hessian";
        if (dispURL.getProtocol().equalsIgnoreCase("https")) {
            hessian = "hessian+ssl";
        }
        String host = null;
        try {
            host = XqeAgent.normalizeLocalhost(dispURL.getHost(), useIP);
        }
        catch (UnknownHostException e) {
            return null;
        }
        StringBuilder builder = new StringBuilder("service:jmx:");
        builder.append(hessian).append("://").append(host).append(COLON).append(dispURL.getPort()).append(ctx).append("/hessian");
        return builder.toString();
    }

    public static synchronized JMXConnector getDispatcherJMXConnection(String dispJxmUrl, byte[] token) {
        JMXConnector cntor = null;
        try {
            JMXServiceURL url = new JMXServiceURL(dispJxmUrl);
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("jmx.remote.credentials", token);
            env.put("request.waiting.timeout", 300000);
            cntor = JMXConnectorFactory.connect(url, env);
        }
        catch (IOException e) {
            XQEDebugLog.err.printStackTrace(e);
            cntor = null;
        }
        return cntor;
    }
}

